/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.JServerService;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public final class JServerServiceAdapterFactory {
    private static final String FILE_NAME = "com.ws.wbem.jserver.JServerServiceAdapterFactory";
    private static final String ERROR_PROTOCOL_NAME_NULL = "Protocol name can not be null";
    private static final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private static final Map<String, JServerService> mServices = new HashMap<String, JServerService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JServerService getService(String serviceName) throws WBEMException {
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new IllegalArgumentException(ERROR_PROTOCOL_NAME_NULL);
        }
        JServerService adapter = mServices.get(serviceName);
        if (null == adapter) {
            try {
                Map<String, JServerService> map = mServices;
                synchronized (map) {
                    adapter = mServices.get(serviceName);
                    if (null == adapter) {
                        PropertyResourceBundle props = (PropertyResourceBundle)ResourceBundle.getBundle(FILE_NAME);
                        String clazz = props.getString(serviceName);
                        Class<?> cl = null;
                        try {
                            cl = Class.forName(clazz);
                        }
                        catch (Exception ex) {
                            mLogger.log(Level.SEVERE, "Class.forName failed!", ex);
                            throw new WBEMException(1, "ERROR");
                        }
                        Class[] paramTypes = new Class[]{};
                        Object[] paramList = new Object[]{};
                        Constructor<?> ctr = cl.getConstructor(paramTypes);
                        adapter = (JServerService)ctr.newInstance(paramList);
                        mServices.put(serviceName, adapter);
                    }
                }
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "AuthService.getAdapter failed!", e);
                throw new WBEMException(1);
            }
        }
        return adapter;
    }
}

