/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.logging.FailSafeLog;
import com.ws.logging.ThreadedFileHandler;
import com.ws.wbem.jserver.JServerTraceFormatter;
import com.ws.wbem.jserver.JServerTraceProperties;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JServerTrace {
    private static final String LOGEXT = ".trace";
    private static final String JSERVERLOG = "jserverlog";
    private static Logger mLog;
    private static FileHandler mLogFileHandle;

    protected static void close() {
        if (null != mLog) {
            mLog.setLevel(Level.OFF);
        }
        if (mLogFileHandle != null) {
            mLogFileHandle.flush();
            mLogFileHandle.close();
        }
    }

    public static void initTrace() {
        mLog = Logger.getLogger("com.ws.wbem.jserver");
        String format = JServerTraceProperties.getLogFormat();
        Level pLevel = JServerTraceProperties.getLogLevel();
        if ((mLog.getLevel() == null || mLog.getLevel().equals(Level.OFF)) && !pLevel.equals(Level.OFF)) {
            mLog.setUseParentHandlers(false);
            int limit = 5000000;
            int numFiles = 3;
            try {
                String limitString = JServerTraceProperties.getMaxLogFileSize();
                if (limitString != null) {
                    limit = Integer.parseInt(limitString);
                }
            }
            catch (NumberFormatException e) {
                FailSafeLog.failSafe((Throwable)e);
            }
            try {
                String numFilesString = JServerTraceProperties.getNumberOfLogs();
                if (numFilesString != null) {
                    numFiles = Integer.parseInt(numFilesString);
                }
            }
            catch (NumberFormatException e) {
                FailSafeLog.failSafe((Throwable)e);
            }
            String trace_sufx = "";
            String logExt = "";
            String logname = JServerTraceProperties.getLogFileName();
            if (null == logname) {
                SimpleDateFormat sdf = new SimpleDateFormat("MMdd_HHmm");
                trace_sufx = "_" + sdf.format(new Date());
                logExt = LOGEXT;
                logname = JSERVERLOG;
            } else {
                int extIndex = logname.lastIndexOf(46);
                if (extIndex > 0 && extIndex < logname.length() - 1) {
                    logExt = logname.substring(extIndex);
                    logname = logname.substring(0, extIndex);
                }
            }
            String dir = JServerTraceProperties.getLogFileDirectory();
            String pFileName = "";
            if (dir != null) {
                pFileName = dir + File.separator;
            }
            try {
                if (limit > 0) {
                    pFileName = pFileName + logname + trace_sufx + "-%g" + logExt;
                    mLogFileHandle = new ThreadedFileHandler(pFileName, limit, numFiles);
                } else {
                    pFileName = pFileName + logname + trace_sufx + logExt;
                    mLogFileHandle = new ThreadedFileHandler(pFileName);
                }
            }
            catch (Exception e) {
                FailSafeLog.failSafe((Throwable)e);
                return;
            }
            if (!"XML".equals(format)) {
                mLogFileHandle.setFormatter(new JServerTraceFormatter());
            }
            mLog.addHandler(mLogFileHandle);
        }
        mLog.setLevel(pLevel);
        if (pLevel.equals(Level.OFF)) {
            JServerTrace.close();
        }
    }
}

