/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.common;

public enum ProtocolEnum {
    SSH(2, "SSH"),
    Telnet(3, "Telnet"),
    CLP(4, "CLP"),
    CIMXML(5, "CIM-XML"),
    WSManagement(6, "WS-Management"),
    CIMRS(7, "CIM-RS");

    private final int mValue;
    private final String mName;

    private ProtocolEnum(int value, String name) {
        this.mValue = value;
        this.mName = name;
    }

    public int getValue() {
        return this.mValue;
    }

    public String getName() {
        return this.mName;
    }

    public static ProtocolEnum getProtocol(int value) {
        ProtocolEnum[] protocols;
        ProtocolEnum ret = null;
        for (ProtocolEnum protocol : protocols = ProtocolEnum.values()) {
            if (value != protocol.getValue()) continue;
            ret = protocol;
            break;
        }
        return ret;
    }

    public static ProtocolEnum getProtocol(String name) {
        ProtocolEnum ret = null;
        if (null != name) {
            ProtocolEnum[] protocols;
            for (ProtocolEnum protocol : protocols = ProtocolEnum.values()) {
                if (!name.equals(protocol.getName())) continue;
                ret = protocol;
                break;
            }
        }
        return ret;
    }

    public String toString() {
        return this.mName;
    }
}

