/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.wbemserver;

import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.embed.Protocol;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.jserver.profiles.common.EnabledDefault;
import com.ws.wbem.jserver.profiles.common.EnabledState;
import com.ws.wbem.jserver.profiles.common.ProtocolEnum;
import com.ws.wbem.jserver.profiles.common.ProtocolIFType;
import com.ws.wbem.jserver.profiles.common.StateChange;
import com.ws.wbem.jserver.services.ProtocolServiceService;
import com.ws.wbem.query.fql.FQLParser;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;

public abstract class ProtocolServiceProvider
extends BaseInstanceProvider {
    static final ProtocolServiceService mProtocolService = ProtocolServiceService.getService();
    static final String PROTOCOL_SERVICE = " Protocol Service";
    public final String mProtocolName;

    public ProtocolServiceProvider(String protocolName) {
        this.mProtocolName = protocolName;
    }

    public static CIMInstance generateProtocolServiceInstance(CIMObjectPath op, Protocol protocol, EnabledState enabledState) throws WBEMException {
        CIMObjectPath opProtocolService = ProtocolServiceProvider.generateProtocolServiceObjectPath(op, protocol);
        String protocolName = protocol.getProtocolName();
        CIMProperty[] keyProps = opProtocolService.getKeys();
        ProtocolEnum protocolEnum = ProtocolEnum.getProtocol(protocolName);
        String name = (String)opProtocolService.getKeyValue("Name");
        UnsignedInteger16[] ops = new UnsignedInteger16[]{new UnsignedInteger16(2)};
        CIMProperty[] props = new CIMProperty[]{keyProps[0], keyProps[1], keyProps[2], keyProps[3], new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(enabledState.getValue()), false), new CIMProperty("MaxConnections", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(0), false), new CIMProperty("Protocol", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(protocolEnum.getValue()), false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)ops, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + " " + name), false)};
        return new CIMInstance(opProtocolService, props);
    }

    public static CIMObjectPath generateProtocolServiceObjectPath(CIMObjectPath op, Protocol protocol) throws WBEMException {
        String protocolName = protocol.getProtocolName();
        return ProtocolServiceProvider.generateProtocolServiceObjectPath(op, protocolName);
    }

    public static CIMObjectPath generateProtocolServiceObjectPath(CIMObjectPath op, String protocolName) throws WBEMException {
        String name = protocolName + PROTOCOL_SERVICE;
        String creationClassName = "WS-Management".equals(protocolName) ? JServerSettings.replaceSchemaClassName("WS_WSManagementProtocolService") : ("CIM-RS".equals(protocolName) ? JServerSettings.replaceSchemaClassName("WS_CIMRSProtocolService") : JServerSettings.replaceSchemaClassName("WS_CIMXMLProtocolService"));
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem"), true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)creationClassName, true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)JServerProperties.getServerHost(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), JServerProperties.getInteropNamespace(), creationClassName, keyProps);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath target, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        this.checkArguments(target, WBEMOperation.OPENENUMERATEINSTANCES, filterQueryLanguage, filterQuery, continueOnError);
        FQLParser fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)target, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES);
        return mProtocolService.getProtocolServiceInstances(target, this.mProtocolName, fqlParser, propertyList);
    }

    public CIMInstance getInstance(CIMObjectPath target, String[] propertyList) throws WBEMException {
        try {
            return mProtocolService.getProtocolServiceInstance(target).filterProperties(propertyList);
        }
        catch (WBEMException we) {
            if (6 == we.getID()) {
                throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.GETINSTANCE, null);
            }
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)we.getMessage(), (WBEMOperation)WBEMOperation.GETINSTANCE, null);
        }
    }

    @Override
    public Object invokeMethod(CIMObjectPath opProtocolService, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        int ret;
        block35: {
            ret = 0;
            if ("RequestStateChange".equals(methodName)) {
                Object[] objs;
                UnsignedInteger16 cpvRequestedState = null;
                StateChange requestedState = null;
                CIMDateTimeInterval timeoutPeriod = null;
                for (CIMArgument<?> inArg : inArgs) {
                    if ("RequestedState".equals(inArg.getName())) {
                        cpvRequestedState = (UnsignedInteger16)inArg.getValue();
                        requestedState = null != cpvRequestedState ? StateChange.getStateChange(cpvRequestedState.intValue()) : null;
                        continue;
                    }
                    if (!"TimeoutPeriod".equals(inArg.getName())) continue;
                    timeoutPeriod = (CIMDateTimeInterval)inArg.getValue();
                }
                if (null != timeoutPeriod && timeoutPeriod.getTotalMilliseconds() > 0L) {
                    objs = new Object[]{methodName};
                    mLogger.log(Level.WARNING, "{0}: The TimeoutPeriod argument is not supported", objs);
                    ret = 4098;
                } else if (null == requestedState) {
                    objs = new Object[]{methodName};
                    mLogger.log(Level.WARNING, "{0}: The RequestedState argument was null.", objs);
                    ret = 5;
                } else if (StateChange.Enabled == requestedState || StateChange.Disabled == requestedState) {
                    try {
                        mProtocolService.setProtocolServiceEnabledState(opProtocolService, requestedState);
                    }
                    catch (WBEMException we) {
                        if (7 == we.getID()) {
                            Object[] objs2 = new Object[]{methodName};
                            mLogger.log(Level.WARNING, "{0}: This method is not supported", objs2);
                            ret = 1;
                            break block35;
                        }
                        Object[] objs3 = new Object[]{methodName, opProtocolService, requestedState.toString(), we.toString()};
                        mLogger.log(Level.WARNING, "{0}: Caught exception trying to set ProtocolService, {1}, to {2}\n{3}", objs3);
                        ret = 4;
                    }
                } else if (StateChange.Reset == requestedState) {
                    try {
                        mProtocolService.setProtocolServiceEnabledState(opProtocolService, StateChange.Disabled);
                        try {
                            mProtocolService.setProtocolServiceEnabledState(opProtocolService, StateChange.Enabled);
                        }
                        catch (WBEMException we) {
                            if (7 == we.getID()) {
                                Object[] objs4 = new Object[]{methodName};
                                mLogger.log(Level.WARNING, "{0}: This method is not supported", objs4);
                                ret = 1;
                                break block35;
                            }
                            Object[] objs5 = new Object[]{methodName, we.toString(), opProtocolService};
                            mLogger.log(Level.WARNING, "{0}: Caught exception trying to start the ProtocolService:{1}\n{2}", objs5);
                            ret = 4;
                        }
                    }
                    catch (WBEMException we) {
                        if (7 == we.getID()) {
                            Object[] objs6 = new Object[]{methodName};
                            mLogger.log(Level.WARNING, "{0}: This method is not supported", objs6);
                            ret = 1;
                            break block35;
                        }
                        Object[] objs7 = new Object[]{methodName, we.toString(), opProtocolService};
                        mLogger.log(Level.WARNING, "{0}: Caught exception trying to stop the ProtocolService:{1}\n{2}", objs7);
                        ret = 4;
                    }
                } else {
                    objs = new Object[]{methodName, cpvRequestedState};
                    mLogger.log(Level.WARNING, "{0}: The RequestedState argument value ({1}) was invalid", objs);
                    ret = 5;
                }
            } else if ("ListenOnPortIF".equals(methodName)) {
                Object[] objs;
                UnsignedInteger32 cpvPortNumber = null;
                UnsignedInteger32 cpvProtocolIFType = null;
                String protocolIFType = null;
                CIMObjectPath opIPProtocolEndpoint = null;
                for (CIMArgument<?> inArg : inArgs) {
                    if ("PortNumber".equals(inArg.getName())) {
                        cpvPortNumber = (UnsignedInteger32)inArg.getValue();
                        continue;
                    }
                    if ("ProtocolIFType".equals(inArg.getName())) {
                        ProtocolIFType ifType;
                        cpvProtocolIFType = (UnsignedInteger32)inArg.getValue();
                        if (null == cpvProtocolIFType || null == (ifType = ProtocolIFType.getProtocolIFType(cpvProtocolIFType.intValue()))) continue;
                        protocolIFType = ifType.getName();
                        continue;
                    }
                    if (!"IPEndpoint".equals(inArg.getName())) continue;
                    opIPProtocolEndpoint = (CIMObjectPath)inArg.getValue();
                }
                if (null == cpvProtocolIFType) {
                    objs = new Object[]{methodName};
                    mLogger.log(Level.WARNING, "{0}: The ProtocolIFType argument was null", objs);
                    ret = 2;
                } else if (null == cpvPortNumber) {
                    objs = new Object[]{methodName};
                    mLogger.log(Level.WARNING, "{0}: The PortNumer argument was null", objs);
                    ret = 4;
                } else if (null == protocolIFType) {
                    objs = new Object[]{methodName, cpvProtocolIFType};
                    mLogger.log(Level.WARNING, "{0}: The protocolIFType argument value ({1}) was invalid", objs);
                    ret = 2;
                } else {
                    try {
                        CIMInstance instTCPProtocolEndpoint = mProtocolService.listenOnPortIF(opProtocolService, this.mProtocolName, cpvPortNumber.intValue(), protocolIFType, opIPProtocolEndpoint);
                        outArgs[0] = new CIMArgument("TCPEndpoint", new CIMDataType("CIM_TCPProtocolEndpoint"), (Object)instTCPProtocolEndpoint.getObjectPath());
                    }
                    catch (WBEMException we) {
                        if (7 == we.getID()) {
                            Object[] objs8 = new Object[]{methodName};
                            mLogger.log(Level.WARNING, "{0}: This method is not supported", objs8);
                            ret = 1;
                            break block35;
                        }
                        Object[] objs9 = new Object[]{methodName, we.toString(), opProtocolService};
                        mLogger.log(Level.WARNING, "{0}: Caught exception trying to create and start new TCPProtocolEndpoint", objs9);
                        ret = 4;
                    }
                }
            } else {
                throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)opProtocolService, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
            }
        }
        return new UnsignedInteger32((long)ret);
    }

    @Override
    public synchronized void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        Object[] objs;
        CIMObjectPath opService = ci.getObjectPath();
        CIMInstance originalInstance = this.getInstance(opService, null);
        UnsignedInteger16 cpvEnabledState = (UnsignedInteger16)originalInstance.getPropertyValue("EnabledState");
        EnabledState oldEnabledState = null != cpvEnabledState ? EnabledState.getEnabledState(cpvEnabledState.intValue()) : EnabledState.Enabled;
        UnsignedInteger16 cpvEnabledDefault = (UnsignedInteger16)originalInstance.getPropertyValue("EnabledDefault");
        EnabledDefault oldEnabledDefault = EnabledDefault.getEnabledDefault(null == cpvEnabledDefault ? 2 : cpvEnabledDefault.intValue());
        UnsignedInteger16 cpvNewEnabledState = (UnsignedInteger16)ci.getPropertyValue("EnabledState");
        EnabledState newEnabledState = null != cpvNewEnabledState ? EnabledState.getEnabledState(cpvNewEnabledState.intValue()) : EnabledState.Enabled;
        cpvEnabledDefault = (UnsignedInteger16)ci.getPropertyValue("EnabledDefault");
        EnabledDefault newEnabledDefault = EnabledDefault.getEnabledDefault(null == cpvEnabledDefault ? 2 : cpvEnabledDefault.intValue());
        String errMsg = null;
        if (null != propertyList) {
            for (String propertyName : propertyList) {
                MessageFormat msgFormat;
                Object[] objs2;
                if (!"EnabledDefault".equalsIgnoreCase(propertyName) && !"EnabledState".equalsIgnoreCase(propertyName)) {
                    objs2 = new Object[]{ci.getClassName(), propertyName};
                    msgFormat = new MessageFormat("{0} does not support modifying property {1}");
                    errMsg = msgFormat.format(objs2);
                    continue;
                }
                if ("EnabledState".equalsIgnoreCase(propertyName)) {
                    if (null != newEnabledState && (newEnabledState == EnabledState.Enabled || newEnabledState == EnabledState.Disabled)) continue;
                    objs2 = new Object[]{"EnabledState", newEnabledState, EnabledState.Enabled.getValue(), EnabledState.Disabled.getValue()};
                    msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                    errMsg = msgFormat.format(objs2);
                    continue;
                }
                if (!"EnabledDefault".equalsIgnoreCase(propertyName) || null != newEnabledDefault && (newEnabledDefault == EnabledDefault.Enabled || newEnabledDefault == EnabledDefault.Disabled)) continue;
                objs2 = new Object[]{"EnabledDefault", newEnabledState, EnabledDefault.Enabled.getValue(), EnabledDefault.Disabled.getValue()};
                msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                errMsg = msgFormat.format(objs2);
            }
        } else if (null != newEnabledState && newEnabledState != EnabledState.Enabled && newEnabledState != EnabledState.Disabled) {
            objs = new Object[]{"EnabledState", newEnabledState, EnabledState.Enabled.getValue(), EnabledState.Disabled.getValue()};
            MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
            errMsg = msgFormat.format(objs);
        } else if (null == newEnabledDefault || newEnabledDefault != EnabledDefault.Enabled && newEnabledDefault != EnabledDefault.Disabled) {
            objs = new Object[]{"EnabledDefault", newEnabledState, EnabledDefault.Enabled.getValue(), EnabledDefault.Disabled.getValue()};
            MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
            errMsg = msgFormat.format(objs);
        }
        if (null != errMsg) {
            mLogger.info(errMsg);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)opService, errMsg, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)ci.getClassName());
        }
        if (newEnabledDefault != oldEnabledDefault) {
            newEnabledDefault = null;
        }
        if (newEnabledState != oldEnabledState) {
            newEnabledState = null;
        }
        if (null != newEnabledState || null != newEnabledDefault) {
            if (null != newEnabledState) {
                StateChange stateChange = StateChange.getStateChange(newEnabledState.getValue());
                try {
                    mProtocolService.setProtocolServiceEnabledState(ci.getObjectPath(), stateChange);
                }
                catch (WBEMException we) {
                    Object[] objs3 = new Object[]{opService, stateChange.toString(), we.toString()};
                    MessageFormat msgFormat = new MessageFormat("Caught exception trying to set EnabledState of ProtocolEndpoint {0} to {1}/n{2}.");
                    errMsg = msgFormat.format(objs3);
                    mLogger.log(Level.WARNING, errMsg);
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)opService, (String)errMsg, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)ci.getClassName());
                }
            }
            if (null != newEnabledDefault) {
                mProtocolService.setProtocolServiceEnabledDefault(opService, newEnabledDefault == EnabledDefault.Enabled);
            }
        }
    }
}

