/*
 * Decompiled with CFR 0.152.
 */
package javax.cim3;

import com.ws.cim3.mof.MOFStyle;
import java.io.Serializable;
import java.util.ArrayList;
import javax.cim3.CIMNamedElementInterface;
import javax.cim3.CIMObjectPath;
import javax.cim3.CIMProperty;
import javax.cim3.Messages;

public class CIMInstance
implements CIMNamedElementInterface,
Serializable {
    private static final long serialVersionUID = -249160087013230559L;
    private final CIMObjectPath mObjectPath;
    private final CIMProperty<?>[] mProperties;

    public CIMInstance(CIMObjectPath name, CIMProperty<?>[] props) {
        if (name == null || name.getObjectName() == null) {
            throw new IllegalArgumentException(Messages.getString("CIMInstance.0"));
        }
        this.mObjectPath = name;
        this.mProperties = props;
    }

    public CIMInstance deriveInstance(CIMObjectPath path) {
        return new CIMInstance(path, this.mProperties);
    }

    public CIMInstance deriveInstance(CIMProperty<?>[] array) {
        if (array == null || array.length == 0 || this.mProperties == null) {
            return this;
        }
        ArrayList l = new ArrayList(this.mProperties.length);
        for (CIMProperty<?> mPropertie : this.mProperties) {
            CIMProperty<?> p = mPropertie;
            if (p == null) continue;
            for (CIMProperty<?> element : array) {
                if (p.getName() == null || element == null || element.getName() == null || !element.getName().equalsIgnoreCase(p.getName())) continue;
                p = element;
            }
            l.add(p);
        }
        return new CIMInstance(this.mObjectPath, l.toArray(new CIMProperty[l.size()]));
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMInstance)) {
            return false;
        }
        return this.getObjectPath().equals(((CIMInstance)o).getObjectPath());
    }

    public CIMInstance filterProperties(String[] propertyList) {
        CIMInstance ci = new CIMInstance(this.getObjectPath(), this.getFilteredProperties(propertyList));
        return ci;
    }

    public String getClassName() {
        if (this.mObjectPath != null) {
            return this.mObjectPath.getObjectName();
        }
        return null;
    }

    private CIMProperty<?>[] getFilteredProperties(String[] propertyList) {
        ArrayList propList = new ArrayList();
        if (propertyList != null) {
            for (String element : propertyList) {
                CIMProperty<?> cp = this.getProperty(element);
                if (cp == null || propList.contains(cp)) continue;
                propList.add(cp);
            }
            return propList.toArray(new CIMProperty[propList.size()]);
        }
        return this.mProperties;
    }

    public CIMProperty<?>[] getKeys() {
        return this.mObjectPath.getKeys();
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.mObjectPath;
    }

    public CIMProperty<?>[] getProperties() {
        return this.mProperties;
    }

    public CIMProperty<?> getProperty(int index) throws ArrayIndexOutOfBoundsException {
        return this.mProperties[index];
    }

    public CIMProperty<?> getProperty(String name) {
        if (this.mProperties == null || name == null) {
            return null;
        }
        for (CIMProperty<?> mPropertie : this.mProperties) {
            if (mPropertie == null || mPropertie.getName() == null || !mPropertie.getName().equalsIgnoreCase(name)) continue;
            return mPropertie;
        }
        return null;
    }

    public int getPropertyCount() {
        return this.mProperties.length;
    }

    public Object getPropertyValue(String name) {
        CIMProperty<?> cp = this.getProperty(name);
        if (cp != null) {
            return cp.getValue();
        }
        return null;
    }

    public int hashCode() {
        return this.getObjectPath().hashCode();
    }

    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

