/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.services.indication;

import com.ws.wbem.IndicationType;
import com.ws.wbem.server.services.indication.EventProviderRequest;
import com.ws.wbem.server.services.indication.EventService;
import com.ws.wbem.server.services.indication.IndicationRequestCollator;
import com.ws.wbem.server.services.indication.SubActivation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifier;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.IndicationProvider;
import org.wbemservices.wbem.query.AndQueryExp;
import org.wbemservices.wbem.query.AttributeExp;
import org.wbemservices.wbem.query.BinaryRelQueryExp;
import org.wbemservices.wbem.query.NonJoinExp;
import org.wbemservices.wbem.query.QueryExp;
import org.wbemservices.wbem.query.SelectExp;

public class FilterActivation {
    private final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private static final String QUERYPROP = "query";
    private static final String INDICATIONQUALIFIER = "indication";
    private List<SubActivation> result = null;
    private WBEMException exception = null;
    private final CIMInstance mIndividualFilterInstance;
    private final CIMInstance mProviderFilterInstance;
    private CIMObjectPath mFilterOp = null;
    private SelectExp parsedExp = null;
    private List<List<BinaryRelQueryExp>> canonizedExp = null;
    private EventService mEventService = null;
    String[] mSourceNamespaces;

    public FilterActivation(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, EventService eventService, String[] stringArray) {
        this(cIMObjectPath, cIMInstance, cIMInstance, eventService, stringArray);
    }

    public FilterActivation(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, CIMInstance cIMInstance2, EventService eventService, String[] stringArray) {
        this.mIndividualFilterInstance = cIMInstance;
        this.mProviderFilterInstance = cIMInstance2;
        this.mFilterOp = new CIMObjectPath(null, null, null, cIMObjectPath.getNamespace().toLowerCase(), cIMObjectPath.getObjectName(), cIMObjectPath.getKeys());
        this.mEventService = eventService;
        this.mSourceNamespaces = null != stringArray && stringArray.length > 0 ? stringArray : new String[]{cIMObjectPath.getNamespace()};
    }

    public void activate(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws WBEMException {
        this.commonActivation(cIMInstance, cIMInstance2, false);
    }

    public void activateSubscription(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws WBEMException {
        this.commonActivation(cIMInstance, cIMInstance2, true);
    }

    public void authorize(final String string, final CIMInstance cIMInstance, final CIMInstance cIMInstance2) throws WBEMException {
        IndicationRequestCollator indicationRequestCollator = new IndicationRequestCollator(this.getSubActivations(), new IndicationRequestCollator.Callback(){

            @Override
            public Object doProviderOperation(String[] stringArray, CIMObjectPath[] cIMObjectPathArray, String[] stringArray2) throws WBEMException {
                IndicationProvider indicationProvider = FilterActivation.this.getProvider(cIMObjectPathArray[0], stringArray2[0]);
                if (indicationProvider != null) {
                    try {
                        indicationProvider.authorizeFilter(FilterActivation.this.mProviderFilterInstance, cIMInstance, cIMInstance2);
                    }
                    catch (WBEMException wBEMException) {
                        if (wBEMException.getID() != 1) {
                            throw new WBEMException(1, wBEMException.getLocalizedMessage());
                        }
                        throw wBEMException;
                    }
                }
                return null;
            }

            @Override
            public EventProviderRequest doSubActivationOperation(SubActivation subActivation) throws WBEMException {
                return subActivation.authorize(string);
            }

            @Override
            public void processSingleException(SubActivation subActivation, WBEMException wBEMException) throws WBEMException {
                subActivation.processAuthorizeFailure(true, wBEMException);
            }

            @Override
            public void processSingleNoResult(SubActivation subActivation) throws WBEMException {
                subActivation.processAuthorizeFailure(false, null);
            }

            @Override
            public void processSingleResult(SubActivation subActivation, Object object) throws WBEMException {
            }
        });
        IndicationRequestCollator.EventRequestResult eventRequestResult = indicationRequestCollator.processEventRequest();
        if (eventRequestResult.mException != null) {
            throw eventRequestResult.mException;
        }
    }

    void commonActivation(final CIMInstance cIMInstance, final CIMInstance cIMInstance2, final boolean bl) throws WBEMException {
        IndicationRequestCollator indicationRequestCollator = new IndicationRequestCollator(this.getSubActivations(), new IndicationRequestCollator.Callback(){

            @Override
            public Object doProviderOperation(String[] stringArray, CIMObjectPath[] cIMObjectPathArray, String[] stringArray2) throws WBEMException {
                IndicationProvider indicationProvider = FilterActivation.this.getProvider(cIMObjectPathArray[0], stringArray2[0]);
                if (indicationProvider != null) {
                    try {
                        indicationProvider.activateFilter(FilterActivation.this.mProviderFilterInstance, cIMInstance, cIMInstance2);
                    }
                    catch (WBEMException wBEMException) {
                        if (wBEMException.getID() != 1) {
                            throw new WBEMException(1, wBEMException.getLocalizedMessage());
                        }
                        throw wBEMException;
                    }
                }
                return null;
            }

            @Override
            public EventProviderRequest doSubActivationOperation(SubActivation subActivation) throws WBEMException {
                if (bl) {
                    return subActivation.activateSubscription();
                }
                return subActivation.activate();
            }

            @Override
            public void processSingleException(SubActivation subActivation, WBEMException wBEMException) throws WBEMException {
                if (!bl) {
                    subActivation.processActivateFailure(true, wBEMException);
                }
            }

            @Override
            public void processSingleNoResult(SubActivation subActivation) throws WBEMException {
                if (!bl) {
                    subActivation.processActivateFailure(false, null);
                }
            }

            @Override
            public void processSingleResult(SubActivation subActivation, Object object) throws WBEMException {
            }
        });
        IndicationRequestCollator.EventRequestResult eventRequestResult = indicationRequestCollator.processEventRequest();
        if (eventRequestResult.mException != null) {
            this.commonDeactivation(eventRequestResult.mListSubActivation, cIMInstance, cIMInstance2, bl);
            throw eventRequestResult.mException;
        }
    }

    private void commonDeactivation(List<SubActivation> list, final CIMInstance cIMInstance, final CIMInstance cIMInstance2, final boolean bl) throws WBEMException {
        if (list == null) {
            list = this.getSubActivations();
        }
        IndicationRequestCollator indicationRequestCollator = new IndicationRequestCollator(list, new IndicationRequestCollator.Callback(){

            @Override
            public Object doProviderOperation(String[] stringArray, CIMObjectPath[] cIMObjectPathArray, String[] stringArray2) throws WBEMException {
                IndicationProvider indicationProvider = FilterActivation.this.getProvider(cIMObjectPathArray[0], stringArray2[0]);
                if (indicationProvider != null) {
                    try {
                        indicationProvider.deActivateFilter(FilterActivation.this.mProviderFilterInstance, cIMInstance, cIMInstance2);
                    }
                    catch (WBEMException wBEMException) {
                        if (wBEMException.getID() != 1) {
                            throw new WBEMException(1, wBEMException.getLocalizedMessage());
                        }
                        throw wBEMException;
                    }
                }
                return null;
            }

            @Override
            public EventProviderRequest doSubActivationOperation(SubActivation subActivation) throws WBEMException {
                try {
                    if (bl) {
                        return subActivation.deactivateSubscription();
                    }
                    return subActivation.deactivate();
                }
                catch (Throwable throwable) {
                    FilterActivation.this.mLogger.log(Level.WARNING, "received deactivate exception", throwable);
                    return null;
                }
            }

            @Override
            public void processSingleException(SubActivation subActivation, WBEMException wBEMException) throws WBEMException {
            }

            @Override
            public void processSingleNoResult(SubActivation subActivation) throws WBEMException {
            }

            @Override
            public void processSingleResult(SubActivation subActivation, Object object) throws WBEMException {
            }
        });
        IndicationRequestCollator.EventRequestResult eventRequestResult = indicationRequestCollator.processEventRequest();
        if (eventRequestResult.mException != null) {
            this.mLogger.log(Level.WARNING, "Received exception during deactivation", eventRequestResult.mException);
        }
    }

    public void deactivate(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws WBEMException {
        this.commonDeactivation(null, cIMInstance, cIMInstance2, false);
    }

    public void deactivateSubscription(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws WBEMException {
        this.commonDeactivation(null, cIMInstance, cIMInstance2, true);
    }

    private void determineClasses(String string) throws Exception {
        this.parsedExp = new SelectExp(this.unquote(string));
        String string2 = ((NonJoinExp)this.parsedExp.getFromClause()).getAttribute().getAttrClassName().toLowerCase();
        this.result = new ArrayList<SubActivation>();
        for (String string3 : this.mSourceNamespaces) {
            Object object;
            Object object2;
            IndicationType indicationType;
            CIMClass cIMClass2;
            String string4;
            String string5;
            if (this.parsedExp.getWhereClause() == null) {
                string5 = string3;
                if (this.mEventService.determineIndicationType(string5, string2).isInstanceIndication()) {
                    string4 = "Invalid query: \"" + string + "\".  Instance indications must have a \"WHERE\" clause";
                    this.mLogger.info(string4);
                    throw new WBEMException(1, string4);
                }
            } else {
                string5 = this.mFilterOp.getNamespace();
            }
            if ((string4 = this.mEventService.mProviderHandle.getClass(new CIMObjectPath(null, null, null, string5, string2, null), false, true)) == null) {
                throw new WBEMException(6, string2);
            }
            CIMQualifier cIMQualifier = string4.getQualifier(INDICATIONQUALIFIER);
            if (cIMQualifier == null) {
                throw new WBEMException(5, string2);
            }
            Object object3 = cIMQualifier.getValue();
            if (object3 == null || !object3.equals(Boolean.TRUE)) {
                throw new WBEMException(5, string2);
            }
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, string5, string2, null);
            CloseableIterator closeableIterator = this.mEventService.mProviderHandle.enumerateClasses(cIMObjectPath, true, false, true);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (!this.isAbstract((CIMClass)string4)) {
                cIMClass2 = this.mEventService.determineIndicationType(string5, string4.getName().toLowerCase());
                if (cIMClass2.isInstanceIndication()) {
                    arrayList2.add(string4);
                } else {
                    arrayList.add(string4);
                }
            }
            while (closeableIterator.hasNext()) {
                cIMClass2 = (CIMClass)closeableIterator.next();
                if (this.isAbstract(cIMClass2)) continue;
                indicationType = this.mEventService.determineIndicationType(string5, cIMClass2.getName().toLowerCase());
                if (!indicationType.isProcessIndication()) {
                    arrayList2.add((String)cIMClass2);
                    continue;
                }
                arrayList.add((String)cIMClass2);
            }
            cIMClass2 = this.parsedExp.getWhereClause();
            indicationType = null;
            if (cIMClass2 != null) {
                indicationType = cIMClass2.canonizeDOC();
            } else {
                indicationType = new ArrayList();
                indicationType.add(new ArrayList());
            }
            this.result = new ArrayList<SubActivation>();
            for (CIMClass cIMClass : arrayList) {
                object2 = IndicationType.getIndicationTypeByClassName((String)cIMClass.getName());
                object = null != object2 && object2.isClassIndication() ? new CISubActivation(string5, cIMClass.getName().toLowerCase(), (QueryExp)cIMClass2, "", string3, this.parsedExp, this.mEventService, this) : new PISubActivation(string5, cIMClass.getName().toLowerCase(), (QueryExp)cIMClass2, "", string3, this.parsedExp, this.mEventService, this);
                this.result.add((SubActivation)object);
            }
            Iterator cIMClass3 = indicationType.iterator();
            this.canonizedExp = new ArrayList<List<BinaryRelQueryExp>>();
            if (arrayList2.size() == 0) {
                return;
            }
            while (cIMClass3.hasNext()) {
                object = (List)cIMClass3.next();
                object2 = this.determineSublistClasses((List<BinaryRelQueryExp>)object, string3);
                Iterator iterator = object2.iterator();
                object = this.removeIsas((List<BinaryRelQueryExp>)object);
                this.canonizedExp.add((List<BinaryRelQueryExp>)object);
                QueryExp queryExp = this.toQueryExp((List<BinaryRelQueryExp>)object);
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    for (CIMClass cIMClass : arrayList2) {
                        ILCSubActivation iLCSubActivation = new ILCSubActivation(string5, cIMClass.getName().toLowerCase(), queryExp, string6.toLowerCase(), string3, this.parsedExp, this.mEventService, this);
                        this.result.add(iLCSubActivation);
                    }
                }
            }
        }
    }

    private Set<String> determineSublistClasses(List<BinaryRelQueryExp> list, String string) throws Exception {
        CloseableIterator closeableIterator;
        String string2;
        Object object;
        BinaryRelQueryExp binaryRelQueryExp;
        Iterator<BinaryRelQueryExp> iterator = list.iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (iterator.hasNext()) {
            binaryRelQueryExp = iterator.next();
            switch (binaryRelQueryExp.getOperator()) {
                case 8: {
                    object = (AttributeExp)binaryRelQueryExp.getRightValue();
                    string2 = object.getAttributeName();
                    arrayList.add(string2);
                    break;
                }
                case 9: {
                    object = (AttributeExp)binaryRelQueryExp.getRightValue();
                    string2 = object.getAttributeName();
                    arrayList2.add(string2);
                }
            }
        }
        binaryRelQueryExp = new CIMObjectPath(null, null, null, string, "", null);
        if (arrayList.size() == 0) {
            object = this.mEventService.mProviderHandle.enumerateClasses((CIMObjectPath)binaryRelQueryExp, true, false, true);
            while (object.hasNext()) {
                treeSet.add(((CIMClass)object.next()).getName());
            }
            if (treeSet.size() == 0) {
                return treeSet;
            }
        } else {
            object = arrayList.iterator();
            string2 = (String)object.next();
            binaryRelQueryExp = new CIMObjectPath(binaryRelQueryExp.getScheme(), binaryRelQueryExp.getHost(), binaryRelQueryExp.getPort(), binaryRelQueryExp.getNamespace(), string2, binaryRelQueryExp.getKeys());
            closeableIterator = this.mEventService.mProviderHandle.enumerateClasses((CIMObjectPath)binaryRelQueryExp, true, false, true);
            treeSet.add(string2);
            while (closeableIterator.hasNext()) {
                treeSet.add(((CIMClass)closeableIterator.next()).getName());
            }
            while (treeSet.size() > 0 && object.hasNext()) {
                String string3 = (String)object.next();
                binaryRelQueryExp = new CIMObjectPath(binaryRelQueryExp.getScheme(), binaryRelQueryExp.getHost(), binaryRelQueryExp.getPort(), binaryRelQueryExp.getNamespace(), string3, binaryRelQueryExp.getKeys());
                CloseableIterator closeableIterator2 = this.mEventService.mProviderHandle.enumerateClasses((CIMObjectPath)binaryRelQueryExp, true, false, true);
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                arrayList3.add(binaryRelQueryExp);
                while (closeableIterator2.hasNext()) {
                    arrayList3.add(((CIMClass)closeableIterator2.next()).getObjectPath());
                }
                for (CIMObjectPath cIMObjectPath : arrayList3) {
                    String string4 = cIMObjectPath.getObjectName();
                    if (treeSet.contains(string4)) continue;
                    treeSet.remove(string4);
                }
            }
            if (treeSet.size() == 0) {
                return treeSet;
            }
        }
        object = arrayList2.iterator();
        while (object.hasNext() && treeSet.size() != 0) {
            string2 = (String)object.next();
            binaryRelQueryExp = new CIMObjectPath(binaryRelQueryExp.getScheme(), binaryRelQueryExp.getHost(), binaryRelQueryExp.getPort(), binaryRelQueryExp.getNamespace(), string2, binaryRelQueryExp.getKeys());
            closeableIterator = this.mEventService.mProviderHandle.enumerateClasses((CIMObjectPath)binaryRelQueryExp, true, false, true);
            treeSet.remove(string2);
            while (closeableIterator.hasNext()) {
                treeSet.remove(((CIMClass)closeableIterator.next()).getName());
            }
        }
        return treeSet;
    }

    CIMInstance getFilterInstance() {
        return this.mIndividualFilterInstance;
    }

    CIMObjectPath getFilterOp() {
        return this.mFilterOp;
    }

    SelectExp getParsedExp() {
        return this.parsedExp;
    }

    private IndicationProvider getProvider(CIMObjectPath cIMObjectPath, String string) throws WBEMException {
        CIMObjectPath cIMObjectPath2 = cIMObjectPath;
        String string2 = cIMObjectPath2.getObjectName();
        if (string2 == null || string2.length() == 0) {
            cIMObjectPath2 = new CIMObjectPath(null, null, null, cIMObjectPath.getNamespace(), string, null);
        }
        IndicationProvider indicationProvider = this.mEventService.mServer.getIndicationProvider(cIMObjectPath2);
        return indicationProvider;
    }

    List<SubActivation> getSubActivations() throws WBEMException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    private boolean isAbstract(CIMClass cIMClass) {
        CIMQualifier cIMQualifier = cIMClass.getQualifier("abstract");
        if (cIMQualifier == null) {
            return false;
        }
        Object object = cIMQualifier.getValue();
        return object != null && object.equals(Boolean.TRUE);
    }

    private List<BinaryRelQueryExp> removeIsas(List<BinaryRelQueryExp> list) {
        ArrayList<BinaryRelQueryExp> arrayList = new ArrayList<BinaryRelQueryExp>();
        for (BinaryRelQueryExp binaryRelQueryExp : list) {
            int n = binaryRelQueryExp.getOperator();
            if (n == 8 || n == 9) continue;
            arrayList.add(binaryRelQueryExp);
        }
        return arrayList;
    }

    public void run() {
        String string = null;
        try {
            string = (String)this.mIndividualFilterInstance.getProperty(QUERYPROP).getValue();
        }
        catch (NullPointerException nullPointerException) {
            this.exception = new WBEMException(4);
        }
        try {
            this.determineClasses(string);
        }
        catch (WBEMException wBEMException) {
            this.exception = wBEMException;
        }
        catch (Exception exception) {
            this.exception = new WBEMException(1, exception.toString());
        }
    }

    private QueryExp toQueryExp(List<BinaryRelQueryExp> list) {
        AndQueryExp andQueryExp = null;
        if (!list.isEmpty()) {
            Iterator<BinaryRelQueryExp> iterator = list.iterator();
            if (list.size() == 1) {
                return (QueryExp)iterator.next();
            }
            QueryExp queryExp = (QueryExp)iterator.next();
            QueryExp queryExp2 = (QueryExp)iterator.next();
            andQueryExp = new AndQueryExp(queryExp, queryExp2);
            while (iterator.hasNext()) {
                andQueryExp = new AndQueryExp((QueryExp)andQueryExp, (QueryExp)iterator.next());
            }
        }
        return andQueryExp;
    }

    private String unquote(String string) {
        if (null != string) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = null != string ? string.length() : 0;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\"') continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    class PISubActivation
    extends SubActivation {
        PISubActivation(String string, String string2, QueryExp queryExp, String string3, String string4, SelectExp selectExp, EventService eventService, FilterActivation filterActivation2) {
            super(string, string2, queryExp, string3, string4, selectExp, eventService, filterActivation2);
            this.indicationType = IndicationType.Process;
        }

        @Override
        ActivateRequest activate() throws WBEMException {
            boolean bl = FilterActivation.this.mEventService.addClassFilter(this.sourceNamespace + ":" + this.subIndicationTypeString, this);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, "", null);
            return new ActivateRequest(this.getSubSelectExp(), this.subIndicationTypeString, cIMObjectPath, bl);
        }

        @Override
        ActivateRequest activateSubscription() throws WBEMException {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, "", null);
            return new ActivateRequest(this.getSubSelectExp(), this.subIndicationTypeString, cIMObjectPath, false);
        }

        @Override
        AuthorizeRequest authorize(String string) throws WBEMException {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, "", null);
            return new AuthorizeRequest(this.getSubSelectExp(), this.subIndicationTypeString, cIMObjectPath, string);
        }

        @Override
        DeactivateRequest deactivate() throws WBEMException {
            boolean bl = FilterActivation.this.mEventService.removeClassFilter(this.sourceNamespace + ":" + this.subIndicationTypeString, this);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, "", null);
            return new DeactivateRequest(this.getSubSelectExp(), this.subIndicationTypeString, cIMObjectPath, bl);
        }

        @Override
        DeactivateRequest deactivateSubscription() throws WBEMException {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, "", null);
            return new DeactivateRequest(this.getSubSelectExp(), this.subIndicationTypeString, cIMObjectPath, false);
        }

        @Override
        void processActivateFailure(boolean bl, WBEMException wBEMException) throws WBEMException {
            FilterActivation.this.mEventService.removeClassFilter(this.sourceNamespace + ":" + this.subIndicationTypeString, this);
        }
    }

    class ILCSubActivation
    extends SubActivation {
        ILCSubActivation(String string, String string2, QueryExp queryExp, String string3, String string4, SelectExp selectExp, EventService eventService, FilterActivation filterActivation2) {
            super(string, string2, queryExp, string3, string4, selectExp, eventService, filterActivation2);
        }

        @Override
        ActivateRequest activate() throws WBEMException {
            boolean bl = FilterActivation.this.mEventService.addClassFilter(this.sourceNamespace + ":" + this.className, this);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, this.className, null);
            return new ActivateRequest(this.getSubSelectExp(), this.getIndicationTypeString(), cIMObjectPath, bl);
        }

        @Override
        ActivateRequest activateSubscription() throws WBEMException {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, this.className, null);
            return new ActivateRequest(this.getSubSelectExp(), this.getIndicationTypeString(), cIMObjectPath, false);
        }

        @Override
        AuthorizeRequest authorize(String string) throws WBEMException {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, this.className, null);
            return new AuthorizeRequest(this.getSubSelectExp(), this.getIndicationTypeString(), cIMObjectPath, string);
        }

        @Override
        DeactivateRequest deactivate() throws WBEMException {
            boolean bl = FilterActivation.this.mEventService.removeClassFilter(this.sourceNamespace + ":" + this.className, this);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, this.className, null);
            return new DeactivateRequest(this.getSubSelectExp(), this.getIndicationTypeString(), cIMObjectPath, bl);
        }

        @Override
        DeactivateRequest deactivateSubscription() throws WBEMException {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, this.className, null);
            return new DeactivateRequest(this.getSubSelectExp(), this.getIndicationTypeString(), cIMObjectPath, false);
        }

        @Override
        void processActivateFailure(boolean bl, WBEMException wBEMException) throws WBEMException {
            FilterActivation.this.mEventService.removeClassFilter(this.sourceNamespace + ":" + this.className, this);
        }
    }

    static final class DeactivateRequest
    extends EventProviderRequest {
        private final boolean mLastActivation;

        DeactivateRequest(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) {
            super(selectExp, string, cIMObjectPath);
            this.mLastActivation = bl;
        }

        boolean getLastActivation() {
            return this.mLastActivation;
        }
    }

    class CISubActivation
    extends SubActivation {
        IndicationProvider indProvider;

        CISubActivation(String string, String string2, QueryExp queryExp, String string3, String string4, SelectExp selectExp, EventService eventService, FilterActivation filterActivation2) {
            super(string, string2, queryExp, string3, string4, selectExp, eventService, filterActivation2);
        }

        @Override
        ActivateRequest activate() throws WBEMException {
            boolean bl = FilterActivation.this.mEventService.addClassFilter(this.sourceNamespace + ":" + this.subIndicationTypeString, this);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, "", null);
            return new ActivateRequest(this.getSubSelectExp(), this.getIndicationTypeString(), cIMObjectPath, bl);
        }

        @Override
        ActivateRequest activateSubscription() {
            return null;
        }

        @Override
        AuthorizeRequest authorize(String string) throws WBEMException {
            return null;
        }

        @Override
        DeactivateRequest deactivate() throws WBEMException {
            boolean bl = FilterActivation.this.mEventService.removeClassFilter(this.sourceNamespace + ":" + this.subIndicationTypeString, this);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, this.sourceNamespace, "", null);
            return new DeactivateRequest(this.getSubSelectExp(), this.subIndicationTypeString, cIMObjectPath, bl);
        }

        @Override
        DeactivateRequest deactivateSubscription() throws WBEMException {
            return null;
        }
    }

    static final class AuthorizeRequest
    extends EventProviderRequest {
        private final String owner;

        AuthorizeRequest(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) {
            super(selectExp, string, cIMObjectPath);
            this.owner = string2;
        }

        String getOwner() {
            return this.owner;
        }
    }

    static final class ActivateRequest
    extends EventProviderRequest {
        private final boolean mFirstActivation;

        ActivateRequest(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) {
            super(selectExp, string, cIMObjectPath);
            this.mFirstActivation = bl;
        }

        boolean getFirstActivation() {
            return this.mFirstActivation;
        }
    }
}

