/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.Encryption;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import sanproject.client.Encryption.com.RJEncFileFilter;
import sanproject.client.Encryption.com.RJEncMacro;
import sanproject.client.Encryption.com.RJEncPassField;
import sanproject.client.Encryption.data.RJEncDataSupplier;
import sanproject.client.com.RJClientFileAccess;
import sanproject.client.com.RJComDef;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcPanel;
import sanproject.client.data.RJDataMsg;

public class RJEncKeyPanel
extends RJcPanel
implements RJEncMacro {
    private JLabel m_KeyDate;
    private JLabel m_KeyCount;
    private JLabel m_BackupCount;
    private JRadioButton m_BackupRadioBtn;
    private JRadioButton m_RestoreRadioBtn;
    private RJEncPassField m_PassField;
    private RJEncPassField m_RePassField;
    private JTextField m_FileNameText;
    private JButton m_BrowseButton;
    protected RJEncDataSupplier m_Supplier;

    public RJEncKeyPanel(RJEncDataSupplier rJEncDataSupplier) {
        this.m_Supplier = rJEncDataSupplier;
        this.initInstance();
    }

    protected void initInstance() {
        JScrollPane jScrollPane;
        BorderLayout borderLayout = new BorderLayout(8, 4);
        this.setOpaque(false);
        this.setLayout(borderLayout);
        Border border = BorderFactory.createEmptyBorder(4, 0, 0, 0);
        this.setBorder(border);
        JPanel jPanel = this.createNorthComponent();
        if (jPanel != null) {
            this.add((Component)jPanel, "North");
        }
        if ((jScrollPane = this.createCenterComponent()) != null) {
            this.add((Component)jScrollPane, "Center");
        }
    }

    protected JScrollPane createCenterComponent() {
        JScrollPane jScrollPane = new JScrollPane();
        Border border = BorderFactory.createEmptyBorder(0, 0, 4, 0);
        jScrollPane.setBorder(border);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        RJcListPanel rJcListPanel = new RJcListPanel();
        rJcListPanel.setMinLabelWidth(0);
        this.m_KeyDate = new JLabel();
        rJcListPanel.addEntry("Encryption/KeyDate", this.m_KeyDate);
        this.m_KeyCount = new JLabel();
        rJcListPanel.addEntry("Encryption/KeyCount", this.m_KeyCount);
        this.m_BackupCount = new JLabel();
        rJcListPanel.addEntry("Encryption/BackupCount", this.m_BackupCount);
        rJcListPanel.addEntry("Encryption/OpeLabel", this.createRadioPanel());
        this.m_BackupRadioBtn.setSelected(true);
        rJcListPanel.addEntry("Encryption/PassLabel", this.createPassPanel());
        rJcListPanel.addEntry("Encryption/RePassLabel", this.createRePassPanel());
        rJcListPanel.addEntry("Encryption/FileLabel", this.createFilePanel());
        rJcListPanel.completed();
        jScrollPane.getViewport().add(rJcListPanel);
        return jScrollPane;
    }

    protected JPanel createNorthComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("Encryption/KeyTitle");
        jPanel.add((Component)rJcHeaderPanel, "North");
        return jPanel;
    }

    protected RJcCushionPanel createRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_BackupRadioBtn = this.newRadioButton("Encryption/BackupLabel");
        this.m_BackupRadioBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RJEncKeyPanel.this.clearText(itemEvent);
            }
        });
        buttonGroup.add(this.m_BackupRadioBtn);
        this.m_RestoreRadioBtn = this.newRadioButton("Encryption/RestoreLabel");
        this.m_RestoreRadioBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RJEncKeyPanel.this.clearText(itemEvent);
            }
        });
        buttonGroup.add(this.m_RestoreRadioBtn);
        jPanel.add((Component)this.m_BackupRadioBtn, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_RestoreRadioBtn, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(jPanel);
        return rJcCushionPanel;
    }

    protected RJcCushionPanel createPassPanel() {
        this.m_PassField = new RJEncPassField();
        RJcCushionPanel rJcCushionPanel = this.createFieldPanel(this.m_PassField, 6, 255);
        return rJcCushionPanel;
    }

    protected RJcCushionPanel createRePassPanel() {
        this.m_RePassField = new RJEncPassField();
        RJcCushionPanel rJcCushionPanel = this.createFieldPanel(this.m_RePassField, 6, 255);
        return rJcCushionPanel;
    }

    protected RJcCushionPanel createFieldPanel(JTextField jTextField, int n, int n2) {
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jTextField.setFont(RJComFont.itemFont);
        jPanel.setOpaque(false);
        jPanel.add((Component)jTextField, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createLeterNumLabel(n, n2), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        rJcCushionPanel.setComponent(jPanel);
        return rJcCushionPanel;
    }

    protected CommentLabel createLeterNumLabel(int n, int n2) {
        String string = null;
        Object[] objectArray = new Object[]{RJcGuide.text("Encryption/CharNumber"), new Integer(n), new Integer(n2)};
        string = MessageFormat.format("({0}:{1,number}-{2,number})", objectArray);
        CommentLabel commentLabel = new CommentLabel(string);
        return commentLabel;
    }

    protected RJcCushionPanel createFilePanel() {
        this.m_FileNameText = new JTextField();
        this.m_FileNameText.setFont(RJComFont.itemFont);
        this.m_FileNameText.setEditable(false);
        this.m_BrowseButton = this.newButton("Encryption/BrowseBtn");
        this.m_BrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJEncKeyPanel.this.showFileSelectDialog(actionEvent);
            }
        });
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.m_FileNameText, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_BrowseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        rJcCushionPanel.setComponent(jPanel);
        return rJcCushionPanel;
    }

    protected JRadioButton newRadioButton(String string) {
        String string2 = RJcGuide.text(string);
        JRadioButton jRadioButton = new JRadioButton(string2);
        jRadioButton.setFont(RJComFont.itemFont);
        jRadioButton.setEnabled(true);
        jRadioButton.setOpaque(false);
        jRadioButton.setActionCommand(string2);
        jRadioButton.setName(string2);
        Dimension dimension = jRadioButton.getPreferredSize();
        jRadioButton.setPreferredSize(new Dimension(dimension.width, 24));
        return jRadioButton;
    }

    public void setEnabledObject(boolean bl) {
        if (bl) {
            if (this.m_Supplier.isEDKA()) {
                if (this.m_Supplier.getKeyCreateCount() > 0) {
                    this.m_BackupRadioBtn.setEnabled(bl);
                } else {
                    this.m_BackupRadioBtn.setEnabled(false);
                    this.m_RestoreRadioBtn.setSelected(true);
                }
                this.m_RestoreRadioBtn.setEnabled(bl);
                this.m_PassField.setEnabled(bl);
                this.m_RePassField.setEnabled(bl);
                this.m_FileNameText.setEnabled(bl);
                this.m_BrowseButton.setEnabled(bl);
            } else {
                this.m_BackupRadioBtn.setEnabled(false);
                this.m_RestoreRadioBtn.setEnabled(false);
                this.m_PassField.setEnabled(false);
                this.m_RePassField.setEnabled(false);
                this.m_FileNameText.setEnabled(false);
                this.m_BrowseButton.setEnabled(false);
            }
        } else {
            this.m_BackupRadioBtn.setEnabled(bl);
            this.m_RestoreRadioBtn.setEnabled(bl);
            this.m_PassField.setEnabled(bl);
            this.m_RePassField.setEnabled(bl);
            this.m_FileNameText.setEnabled(bl);
            this.m_BrowseButton.setEnabled(bl);
        }
    }

    protected void showFileSelectDialog(ActionEvent actionEvent) {
        int n = 0;
        Frame frame = RJComUty.getTopFrame(this);
        File file = new File(System.getProperty("user.home"));
        JFileChooser jFileChooser = new JFileChooser(file);
        RJEncFileFilter rJEncFileFilter = new RJEncFileFilter(".ekf", "Encryption Key File(*.ekf)");
        jFileChooser.addChoosableFileFilter(rJEncFileFilter);
        jFileChooser.setDialogTitle(RJComDef.DlgTitle);
        boolean bl = true;
        while (bl) {
            if (this.getOparationKind() == 0) {
                File file2 = new File(this.m_Supplier.getDeviceName() + "sn" + this.m_Supplier.getSerialNum() + ".ekf");
                jFileChooser.setSelectedFile(file2);
                n = jFileChooser.showSaveDialog(this);
                if (n != 1 && n != -1) {
                    if (!this.chkBackup(jFileChooser)) continue;
                    bl = false;
                    continue;
                }
                bl = false;
                continue;
            }
            n = jFileChooser.showOpenDialog(this);
            if (n != 1 && n != -1) {
                if (!this.chkRestore(jFileChooser)) continue;
                bl = false;
                continue;
            }
            bl = false;
        }
    }

    protected boolean chkBackup(JFileChooser jFileChooser) {
        boolean bl = true;
        File file = jFileChooser.getSelectedFile();
        String string = file.getParent();
        String string2 = file.getName();
        if (string.lastIndexOf(RJEncMacro.FILE_SEP) != string.length() - 1) {
            string = string.concat(RJEncMacro.FILE_SEP);
        }
        if (string2.length() < 4 || !string2.substring(string2.length() - 4, string2.length()).equals(".ekf")) {
            string2 = string2.concat(".ekf");
        }
        String string3 = string2;
        int n = new RJClientFileAccess().checkFileExist(string + string3);
        if (n == 59013) {
            int n2 = 1000000 + n;
            RJDataMsg rJDataMsg = this.m_Supplier.getMessage(n2);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
            int n3 = RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            bl = n3 == 0;
        }
        if (n == 0 || n == 59013 && bl) {
            this.m_FileNameText.setText(string + string3);
        }
        return bl;
    }

    protected boolean chkRestore(JFileChooser jFileChooser) {
        boolean bl = true;
        File file = jFileChooser.getSelectedFile();
        RJClientFileAccess rJClientFileAccess = new RJClientFileAccess(file);
        if (rJClientFileAccess.getStringFromFile() == null) {
            int n = 1000000 + rJClientFileAccess.getLastError();
            RJDataMsg rJDataMsg = this.m_Supplier.getMessage(n);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            int n2 = RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            bl = false;
        } else {
            String string = file.getParent();
            if (string.lastIndexOf(RJEncMacro.FILE_SEP) != string.length() - 1) {
                string = string.concat(RJEncMacro.FILE_SEP);
            }
            this.m_FileNameText.setText(string + file.getName());
        }
        return bl;
    }

    public int getOparationKind() {
        int n = 0;
        if (this.m_RestoreRadioBtn.isSelected()) {
            n = 1;
        }
        return n;
    }

    public void clearText(ItemEvent itemEvent) {
        if (this.m_PassField != null) {
            this.m_PassField.setText("");
            this.m_PassField.setCaretPosition(0);
        }
        if (this.m_RePassField != null) {
            this.m_RePassField.setText("");
            this.m_RePassField.setCaretPosition(0);
        }
        if (this.m_FileNameText != null) {
            this.m_FileNameText.setText("");
            this.m_FileNameText.setCaretPosition(0);
        }
    }

    public String getPassword() {
        String string = new String(this.m_PassField.getPassword());
        return string;
    }

    public void clearPassword() {
        this.m_PassField.setText("");
        this.m_PassField.setCaretPosition(0);
    }

    public String getRePassword() {
        String string = new String(this.m_RePassField.getPassword());
        return string;
    }

    public void clearRePassword() {
        this.m_RePassField.setText("");
        this.m_RePassField.setCaretPosition(0);
    }

    public String getFileNameText() {
        return this.m_FileNameText.getText();
    }

    public void setKeyData() {
        if (this.m_Supplier.isEDKA()) {
            Date date = this.m_Supplier.getKeyCreateDate();
            if (date != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.m_KeyDate.setText(simpleDateFormat.format(date));
            } else {
                this.m_KeyDate.setText(RJcGuide.text("Encryption/Hyphen"));
            }
            this.m_KeyCount.setText(Integer.toString(this.m_Supplier.getKeyCreateCount()));
            this.m_BackupCount.setText(Integer.toString(this.m_Supplier.getKeyBackupCount()));
        } else {
            this.m_KeyDate.setText(RJcGuide.text("Encryption/Hyphen"));
            this.m_KeyCount.setText(RJcGuide.text("Encryption/Hyphen"));
            this.m_BackupCount.setText(RJcGuide.text("Encryption/Hyphen"));
        }
    }

    class CommentLabel
    extends JLabel {
        CommentLabel() {
            this(null);
        }

        CommentLabel(String string) {
            this.setText(string);
            this.setPreferredSize(new Dimension(100, 24));
        }
    }
}

