/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo.lu;

import java.text.MessageFormat;
import javax.swing.Icon;
import sanproject.client.baseinfo.com.RJBaseInfoDataSupplier;
import sanproject.client.baseinfo.com.RJBaseInfoElement;
import sanproject.client.baseinfo.com.RJBaseInfoLDEVElement;
import sanproject.client.com.RJIconTBL;
import sanproject.client.data.RJDataLPRControler;
import sanproject.common.Robj_interface_RJiLUPathIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;
import sanproject.serverux.dataimpl.RJiLUPathIndex;

public class RJBaseInfoLUElement
extends RJBaseInfoElement {
    protected Robj_interface_RJiPortInfoDetail portDetail = null;
    protected Robj_interface_RJiLUPathIndex luPath = null;
    protected RJBaseInfoLDEVElement ldevElement = null;
    private String slprString = null;
    private String emulationType = null;
    private String groupID = null;
    private static final String DISP_LUNSTR_PATTERN = "{0} (0x{1})";

    public RJBaseInfoLUElement(Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail, Robj_interface_RJiLUPathIndex robj_interface_RJiLUPathIndex, RJBaseInfoDataSupplier rJBaseInfoDataSupplier) {
        super(null, rJBaseInfoDataSupplier);
        this.initDetail(robj_interface_RJiPortInfoDetail, robj_interface_RJiLUPathIndex);
    }

    public void initDetail(Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail, Robj_interface_RJiLUPathIndex robj_interface_RJiLUPathIndex) {
        this.portDetail = robj_interface_RJiPortInfoDetail;
        this.luPath = robj_interface_RJiLUPathIndex;
        this.setName(this.getLunIdString(RJBaseInfoLUElement.toHexString(robj_interface_RJiLUPathIndex.getSLUN(), 4), robj_interface_RJiLUPathIndex.getSLUN()));
        RJDataLPRControler rJDataLPRControler = this.supplier.getLPRControler();
        this.slprNo = new Integer(robj_interface_RJiPortInfoDetail.getSSLPR());
        this.slprName = rJDataLPRControler.getSLPRNoToName(robj_interface_RJiPortInfoDetail.getSSLPR());
        this.slprString = RJBaseInfoLUElement.toClprString(this.slprNo, this.slprName);
        this.groupID = RJBaseInfoLUElement.toHexString(robj_interface_RJiLUPathIndex.getSHostGroup(), 2);
    }

    private String getLunIdString(String string, short s) {
        String string2 = MessageFormat.format(DISP_LUNSTR_PATTERN, String.valueOf(s), string);
        return string2;
    }

    public void setLDEVElement(RJBaseInfoLDEVElement rJBaseInfoLDEVElement) {
        this.ldevElement = rJBaseInfoLDEVElement;
    }

    public RJBaseInfoLDEVElement getLDEVElement() {
        return this.ldevElement;
    }

    public Icon getIcon(boolean bl) {
        Icon icon = null;
        if (this.ldevElement != null) {
            RJiLDEVInfoDetail3 rJiLDEVInfoDetail3 = this.ldevElement.getLDEVDetail();
            icon = this.getLUNIcon(rJiLDEVInfoDetail3);
        }
        return icon;
    }

    private Icon getLUNIcon(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        int n = 0;
        if (rJiLDEVInfoDetail3.isBRmtCmdDev()) {
            n = 23;
        } else if (rJiLDEVInfoDetail3.isBLUPathCmdDev()) {
            n = 85;
            if (rJiLDEVInfoDetail3.isBLUPathCmdDevSec()) {
                n = 86;
            }
        } else {
            n = rJiLDEVInfoDetail3.getSLUSEElmCount() != 1 ? 84 : 83;
        }
        Icon icon = RJIconTBL.getIcon(n);
        return icon;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJBaseInfoLUElement) {
            bl = this.luPath.equals(((RJBaseInfoLUElement)object).getLUPathIndex());
        }
        return bl;
    }

    public int hashCode() {
        int n = this.luPath.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof RJBaseInfoLUElement) {
            n = ((RJiLUPathIndex)this.luPath).compareTo((Object)((RJBaseInfoLUElement)object).getLUPathIndex());
        }
        return n;
    }

    public Robj_interface_RJiLUPathIndex getLUPathIndex() {
        return this.luPath;
    }

    public String getPortString() {
        short s = this.portDetail.getSPort();
        String string = this.supplier.getPortName(s);
        return string;
    }

    public String getSlprString() {
        return this.slprString;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public String getEmulationType() {
        return this.emulationType;
    }
}

