/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import sanproject.client.com.restoreview.ComponentParser;
import sanproject.client.com.restoreview.DefaultScrollPaneComponentParser;
import sanproject.client.com.restoreview.ScrollPaneComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.com.restoreview.ViewRestorer;
import sanproject.client.com.restoreview.utility.ScrollPaneComponentUtilities;

public class DefaultScrollPaneViewRestorer
implements ViewRestorer {
    public static final int HORIZONTAL_VIEWPORT_RESTORE = 256;
    public static final int VERTICAL_VIEWPORT_RESTORE = 512;
    private int miRestoreMode;
    private JScrollPane mclsSaveScrollPane;
    private ScrollPaneComponentParser mclsComponentParser;

    public DefaultScrollPaneViewRestorer() {
        this.initInstance();
    }

    public DefaultScrollPaneViewRestorer(JScrollPane jScrollPane) throws UnsupportedComponentException {
        this();
        this.saveViewComponent(jScrollPane);
    }

    private void initInstance() {
        int n = 0;
        n |= 0x100;
        n |= 0x200;
        try {
            this.setRestoreMode(n);
        }
        catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
            throw new RuntimeException();
        }
        this.mclsComponentParser = this.createDefaultComponentParser();
    }

    protected void finalize() throws Throwable {
        this.mclsSaveScrollPane = null;
        this.mclsComponentParser = null;
        super.finalize();
    }

    public void saveViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JScrollPane)) {
            String string = "Any components other than 'javax.swing.JScrollPane' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        try {
            JScrollPane jScrollPane = (JScrollPane)component;
            this.mclsSaveScrollPane = ScrollPaneComponentUtilities.createCopyScrollPane(jScrollPane);
            ScrollPaneComponentParser scrollPaneComponentParser = (ScrollPaneComponentParser)this.getComponentParser();
            scrollPaneComponentParser.setAnalysisComponent(this.mclsSaveScrollPane);
            JViewport jViewport = this.mclsSaveScrollPane.getViewport();
            Point point = scrollPaneComponentParser.findViewPosition(jScrollPane);
            jViewport.setViewPosition(point);
        }
        catch (Exception exception) {
            System.err.println("[Default Scroll]Save View Failure");
            exception.printStackTrace();
            this.releaseSavedViewComponent();
        }
    }

    public void restoreViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JScrollPane)) {
            String string = "Any components other than 'javax.swing.JScrollPane' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        try {
            if (this.hasSavedViewComponent()) {
                JScrollPane jScrollPane = (JScrollPane)component;
                ScrollPaneComponentParser scrollPaneComponentParser = (ScrollPaneComponentParser)this.getComponentParser();
                scrollPaneComponentParser.setAnalysisComponent(jScrollPane);
                Point point = ScrollPaneComponentUtilities.getViewportViewPosition(jScrollPane);
                Point point2 = scrollPaneComponentParser.findViewPosition(this.mclsSaveScrollPane);
                int n = (int)point.getX();
                int n2 = (int)point.getY();
                int n3 = this.getRestoreMode();
                if ((n3 & 0x100) > 0) {
                    n = (int)point2.getX();
                }
                if ((n3 & 0x200) > 0) {
                    n2 = (int)point2.getY();
                }
                Point point3 = new Point(n, n2);
                JViewport jViewport = jScrollPane.getViewport();
                jViewport.setViewPosition(point3);
            }
        }
        catch (Exception exception) {
            System.err.println("[Default Scroll]Restore View Failure");
            exception.printStackTrace();
        }
    }

    public void setRestoreMode(int n) throws UnsupportedRestoreModeException {
        if (!this.isSupportedRestoreMode(n)) {
            String string = "The parameter which is not supported was specified [" + n + "].";
            throw new UnsupportedRestoreModeException(string);
        }
        this.miRestoreMode = n;
    }

    public int getRestoreMode() {
        return this.miRestoreMode;
    }

    public void setComponentParser(ComponentParser componentParser) throws IllegalArgumentException {
        if (componentParser == null || !(componentParser instanceof ScrollPaneComponentParser)) {
            String string = "Any components other than 'restoreview.ScrollPaneComponentParser' are not supported.";
            throw new IllegalArgumentException(string);
        }
        this.mclsComponentParser = (ScrollPaneComponentParser)componentParser;
    }

    public ComponentParser getComponentParser() {
        return this.mclsComponentParser;
    }

    public boolean isSupportedRestoreMode(int n) {
        int n2 = n;
        n2 &= 0xFFFFFEFF;
        return (n2 &= 0xFFFFFDFF) == 0;
    }

    public boolean hasSavedViewComponent() {
        return this.mclsSaveScrollPane != null;
    }

    public void releaseSavedViewComponent() {
        this.mclsSaveScrollPane = null;
    }

    protected ScrollPaneComponentParser createDefaultComponentParser() {
        return new DefaultScrollPaneComponentParser();
    }

    protected JScrollPane getSavedViewComponent() {
        return this.mclsSaveScrollPane;
    }
}

