/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.email;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcComboBoxModel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcPanel;
import sanproject.client.email.RJEmailApplyData;
import sanproject.client.email.RJEmailApplyItem;
import sanproject.client.email.RJEmailComboBox;
import sanproject.client.email.RJEmailComboItem;
import sanproject.client.email.RJEmailDataSupplier;
import sanproject.client.email.RJEmailEnvElement;
import sanproject.client.email.RJEmailGuideDef;
import sanproject.client.email.RJEmailListPanel;
import sanproject.client.email.RJEmailTextField;
import sanproject.client.email.RJEmailToAddrTablePanel;

public class RJEmailAddressPanel
extends RJcPanel
implements RJEmailGuideDef {
    private RJEmailDataSupplier supplier;
    private RJEmailEnvElement mailEnvElement = null;
    private JRadioButton radioEnable;
    private JRadioButton radioDisable;
    private CardLayout cardLayout = new CardLayout();
    private JPanel textPanel;
    private RJEmailTextField fromAddr = null;
    private RJEmailTextField retAddr = null;
    private RJEmailToAddrTablePanel addrTablePanel = null;
    private RJEmailTextField toAddr = null;
    private RJEmailComboBox toAttr = null;
    private RJcButton updBtn;
    private RJcButton delBtn;

    public RJEmailAddressPanel() {
        this((RJEmailDataSupplier)null);
    }

    public RJEmailAddressPanel(RJEmailDataSupplier rJEmailDataSupplier) {
        this.supplier = rJEmailDataSupplier;
        this.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.setBorder(border);
        this.setOpaque(false);
        RJEmailListPanel rJEmailListPanel = new RJEmailListPanel();
        rJEmailListPanel.setMinLabelWidth(140);
        rJEmailListPanel.addEntry("Email/FromAddressLbl", this.createFromAddrPanel());
        rJEmailListPanel.addEntry("Email/RetAddressLbl", this.createRetAddrPanel());
        rJEmailListPanel.addEntry2("Email/ToAddressLbl", this.createToAddrPanel());
        this.addrTablePanel.setToAddrTextField(this.toAddr);
        this.addrTablePanel.setToAttrComboBox(this.toAttr);
        this.addrTablePanel.setUpdButton(this.updBtn);
        this.addrTablePanel.setDelButton(this.delBtn);
        this.add((Component)rJEmailListPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel createFromAddrPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.fromAddr = new RJEmailTextField(19, 255);
        this.fromAddr.setEnabled(false);
        this.fromAddr.setEditable(false);
        this.fromAddr.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                RJEmailAddressPanel.this.from_caretUpdate(caretEvent);
            }
        });
        jPanel.add((Component)this.fromAddr, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createRetAddrPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.retAddr = new RJEmailTextField(19, 255);
        this.retAddr.setEnabled(false);
        this.retAddr.setEditable(false);
        this.retAddr.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                RJEmailAddressPanel.this.return_caretUpdate(caretEvent);
            }
        });
        jPanel.add((Component)this.retAddr, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createToAddrPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = this.createInputPanel();
        this.addrTablePanel = new RJEmailToAddrTablePanel(this.supplier);
        this.addrTablePanel.setBackground(RJcGuide.color("Email/ToAddrTablePanelBgClr"));
        jPanel.add((Component)this.addrTablePanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(4, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createInputPanel(), new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(4, 0, 4, 0), 0, 0));
        return jPanel;
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.toAddr = new RJEmailTextField(19, 255);
        this.toAddr.setEnabled(false);
        this.toAddr.setEditable(false);
        this.toAddr.setPreferredSize(new Dimension(300, 24));
        this.toAddr.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                RJEmailAddressPanel.this.to_caretUpdate(caretEvent);
            }
        });
        this.toAttr = new RJEmailComboBox();
        this.toAttr.setPreferredSize(new Dimension(100, 24));
        this.toAttr.setEnabled(false);
        this.updBtn = new RJcButton("Email/UpdateBtn");
        this.updBtn.setMargin(new Insets(2, 8, 2, 8));
        this.updBtn.setEnabled(false);
        this.updBtn.setPreferredSize(new Dimension(80, 24));
        this.updBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJEmailAddressPanel.this.updBtn_actionPerformed(actionEvent);
            }
        });
        this.delBtn = new RJcButton("Email/DeleteBtn");
        this.delBtn.setMargin(new Insets(2, 8, 2, 8));
        this.delBtn.setEnabled(false);
        this.delBtn.setPreferredSize(new Dimension(80, 24));
        this.delBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJEmailAddressPanel.this.delBtn_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)this.toAddr, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 4), 0, 0));
        jPanel.add((Component)this.toAttr, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 4), 0, 0));
        jPanel.add((Component)this.updBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 4), 0, 0));
        jPanel.add((Component)this.delBtn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void initAttrComboBox() {
        ArrayList<RJEmailComboItem> arrayList = new ArrayList<RJEmailComboItem>();
        for (int i = 1; i < 4; ++i) {
            RJEmailComboItem rJEmailComboItem = new RJEmailComboItem(new Integer(i));
            arrayList.add(rJEmailComboItem);
        }
        RJcComboBoxModel rJcComboBoxModel = new RJcComboBoxModel(arrayList);
        rJcComboBoxModel.setSelectedItem(null);
        this.toAttr.setModel((ComboBoxModel)rJcComboBoxModel);
        this.toAttr.setSelectedIndex(0);
        this.toAttr.setEnabled(this.supplier.isModify());
    }

    private void from_caretUpdate(CaretEvent caretEvent) {
        this.mailEnvElement = this.supplier.getMailEnvElement();
        String string = this.fromAddr.getText();
        this.mailEnvElement.setFromAddr(string);
        RJEmailApplyData rJEmailApplyData = this.supplier.getApplyData();
        this.supplier.setMailEnvElement(this.mailEnvElement);
        if (this.mailEnvElement.isModify()) {
            RJEmailApplyItem rJEmailApplyItem = new RJEmailApplyItem();
            rJEmailApplyItem.setEnvElement(this.mailEnvElement);
            rJEmailApplyData.updEmailInfo(rJEmailApplyItem);
        } else {
            rJEmailApplyData.clearEnvApplyData();
        }
    }

    private void return_caretUpdate(CaretEvent caretEvent) {
        this.mailEnvElement = this.supplier.getMailEnvElement();
        String string = this.retAddr.getText();
        this.mailEnvElement.setRetAddr(string);
        RJEmailApplyData rJEmailApplyData = this.supplier.getApplyData();
        this.supplier.setMailEnvElement(this.mailEnvElement);
        if (this.mailEnvElement.isModify()) {
            RJEmailApplyItem rJEmailApplyItem = new RJEmailApplyItem();
            rJEmailApplyItem.setEnvElement(this.mailEnvElement);
            rJEmailApplyData.updEmailInfo(rJEmailApplyItem);
        } else {
            rJEmailApplyData.clearEnvApplyData();
        }
    }

    private void to_caretUpdate(CaretEvent caretEvent) {
        String string = this.toAddr.getText();
    }

    private void updBtn_actionPerformed(ActionEvent actionEvent) {
        RJEmailComboItem rJEmailComboItem;
        int n;
        String string = this.toAddr.getText();
        if (this.addrTablePanel.updAddress(string, n = ((Integer)(rJEmailComboItem = (RJEmailComboItem)this.toAttr.getSelectedItem()).getValue()).intValue())) {
            this.toAddr.setText("");
            this.toAttr.setSelectedIndex(0);
            this.toAddr.setEnabled(false);
            this.toAddr.setEditable(false);
            this.toAttr.setEnabled(false);
        }
    }

    private void delBtn_actionPerformed(ActionEvent actionEvent) {
        this.addrTablePanel.delAddress();
        this.toAddr.setText("");
        this.toAttr.setSelectedIndex(0);
        this.toAddr.setEnabled(false);
        this.toAddr.setEditable(false);
        this.toAttr.setEnabled(false);
    }

    public void showPanel() {
        this.mailEnvElement = this.supplier.getMailEnvElement();
        this.fromAddr.setText(this.mailEnvElement.getFromAddr(), true);
        this.fromAddr.setEnabled(this.supplier.isModify());
        this.fromAddr.setEditable(this.supplier.isModify());
        this.retAddr.setText(this.mailEnvElement.getRetAddr(), true);
        this.retAddr.setEnabled(this.supplier.isModify());
        this.retAddr.setEditable(this.supplier.isModify());
        this.initAttrComboBox();
        this.addrTablePanel.init();
        this.toAddr.setText("", true);
        this.toAddr.setEditable(false);
        this.toAddr.setEnabled(false);
        this.toAttr.setEnabled(false);
    }
}

