/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.com;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AutocompleteComboBox
extends JComboBox {
    private AutocompleteComboPopup autocompletePopup = null;
    private transient DocumentListener editorDocumentListener;
    private transient KeyListener editorKeyListener;
    private transient InputMethodListener editorInputMethodListener;
    private transient FocusListener editorFocusListener;
    private boolean wantedPopup = true;

    public AutocompleteComboBox() {
        this((ComboBoxModel)new DefaultComboBoxModel());
    }

    public AutocompleteComboBox(Object[] objectArray) {
        this((ComboBoxModel)new DefaultComboBoxModel<Object>(objectArray));
    }

    public AutocompleteComboBox(Vector vector) {
        this((ComboBoxModel)new DefaultComboBoxModel(vector));
    }

    public AutocompleteComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.configure();
    }

    public boolean isEditable() {
        boolean bl = true;
        return bl;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        Document document = null;
        ComboBoxEditor comboBoxEditor = this.getEditor();
        if (comboBoxEditor != null) {
            JTextComponent jTextComponent = (JTextComponent)comboBoxEditor.getEditorComponent();
            document = jTextComponent.getDocument();
            document.removeDocumentListener(this.editorDocumentListener);
        }
        super.setModel(comboBoxModel);
        this.setSelectedItem(null);
        this.setShowPopupList(true);
        if (document != null) {
            document.addDocumentListener(this.editorDocumentListener);
        }
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        Object object;
        Component component;
        Component component2 = comboBoxEditor.getEditorComponent();
        if (!(component2 instanceof JTextComponent)) {
            String string = "To an editor Only 'javax.swing.text.JTextComponent' can be set up.";
            throw new IllegalArgumentException(string);
        }
        ComboBoxEditor comboBoxEditor2 = this.getEditor();
        if (comboBoxEditor2 != null) {
            component = comboBoxEditor2.getEditorComponent();
            if (component2 instanceof JTextComponent) {
                object = (JTextComponent)component;
                ((Component)object).removeKeyListener(this.editorKeyListener);
                ((Component)object).removeInputMethodListener(this.editorInputMethodListener);
                ((Component)object).removeFocusListener(this.editorFocusListener);
                Document document = ((JTextComponent)object).getDocument();
                document.removeDocumentListener(this.editorDocumentListener);
            }
        }
        super.setEditor(comboBoxEditor);
        component = (JTextComponent)component2;
        component.addKeyListener(this.editorKeyListener);
        ((JTextComponent)component).addInputMethodListener(this.editorInputMethodListener);
        component.addFocusListener(this.editorFocusListener);
        object = ((JTextComponent)component).getDocument();
        object.addDocumentListener(this.editorDocumentListener);
    }

    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        Object object2 = this.selectedItemReminder;
        if (object2 != null && object2.equals(object)) {
            ComboBoxEditor comboBoxEditor = this.getEditor();
            this.configureEditor(comboBoxEditor, object);
        }
    }

    public void setEditable(boolean bl) {
        String string = "can not change editable state.";
        throw new UnsupportedOperationException(string);
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        this.setShowPopupList(false);
        super.configureEditor(comboBoxEditor, object);
    }

    public void setAutocompletePopupVisible(boolean bl) {
        if (bl) {
            this.autocompletePopup.show();
        } else {
            this.autocompletePopup.hide();
        }
    }

    public boolean isAutocompletePopupVisible() {
        boolean bl = this.autocompletePopup.isVisible();
        return bl;
    }

    public void setEditorDocument(Document document) {
        Component component;
        ComboBoxEditor comboBoxEditor = this.getEditor();
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.setDocument(document);
        }
        this.setEditor(comboBoxEditor);
    }

    protected DocumentListener createEditorDocumentListener() {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processDocumentEvent(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (AutocompleteComboBox.this.isShowPopupList()) {
                    this.processDocumentEvent(documentEvent);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processDocumentEvent(documentEvent);
            }

            private void processDocumentEvent(DocumentEvent documentEvent) {
                String string;
                Document document = documentEvent.getDocument();
                int n = document.getLength();
                try {
                    string = document.getText(0, n);
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
                AutocompleteComboBox.this.updatePopupList(string);
                if (AutocompleteComboBox.this.isShowPopupList()) {
                    if (!AutocompleteComboBox.this.isAutocompletePopupVisible()) {
                        AutocompleteComboBox.this.setAutocompletePopupVisible(true);
                    }
                } else {
                    AutocompleteComboBox.this.setShowPopupList(true);
                }
            }
        };
        return documentListener;
    }

    protected KeyListener createEditorKeyListener() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed()) {
                    AutocompleteComboBox.this.processEditorComponentKeyEvent(keyEvent);
                }
            }
        };
        return keyAdapter;
    }

    protected InputMethodListener createEditorInputMethodListener() {
        InputMethodListener inputMethodListener = new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                int n = inputMethodEvent.getCommittedCharacterCount();
                if (n == 0) {
                    AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
                    if (attributedCharacterIterator != null) {
                        AutocompleteComboBox.this.setShowPopupList(false);
                    } else {
                        AutocompleteComboBox.this.setShowPopupList(true);
                    }
                }
            }

            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }
        };
        return inputMethodListener;
    }

    protected FocusListener createEditorFocusListener() {
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                Object object = focusEvent.getSource();
                if (object instanceof JTextComponent) {
                    JTextComponent jTextComponent = (JTextComponent)object;
                    jTextComponent.selectAll();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                AutocompleteComboBox.this.setAutocompletePopupVisible(false);
            }
        };
        return focusListener;
    }

    private void configure() {
        this.autocompletePopup = new AutocompleteComboPopup(this);
        this.editorDocumentListener = this.createEditorDocumentListener();
        this.editorKeyListener = this.createEditorKeyListener();
        this.editorInputMethodListener = this.createEditorInputMethodListener();
        this.editorFocusListener = this.createEditorFocusListener();
        AutocompleteComboBoxEditor autocompleteComboBoxEditor = new AutocompleteComboBoxEditor(this);
        this.setEditor(autocompleteComboBoxEditor);
        this.updatePopupList("");
    }

    private void updatePopupList(String string) {
        this.autocompletePopup.retrieveListStartsWith(string);
    }

    private void setShowPopupList(boolean bl) {
        this.wantedPopup = bl;
    }

    private boolean isShowPopupList() {
        boolean bl = this.wantedPopup;
        return bl;
    }

    private void processEditorComponentKeyEvent(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            int n = keyEvent.getKeyCode();
            if (this.isAutocompletePopupVisible()) {
                if (n == 38) {
                    JList<Object> jList = this.autocompletePopup.getList();
                    ListModel<Object> listModel = jList.getModel();
                    int n2 = listModel.getSize();
                    if (n2 > 0) {
                        int n3 = jList.getSelectedIndex();
                        if (n3 > -1) {
                            --n3;
                        }
                        if (n3 > -1) {
                            jList.setSelectedIndex(n3);
                        }
                    }
                    keyEvent.consume();
                } else if (n == 40) {
                    JList<Object> jList = this.autocompletePopup.getList();
                    ListModel<Object> listModel = jList.getModel();
                    int n4 = listModel.getSize();
                    if (n4 > 0) {
                        int n5 = jList.getSelectedIndex();
                        n5 = n5 < 0 ? 0 : ++n5;
                        if (n5 < n4) {
                            jList.setSelectedIndex(n5);
                        }
                    }
                    keyEvent.consume();
                } else if (n == 10) {
                    JList<Object> jList = this.autocompletePopup.getList();
                    ListModel<Object> listModel = jList.getModel();
                    int n6 = listModel.getSize();
                    int n7 = jList.getSelectedIndex();
                    if (n7 < n6) {
                        Object object = jList.getSelectedValue();
                        this.setSelectedItem(object);
                        if (object != null) {
                            String string = object.toString();
                            this.updatePopupList(string);
                        }
                    }
                    this.setAutocompletePopupVisible(false);
                    keyEvent.consume();
                } else if (n == 27) {
                    this.setAutocompletePopupVisible(false);
                    keyEvent.consume();
                }
            } else if (keyEvent.isControlDown() && n == 32) {
                this.setAutocompletePopupVisible(true);
                keyEvent.consume();
            }
        }
    }

    public static class AutocompleteComboPopup
    extends BasicComboPopup {
        public AutocompleteComboPopup(AutocompleteComboBox autocompleteComboBox) {
            super(autocompleteComboBox);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            ++dimension.height;
            return dimension;
        }

        protected JList createList() {
            JList jList = new JList();
            return jList;
        }

        protected int getPopupHeightForRowCount(int n) {
            JComboBox<Object> jComboBox = this.comboBox;
            JList<Object> jList = this.getList();
            ListCellRenderer<Object> listCellRenderer = jList.getCellRenderer();
            ComboBoxModel<Object> comboBoxModel = jComboBox.getModel();
            int n2 = jComboBox.getItemCount();
            int n3 = Math.min(n, n2);
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                Object e = comboBoxModel.getElementAt(i);
                Component component = listCellRenderer.getListCellRendererComponent(jList, e, i, false, false);
                Dimension dimension = component.getPreferredSize();
                n4 += dimension.height;
            }
            if (n4 == 0) {
                n4 = 100;
            }
            return n4;
        }

        protected MouseListener createListMouseListener() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    AutocompleteComboBox autocompleteComboBox = (AutocompleteComboBox)AutocompleteComboPopup.this.comboBox;
                    JList jList = AutocompleteComboPopup.this.list;
                    ListModel listModel = jList.getModel();
                    int n = listModel.getSize();
                    int n2 = jList.getSelectedIndex();
                    if (n2 < n) {
                        ComboBoxEditor comboBoxEditor;
                        Object e = jList.getSelectedValue();
                        autocompleteComboBox.setSelectedItem(e);
                        AutocompleteComboPopup.this.hide();
                        if (autocompleteComboBox.isEditable() && (comboBoxEditor = autocompleteComboBox.getEditor()) != null) {
                            autocompleteComboBox.setShowPopupList(false);
                            comboBoxEditor.setItem(e);
                        }
                    } else {
                        AutocompleteComboPopup.this.hide();
                    }
                }
            };
            return mouseAdapter;
        }

        public void retrieveListStartsWith(String string) {
            Object object;
            JComboBox<Object> jComboBox = this.comboBox;
            ComboBoxModel<Object> comboBoxModel = jComboBox.getModel();
            int n = comboBoxModel.getSize();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < n; ++i) {
                String string2;
                object = comboBoxModel.getElementAt(i);
                String string3 = object.toString();
                if (!(string3 = string3.toLowerCase()).startsWith(string2 = string.toLowerCase())) continue;
                arrayList.add(object);
            }
            Object[] objectArray = arrayList.toArray();
            object = this.getList();
            ((JList)object).setListData((Object[])objectArray);
            ((JList)object).clearSelection();
        }
    }

    public static class AutocompleteComboBoxEditor
    implements ComboBoxEditor {
        private JTextField textEditor;

        public AutocompleteComboBoxEditor(JComboBox jComboBox) {
            Border border;
            ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
            Component component = comboBoxEditor.getEditorComponent();
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                border = jComponent.getBorder();
            } else {
                border = BorderFactory.createEmptyBorder();
            }
            this.textEditor = new JTextField();
            this.textEditor.setBorder(border);
        }

        public Component getEditorComponent() {
            JTextField jTextField = this.textEditor;
            return jTextField;
        }

        public void addActionListener(ActionListener actionListener) {
            this.textEditor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.textEditor.removeActionListener(actionListener);
        }

        public void selectAll() {
            this.textEditor.selectAll();
            this.textEditor.requestFocus();
        }

        public Object getItem() {
            String string = this.textEditor.getText();
            return string;
        }

        public void setItem(Object object) {
            if (object != null) {
                String string = object.toString();
                this.textEditor.setText(string);
            } else {
                this.textEditor.setText("");
            }
        }
    }
}

