/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sanproject.client.com.RJCom;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.ApplyEndListener;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.Utility;

public class ApplyThread
extends Thread {
    public static final int STS_INITIALIZED = 16;
    public static final int STS_EXECUTE = 32;
    public static final int STS_END = 48;
    protected static final int ERP_NORMAL = 0;
    protected static final int ERP_CLIENT = AbstractDataControl.ERP_CLIENT;
    protected static final int ERP_HIC = AbstractDataControl.ERP_HIC;
    protected static final int MSG_APPLYNMLEND = 0;
    protected static final int MSG_UNKNOWN_ERR = 7060;
    protected static final int MSG_NO_ENDDATA = 7060;
    protected static final int MSG_SRVREQ_NG = 7111;
    protected static final int MSG_ENDDATA_UNMATCH = 7060;
    protected static final int MSG_NO_ENDLISTENER = 7060;
    protected String logName = "ApplyThread";
    protected int threadStatus;
    protected RJDataControl dctl;
    protected AbstractDataControl absDctl;
    protected ArrayList applyList = new ArrayList();
    protected ArrayList applyEndListenerList = new ArrayList();

    public ApplyThread(AbstractDataControl abstractDataControl) throws EXDException {
        this.absDctl = abstractDataControl;
        this.dctl = this.absDctl.getCommonDataControl();
        List list = this.absDctl.getApplyData();
        this.applyList.addAll(list);
        List list2 = this.absDctl.getApplyEndListener();
        this.applyEndListenerList.addAll(list2);
        if (this.applyEndListenerList.isEmpty()) {
            throw new EXDException(ERP_CLIENT, 7060, "No ApplyEndListener.");
        }
        this.threadStatus = 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        EXDException eXDException = new EXDException(ERP_CLIENT, 0);
        try {
            Object object;
            Utility.putLog(this.logName, "Apply Start");
            this.threadStatus = 32;
            this.waitCtl();
            Iterator iterator = this.applyList.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                this.dctl.setObject(object);
            }
            this.apply2Control();
            this.waitCtl();
            object = this.dctl.getApply2Data();
            if (object == null) {
                Utility.putLog(this.logName, "Fatal Error! getApply2Data() is null");
                throw new EXDException(ERP_CLIENT, 7060, "No ApplyEnd Data.");
            }
            try {
                this.absDctl.createErrInfo(object);
            }
            catch (ClassCastException classCastException) {
                String string = "Fatal Error! ApplyEnd Data Unmatch. " + classCastException.getMessage();
                Utility.putLog(this.logName, string);
                throw new EXDException(ERP_CLIENT, 7060, string);
            }
        }
        catch (EXDException eXDException2) {
            eXDException = eXDException2;
        }
        catch (Exception exception) {
            Utility.putExceptionLog(this.logName, eXDException);
            exception.printStackTrace();
            eXDException = new EXDException(ERP_CLIENT, 7060);
        }
        finally {
            int n = eXDException.getPosition();
            int n2 = eXDException.getCode();
            RJDataMsg rJDataMsg = RJCom.getMsg(this.dctl, n, n2);
            Utility.putLog(this.logName, "ApplyThread End Status=(" + n + ":" + n2 + ")");
            this.threadStatus = 48;
            this.applyEndNotice(rJDataMsg);
        }
    }

    public int getStatus() {
        return this.threadStatus;
    }

    protected void apply2Control() throws EXDException {
        this.waitCtl();
        if (this.dctl.Apply2Start()) {
            while (!this.dctl.EndData) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        } else {
            RJCom.putLog(this.dctl, "ExDevice", this.logName, "Apply2Start() failure.", 0);
            throw new EXDException(ERP_CLIENT, 7111, "Apply2Start() failure.");
        }
        this.waitCtl();
        ArrayList arrayList = this.dctl.getEndStatus();
        int n = (Integer)arrayList.get(0);
        int n2 = (Integer)arrayList.get(1);
        RJCom.putLog(this.dctl, "ExDevice", this.logName, "applyEnd Status=(" + n + ":" + n2 + ")", 0);
        if (n != 0) {
            throw new EXDException(n, n2);
        }
    }

    public void waitCtl() {
        while (this.dctl.getControlDoing().getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    public RJDataControl getCommonDataControl() {
        return this.dctl;
    }

    protected void applyEndNotice(RJDataMsg rJDataMsg) {
        Iterator iterator = this.applyEndListenerList.iterator();
        while (iterator.hasNext()) {
            ((ApplyEndListener)iterator.next()).applyProcessFinished(rJDataMsg);
        }
    }
}

