/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.ExternalVolumeInfo;
import sanproject.client.exdevice.data.ExternalVolumeMaintenanceData;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.VolumeOperationDataControl;
import sanproject.client.exdevice.data.VpgInfo;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDVpg;
import sanproject.serverux.dataimpl.EXDgetMappedExternalVolume_IN;
import sanproject.serverux.dataimpl.EXDgetMappedExternalVolume_OUT;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class ExternalVolumeManager
implements Singleton {
    private static final String LOG_NAME = "ExternalVolumeManager";
    private ArrayList mExtVolInfoList = new ArrayList();
    private int mPathGroupId = -1;
    private HashMap mUnconfiguardVolumes = new HashMap();
    static Comparator mExVolPgidComparator = new ExternalVolumePgidComparator();
    static /* synthetic */ Class class$sanproject$client$exdevice$data$ExternalVolumeManager;
    static /* synthetic */ Class class$sanproject$client$exdevice$data$ExternalVolumeMaintenanceData;

    ExternalVolumeManager() {
    }

    public static synchronized ExternalVolumeManager getInstance() {
        return (ExternalVolumeManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$ExternalVolumeManager == null ? (class$sanproject$client$exdevice$data$ExternalVolumeManager = ExternalVolumeManager.class$("sanproject.client.exdevice.data.ExternalVolumeManager")) : class$sanproject$client$exdevice$data$ExternalVolumeManager);
    }

    public void destroy() {
    }

    void initialize() {
        this.mExtVolInfoList.clear();
        this.mPathGroupId = -1;
        this.mUnconfiguardVolumes.clear();
    }

    public Collection getExternalVolumeInfo(PathGroupInfo pathGroupInfo) throws EXDException {
        int n = pathGroupInfo.getId();
        ArrayList arrayList = pathGroupInfo.isConfiguard() ? this.getConfiguardVolume(pathGroupInfo) : new ArrayList();
        ArrayList arrayList2 = this.getUnconfiguardVolumes(n);
        ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
        arrayList3.addAll(arrayList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            ExternalVolumeInfo externalVolumeInfo = (ExternalVolumeInfo)arrayList2.get(i);
            int n2 = Collections.binarySearch(arrayList3, externalVolumeInfo, mExVolPgidComparator);
            if (n2 >= 0) {
                Object e = arrayList3.get(n2);
                if (externalVolumeInfo.equals(e)) {
                    arrayList3.set(n2, externalVolumeInfo);
                    continue;
                }
                arrayList3.add(n2, externalVolumeInfo);
                continue;
            }
            n2 = -(n2 + 1);
            arrayList3.add(n2, externalVolumeInfo);
        }
        return arrayList3;
    }

    ArrayList getConfiguardVolume(PathGroupInfo pathGroupInfo) throws EXDException {
        int n = pathGroupInfo.getId();
        if (this.mPathGroupId != n) {
            ExternalVolumeInfo[] externalVolumeInfoArray;
            Object object;
            this.mPathGroupId = n;
            EXDgetMappedExternalVolume_IN eXDgetMappedExternalVolume_IN = new EXDgetMappedExternalVolume_IN();
            eXDgetMappedExternalVolume_IN.setPathGroupID(n);
            VolumeOperationDataControl volumeOperationDataControl = VolumeOperationDataControl.getInstance();
            EXDgetMappedExternalVolume_OUT eXDgetMappedExternalVolume_OUT = (EXDgetMappedExternalVolume_OUT)volumeOperationDataControl.comGet((SanRmiInputInterface)eXDgetMappedExternalVolume_IN);
            EXDExternalVolume[] eXDExternalVolumeArray = eXDgetMappedExternalVolume_OUT.getAllExternalVolume(n);
            int n2 = eXDExternalVolumeArray.length;
            this.mExtVolInfoList = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                object = eXDExternalVolumeArray[i];
                if (object == null) continue;
                externalVolumeInfoArray = new ExternalVolumeInfo((EXDExternalVolume)object);
                this.mExtVolInfoList.add(externalVolumeInfoArray);
            }
            Collections.sort(this.mExtVolInfoList, mExVolPgidComparator);
            PresetManager presetManager = PresetManager.getInstance();
            object = presetManager.getEntryClass();
            if ((class$sanproject$client$exdevice$data$ExternalVolumeMaintenanceData == null ? (class$sanproject$client$exdevice$data$ExternalVolumeMaintenanceData = ExternalVolumeManager.class$("sanproject.client.exdevice.data.ExternalVolumeMaintenanceData")) : class$sanproject$client$exdevice$data$ExternalVolumeMaintenanceData).equals(object)) {
                externalVolumeInfoArray = new ExternalVolumeInfo[this.mExtVolInfoList.size()];
                externalVolumeInfoArray = this.mExtVolInfoList.toArray(externalVolumeInfoArray);
                ExternalVolumeMaintenanceData.refrectModifyValue(externalVolumeInfoArray);
            }
        }
        return this.mExtVolInfoList;
    }

    ExternalVolumeInfo getCachedVolume(VpgInfo vpgInfo) {
        int n;
        ExternalVolumeInfo externalVolumeInfo = null;
        EXDVpg eXDVpg = vpgInfo.getEXDVpg();
        int n2 = eXDVpg.referPathGroupId();
        if (this.mPathGroupId == n2 && (n = Collections.binarySearch(this.mExtVolInfoList, eXDVpg, mExVolPgidComparator)) >= 0) {
            externalVolumeInfo = (ExternalVolumeInfo)this.mExtVolInfoList.get(n);
        }
        return externalVolumeInfo;
    }

    void addExternalVolume(ExternalVolumeInfo externalVolumeInfo) {
        int n = externalVolumeInfo.getPathGroupId();
        ArrayList arrayList = this.getUnconfiguardVolumes(n);
        int n2 = Collections.binarySearch(arrayList, externalVolumeInfo, mExVolPgidComparator);
        if (n2 >= 0) {
            Object e = arrayList.get(n2);
            if (externalVolumeInfo.equals(e)) {
                arrayList.set(n2, externalVolumeInfo);
            } else {
                arrayList.add(n2, externalVolumeInfo);
            }
        } else {
            n2 = -(n2 + 1);
            arrayList.add(n2, externalVolumeInfo);
        }
    }

    void removeExternalVolume(ExternalVolumeInfo externalVolumeInfo) {
        int n = externalVolumeInfo.getPathGroupId();
        ArrayList arrayList = this.getUnconfiguardVolumes(n);
        int n2 = arrayList.indexOf(externalVolumeInfo);
        if (n2 >= 0) {
            arrayList.remove(n2);
        }
    }

    ArrayList getUnconfiguardVolumes(int n) {
        Integer n2 = new Integer(n);
        ArrayList arrayList = (ArrayList)this.mUnconfiguardVolumes.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList(0);
            this.mUnconfiguardVolumes.put(n2, arrayList);
        }
        return arrayList;
    }

    ExternalVolumeInfo[] getUnconfiguardVolumes() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.mUnconfiguardVolumes.values().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll((ArrayList)iterator.next());
        }
        ExternalVolumeInfo[] externalVolumeInfoArray = new ExternalVolumeInfo[]{};
        externalVolumeInfoArray = arrayList.toArray(externalVolumeInfoArray);
        return externalVolumeInfoArray;
    }

    Set getChar2OfUnconfiguardVolumes() {
        ExternalVolumeInfo[] externalVolumeInfoArray = this.getUnconfiguardVolumes();
        int n = externalVolumeInfoArray.length;
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = externalVolumeInfoArray[i].getCharacteristic2();
            hashSet.add(string);
        }
        return hashSet;
    }

    void clearCache(int n) {
        if (this.mPathGroupId == n) {
            this.mPathGroupId = -1;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ExternalVolumePgidComparator
    implements Comparator {
        ExternalVolumePgidComparator() {
        }

        public int compare(Object object, Object object2) {
            RJiPGIndex rJiPGIndex = this.getPgIndex(object);
            RJiPGIndex rJiPGIndex2 = this.getPgIndex(object2);
            return rJiPGIndex.compareTo((Object)rJiPGIndex2);
        }

        RJiPGIndex getPgIndex(Object object) {
            Object object2 = object instanceof ExternalVolumeInfo ? ((ExternalVolumeInfo)object).getVpgInfo().getEXDVpg() : (object instanceof VpgInfo ? ((VpgInfo)object).getEXDVpg() : (RJiPGIndex)object);
            return object2;
        }
    }
}

