/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.com.TableSortedEvent;
import sanproject.client.openldevguard.gui.DataWrapper;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.OpenLDEVGuardProperties;
import sanproject.client.openldevguard.gui.main.AbstractPagingTableModel;
import sanproject.client.openldevguard.gui.main.CUWrapper;
import sanproject.client.openldevguard.gui.main.ExtentAreaWrapper;
import sanproject.client.openldevguard.gui.main.LDEVAndExtentDataTableItem;
import sanproject.client.openldevguard.gui.main.LDEVWrapper;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.gui.main.TableDataItem;
import sanproject.client.openldevguard.gui.main.ViewDefine;
import sanproject.client.openldevguard.utility.ObjectUtilities;

class LDEVAndExtentTableModel
extends AbstractPagingTableModel {
    private static final int MAXCOUNT_INPAGE = 8192;
    public static final String VIEWTYPE_EMPTY = "";
    public static final String VIEWTYPE_LDEV = "ldev";
    public static final String VIEWTYPE_EXTENT = "extent";
    public static final int LDEVTYPE_LDEV = 0;
    public static final int LDEVTYPE_ATTRIBUTE = 1;
    public static final int LDEVTYPE_TYPE = 2;
    public static final int LDEVTYPE_CAPACITY = 3;
    public static final int LDEVTYPE_VMA = 4;
    public static final int LDEVTYPE_SVOL = 5;
    public static final int LDEVTYPE_RESERVED = 6;
    public static final int LDEVTYPE_RETENTION = 7;
    public static final int LDEVTYPE_PATHS = 8;
    public static final int LDEVTYPE_MODE = 9;
    public static final int LDEVTYPE_MAX_LENGTH = 10;
    public static final int EXTENTTYPE_EXTENTID = 0;
    public static final int EXTENTTYPE_ATTRIBUTE = 1;
    public static final int EXTENTTYPE_LBA = 2;
    public static final int EXTENTTYPE_CAPACITY = 3;
    public static final int EXTENTTYPE_RETENTION = 4;
    public static final int EXTENTTYPE_STATUS = 5;
    public static final int EXTENTTYPE_PROGRESS = 6;
    public static final int EXTENTTYPE_MAX_LENGTH = 7;
    private OpenLDEVGuardDataControlWrapper mdcwWrapper;
    private List mlstRowDataList;
    private String mstrViewType;
    private int[] marrLDEVSorterType;
    private int[] marrExtentSorterType;
    private String[] marrLDEVColumnNames;
    private String[] marrLDEVColumnIDs;
    private String[] marrExtentColumnNames;
    private String[] marrExtentColumnIDs;
    private volatile int miProtectCount;
    private volatile int miReadOnlyCount;
    private volatile int miReadWriteCount;
    private volatile int miVMAProtectCount;
    private volatile int miVMAReadOnlyCount;
    private volatile int miVMAReadWriteCount;
    private volatile int miExtentProtectCount;
    private volatile int miExtentReadOnlyCount;
    private volatile int miExtentReadWriteCount;

    LDEVAndExtentTableModel(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper) {
        this.loadProperties();
        this.mdcwWrapper = openLDEVGuardDataControlWrapper;
        this.mlstRowDataList = new ArrayList();
        this.mstrViewType = VIEWTYPE_EMPTY;
        this.marrLDEVSorterType = new int[10];
        this.marrLDEVColumnIDs = new String[10];
        this.marrLDEVColumnNames = new String[10];
        this.marrLDEVSorterType[0] = 2;
        this.marrLDEVColumnIDs[0] = VIEWTYPE_LDEV;
        this.marrLDEVColumnNames[0] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/LDEV");
        this.marrLDEVSorterType[1] = 1;
        this.marrLDEVColumnIDs[1] = "attribute";
        this.marrLDEVColumnNames[1] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Attribute");
        this.marrLDEVSorterType[2] = 2;
        this.marrLDEVColumnIDs[2] = "type";
        this.marrLDEVColumnNames[2] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Emulation");
        this.marrLDEVSorterType[3] = 2;
        this.marrLDEVColumnIDs[3] = "capacity";
        this.marrLDEVColumnNames[3] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Capacity_Caption");
        this.marrLDEVSorterType[4] = 2;
        this.marrLDEVColumnIDs[4] = "vmasize";
        this.marrLDEVColumnNames[4] = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_VMASIZE");
        this.marrLDEVSorterType[5] = 1;
        this.marrLDEVColumnIDs[5] = "svol";
        this.marrLDEVColumnNames[5] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/SVOL_Open");
        this.marrLDEVSorterType[6] = 1;
        this.marrLDEVColumnIDs[6] = "reserved";
        this.marrLDEVColumnNames[6] = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_RESERVED");
        this.marrLDEVSorterType[7] = 2;
        this.marrLDEVColumnIDs[7] = "term";
        this.marrLDEVColumnNames[7] = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_RETENTIONTERM");
        this.marrLDEVSorterType[8] = 2;
        this.marrLDEVColumnIDs[8] = "paths";
        this.marrLDEVColumnNames[8] = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_PATHS");
        this.marrLDEVSorterType[9] = 1;
        this.marrLDEVColumnIDs[9] = "mode";
        this.marrLDEVColumnNames[9] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Mode");
        this.marrExtentSorterType = new int[7];
        this.marrExtentColumnIDs = new String[7];
        this.marrExtentColumnNames = new String[7];
        this.marrExtentSorterType[0] = 2;
        this.marrExtentColumnIDs[0] = VIEWTYPE_EXTENT;
        this.marrExtentColumnNames[0] = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_EXTENTID");
        this.marrExtentSorterType[1] = 1;
        this.marrExtentColumnIDs[1] = "attribute";
        this.marrExtentColumnNames[1] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Attribute");
        this.marrExtentSorterType[2] = 2;
        this.marrExtentColumnIDs[2] = "lba";
        this.marrExtentColumnNames[2] = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_LBA");
        this.marrExtentSorterType[3] = 2;
        this.marrExtentColumnIDs[3] = "capacity";
        this.marrExtentColumnNames[3] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Capacity_Caption");
        this.marrExtentSorterType[4] = 2;
        this.marrExtentColumnIDs[4] = "term";
        this.marrExtentColumnNames[4] = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_RETENTIONTERM");
        this.marrExtentSorterType[5] = 1;
        this.marrExtentColumnIDs[5] = "status";
        this.marrExtentColumnNames[5] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Status");
        this.marrExtentSorterType[6] = 2;
        this.marrExtentColumnIDs[6] = "progress";
        this.marrExtentColumnNames[6] = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_PROGRESS");
        this.miProtectCount = 0;
        this.miReadOnlyCount = 0;
        this.miReadWriteCount = 0;
        this.miVMAProtectCount = 0;
        this.miVMAReadOnlyCount = 0;
        this.miVMAReadWriteCount = 0;
    }

    public final int getMaxRowCountInPage() {
        int n = 8192;
        return n;
    }

    protected final List getAllRowDataList() {
        return this.mlstRowDataList;
    }

    protected final TableDataItem createCellObject(Object object, int n) {
        TableDataItem tableDataItem;
        if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
            LDEVWrapper lDEVWrapper = (LDEVWrapper)object;
            int n2 = this.convertToLdevColumnIndex(n);
            tableDataItem = this.createLDEVTypeCellObject(lDEVWrapper, n2);
        } else if (this.mstrViewType.equals(VIEWTYPE_EXTENT)) {
            ExtentAreaWrapper extentAreaWrapper = (ExtentAreaWrapper)object;
            tableDataItem = this.createExtentTypeCellObject(extentAreaWrapper, n);
        } else {
            tableDataItem = null;
        }
        return tableDataItem;
    }

    protected final TableDataItem[] getRowCellItems(Object object) {
        TableDataItem[] tableDataItemArray;
        if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
            tableDataItemArray = new TableDataItem[10];
            for (int i = 0; i < 10; ++i) {
                tableDataItemArray[i] = this.createCellObject(object, i);
            }
        } else if (this.mstrViewType.equals(VIEWTYPE_EXTENT)) {
            tableDataItemArray = new TableDataItem[7];
            for (int i = 0; i < 7; ++i) {
                tableDataItemArray[i] = this.createCellObject(object, i);
            }
        } else {
            tableDataItemArray = new TableDataItem[]{};
        }
        return tableDataItemArray;
    }

    protected final int getSorterType(int n) {
        int n2;
        if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
            int n3 = this.convertToLdevColumnIndex(n);
            n2 = this.marrLDEVSorterType[n3];
        } else {
            n2 = this.mstrViewType.equals(VIEWTYPE_EXTENT) ? this.marrExtentSorterType[n] : 2;
        }
        return n2;
    }

    public final int getSortingIndex() {
        String string = ObjectUtilities.getClassName(this);
        String string2 = this.mstrViewType.equals(VIEWTYPE_LDEV) ? string + ".ldevtype_sortingindex" : (this.mstrViewType.equals(VIEWTYPE_EXTENT) ? string + ".extenttype_sortingindex" : null);
        int n = -1;
        if (string2 != null) {
            String string3 = OpenLDEVGuardProperties.getProperty(string2);
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = String.valueOf(n);
                OpenLDEVGuardProperties.setProperty(string2, string4);
            }
        }
        return n;
    }

    public final int getSortKind(int n) {
        int n2 = this.getSortingIndex();
        int n3 = -1;
        if (n2 == n) {
            String string = ObjectUtilities.getClassName(this);
            String string2 = this.mstrViewType.equals(VIEWTYPE_LDEV) ? string + ".ldevtype_sortkind" : (this.mstrViewType.equals(VIEWTYPE_EXTENT) ? string + ".extenttype_sortkind" : null);
            if (string2 != null) {
                String string3 = OpenLDEVGuardProperties.getProperty(string2);
                try {
                    n3 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    String string4 = String.valueOf(n3);
                    OpenLDEVGuardProperties.setProperty(string2, string4);
                }
            }
        }
        return n3;
    }

    protected final String[] getColumnNames() {
        String[] stringArray = this.mstrViewType.equals(VIEWTYPE_LDEV) ? this.convertToLdevColumnArray(this.marrLDEVColumnNames) : (this.mstrViewType.equals(VIEWTYPE_EXTENT) ? this.marrExtentColumnNames : new String[]{});
        return stringArray;
    }

    protected final String[] getColumnIDs() {
        String[] stringArray = this.mstrViewType.equals(VIEWTYPE_LDEV) ? this.convertToLdevColumnArray(this.marrLDEVColumnIDs) : (this.mstrViewType.equals(VIEWTYPE_EXTENT) ? this.marrExtentColumnIDs : new String[]{});
        return stringArray;
    }

    private void loadProperties() {
        String string;
        String string2 = ObjectUtilities.getClassName(this);
        String string3 = string2 + ".ldevtype_sortingindex";
        int n = -1;
        if (ViewDefine.isSupportLoadViewProperties() && (string = OpenLDEVGuardProperties.getProperty(string3)) != null && !string.equals(VIEWTYPE_EMPTY)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        string = String.valueOf(n);
        OpenLDEVGuardProperties.setProperty(string3, string);
        string3 = string2 + ".extenttype_sortingindex";
        n = -1;
        if (ViewDefine.isSupportLoadViewProperties() && (string = OpenLDEVGuardProperties.getProperty(string3)) != null && !string.equals(VIEWTYPE_EMPTY)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        string = String.valueOf(n);
        OpenLDEVGuardProperties.setProperty(string3, string);
        string3 = string2 + ".ldevtype_sortkind";
        n = 0;
        if (ViewDefine.isSupportLoadViewProperties() && (string = OpenLDEVGuardProperties.getProperty(string3)) != null && !string.equals(VIEWTYPE_EMPTY)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        string = String.valueOf(n);
        OpenLDEVGuardProperties.setProperty(string3, string);
        string3 = string2 + ".extenttype_sortkind";
        n = 0;
        if (ViewDefine.isSupportLoadViewProperties() && (string = OpenLDEVGuardProperties.getProperty(string3)) != null && !string.equals(VIEWTYPE_EMPTY)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        string = String.valueOf(n);
        OpenLDEVGuardProperties.setProperty(string3, string);
    }

    private TableDataItem createLDEVTypeCellObject(LDEVWrapper lDEVWrapper, int n) {
        TableDataItem tableDataItem;
        switch (n) {
            case 0: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVNumberCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 1: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVAttributeCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 2: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVTypeCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 3: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVCapacityCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 4: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVVMASizeCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 5: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVSVolCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 6: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVReservedCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 7: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVTermCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 8: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVPathsCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 9: {
                tableDataItem = LDEVAndExtentDataTableItem.createLDEVModeCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            default: {
                tableDataItem = null;
            }
        }
        return tableDataItem;
    }

    private TableDataItem createExtentTypeCellObject(ExtentAreaWrapper extentAreaWrapper, int n) {
        LDEVAndExtentDataTableItem lDEVAndExtentDataTableItem;
        switch (n) {
            case 0: {
                lDEVAndExtentDataTableItem = LDEVAndExtentDataTableItem.createExtentIDCellItem(this.mdcwWrapper, extentAreaWrapper);
                break;
            }
            case 1: {
                lDEVAndExtentDataTableItem = LDEVAndExtentDataTableItem.createExtentAttributeCellItem(this.mdcwWrapper, extentAreaWrapper);
                break;
            }
            case 2: {
                lDEVAndExtentDataTableItem = LDEVAndExtentDataTableItem.createExtentLBARangeCellItem(this.mdcwWrapper, extentAreaWrapper);
                break;
            }
            case 3: {
                lDEVAndExtentDataTableItem = LDEVAndExtentDataTableItem.createExtentCapacityCellItem(this.mdcwWrapper, extentAreaWrapper);
                break;
            }
            case 4: {
                lDEVAndExtentDataTableItem = LDEVAndExtentDataTableItem.createExtentTermCellItem(this.mdcwWrapper, extentAreaWrapper);
                break;
            }
            case 5: {
                lDEVAndExtentDataTableItem = LDEVAndExtentDataTableItem.createExtentStatusCellItem(this.mdcwWrapper, extentAreaWrapper);
                break;
            }
            case 6: {
                lDEVAndExtentDataTableItem = LDEVAndExtentDataTableItem.createExtentProgressCellItem(this.mdcwWrapper, extentAreaWrapper);
                break;
            }
            default: {
                lDEVAndExtentDataTableItem = null;
            }
        }
        return lDEVAndExtentDataTableItem;
    }

    public final void initializeData(CUWrapper cUWrapper) throws OpenLDEVGuardException {
        Object object;
        if (cUWrapper != null) {
            object = this.mdcwWrapper.getAllLDEVs(cUWrapper);
            this.mlstRowDataList = Arrays.asList(object);
            this.mstrViewType = VIEWTYPE_LDEV;
        } else {
            this.mlstRowDataList = new ArrayList();
            this.mstrViewType = VIEWTYPE_EMPTY;
        }
        this.countAttributes();
        this.updateCellData();
        object = new TableModelEvent(this, -1);
        this.fireTableChanged((TableModelEvent)object);
        int n = this.getSortingIndex();
        int n2 = this.getSortKind(n);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n, n2);
        this.fireTableSorted(tableSortedEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initializeData(LDEVWrapper lDEVWrapper) throws OpenLDEVGuardException {
        ExtentAreaWrapper[] extentAreaWrapperArray = new ExtentAreaWrapper[]{};
        try {
            if (lDEVWrapper != null) {
                this.mstrViewType = VIEWTYPE_EXTENT;
                extentAreaWrapperArray = lDEVWrapper.getExtentAreas();
            } else {
                this.mstrViewType = VIEWTYPE_EMPTY;
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mlstRowDataList = Arrays.asList(extentAreaWrapperArray);
            this.countAttributes();
            this.updateCellData();
            TableModelEvent tableModelEvent = new TableModelEvent(this, -1);
            this.fireTableChanged(tableModelEvent);
            int n = this.getSortingIndex();
            int n2 = this.getSortKind(n);
            TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n, n2);
            this.fireTableSorted(tableSortedEvent);
            throw throwable;
        }
        this.mlstRowDataList = Arrays.asList(extentAreaWrapperArray);
        this.countAttributes();
        this.updateCellData();
        TableModelEvent tableModelEvent = new TableModelEvent(this, -1);
        this.fireTableChanged(tableModelEvent);
        int n = this.getSortingIndex();
        int n3 = this.getSortKind(n);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n, n3);
        this.fireTableSorted(tableSortedEvent);
    }

    public final void requestSort(int n) {
        int n2 = this.getSortKind(n);
        n2 = this.getNextSortKind(n, n2);
        this.updateSortingFlags(n, n2);
        this.updateSortCellData(n, n2);
        n2 = this.getRowCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2);
        this.fireTableChanged(tableModelEvent);
        n2 = this.getSortingIndex();
        int n3 = this.getSortKind(n2);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n2, n3);
        this.fireTableSorted(tableSortedEvent);
    }

    public final LDEVWrapper[] requestChangeAttribute(int[] nArray, byte by) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
            if (nArray.length > 0) {
                int n = this.getRowCount();
                int n2 = 0;
                ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
                for (int i = 0; i < nArray.length; ++i) {
                    int n3 = nArray[i];
                    LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n3);
                    if (lDEVWrapper.canChangeAttribute()) {
                        lDEVWrapper.changeAttribute(by);
                        arrayList.add(lDEVWrapper);
                    }
                    if (n > n3) {
                        n = n3;
                    }
                    if (n2 >= n3) continue;
                    n2 = n3;
                }
                this.updateRows(nArray);
                TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
                this.fireTableChanged(tableModelEvent);
                lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
            }
        } else if (this.mstrViewType.equals(VIEWTYPE_EXTENT) && nArray.length > 0) {
            int n = this.getRowCount();
            int n4 = 0;
            LDEVWrapper lDEVWrapper = null;
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = nArray[i];
                ExtentAreaWrapper extentAreaWrapper = (ExtentAreaWrapper)this.getRowDataRowAt(n5);
                if (extentAreaWrapper.canChangeAttribute()) {
                    extentAreaWrapper.changeAttribute(by);
                    lDEVWrapper = extentAreaWrapper.getParentLDEV();
                }
                if (n > n5) {
                    n = n5;
                }
                if (n4 >= n5) continue;
                n4 = n5;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n4, -1, 0);
            this.fireTableChanged(tableModelEvent);
            if (lDEVWrapper != null) {
                lDEVWrapperArray = new LDEVWrapper[]{lDEVWrapper};
            }
        }
        this.countAttributes();
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestChangeSVolState(int[] nArray, boolean bl) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV) && nArray.length > 0) {
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n3);
                if (lDEVWrapper.canChangeSVolState()) {
                    lDEVWrapper.setSVolEnabled(bl);
                    arrayList.add(lDEVWrapper);
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
        }
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestChangeReservedState(int[] nArray, boolean bl) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV) && nArray.length > 0) {
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n3);
                if (lDEVWrapper.canChangeReserved()) {
                    lDEVWrapper.setReserved(bl);
                    arrayList.add(lDEVWrapper);
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
        }
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestChangeTermDays(int[] nArray, int n) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
            if (nArray.length > 0) {
                int n2 = this.getRowCount();
                int n3 = 0;
                ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
                for (int i = 0; i < nArray.length; ++i) {
                    int n4 = nArray[i];
                    LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n4);
                    if (lDEVWrapper.canChangeRetentionTerm()) {
                        lDEVWrapper.setRetentionTerm(n);
                        arrayList.add(lDEVWrapper);
                    }
                    if (n2 > n4) {
                        n2 = n4;
                    }
                    if (n3 >= n4) continue;
                    n3 = n4;
                }
                this.updateRows(nArray);
                TableModelEvent tableModelEvent = new TableModelEvent(this, n2, n3, -1, 0);
                this.fireTableChanged(tableModelEvent);
                lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
            }
        } else if (this.mstrViewType.equals(VIEWTYPE_EXTENT) && nArray.length > 0) {
            int n5 = this.getRowCount();
            int n6 = 0;
            LDEVWrapper lDEVWrapper = null;
            for (int i = 0; i < nArray.length; ++i) {
                int n7 = nArray[i];
                ExtentAreaWrapper extentAreaWrapper = (ExtentAreaWrapper)this.getRowDataRowAt(n7);
                if (extentAreaWrapper.canChangeRetentionTerm()) {
                    extentAreaWrapper.setRetentionTerm(n);
                    lDEVWrapper = extentAreaWrapper.getParentLDEV();
                }
                if (n5 > n7) {
                    n5 = n7;
                }
                if (n6 >= n7) continue;
                n6 = n7;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n5, n6, -1, 0);
            this.fireTableChanged(tableModelEvent);
            if (lDEVWrapper != null) {
                lDEVWrapperArray = new LDEVWrapper[]{lDEVWrapper};
            }
        }
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestCreateVMAArea(int[] nArray) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV) && nArray.length > 0) {
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n3);
                if (lDEVWrapper.canCreateVMA()) {
                    lDEVWrapper.createVMAArea();
                    arrayList.add(lDEVWrapper);
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
        }
        this.countAttributes();
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestReleaseVMAArea(int[] nArray) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV) && nArray.length > 0) {
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n3);
                if (lDEVWrapper.canReleaseVMA()) {
                    lDEVWrapper.releaseVMAArea();
                    arrayList.add(lDEVWrapper);
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
        }
        this.countAttributes();
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestDeleteVMAArea(int[] nArray) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV) && nArray.length > 0) {
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n3);
                if (lDEVWrapper.canDeleteVMA()) {
                    lDEVWrapper.deleteVMAArea();
                    arrayList.add(lDEVWrapper);
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
        }
        this.countAttributes();
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestClearMode(int[] nArray) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_LDEV) && nArray.length > 0) {
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList<LDEVWrapper> arrayList = new ArrayList<LDEVWrapper>();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                LDEVWrapper lDEVWrapper = (LDEVWrapper)this.getRowDataRowAt(n3);
                if (lDEVWrapper.canClearMode()) {
                    lDEVWrapper.clearMode();
                    arrayList.add(lDEVWrapper);
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            lDEVWrapperArray = arrayList.toArray(lDEVWrapperArray);
        }
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestCreateExtentArea(int[] nArray, long l, long l2, byte by, int n) throws OpenLDEVGuardException {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        OpenLDEVGuardException openLDEVGuardException = null;
        if (this.mstrViewType.equals(VIEWTYPE_EXTENT) && nArray.length > 0) {
            int n2 = this.getRowCount();
            int n3 = 0;
            LDEVWrapper lDEVWrapper = null;
            long l3 = l;
            long l4 = l2;
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = nArray[i];
                ExtentAreaWrapper extentAreaWrapper = (ExtentAreaWrapper)this.getRowDataRowAt(n4);
                if (extentAreaWrapper.canCreateExtentArea()) {
                    LDEVWrapper lDEVWrapper2 = extentAreaWrapper.getParentLDEV();
                    if (lDEVWrapper2.canCreateExtentArea(l3, l4)) {
                        extentAreaWrapper.createExtentArea(l3, l4, by);
                        extentAreaWrapper.setRetentionTerm(n);
                        lDEVWrapper = lDEVWrapper2;
                        l3 += l2;
                    } else {
                        RJDataMsg rJDataMsg = this.mdcwWrapper.createMessageObject(9610, 9994);
                        openLDEVGuardException = new OpenLDEVGuardException(rJDataMsg);
                        break;
                    }
                }
                if (n2 > n4) {
                    n2 = n4;
                }
                if (n3 >= n4) continue;
                n3 = n4;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n2, n3, -1, 0);
            this.fireTableChanged(tableModelEvent);
            if (lDEVWrapper != null) {
                lDEVWrapperArray = new LDEVWrapper[]{lDEVWrapper};
            }
        }
        this.countAttributes();
        if (openLDEVGuardException != null) {
            throw openLDEVGuardException;
        }
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestReleaseExtentArea(int[] nArray) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_EXTENT) && nArray.length > 0) {
            LDEVWrapper lDEVWrapper = null;
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                ExtentAreaWrapper extentAreaWrapper = (ExtentAreaWrapper)this.getRowDataRowAt(n3);
                if (extentAreaWrapper.canReleaseExtentArea()) {
                    extentAreaWrapper.releaseExtentArea();
                    lDEVWrapper = extentAreaWrapper.getParentLDEV();
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            if (lDEVWrapper != null) {
                lDEVWrapperArray = new LDEVWrapper[]{lDEVWrapper};
            }
        }
        this.countAttributes();
        return lDEVWrapperArray;
    }

    public final LDEVWrapper[] requestCancelShred(int[] nArray) {
        LDEVWrapper[] lDEVWrapperArray = new LDEVWrapper[]{};
        if (this.mstrViewType.equals(VIEWTYPE_EXTENT) && nArray.length > 0) {
            LDEVWrapper lDEVWrapper = null;
            int n = this.getRowCount();
            int n2 = 0;
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                ExtentAreaWrapper extentAreaWrapper = (ExtentAreaWrapper)this.getRowDataRowAt(n3);
                if (extentAreaWrapper.canCancelShredProcess()) {
                    extentAreaWrapper.cancelShredding();
                    lDEVWrapper = extentAreaWrapper.getParentLDEV();
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n3) continue;
                n2 = n3;
            }
            this.updateRows(nArray);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
            this.fireTableChanged(tableModelEvent);
            if (lDEVWrapper != null) {
                lDEVWrapperArray = new LDEVWrapper[]{lDEVWrapper};
            }
        }
        return lDEVWrapperArray;
    }

    private void updateSortingFlags(int n, int n2) {
        if (!this.mstrViewType.equals(VIEWTYPE_EMPTY)) {
            String string = ObjectUtilities.getClassName(this);
            String string2 = this.mstrViewType.equals(VIEWTYPE_LDEV) ? string + ".ldevtype_" : (this.mstrViewType.equals(VIEWTYPE_EXTENT) ? string + ".extenttype_" : VIEWTYPE_EMPTY);
            String string3 = String.valueOf(n);
            String string4 = String.valueOf(n2);
            OpenLDEVGuardProperties.setProperty(string2 + "sortingindex", string3);
            OpenLDEVGuardProperties.setProperty(string2 + "sortkind", string4);
        }
    }

    void countAttributes() {
        this.miProtectCount = 0;
        this.miReadOnlyCount = 0;
        this.miReadWriteCount = 0;
        this.miVMAProtectCount = 0;
        this.miVMAReadOnlyCount = 0;
        this.miVMAReadWriteCount = 0;
        this.miExtentProtectCount = 0;
        this.miExtentReadOnlyCount = 0;
        this.miExtentReadWriteCount = 0;
        Iterator iterator = this.mlstRowDataList.iterator();
        while (iterator.hasNext()) {
            byte by;
            DataWrapper dataWrapper;
            boolean bl = false;
            boolean bl2 = false;
            if (this.mstrViewType.equals(VIEWTYPE_LDEV)) {
                dataWrapper = (LDEVWrapper)iterator.next();
                by = dataWrapper.getAttribute();
                bl = dataWrapper.hasVMAArea();
                bl2 = dataWrapper.hasExtentArea();
            } else if (this.mstrViewType.equals(VIEWTYPE_EXTENT)) {
                dataWrapper = (ExtentAreaWrapper)iterator.next();
                by = dataWrapper.getAttribute();
            } else {
                by = 0;
            }
            if (by == -127) {
                ++this.miProtectCount;
            } else if (by == -126) {
                ++this.miReadOnlyCount;
            } else if (by == -128) {
                ++this.miReadWriteCount;
            }
            if (bl2) {
                if (by == -127) {
                    ++this.miExtentProtectCount;
                    continue;
                }
                if (by == -126) {
                    ++this.miExtentReadOnlyCount;
                    continue;
                }
                if (by != -128) continue;
                ++this.miExtentReadWriteCount;
                continue;
            }
            if (!bl) continue;
            if (by == -127) {
                ++this.miVMAProtectCount;
                continue;
            }
            if (by == -126) {
                ++this.miVMAReadOnlyCount;
                continue;
            }
            if (by != -128) continue;
            ++this.miVMAReadWriteCount;
        }
    }

    public final void changePreviousPage() {
        int n = this.getShowPage();
        this.updateChangePageAt(n - 1);
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2, n3, -1);
        this.fireTableChanged(tableModelEvent);
    }

    public final void changeNextPage() {
        int n = this.getShowPage();
        this.updateChangePageAt(n + 1);
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2, n3, -1);
        this.fireTableChanged(tableModelEvent);
    }

    public final String getViewType() {
        return this.mstrViewType;
    }

    public final int getAttributeCount(byte by) {
        int n = by == -127 ? this.miProtectCount : (by == -126 ? this.miReadOnlyCount : (by == -128 ? this.miReadWriteCount : 0));
        return n;
    }

    public int getAttributeCountHasVMAArea(byte by) {
        int n = by == -127 ? this.miVMAProtectCount : (by == -126 ? this.miVMAReadOnlyCount : (by == -128 ? this.miVMAReadWriteCount : 0));
        return n;
    }

    public int getAttributeCountHasExtentArea(byte by) {
        int n = by == -127 ? this.miExtentProtectCount : (by == -126 ? this.miExtentReadOnlyCount : (by == -128 ? this.miExtentReadWriteCount : 0));
        return n;
    }

    public final Object getRowDataRowAt(int n) {
        TableDataItem tableDataItem = (TableDataItem)this.getValueAt(n, 0);
        Object object = tableDataItem.getReferencedObject();
        return object;
    }

    private int convertToLdevColumnIndex(int n) {
        int n2 = 0;
        if (!this.mdcwWrapper.isSupportFunctionVma()) {
            if (0 <= n && n < 4) {
                n2 = 0;
            } else if (4 <= n) {
                n2 = 1;
            }
        }
        return n + n2;
    }

    private String[] convertToLdevColumnArray(String[] stringArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length && (n = this.convertToLdevColumnIndex(i)) < stringArray.length; ++i) {
            arrayList.add(stringArray[n]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    public boolean isRetentionTermColumnIndex(int n) {
        return this.convertToLdevColumnIndex(n) == 7;
    }
}

