/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.restoreview.DefaultComboBoxViewRestorer;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.openldevguard.gui.ComponentFactory;
import sanproject.client.openldevguard.gui.main.StandardComponentFactory;
import sanproject.client.openldevguard.gui.main.ViewDefine;

public class LdkcAndCuGroupComponent
extends RJcListPanel {
    private JComboBox ldkcCombo;
    private JComboBox cuGroupCombo;
    private DefaultComboBoxViewRestorer ldkcRestorer;
    private DefaultComboBoxViewRestorer cuGroupRestorer;
    private int beforeLdkc = 0;
    private int beforeCuGroup = 0;

    public LdkcAndCuGroupComponent(String string, String string2) {
        this.initializeComponents(string, string2);
    }

    public void initializeComponents(String string, String string2) {
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        this.ldkcCombo = componentFactory.createComboBox();
        this.addEntry(string, this.ldkcCombo);
        this.cuGroupCombo = componentFactory.createComboBox();
        this.addEntry(string2, this.cuGroupCombo);
        this.completed();
        this.ldkcRestorer = new DefaultComboBoxViewRestorer();
        this.cuGroupRestorer = new DefaultComboBoxViewRestorer();
    }

    private ItemListener[] removeItemListeners(JComboBox jComboBox) {
        ItemListener[] itemListenerArray = jComboBox.getItemListeners();
        for (int i = 0; i < itemListenerArray.length; ++i) {
            jComboBox.removeItemListener(itemListenerArray[i]);
        }
        return itemListenerArray;
    }

    private void addItemListeners(JComboBox jComboBox, ItemListener[] itemListenerArray) {
        for (int i = 0; i < itemListenerArray.length; ++i) {
            jComboBox.addItemListener(itemListenerArray[i]);
        }
    }

    public void saveViewComponentsState() {
        try {
            this.ldkcRestorer.saveViewComponent(this.ldkcCombo);
            this.cuGroupRestorer.saveViewComponent(this.cuGroupCombo);
        }
        catch (UnsupportedComponentException unsupportedComponentException) {
            unsupportedComponentException.printStackTrace();
        }
    }

    public void restoreViewComponentsState() {
        try {
            this.ldkcRestorer.restoreViewComponent(this.ldkcCombo);
            this.ldkcRestorer.releaseSavedViewComponent();
        }
        catch (UnsupportedComponentException unsupportedComponentException) {
            unsupportedComponentException.printStackTrace();
        }
        try {
            this.cuGroupRestorer.restoreViewComponent(this.cuGroupCombo);
            this.cuGroupRestorer.releaseSavedViewComponent();
        }
        catch (UnsupportedComponentException unsupportedComponentException) {
            unsupportedComponentException.printStackTrace();
        }
    }

    public void addItemListenerLkdc(ItemListener itemListener) {
        this.ldkcCombo.addItemListener(itemListener);
    }

    public void addItemListenerCuGroup(ItemListener itemListener) {
        this.cuGroupCombo.addItemListener(itemListener);
    }

    public String getLdkcString() {
        String string = null;
        LdkcItem ldkcItem = (LdkcItem)this.ldkcCombo.getSelectedItem();
        if (ldkcItem != null) {
            string = ldkcItem.toString();
        }
        return string;
    }

    public String getCuGroupString() {
        String string = null;
        CuGroupItem cuGroupItem = (CuGroupItem)this.cuGroupCombo.getSelectedItem();
        if (cuGroupItem != null) {
            string = cuGroupItem.toString();
        }
        return string;
    }

    public int getLdkc() {
        int n = 0;
        LdkcItem ldkcItem = (LdkcItem)this.ldkcCombo.getSelectedItem();
        if (ldkcItem != null) {
            n = ldkcItem.getLdkc();
        }
        return n;
    }

    public int getCuGroup() {
        int n = 0;
        CuGroupItem cuGroupItem = (CuGroupItem)this.cuGroupCombo.getSelectedItem();
        if (cuGroupItem != null) {
            n = cuGroupItem.getCuGroup();
        }
        return n;
    }

    public void loadLdkc() {
        int n;
        ItemListener[] itemListenerArray = this.removeItemListeners(this.ldkcCombo);
        int n2 = this.ldkcCombo.getItemCount();
        for (n = 0; n < n2; ++n) {
            LdkcItem ldkcItem = (LdkcItem)this.ldkcCombo.getItemAt(n);
            if (ldkcItem.getLdkc() != this.beforeLdkc) continue;
            this.ldkcCombo.setSelectedIndex(n);
            break;
        }
        if (n2 != 0 && n == n2) {
            this.ldkcCombo.setSelectedIndex(0);
        }
        this.addItemListeners(this.ldkcCombo, itemListenerArray);
    }

    public void loadCuGroup() {
        int n;
        ItemListener[] itemListenerArray = this.removeItemListeners(this.cuGroupCombo);
        int n2 = this.cuGroupCombo.getItemCount();
        for (n = 0; n < n2; ++n) {
            CuGroupItem cuGroupItem = (CuGroupItem)this.cuGroupCombo.getItemAt(n);
            if (cuGroupItem.getCuGroup() != this.beforeCuGroup) continue;
            this.cuGroupCombo.setSelectedIndex(n);
            break;
        }
        if (n2 != 0 && n == n2) {
            this.cuGroupCombo.setSelectedIndex(0);
        }
        this.addItemListeners(this.cuGroupCombo, itemListenerArray);
    }

    public void saveLdkc(int n) {
        this.beforeLdkc = n;
    }

    public void saveCuGroup(int n) {
        this.beforeCuGroup = n;
    }

    public void setModelLdkc(Integer[] integerArray) {
        LdkcItem[] ldkcItemArray = new LdkcItem[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            ldkcItemArray[i] = new LdkcItem(integerArray[i]);
        }
        DefaultComboBoxModel<LdkcItem> defaultComboBoxModel = new DefaultComboBoxModel<LdkcItem>(ldkcItemArray);
        this.ldkcCombo.setModel(defaultComboBoxModel);
    }

    public void setModelCuGroup(Integer[] integerArray) {
        CuGroupItem[] cuGroupItemArray = new CuGroupItem[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            cuGroupItemArray[i] = new CuGroupItem(integerArray[i]);
        }
        DefaultComboBoxModel<CuGroupItem> defaultComboBoxModel = new DefaultComboBoxModel<CuGroupItem>(cuGroupItemArray);
        this.cuGroupCombo.setModel(defaultComboBoxModel);
    }

    public void selectLdkc(int n) {
        int n2;
        this.ldkcCombo.setSelectedIndex(-1);
        int n3 = this.ldkcCombo.getItemCount();
        for (n2 = 0; n2 < n3; ++n2) {
            LdkcItem ldkcItem = (LdkcItem)this.ldkcCombo.getItemAt(n2);
            if (ldkcItem.getLdkc() != n) continue;
            this.ldkcCombo.setSelectedIndex(n2);
            break;
        }
        if (n3 != 0 && n2 == n3) {
            this.ldkcCombo.setSelectedIndex(0);
        }
    }

    public void selectCuGroup(int n) {
        int n2;
        this.cuGroupCombo.setSelectedIndex(-1);
        int n3 = this.cuGroupCombo.getItemCount();
        for (n2 = 0; n2 < n3; ++n2) {
            CuGroupItem cuGroupItem = (CuGroupItem)this.cuGroupCombo.getItemAt(n2);
            if (cuGroupItem.getCuGroup() != n) continue;
            this.cuGroupCombo.setSelectedIndex(n2);
            break;
        }
        if (n3 != 0 && n2 == n3) {
            this.cuGroupCombo.setSelectedIndex(0);
        }
    }

    public class CuGroupItem {
        private final int cuGroup;
        private final String itemString;

        public CuGroupItem(int n) {
            this.cuGroup = n;
            this.itemString = ViewDefine.convertToCUGroupString(n);
        }

        public int getCuGroup() {
            return this.cuGroup;
        }

        public String toString() {
            return this.itemString;
        }
    }

    public class LdkcItem {
        private final int ldkcNumber;
        private final String itemString;

        public LdkcItem(int n) {
            this.ldkcNumber = n;
            this.itemString = ViewDefine.convertToLDKCNumberString(n);
        }

        public int getLdkc() {
            return this.ldkcNumber;
        }

        public String toString() {
            return this.itemString;
        }
    }
}

