/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.util.ArrayList;
import java.util.Iterator;
import sanproject.client.pool.RJPoolLdevElement;
import sanproject.serverux.dataimpl.QSAddPoolData;
import sanproject.serverux.dataimpl.QSPoolVolData;
import sanproject.serverux.dataimpl.QSRecoveryPoolData;
import sanproject.serverux.dataimpl.QSUpdatePoolData;

public class RJPoolApplyItem
implements Comparable {
    public static final int POOLID_MIN = 0;
    public static final int POOLID_MAX = 127;
    public static final int THRESHOLD_MIN = 20;
    public static final int THRESHOLD_MIN_AOU = 5;
    public static final int THRESHOLD_MAX = 95;
    public static final int THRESHOLD_DEF = 80;
    public static final int THRESHOLD_DEF_AOU = 70;
    public static final int THRESHOLD_INC = 5;
    public static final int GRAIN_SIZE_QS = 1;
    public static final int GRAIN_SIZE_AOU = 168;
    private int func = 0;
    private int allowFunc = 0;
    private int poolId = -1;
    private int threshold = 80;
    private int fixThreshold = 80;
    private int grainSize = 1;
    private int kind = 1;
    private int usedPercent = 0;
    private ArrayList poolVolList = new ArrayList();
    private boolean invalidity = false;

    public RJPoolApplyItem() {
        this(-1);
    }

    public RJPoolApplyItem(int n) {
        this.poolId = n;
    }

    public int getFunc() {
        return this.func;
    }

    public void setFunc(int n) {
        this.func = n;
    }

    public int getAllowFunc() {
        return this.allowFunc;
    }

    public void setAllowFunc(int n) {
        this.allowFunc = n;
    }

    public boolean isFunc(int n) {
        return (this.func & n) != 0;
    }

    public int getPoolId() {
        return this.poolId;
    }

    public void setPoolId(int n) {
        this.poolId = n;
    }

    public boolean isPoolIdValidity() {
        boolean bl = this.poolId >= 0 && this.poolId <= 127;
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJPoolApplyItem) {
            bl = this.poolId == ((RJPoolApplyItem)object).getPoolId();
        }
        return bl;
    }

    public int hashCode() {
        int n = this.poolId;
        return n;
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object instanceof RJPoolApplyItem) {
            n = this.poolId - ((RJPoolApplyItem)object).getPoolId();
        }
        return n;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public int getFixThreshold() {
        return this.fixThreshold;
    }

    public void setFixThreshold(int n) {
        this.fixThreshold = n;
    }

    public int getGrainSize() {
        return this.grainSize;
    }

    public void setGrainSize(int n) {
        this.grainSize = n;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int n) {
        this.kind = n;
    }

    public int getUsedPercent() {
        return this.usedPercent;
    }

    public void setUsedPercent(int n) {
        this.usedPercent = n;
    }

    public ArrayList getPoolVolList() {
        return this.poolVolList;
    }

    public void addPoolVol(RJPoolLdevElement rJPoolLdevElement) {
        this.poolVolList.add(rJPoolLdevElement);
    }

    public boolean isInvalidity() {
        return this.invalidity;
    }

    public void setInvalidity(boolean bl) {
        this.invalidity = bl;
    }

    public boolean merge(RJPoolApplyItem rJPoolApplyItem) {
        boolean bl = false;
        if (!rJPoolApplyItem.isInvalidity()) {
            bl = true;
            int n = rJPoolApplyItem.getFunc();
            if (n == 1) {
                if (this.func != 2) {
                    this.func |= n;
                }
                this.poolVolList.addAll(rJPoolApplyItem.getPoolVolList());
            } else if (n == 16) {
                this.func = n;
                this.threshold = -1;
                this.fixThreshold = -1;
                this.grainSize = rJPoolApplyItem.getGrainSize();
                this.kind = rJPoolApplyItem.getKind();
                this.poolVolList.clear();
            } else if (n == 32) {
                ArrayList arrayList = rJPoolApplyItem.getPoolVolList();
                for (int i = this.poolVolList.size() - 1; i >= 0; --i) {
                    if (!arrayList.contains(this.poolVolList.get(i))) continue;
                    this.poolVolList.remove(i);
                }
                if (this.poolVolList.size() <= 0) {
                    this.func &= 0xFFFFFFFE;
                }
                if (this.func == 0) {
                    bl = false;
                }
            } else {
                this.func |= n;
                this.threshold = rJPoolApplyItem.getThreshold();
                this.fixThreshold = rJPoolApplyItem.getFixThreshold();
                this.grainSize = rJPoolApplyItem.getGrainSize();
                this.kind = rJPoolApplyItem.getKind();
            }
        }
        return bl;
    }

    public QSAddPoolData createAddParam() {
        QSAddPoolData qSAddPoolData = null;
        if (this.isFunc(2)) {
            qSAddPoolData = new QSAddPoolData();
            qSAddPoolData.sPoolId = (short)this.poolId;
            qSAddPoolData.sPoolFixThreshold = (short)this.fixThreshold;
            qSAddPoolData.sPoolThreshold = (short)this.threshold;
            qSAddPoolData.sPoolGrainSize = (short)this.grainSize;
            qSAddPoolData.byPoolKind = (byte)this.kind;
            qSAddPoolData.objPoolVolData = this.createPoolVols();
        }
        return qSAddPoolData;
    }

    public QSUpdatePoolData createDeleteParam() {
        QSUpdatePoolData qSUpdatePoolData = null;
        if (this.isFunc(16)) {
            qSUpdatePoolData = new QSUpdatePoolData();
            qSUpdatePoolData.sPoolId = (short)this.poolId;
        }
        return qSUpdatePoolData;
    }

    public QSRecoveryPoolData createRestoreParam() {
        QSRecoveryPoolData qSRecoveryPoolData = null;
        if (this.isFunc(8)) {
            qSRecoveryPoolData = new QSRecoveryPoolData();
            qSRecoveryPoolData.sPoolId = (short)this.poolId;
            qSRecoveryPoolData.lErrorCode = 0L;
        }
        return qSRecoveryPoolData;
    }

    public QSUpdatePoolData createChangeParam() {
        QSUpdatePoolData qSUpdatePoolData = null;
        if (this.isFunc(4)) {
            qSUpdatePoolData = new QSUpdatePoolData();
            qSUpdatePoolData.sPoolId = (short)this.poolId;
            qSUpdatePoolData.sPoolThreshold = (short)this.threshold;
            qSUpdatePoolData.sPoolGrainSize = (short)this.grainSize;
            qSUpdatePoolData.byPoolKind = (byte)this.kind;
        }
        return qSUpdatePoolData;
    }

    public QSAddPoolData createAddVolParam() {
        QSAddPoolData qSAddPoolData = null;
        if (this.isFunc(1)) {
            qSAddPoolData = new QSAddPoolData();
            qSAddPoolData.sPoolId = (short)this.poolId;
            qSAddPoolData.sPoolThreshold = (short)this.threshold;
            qSAddPoolData.sPoolFixThreshold = (short)this.fixThreshold;
            qSAddPoolData.sPoolGrainSize = (short)this.grainSize;
            qSAddPoolData.byPoolKind = (byte)this.kind;
            qSAddPoolData.objPoolVolData = this.createPoolVols();
        }
        return qSAddPoolData;
    }

    private QSPoolVolData[] createPoolVols() {
        QSPoolVolData[] qSPoolVolDataArray = null;
        if (this.poolVolList.size() > 0) {
            qSPoolVolDataArray = new QSPoolVolData[this.poolVolList.size()];
            Iterator iterator = this.poolVolList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                RJPoolLdevElement rJPoolLdevElement = (RJPoolLdevElement)iterator.next();
                qSPoolVolDataArray[n] = new QSPoolVolData();
                qSPoolVolDataArray[n].sLDKC = (short)rJPoolLdevElement.getLDKC();
                qSPoolVolDataArray[n].sCU = (short)rJPoolLdevElement.getCU();
                qSPoolVolDataArray[n].sLDEV = (short)rJPoolLdevElement.getLdev();
                ++n;
            }
        }
        return qSPoolVolDataArray;
    }

    public String toString() {
        String string = new String("");
        string = string + "Id=" + this.poolId;
        string = string + ", FixThreshold=" + this.fixThreshold;
        if (this.threshold >= 0) {
            string = string + ", Threshold=" + this.threshold;
        }
        string = string + ", GrainSize=" + this.grainSize;
        string = string + ", Kind=" + this.kind;
        Iterator iterator = this.poolVolList.iterator();
        if (iterator.hasNext()) {
            RJPoolLdevElement rJPoolLdevElement = (RJPoolLdevElement)iterator.next();
            string = string + ", [" + rJPoolLdevElement.toString();
            int n = 0;
            while (iterator.hasNext()) {
                if (n >= 8) {
                    string = string + " ...";
                    break;
                }
                rJPoolLdevElement = (RJPoolLdevElement)iterator.next();
                string = string + ", " + rJPoolLdevElement.toString();
                ++n;
            }
            string = string + "]";
        }
        return string;
    }
}

