/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.syslog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import sanproject.client.com.RJClientFileAccess;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDef;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJComWaitingDialog;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.com.RJcLabelPanel;
import sanproject.client.com.RJcPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.data.RJDataStartParam;
import sanproject.client.syslog.RJMediator;
import sanproject.client.syslog.RJRadioButton;
import sanproject.client.syslog.RJslDataControl;
import sanproject.client.syslog.RJslDef;
import sanproject.client.syslog.RJslGuide;
import sanproject.client.syslog.RJslLocationField;
import sanproject.client.syslog.RJslMediator;
import sanproject.client.syslog.RJslTabPanel;
import sanproject.serverux.data.AuditConfigData;
import sanproject.serverux.data.SysLogServ;

public class RJslCenterPanel
extends RJcPanel
implements RJslGuide,
RJMediator {
    RJslTabPanel parentPanel;
    RJslMediator mainMediator;
    RJslMediator subMediator;
    RJcHeaderPanel headerPanel;
    RJcLabelPanel main_OutPanel;
    RJcLabelPanel main_IPSetPanel;
    RJcLabelPanel sub_OutPanel;
    RJcLabelPanel sub_IPsetPanel;
    RJcLabelPanel locationPanel;
    RJcLabelPanel detailPanel;
    RJcLabelPanel exportPanel;
    JPanel loca_DmyPanel;
    RJslLocationField location;
    RJRadioButton detail_Enable;
    RJRadioButton detail_Disable;
    JButton export_Button;
    RJcCushionPanel main_OutPanel_c;
    RJcCushionPanel main_IPSetPanel_c;
    RJcCushionPanel sub_OutPanel_c;
    RJcCushionPanel sub_IPsetPanel_c;
    RJcCushionPanel locationPanel_c;
    RJcCushionPanel detailPanel_c;
    RJcCushionPanel exportPanel_c;
    private RJslDataControl dataControl;
    public final String FILE_SEP = System.getProperty("file.separator");
    RJDataControl m_DataControl;

    public RJslCenterPanel() {
        this((RJslDataControl)null);
    }

    public RJslCenterPanel(RJslDataControl rJslDataControl) {
        this.dataControl = rJslDataControl;
        this.init();
    }

    public void init() {
        this.setOpaque(false);
        this.headerPanel = new RJcHeaderPanel(RJcGuide.text("syslog/SubTitle"));
        this.mainMediator = new RJslMediator();
        this.subMediator = new RJslMediator();
        this.mainMediator.setMediatorNum(0);
        this.subMediator.setMediatorNum(1);
        this.mainMediator.setDataControl(this.dataControl);
        this.subMediator.setDataControl(this.dataControl);
        this.main_OutPanel_c = this.mainMediator.getRadioPanel();
        this.sub_OutPanel_c = this.subMediator.getRadioPanel();
        this.main_IPSetPanel_c = this.mainMediator.getIPTextPanel();
        this.sub_IPsetPanel_c = this.subMediator.getIPTextPanel();
        this.detail_Enable = new RJRadioButton(RJcGuide.text("syslog/Enable"), false);
        this.detail_Disable = new RJRadioButton(RJcGuide.text("syslog/Disable"), true);
        this.location = new RJslLocationField(32);
        this.detail_Enable.setOpaque(false);
        this.detail_Disable.setOpaque(false);
        this.detail_Enable.setMediator(this);
        this.detail_Disable.setMediator(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.detail_Enable);
        buttonGroup.add(this.detail_Disable);
        this.location.setMediator(this);
        this.location.setBorder(BorderFactory.createEmptyBorder());
        this.location.setOpaque(false);
        this.export_Button = new RJcButton("syslog/Export");
        this.export_Button.setEnabled(false);
        this.export_Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJslCenterPanel.this.exportButton_actionPerformed(actionEvent);
            }
        });
        this.loca_DmyPanel = new JPanel();
        this.loca_DmyPanel.setLayout(new GridBagLayout());
        this.loca_DmyPanel.setBackground(Color.white);
        this.loca_DmyPanel.setBorder(UIManager.getBorder("TextField.border"));
        this.loca_DmyPanel.setPreferredSize(new Dimension(400, 20));
        this.loca_DmyPanel.add((Component)this.location, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel_c = this.createLocationPanel();
        this.detailPanel_c = this.createDetailPanel();
        this.exportPanel_c = this.createExportPanel();
        this.main_OutPanel = new RJcLabelPanel(RJcGuide.text("syslog/MainOut"));
        this.main_IPSetPanel = new RJcLabelPanel(RJcGuide.text("syslog/MainSet"));
        this.sub_OutPanel = new RJcLabelPanel(RJcGuide.text("syslog/SubOut"));
        this.sub_IPsetPanel = new RJcLabelPanel(RJcGuide.text("syslog/SubSet"));
        this.locationPanel = new RJcLabelPanel(RJcGuide.text("syslog/Location"));
        this.detailPanel = new RJcLabelPanel(RJcGuide.text("syslog/DetaiOut"));
        this.exportPanel = new RJcLabelPanel(RJcGuide.text("syslog/Inside"));
        this.main_OutPanel.setPreferredSize(new Dimension(250, 30));
        this.main_IPSetPanel.setPreferredSize(new Dimension(250, 60));
        this.sub_OutPanel.setPreferredSize(new Dimension(250, 30));
        this.sub_IPsetPanel.setPreferredSize(new Dimension(250, 60));
        this.locationPanel.setPreferredSize(new Dimension(250, 30));
        this.detailPanel.setPreferredSize(new Dimension(250, 30));
        this.exportPanel.setPreferredSize(new Dimension(250, 30));
        this.main_OutPanel_c.setPreferredSize(new Dimension(300, 30));
        this.main_IPSetPanel_c.setPreferredSize(new Dimension(300, 60));
        this.sub_OutPanel_c.setPreferredSize(new Dimension(300, 30));
        this.sub_IPsetPanel_c.setPreferredSize(new Dimension(300, 60));
        this.locationPanel_c.setPreferredSize(new Dimension(300, 30));
        this.detailPanel_c.setPreferredSize(new Dimension(300, 30));
        this.exportPanel_c.setPreferredSize(new Dimension(300, 30));
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.createCenterPanel(), "Center");
    }

    public void showpanel() {
        SysLogServ sysLogServ = this.dataControl.getMain_state();
        if (!this.dataControl.check_IP(sysLogServ)) {
            sysLogServ.I_IP_Add = sysLogServ.B_IPv6 ? RJslDef.def_IPv6 : RJslDef.def_IPv4;
            this.dataControl.compel_set();
        }
        this.mainMediator.setValue(sysLogServ);
        sysLogServ = this.dataControl.getSub_state();
        if (!this.dataControl.check_IP(sysLogServ)) {
            sysLogServ.I_IP_Add = sysLogServ.B_IPv6 ? RJslDef.def_IPv6_2 : RJslDef.def_IPv4_2;
            this.dataControl.compel_set();
        }
        this.subMediator.setValue(sysLogServ);
        this.location.setText(this.dataControl.getLocation());
        this.detail_Enable.setSelected(this.dataControl.detail_Enable());
        this.detail_Disable.setSelected(!this.dataControl.detail_Enable());
        this.mainMediator.setModifyMode(this.dataControl.isModify());
        this.subMediator.setModifyMode(this.dataControl.isModify());
        if (!this.dataControl.isModify()) {
            this.location.setEnabled(true);
            this.location.setEditable(false);
        } else {
            this.location.setEnabled(true);
            this.location.setEditable(true);
        }
        this.detail_Enable.setEnabled(this.dataControl.isModify());
        this.detail_Disable.setEnabled(this.dataControl.isModify());
        this.detail_Enable.setstate(false);
        this.detail_Disable.setstate(false);
        this.export_Button.setEnabled(true);
        this.location.setBlue(false);
        this.location.setItalic(false);
    }

    private RJcPanel createCenterPanel() {
        RJcPanel rJcPanel = new RJcPanel();
        rJcPanel.setOpaque(false);
        JLabel jLabel = new JLabel(" ");
        rJcPanel.setLayout(new GridBagLayout());
        rJcPanel.add((Component)this.main_OutPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        rJcPanel.add((Component)this.main_OutPanel_c, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        rJcPanel.add((Component)this.main_IPSetPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        rJcPanel.add((Component)this.main_IPSetPanel_c, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        rJcPanel.add((Component)this.sub_OutPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        rJcPanel.add((Component)this.sub_OutPanel_c, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        rJcPanel.add((Component)this.sub_IPsetPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        rJcPanel.add((Component)this.sub_IPsetPanel_c, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        rJcPanel.add((Component)this.locationPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        rJcPanel.add((Component)this.locationPanel_c, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        rJcPanel.add((Component)this.detailPanel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        rJcPanel.add((Component)this.detailPanel_c, new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        rJcPanel.add((Component)this.exportPanel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        rJcPanel.add((Component)this.exportPanel_c, new GridBagConstraints(1, 6, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        rJcPanel.add((Component)jLabel, new GridBagConstraints(0, 7, 2, 1, 0.1, 0.1, 11, 2, new Insets(2, 0, 2, 2), 0, 0));
        return rJcPanel;
    }

    public void colleagueChanged() {
        if (this.location.getText().equals(this.dataControl.getLocation())) {
            this.location.setItalic(false);
            this.location.setBlue(false);
        } else {
            this.location.setItalic(true);
            this.location.setBlue(true);
        }
        if (this.dataControl.detail_Enable() != this.detail_Enable.isSelected()) {
            this.detail_Enable.setstate(true);
        } else {
            this.detail_Enable.setstate(false);
        }
    }

    public boolean getstate() {
        boolean bl = false;
        bl = this.detail_Enable.getstate() || this.location.getstate() || this.mainMediator.getstate() || this.subMediator.getstate();
        return bl;
    }

    public AuditConfigData getValue() {
        AuditConfigData auditConfigData = new AuditConfigData();
        auditConfigData.B_Detail = this.detail_Enable.isSelected();
        auditConfigData.S_Location = this.location.getText().substring(0);
        auditConfigData.syslogserv = new SysLogServ[2];
        auditConfigData.syslogserv[0] = new SysLogServ();
        auditConfigData.syslogserv[1] = new SysLogServ();
        auditConfigData.syslogserv[0].B_IPv6 = this.mainMediator.getIPMode();
        auditConfigData.syslogserv[0].B_On = this.mainMediator.getServEnable();
        auditConfigData.syslogserv[0].I_IP_Add = new int[8];
        auditConfigData.syslogserv[0].I_IP_Add = this.mainMediator.getIPAddress();
        auditConfigData.syslogserv[0].I_Port = this.mainMediator.getPortNum();
        auditConfigData.syslogserv[1].B_IPv6 = this.subMediator.getIPMode();
        auditConfigData.syslogserv[1].B_On = this.subMediator.getServEnable();
        auditConfigData.syslogserv[1].I_IP_Add = new int[8];
        auditConfigData.syslogserv[1].I_IP_Add = this.subMediator.getIPAddress();
        auditConfigData.syslogserv[1].I_Port = this.subMediator.getPortNum();
        return auditConfigData;
    }

    public void setMainIPFocus() {
        this.mainMediator.setIPFocus();
    }

    public void setSubIPFocus() {
        this.subMediator.setIPFocus();
    }

    public void setParentPanel(RJslTabPanel rJslTabPanel) {
        this.parentPanel = rJslTabPanel;
        this.mainMediator.setParentPanel(rJslTabPanel);
        this.subMediator.setParentPanel(rJslTabPanel);
    }

    private RJcCushionPanel createDetailPanel() {
        JLabel jLabel = new JLabel(" ");
        jLabel.setOpaque(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.detail_Enable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.detail_Disable, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(jPanel);
        return rJcCushionPanel;
    }

    private RJcCushionPanel createLocationPanel() {
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel();
        JLabel jLabel = new JLabel(" ");
        jLabel.setOpaque(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.loca_DmyPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        rJcCushionPanel.setComponent(jPanel);
        return rJcCushionPanel;
    }

    private RJcCushionPanel createExportPanel() {
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.export_Button, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0));
        rJcCushionPanel.setComponent(jPanel);
        return rJcCushionPanel;
    }

    private void exportButton_actionPerformed(ActionEvent actionEvent) {
        this.fileoutproc();
    }

    private String makeoutputFilename() {
        Calendar calendar = Calendar.getInstance();
        String string = "syslog";
        string = string + calendar.get(1);
        int n = calendar.get(2) + 1;
        String string2 = new String("" + n);
        string = string2.length() == 1 ? string.concat("0" + string2) : string.concat(string2);
        String string3 = new String("" + calendar.get(5));
        string = string3.length() == 1 ? string.concat("0" + string3) : string.concat(string3);
        string = string.concat(".tgz");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fileoutproc() {
        this.m_DataControl = this.dataControl.getDataControl();
        boolean bl = true;
        int[] nArray = new int[]{0, 0};
        Frame frame = RJComUty.getTopFrame(this);
        File file = new File(System.getProperty("user.home"));
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(RJComDef.DlgTitle);
        File file2 = new File(this.makeoutputFilename());
        jFileChooser.setSelectedFile(file2);
        boolean bl2 = true;
        while (bl2) {
            int n = jFileChooser.showSaveDialog(this);
            if (n != 1 && n != -1) {
                Object[] objectArray;
                RJDataMsg rJDataMsg;
                StringBuffer stringBuffer;
                String string;
                File file3 = jFileChooser.getSelectedFile();
                String string2 = file3.getParent();
                if (string2.lastIndexOf(this.FILE_SEP) != string2.length() - 1) {
                    string2 = string2.concat(this.FILE_SEP);
                }
                if ((string = (stringBuffer = new StringBuffer(file3.getPath())).delete(0, string2.length()).toString()).length() < 4 || !string.substring(string.length() - 4, string.length()).equals(".tgz")) {
                    string = string.concat(".tgz");
                }
                String string3 = string;
                System.out.println("outDir = " + string2);
                System.out.println("m_OutPutFileName = " + string3);
                int n2 = new RJClientFileAccess().checkFileExist(string2 + string3);
                boolean bl3 = false;
                if (n2 == 59013) {
                    rJDataMsg = RJCom.getMsg(this.m_DataControl, 10, n2);
                    objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
                    int n3 = RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
                    bl3 = n3 == 0;
                }
                if (n2 != 0 && (n2 != 59013 || !bl3)) continue;
                try {
                    frame.setEnabled(false);
                    this.parentPanel.waitCtl();
                    this.m_DataControl.getSysLogFile(string2, string3);
                    nArray = this.chkDCResultEx();
                    if (nArray[0] != 0) {
                        rJDataMsg = RJCom.getMsg(this.m_DataControl, nArray[0], nArray[1]);
                        objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                        RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
                        if (rJDataMsg.getErrorLevel() != 0 && rJDataMsg.getErrorLevel() != 4) {
                            this.parentPanel.endRequest(rJDataMsg.getErrorLevel());
                            bl = false;
                        }
                    } else {
                        this.parentPanel.waitCtl();
                        this.m_DataControl.SysLogReset();
                        nArray = this.chkDCResultEx();
                        if (nArray[0] != 0) {
                            rJDataMsg = RJCom.getMsg(this.m_DataControl, nArray[0], nArray[1]);
                            objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
                            if (rJDataMsg.getErrorLevel() != 0 && rJDataMsg.getErrorLevel() != 4) {
                                this.parentPanel.endRequest(rJDataMsg.getErrorLevel());
                                bl = false;
                            }
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    objectArray = RJCom.getMsg(this.m_DataControl, 710, 57011);
                    Object[] objectArray2 = new Object[]{RJComUty.CAPTION_MSG_OK};
                    RJComDialog.show(this, (RJDataMsg)objectArray, 0, objectArray2, objectArray2[0]);
                    RJDataStartParam rJDataStartParam = this.m_DataControl.getStartParamClass();
                    RJComWaitingDialog rJComWaitingDialog = rJDataStartParam.getWaitingDialog();
                    if (rJComWaitingDialog != null) {
                        rJComWaitingDialog.dispose();
                    }
                    this.parentPanel.endRequest(objectArray.getErrorLevel());
                    bl = false;
                }
                finally {
                    frame.setEnabled(true);
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return bl;
    }

    protected int[] chkDCResult() {
        int[] nArray = new int[2];
        while (!this.m_DataControl.EndData) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        ArrayList arrayList = this.m_DataControl.getEndStatus();
        Integer n = (Integer)arrayList.get(0);
        nArray[0] = n;
        Integer n2 = (Integer)arrayList.get(1);
        nArray[1] = n2;
        return nArray;
    }

    protected int[] chkDCResultEx() {
        return this.chkDCResultEx(true);
    }

    protected int[] chkDCResultEx(boolean bl) {
        int[] nArray = new int[2];
        if (bl) {
            this.m_DataControl.waitDC();
        } else {
            this.m_DataControl.waitDC(null);
        }
        ArrayList arrayList = this.m_DataControl.getEndStatus();
        Integer n = (Integer)arrayList.get(0);
        nArray[0] = n;
        Integer n2 = (Integer)arrayList.get(1);
        nArray[1] = n2;
        return nArray;
    }
}

