/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.adapters.coma.cimxml;

import com.ws.cim.xmlcim.CIMXMLElementsWriter;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.WBEMServerAuthentication;
import com.ws.wbem.jserver.embed.Headers;
import com.ws.wbem.jserver.embed.HttpConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger32;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.client.WBEMClient;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CIMXMLResponseStreamWriter
implements WBEMClient {
    private static final String mCIMVersion = "2.8";
    private static final String mDTDVersion = "2.4";
    private static final String mProtocolVersion = "1.4";
    private final WBEMServerAuthentication mAuth;
    private final HttpConnection mHTTPD;
    private final String mMessageID;
    private final WBEMServer mServer;
    private OutputStream mStream;

    public CIMXMLResponseStreamWriter(String string, WBEMServer wBEMServer, HttpConnection httpConnection, WBEMServerAuthentication wBEMServerAuthentication) {
        this.mMessageID = string;
        this.mServer = wBEMServer;
        this.mStream = httpConnection.getResponseBody();
        this.mHTTPD = httpConnection;
        this.mAuth = wBEMServerAuthentication;
    }

    public CloseableIterator<CIMClass> associatorClasses(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String string3, final String string4, final boolean bl) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.ASSOCIATORCLASSES, "Associators", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.associatorClasses(cIMObjectPath, string, string2, string3, string4, bl, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueObjectWithPath((XMLStreamWriter)xMLStreamWriter, (CIMClass)((CIMClass)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.ASSOCIATORCLASSES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.ASSOCIATORCLASSES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMInstance> associatorInstances(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String string3, final String string4, final String[] stringArray) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.ASSOCIATORS, "Associators", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.associatorInstances(cIMObjectPath, string, string2, string3, string4, stringArray, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueObjectWithPath((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.ASSOCIATORS, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.ASSOCIATORS, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMObjectPath> associatorNames(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String string3, final String string4, final String string5, final String string6, final UnsignedInteger32 unsignedInteger32, final boolean bl, final UnsignedInteger32 unsignedInteger322) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENASSOCIATORS, "OpenAssociatorInstancePaths", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.associators(cIMObjectPath, string, string2, string3, string4, null, string5, string6, unsignedInteger32, bl, unsignedInteger322, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeInstancePath((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)((CIMInstance)closeableIterator.next()).getObjectPath());
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> associators(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String string3, final String string4, final String[] stringArray, final String string5, final String string6, final UnsignedInteger32 unsignedInteger32, final boolean bl, final UnsignedInteger32 unsignedInteger322) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENASSOCIATORS, "OpenAssociatorInstances", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.associators(cIMObjectPath, string, string2, string3, string4, stringArray, string5, string6, unsignedInteger32, bl, unsignedInteger322, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueInstanceWithPath((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public void close() {
    }

    public void closeEnumeration(final CIMObjectPath cIMObjectPath, final String string) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.CLOSEENUMERATION, "CloseEnumeration", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMXMLResponseStreamWriter.this.mServer.closeEnumeration(cIMObjectPath, string, CIMXMLResponseStreamWriter.this.mAuth);
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
    }

    public void createClass(final CIMClass cIMClass) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.CREATECLASS, "CreateClass", cIMClass.getObjectPath(), new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMXMLResponseStreamWriter.this.mServer.createClass(cIMClass, CIMXMLResponseStreamWriter.this.mAuth);
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
    }

    public CIMObjectPath createInstance(final CIMInstance cIMInstance) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.CREATECLASS, "CreateInstance", cIMInstance.getObjectPath(), new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMObjectPath cIMObjectPath = CIMXMLResponseStreamWriter.this.mServer.createInstance(cIMInstance, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    CIMXMLElementsWriter.writeInstanceName((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)cIMObjectPath);
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMInstance.getObjectPath(), (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)cIMInstance.getClassName()));
                }
            }
        });
        return null;
    }

    public void deleteClass(final CIMObjectPath cIMObjectPath) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.DELETECLASS, "DeleteClass", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMXMLResponseStreamWriter.this.mServer.deleteClass(cIMObjectPath, CIMXMLResponseStreamWriter.this.mAuth);
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
    }

    public void deleteInstance(final CIMObjectPath cIMObjectPath) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.DELETEINSTANCE, "DeleteInstance", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMXMLResponseStreamWriter.this.mServer.deleteInstance(cIMObjectPath, CIMXMLResponseStreamWriter.this.mAuth);
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
    }

    public void deleteQualifierType(final CIMObjectPath cIMObjectPath) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.DELETEQUALIFIERTYPE, "DeleteQualifier", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMXMLResponseStreamWriter.this.mServer.deleteQualifierType(cIMObjectPath, CIMXMLResponseStreamWriter.this.mAuth);
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
    }

    public CloseableIterator<CIMClass> enumerateClasses(final CIMObjectPath cIMObjectPath, final boolean bl, final boolean bl2, final boolean bl3) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.ENUMERATECLASSES, "EnumerateClasses", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.enumerateClasses(cIMObjectPath, bl, bl2, bl3, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeClass((XMLStreamWriter)xMLStreamWriter, (CIMClass)((CIMClass)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.ENUMERATECLASSES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.ENUMERATECLASSES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMObjectPath> enumerateClassNames(final CIMObjectPath cIMObjectPath, final boolean bl) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.ENUMERATECLASSNAMES, "EnumerateClassNames", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.enumerateClasses(cIMObjectPath, bl, false, true, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMClass cIMClass = (CIMClass)closeableIterator.next();
                        CIMXMLElementsWriter.writeClassName((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)cIMClass.getObjectPath());
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.ENUMERATECLASSNAMES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.ENUMERATECLASSNAMES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMObjectPath> enumerateInstanceNames(final CIMObjectPath cIMObjectPath, final String string, final String string2, final UnsignedInteger32 unsignedInteger32, final boolean bl, final UnsignedInteger32 unsignedInteger322) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENENUMERATEINSTANCES, "OpenEnumerateInstancePaths", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.enumerateInstances(cIMObjectPath, true, null, string, string2, unsignedInteger32, bl, unsignedInteger322, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeInstancePath((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)((CIMInstance)closeableIterator.next()).getObjectPath());
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMInstance> enumerateInstances(final CIMObjectPath cIMObjectPath, final String[] stringArray) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.ENUMERATEINSTANCES, "EnumerateInstances", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.enumerateInstances(cIMObjectPath, true, stringArray, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueNamedInstance((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> enumerateInstances(final CIMObjectPath cIMObjectPath, final String[] stringArray, final String string, final String string2, final UnsignedInteger32 unsignedInteger32, final boolean bl, final UnsignedInteger32 unsignedInteger322) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENENUMERATEINSTANCES, "OpenEnumerateInstances", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.enumerateInstances(cIMObjectPath, true, stringArray, string, string2, unsignedInteger32, bl, unsignedInteger322, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueInstanceWithPath((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypes(final CIMObjectPath cIMObjectPath) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.ENUMERATEQUALIFIERTYPES, "EnumerateQualifiers", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.enumQualifierTypes(cIMObjectPath, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeQualifierType((XMLStreamWriter)xMLStreamWriter, (CIMQualifierType)((CIMQualifierType)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.ENUMERATEQUALIFIERTYPES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.ENUMERATEQUALIFIERTYPES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMInstance> execQuery(final CIMObjectPath cIMObjectPath, final String string, final String string2) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.EXECUTEQUERY, "ExecQuery", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.execQuery(cIMObjectPath, string, string2, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueObjectWithPath((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.EXECUTEQUERY, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.EXECUTEQUERY, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> execQueryInstances(final CIMObjectPath cIMObjectPath, final String string, final String string2, final boolean bl, final UnsignedInteger32 unsignedInteger32, final boolean bl2, final UnsignedInteger32 unsignedInteger322, final CIMClass cIMClass) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENQUERYINSTANCES, "OpenQueryInstances", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.execQueryInstances(cIMObjectPath, string, string2, bl, unsignedInteger32, bl2, unsignedInteger322, cIMClass, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueInstanceWithPath((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENQUERYINSTANCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENQUERYINSTANCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public CIMClass getClass(final CIMObjectPath cIMObjectPath, final boolean bl, final boolean bl2) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.GETCLASS, "GetClass", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMClass cIMClass = CIMXMLResponseStreamWriter.this.mServer.getClass(cIMObjectPath, bl, bl2, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    CIMXMLElementsWriter.writeClass((XMLStreamWriter)xMLStreamWriter, (CIMClass)cIMClass);
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.GETCLASS, (String)cIMObjectPath.getObjectName()));
                }
            }
        });
        return null;
    }

    public CIMInstance getInstance(final CIMObjectPath cIMObjectPath, final String[] stringArray) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.GETINSTANCE, "GetInstance", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMInstance cIMInstance = CIMXMLResponseStreamWriter.this.mServer.getInstance(cIMObjectPath, stringArray, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    CIMXMLElementsWriter.writeInstance((XMLStreamWriter)xMLStreamWriter, (CIMInstance)cIMInstance);
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.GETINSTANCE, (String)cIMObjectPath.getObjectName()));
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMObjectPath> getInstancePaths(final CIMObjectPath cIMObjectPath, final String string, final UnsignedInteger32 unsignedInteger32) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.PULLINSTANCESWITHPATH, "PullInstancePaths", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.getInstancesWithPath(cIMObjectPath, string, unsignedInteger32, CIMXMLResponseStreamWriter.this.mAuth);
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        CIMInstance cIMInstance;
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        if (null == (cIMInstance = (CIMInstance)closeableIterator.next())) continue;
                        CIMXMLElementsWriter.writeInstancePath((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)cIMInstance.getObjectPath());
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.PULLINSTANCESWITHPATH, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.PULLINSTANCESWITHPATH, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> getInstances(final CIMObjectPath cIMObjectPath, final String string, final UnsignedInteger32 unsignedInteger32) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.PULLINSTANCES, "PullInstances", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.getInstances(cIMObjectPath, string, unsignedInteger32, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeInstance((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.PULLINSTANCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.PULLINSTANCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> getInstancesWithPath(final CIMObjectPath cIMObjectPath, final String string, final UnsignedInteger32 unsignedInteger32) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.PULLINSTANCESWITHPATH, "PullInstancesWithPath", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.getInstancesWithPath(cIMObjectPath, string, unsignedInteger32, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueInstanceWithPath((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.PULLINSTANCESWITHPATH, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.PULLINSTANCESWITHPATH, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public String getProperty(String string) {
        return null;
    }

    public CIMQualifierType<?> getQualifierType(final CIMObjectPath cIMObjectPath) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.GETQUALIFIERTYPE, "GetQualifier", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMQualifierType cIMQualifierType = CIMXMLResponseStreamWriter.this.mServer.getQualifierType(cIMObjectPath, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    CIMXMLElementsWriter.writeQualifierType((XMLStreamWriter)xMLStreamWriter, (CIMQualifierType)cIMQualifierType);
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.GETQUALIFIERTYPE, (String)cIMObjectPath.getObjectName()));
                }
            }
        });
        return null;
    }

    public void initialize(CIMObjectPath cIMObjectPath, Subject subject, Locale[] localeArray) throws WBEMException {
    }

    public Object invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument<?>[] cIMArgumentArray, CIMArgument<?>[] cIMArgumentArray2) throws WBEMException {
        try {
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(this.mStream);
            Headers headers = this.mHTTPD.getResponseHeaders();
            headers.addHeader("Content-Type", "text/xml;charset=UTF-8");
            headers.addHeader("CIMOperation", "MethodResponse");
            this.mHTTPD.sendResponseHeaders(200, 0L);
            ArrayList arrayList = new ArrayList();
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeStartElement("CIM");
            xMLStreamWriter.writeAttribute("CIMVERSION", mCIMVersion);
            xMLStreamWriter.writeAttribute("DTDVERSION", mDTDVersion);
            xMLStreamWriter.writeStartElement("MESSAGE");
            xMLStreamWriter.writeAttribute("ID", this.mMessageID);
            xMLStreamWriter.writeAttribute("PROTOCOLVERSION", mProtocolVersion);
            xMLStreamWriter.writeStartElement("SIMPLERSP");
            xMLStreamWriter.writeStartElement("METHODRESPONSE");
            xMLStreamWriter.writeAttribute("NAME", string);
            try {
                CIMClass cIMClass = this.mServer.getClass(cIMObjectPath, false, true, this.mAuth);
                CIMMethod cIMMethod = cIMClass.getMethod(string);
                Object object = this.mServer.invokeMethod(cIMObjectPath, string, cIMArgumentArray, arrayList, this.mAuth);
                CIMArgument[] cIMArgumentArray3 = arrayList.toArray(new CIMArgument[arrayList.size()]);
                CIMXMLElementsWriter.writeInvokeMethod((XMLStreamWriter)xMLStreamWriter, (CIMMethod)cIMMethod, (Object)object, (CIMArgument[])cIMArgumentArray3);
            }
            catch (WBEMException wBEMException) {
                CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)string);
        }
        catch (IOException iOException) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)iOException, (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)string);
        }
        return null;
    }

    public void modifyClass(final CIMClass cIMClass) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.MODIFYCLASS, "ModifyClass", cIMClass.getObjectPath(), new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMXMLResponseStreamWriter.this.mServer.modifyClass(cIMClass, CIMXMLResponseStreamWriter.this.mAuth);
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
    }

    public void modifyInstance(final CIMInstance cIMInstance, final String[] stringArray) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.MODIFYINSTANCE, "ModifyInstance", cIMInstance.getObjectPath(), new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMXMLResponseStreamWriter.this.mServer.modifyInstance(cIMInstance, stringArray, CIMXMLResponseStreamWriter.this.mAuth);
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
    }

    public CloseableIterator<CIMClass> referenceClasses(final CIMObjectPath cIMObjectPath, final String string, final String string2, final boolean bl) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.REFERENCECLASSES, "References", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.referenceClasses(cIMObjectPath, string, string2, bl, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueObjectWithPath((XMLStreamWriter)xMLStreamWriter, (CIMClass)((CIMClass)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.REFERENCECLASSES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.REFERENCECLASSES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMInstance> referenceInstances(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String[] stringArray) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.REFERENCES, "References", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.referenceInstances(cIMObjectPath, string, string2, stringArray, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueObjectWithPath((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.REFERENCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.REFERENCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMObjectPath> referenceNames(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String string3, final String string4, final UnsignedInteger32 unsignedInteger32, final boolean bl, final UnsignedInteger32 unsignedInteger322) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENREFERENCES, "OpenReferenceInstancePaths", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.references(cIMObjectPath, string, string2, null, string3, string4, unsignedInteger32, bl, unsignedInteger322, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeInstancePath((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)((CIMInstance)closeableIterator.next()).getObjectPath());
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> references(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String[] stringArray, final String string3, final String string4, final UnsignedInteger32 unsignedInteger32, final boolean bl, final UnsignedInteger32 unsignedInteger322) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENREFERENCES, "OpenReferenceInstances", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    EnumerateResponse enumerateResponse = CIMXMLResponseStreamWriter.this.mServer.references(cIMObjectPath, string, string2, stringArray, string3, string4, unsignedInteger32, bl, unsignedInteger322, CIMXMLResponseStreamWriter.this.mAuth);
                    int n = 0;
                    CloseableIterator closeableIterator = enumerateResponse.getResponses();
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        if (1 == ++n) {
                            xMLStreamWriter.writeStartElement("IRETURNVALUE");
                        }
                        CIMXMLElementsWriter.writeValueInstanceWithPath((XMLStreamWriter)xMLStreamWriter, (CIMInstance)((CIMInstance)closeableIterator.next()));
                    }
                    if (0 == n) {
                        xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    }
                    xMLStreamWriter.writeEndElement();
                    CIMXMLResponseStreamWriter.this.writeParamEndOfSequence(xMLStreamWriter, enumerateResponse.isEnd());
                    CIMXMLResponseStreamWriter.this.writeParamEnumerationContext(xMLStreamWriter, enumerateResponse.getContext());
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    public void setLocales(Locale[] localeArray) {
    }

    public void setProperty(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public void createQualifierType(CIMQualifierType<?> cIMQualifierType) throws WBEMException {
        this.setQualifierType(cIMQualifierType);
    }

    public void modifyQualifierType(CIMQualifierType<?> cIMQualifierType) throws WBEMException {
        this.setQualifierType(cIMQualifierType);
    }

    public void setQualifierType(final CIMQualifierType<?> cIMQualifierType) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.CREATEQUALIFIERTYPE, "SetQualifier", cIMQualifierType.getObjectPath(), new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CIMXMLResponseStreamWriter.this.mServer.modifyQualifierType(cIMQualifierType, CIMXMLResponseStreamWriter.this.mAuth);
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
    }

    private void simpleIntrinsicResponse(WBEMOperation wBEMOperation, String string, CIMObjectPath cIMObjectPath, ParamIF paramIF) throws WBEMException {
        try {
            Headers headers = this.mHTTPD.getResponseHeaders();
            headers.addHeader("Content-Type", "text/xml;charset=UTF-8");
            headers.addHeader("CIMOperation", "MethodResponse");
            this.mHTTPD.sendResponseHeaders(200, 0L);
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(this.mStream);
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeStartElement("CIM");
            xMLStreamWriter.writeAttribute("CIMVERSION", mCIMVersion);
            xMLStreamWriter.writeAttribute("DTDVERSION", mDTDVersion);
            xMLStreamWriter.writeStartElement("MESSAGE");
            xMLStreamWriter.writeAttribute("ID", this.mMessageID);
            xMLStreamWriter.writeAttribute("PROTOCOLVERSION", mProtocolVersion);
            xMLStreamWriter.writeStartElement("SIMPLERSP");
            xMLStreamWriter.writeStartElement("IMETHODRESPONSE");
            xMLStreamWriter.writeAttribute("NAME", string);
            paramIF.getReturnValue(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)wBEMOperation, (String)cIMObjectPath.getObjectName());
        }
        catch (IOException iOException) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)iOException, (WBEMOperation)wBEMOperation, (String)cIMObjectPath.getObjectName());
        }
    }

    private void writeParamEndOfSequence(XMLStreamWriter xMLStreamWriter, boolean bl) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("PARAMVALUE");
        xMLStreamWriter.writeAttribute("NAME", "EndOfSequence");
        xMLStreamWriter.writeAttribute("PARAMTYPE", "boolean");
        if (bl) {
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)xMLStreamWriter, (Object)"true");
        } else {
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)xMLStreamWriter, (Object)"false");
        }
        xMLStreamWriter.writeEndElement();
    }

    private void writeParamEnumerationContext(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("PARAMVALUE");
        xMLStreamWriter.writeAttribute("NAME", "EnumerationContext");
        xMLStreamWriter.writeAttribute("PARAMTYPE", "string");
        CIMXMLElementsWriter.writeValue((XMLStreamWriter)xMLStreamWriter, (Object)string);
        xMLStreamWriter.writeEndElement();
    }

    protected void setStream(OutputStream outputStream) {
        this.mStream = outputStream;
    }

    protected void writeException(WBEMOperation wBEMOperation, String string, CIMObjectPath cIMObjectPath, final WBEMException wBEMException) throws WBEMException {
        this.simpleIntrinsicResponse(wBEMOperation, string, cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
            }
        });
    }

    CloseableIterator<CIMObjectPath> associatorClassNames(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String string3, final String string4, final boolean bl, boolean bl2) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.ASSOCIATORCLASSES, "AssociatorNames", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.associatorClasses(cIMObjectPath, string, string2, string3, string4, bl, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        xMLStreamWriter.writeStartElement("OBJECTPATH");
                        CIMXMLElementsWriter.writeClassPath((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)((CIMClass)closeableIterator.next()).getObjectPath());
                        xMLStreamWriter.writeEndElement();
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.ASSOCIATORCLASSES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.ASSOCIATORCLASSES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    CloseableIterator<CIMObjectPath> associatorInstanceNames(final CIMObjectPath cIMObjectPath, final String string, final String string2, final String string3, final String string4) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENASSOCIATORS, "AssociatorNames", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.associatorInstances(cIMObjectPath, string, string2, string3, string4, null, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        xMLStreamWriter.writeStartElement("OBJECTPATH");
                        CIMXMLElementsWriter.writeInstancePath((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)((CIMInstance)closeableIterator.next()).getObjectPath());
                        xMLStreamWriter.writeEndElement();
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    CloseableIterator<CIMObjectPath> enumerateInstanceNames(final CIMObjectPath cIMObjectPath) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.ENUMERATEINSTANCES, "EnumerateInstanceNames", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.enumerateInstances(cIMObjectPath, true, null, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        CIMXMLElementsWriter.writeInstanceName((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)((CIMInstance)closeableIterator.next()).getObjectPath());
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    CloseableIterator<CIMObjectPath> referenceClassNames(final CIMObjectPath cIMObjectPath, final String string, final String string2) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.REFERENCECLASSES, "ReferenceNames", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.referenceClasses(cIMObjectPath, string, string2, true, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        xMLStreamWriter.writeStartElement("OBJECTPATH");
                        CIMXMLElementsWriter.writeClassPath((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)((CIMClass)closeableIterator.next()).getObjectPath());
                        xMLStreamWriter.writeEndElement();
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.REFERENCECLASSES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.REFERENCECLASSES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    CloseableIterator<CIMObjectPath> referenceInstanceNames(final CIMObjectPath cIMObjectPath, final String string, final String string2) throws WBEMException {
        this.simpleIntrinsicResponse(WBEMOperation.OPENREFERENCES, "ReferenceNames", cIMObjectPath, new ParamIF(){

            @Override
            public void getReturnValue(XMLStreamWriter xMLStreamWriter) {
                try {
                    CloseableIterator closeableIterator = CIMXMLResponseStreamWriter.this.mServer.referenceInstances(cIMObjectPath, string, string2, null, CIMXMLResponseStreamWriter.this.mAuth);
                    xMLStreamWriter.writeStartElement("IRETURNVALUE");
                    while (null != closeableIterator && closeableIterator.hasNext()) {
                        xMLStreamWriter.writeStartElement("OBJECTPATH");
                        CIMXMLElementsWriter.writeInstancePath((XMLStreamWriter)xMLStreamWriter, (CIMObjectPath)((CIMInstance)closeableIterator.next()).getObjectPath());
                        xMLStreamWriter.writeEndElement();
                    }
                    xMLStreamWriter.writeEndElement();
                }
                catch (WBEMException wBEMException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
                catch (XMLStreamException xMLStreamException) {
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)cIMObjectPath.getObjectName()));
                }
                catch (Throwable throwable) {
                    WBEMException wBEMException = null;
                    wBEMException = throwable.getCause() instanceof WBEMException ? (WBEMException)throwable.getCause() : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)wBEMException, (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)cIMObjectPath.getObjectName());
                    CIMXMLElementsWriter.writeException((XMLStreamWriter)xMLStreamWriter, (WBEMException)wBEMException);
                }
            }
        });
        return null;
    }

    private static interface ParamIF {
        public void getReturnValue(XMLStreamWriter var1);
    }
}

