/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server.managers;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataInternalUtility;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanInterface;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiErrorCode;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.sanproject.rmi.server.SanRemoteObject;
import com.hitachi.sanproject.rmi.server.SanRmiServer;
import com.hitachi.sanproject.rmi.server.managers.SanUserAccount;
import com.hitachi.sanproject.util.SanLogger;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class SanAuthenticationManager {
    protected Logger logger;
    protected ConcurrentHashMap<String, SanUserAccount> useraccountMap;
    protected SanRemoteObject robj;
    protected SanData generalParameter;

    public void initialize() {
        this.logger = SanRmiServer.getLogger();
        this.useraccountMap = new ConcurrentHashMap();
        this.robj = SanRmiServer.getRemoteObject();
        this.generalParameter = SanRmiServer.getGeneralParameter();
        this.startRemovalTaskOfUserAccount();
    }

    protected void startRemovalTaskOfUserAccount() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                SanAuthenticationManager.this.logger.info(String.format("RemovalTaskOfUserAccount : start : useraccountMap.size=%d", SanAuthenticationManager.this.useraccountMap.size()));
                long l = System.currentTimeMillis();
                for (Map.Entry<String, SanUserAccount> entry : SanAuthenticationManager.this.useraccountMap.entrySet()) {
                    SanUserAccount sanUserAccount = entry.getValue();
                    if (l - sanUserAccount.getAuthTime() < 60000L && l - sanUserAccount.getAuthTime() >= 0L) continue;
                    SanAuthenticationManager.this.useraccountMap.remove(entry.getKey());
                }
                SanAuthenticationManager.this.logger.info(String.format("RemovalTaskOfUserAccount : end   : useraccountMap.size=%d", SanAuthenticationManager.this.useraccountMap.size()));
            }
        };
        Timer timer = new Timer(true);
        timer.schedule(timerTask, 180000L, 90000L);
    }

    public SanUserAccount authenticateStorageUser(SanData sanData, String string, String string2, int n, SanResponse sanResponse) throws SanRmiException, SanDataException {
        this.logger.info("start");
        if (string == null || string2 == null) {
            this.logger.info("(userName == null) || (password == null)");
            if (sanResponse == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, String.format("UserName=%s", string));
            }
            SanObject sanObject = sanResponse.newObj("ErrorInfo");
            sanObject.putInt("ErrorCode", 3000);
            sanObject.putIntArray("MessageId", new int[]{20020, 107095});
            return null;
        }
        long l = System.currentTimeMillis();
        SanUserAccount sanUserAccount = null;
        if (n == 0) {
            sanUserAccount = this.useraccountMap.get(string);
            if (sanUserAccount == null) {
                this.logger.info("userAccount == null");
            } else if (l - sanUserAccount.getAuthTime() >= 60000L || l - sanUserAccount.getAuthTime() < 0L) {
                this.logger.info(String.format("useraccountMap.remove : userName=%s", string));
                this.useraccountMap.remove(string);
                sanUserAccount = null;
            } else {
                if (string2.equals(sanUserAccount.getPassword())) {
                    this.logger.info(String.format("Aucentication OK : userName=%s", string));
                    if (sanResponse != null) {
                        SanObject sanObject = sanResponse.newObj("ErrorInfo");
                        sanObject.putInt("ErrorCode", 0);
                        sanObject.putIntArray("MessageId", new int[]{0, 0});
                        SanObject sanObject2 = sanResponse.newObj("AccountInfo");
                        sanObject2.putBitSet("AuthBitmap", sanUserAccount.getAuthorityBitmap());
                        sanObject2.putBitSet("ResourceGroupBitmap", sanUserAccount.getAvailableResourcegroups());
                        sanObject2.putBoolean("AllResourceGroup", sanUserAccount.isAllResourcegroup());
                    }
                } else {
                    this.logger.info(String.format("Aucentication NG : userName=%s", string));
                    sanUserAccount = null;
                    if (sanResponse != null) {
                        SanObject sanObject = sanResponse.newObj("ErrorInfo");
                        sanObject.putInt("ErrorCode", 3000);
                        sanObject.putIntArray("MessageId", new int[]{20020, 107095});
                    } else {
                        throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, String.format("UserName=%s", string));
                    }
                }
                this.logger.info("end");
                return sanUserAccount;
            }
        }
        SanInterface sanInterface = this.robj.getInterface("NativeSANauthenticateStorageUser");
        SanRequest sanRequest = sanInterface.getRequest().clone();
        sanRequest.putString("UserName", string);
        sanRequest.putString("Password", string2);
        sanRequest.putInt("SsoOption", n);
        SanResponse sanResponse2 = this.robj.privateinvoke(sanInterface, sanData, sanRequest);
        if (sanResponse2.errorCode() == 0) {
            this.logger.info(String.format("Aucentication OK : userName=%s", string));
            SanObject sanObject = sanResponse2.getObj("AccountInfo");
            sanUserAccount = new SanUserAccount(string, string2, sanObject.getBitSet("AuthBitmap"), sanObject.getBitSet("ResourceGroupBitmap"), sanObject.getBoolean("AllResourceGroup"), l);
            if (n == 0) {
                this.useraccountMap.put(string, sanUserAccount);
            }
            if (sanResponse != null) {
                SanObject sanObject3 = sanResponse.newObj("ErrorInfo");
                sanObject3.putInt("ErrorCode", 0);
                sanObject3.putIntArray("MessageId", new int[]{0, 0});
                SanObject sanObject4 = sanResponse.newObj("AccountInfo");
                sanObject4.putBitSet("AuthBitmap", sanUserAccount.getAuthorityBitmap());
                sanObject4.putBitSet("ResourceGroupBitmap", sanUserAccount.getAvailableResourcegroups());
                sanObject4.putBoolean("AllResourceGroup", sanUserAccount.isAllResourcegroup());
            }
        } else {
            this.logger.info(String.format("Aucentication NG : userName=%s, errorCode=%d", string, sanResponse2.errorCode()));
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                SanObject sanObject5 = sanResponse2.getObj("ErrorInfo");
                sanObject.putMember("ErrorCode", sanObject5.getMember("ErrorCode"));
                sanObject.putMember("MessageId", sanObject5.getMember("MessageId"));
            } else {
                if (sanResponse2.errorCode() == 4000) {
                    throw SanRmiErrorCode.newException(SanRmiErrorCode.GUM_CONNECTTION_ERROR);
                }
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, String.format("UserName=%s", string));
            }
        }
        this.logger.info("end");
        return sanUserAccount;
    }

    public SanData authenticateStorageUser(SanData sanData) throws SanRmiException {
        this.logger.info("start");
        SanData sanData2 = null;
        try {
            SanObject sanObject = sanData.getObj("AccountInfo");
            if (sanObject == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, "AccountInfo=null");
            }
            String string = (String)sanObject.getMember("UserName");
            if (string == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, "AccountInfo.UserName=null");
            }
            String string2 = (String)sanObject.getMember("Password");
            if (string2 == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, "AccountInfo.Password=null");
            }
            int n = sanObject.getInt("SsoOption");
            SanUserAccount sanUserAccount = this.authenticateStorageUser(sanData, string, string2, n, null);
            if (sanUserAccount == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, String.format("UserName=%s", string));
            }
            sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
            SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
            sanData2 = sanUserAccount.copyProperties(sanData2);
            sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        }
        catch (SanDataException sanDataException) {
            this.logger.severe(SanLogger.getStackTrace((Throwable)sanDataException));
            throw SanRmiErrorCode.newException(SanRmiErrorCode.INTERNAL_ERROR);
        }
        this.logger.info("end");
        return sanData2;
    }
}

