/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sanproject.sn2.rptdt.main.SJdtRPTDTMain;
import sanproject.sn2.rptdt.util.SJdtRPTDTUtils;

public class SJdtRPTDTLogFormatter
extends Formatter {
    private static final int BUFFER_SIZE = 64;
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final String LEVEL_FORMAT = "%-7s";

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        Date date = new Date();
        date.setTime(record.getMillis());
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        sb.append(formatter.format(date));
        sb.append("]");
        sb.append("[");
        String level = String.format(LEVEL_FORMAT, record.getLevel().toString());
        sb.append(level);
        sb.append("]");
        sb.append("[");
        String sourceClassName = record.getSourceClassName();
        int i = sourceClassName.lastIndexOf(".");
        sb.append(sourceClassName.substring(i + 1));
        sb.append("#");
        sb.append(record.getSourceMethodName());
        sb.append("]");
        sb.append(" - ");
        sb.append(record.getMessage());
        Throwable th = record.getThrown();
        if (th != null) {
            sb.append(SJdtRPTDTMain.LINE_SEPARATOR);
            sb.append(SJdtRPTDTUtils.getPrintStackTrace(th));
        }
        sb.append(SJdtRPTDTMain.LINE_SEPARATOR);
        return sb.toString();
    }
}

