/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.io.File;
import java.util.List;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.ReportInfo;

public class SJdtCommonReportGenerator {
    private static final String REPORT_TITLE_KEY = "Common.report.title";
    private static final String MENU_TITLE_KEY = "Common.menu.title";
    private static final String REPORT_TITLE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/reportTitle.vm";
    private static final String MENU_TITLE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/menuTitle.vm";
    private static final String COMMON_DIR = SJdtReportGeneratorManager.outputDir + "common" + File.separator;
    private static final String COMMON_HTML_DIR = COMMON_DIR + "html" + File.separator;
    private static final String COMMON_CSS_DIR = COMMON_DIR + "css" + File.separator;
    private static final String COMMON_IMG_DIR = COMMON_DIR + "img" + File.separator;
    private static final String COMMON_FLEX_DIR = COMMON_DIR + "flex" + File.separator;
    private static final String COMMON_FLEX_SWF_DIR = COMMON_DIR + "flex" + File.separator + "swf" + File.separator;

    public static void generate(List<ReportInfo> reportInfoList) throws SJdtRPTDTException {
        SJdtCommonReportGenerator.generateReportDir();
        SJdtCommonReportGenerator.generateDefaultCss();
        SJdtCommonReportGenerator.generateReportTitle();
        SJdtCommonReportGenerator.generateMenuTitle();
        SJdtCommonReportGenerator.generateMenuBody();
        SJdtCommonReportGenerator.generateContentsTitle();
        SJdtCommonReportGenerator.generateContentsBody(reportInfoList);
        SJdtCommonReportGenerator.generateContentsFooter(reportInfoList);
    }

    public static void generateReportDir() {
        SJdtReportGeneratorManager.generateDir(COMMON_HTML_DIR);
        SJdtReportGeneratorManager.generateDir(COMMON_CSS_DIR);
        SJdtReportGeneratorManager.generateDir(COMMON_IMG_DIR);
        SJdtReportGeneratorManager.generateDir(COMMON_FLEX_SWF_DIR);
    }

    private static void generateDefaultCss() throws SJdtRPTDTException {
        try {
            String cssFileName = "style.css";
            String originalFilePath = "/sanproject/sn2/rptdt/template/common/css/" + cssFileName;
            String destFilePath = COMMON_CSS_DIR + cssFileName;
            SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107013");
            throw e;
        }
    }

    private static void generateReportTitle() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("reportTitle", (Object)SJdtReportGeneratorManager.getGuidanceValue(REPORT_TITLE_KEY));
            String generateFilePath = COMMON_HTML_DIR + "reportTitle.html";
            SJdtReportGeneratorManager.generateFile(context, REPORT_TITLE_VM_FILE_PATH, generateFilePath);
            String cssFileName = "reportTitle.css";
            String originalFilePath = "/sanproject/sn2/rptdt/template/common/css/" + cssFileName;
            String destFilePath = COMMON_CSS_DIR + cssFileName;
            SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
            String headerImgFileName = "header_bg.png";
            String originalHeaderImgFilePath = "/sanproject/sn2/rptdt/template/common/img/" + headerImgFileName;
            String destHeaderImgFilePath = COMMON_IMG_DIR + headerImgFileName;
            SJdtReportGeneratorManager.copyFile(originalHeaderImgFilePath, destHeaderImgFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107013");
            throw e;
        }
    }

    private static void generateMenuTitle() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("menuTitle", (Object)SJdtReportGeneratorManager.getGuidanceValue(MENU_TITLE_KEY));
            String generateFilePath = COMMON_HTML_DIR + "menuTitle.html";
            SJdtReportGeneratorManager.generateFile(context, MENU_TITLE_VM_FILE_PATH, generateFilePath);
            String cssFileName = "menuTitle.css";
            String originalFilePath = "/sanproject/sn2/rptdt/template/common/css/" + cssFileName;
            String destFilePath = COMMON_CSS_DIR + cssFileName;
            SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107014");
            throw e;
        }
    }

    private static void generateMenuBody() throws SJdtRPTDTException {
        try {
            String cssFileName = "menuBody.css";
            String originalCssFilePath = "/sanproject/sn2/rptdt/template/common/css/" + cssFileName;
            String destCssFilePath = COMMON_CSS_DIR + cssFileName;
            SJdtReportGeneratorManager.copyFile(originalCssFilePath, destCssFilePath);
            String graphicImgFileName = "report_graphic.png";
            String originalGraphicImgFilePath = "/sanproject/sn2/rptdt/template/common/img/" + graphicImgFileName;
            String destGraphicImgFilePath = COMMON_IMG_DIR + graphicImgFileName;
            SJdtReportGeneratorManager.copyFile(originalGraphicImgFilePath, destGraphicImgFilePath);
            String tableImgFileName = "report_table.png";
            String originalTableImgFilePath = "/sanproject/sn2/rptdt/template/common/img/" + tableImgFileName;
            String destTableImgFilePath = COMMON_IMG_DIR + tableImgFileName;
            SJdtReportGeneratorManager.copyFile(originalTableImgFilePath, destTableImgFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107015");
            throw e;
        }
    }

    private static void generateContentsTitle() throws SJdtRPTDTException {
        try {
            String fileName = "contentsTitle.css";
            String originalFilePath = "/sanproject/sn2/rptdt/template/common/css/" + fileName;
            String destFilePath = COMMON_CSS_DIR + fileName;
            SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107016");
            throw e;
        }
    }

    private static void generateContentsBody(List<ReportInfo> reportInfoList) throws SJdtRPTDTException {
        try {
            String cssContentsBodyFileName = "contentsBody.css";
            String originalCssFilePath = "/sanproject/sn2/rptdt/template/common/css/" + cssContentsBodyFileName;
            String destCssFilePath = COMMON_CSS_DIR + cssContentsBodyFileName;
            SJdtReportGeneratorManager.copyFile(originalCssFilePath, destCssFilePath);
            if (SJdtCommonReportGenerator.existsUseTableSortReport(reportInfoList)) {
                String readerSwfFileName = "CVSReader.swf";
                String originalReaderSwfFilePath = "/sanproject/sn2/rptdt/template/common/flex/" + readerSwfFileName;
                String destReaderSwfFilePath = COMMON_FLEX_DIR + readerSwfFileName;
                SJdtReportGeneratorManager.copyFile(originalReaderSwfFilePath, destReaderSwfFilePath);
                String installSwfFileName = "playerProductInstall.swf";
                String originalInstallSwfFilePath = "/sanproject/sn2/rptdt/template/common/flex/" + installSwfFileName;
                String destInstallSwfFilePath = COMMON_FLEX_DIR + installSwfFileName;
                SJdtReportGeneratorManager.copyFile(originalInstallSwfFilePath, destInstallSwfFilePath);
                String acFileName = "AC_OETags.js";
                String originalAcFilePath = "/sanproject/sn2/rptdt/template/common/flex/" + acFileName;
                String destAcFilePath = COMMON_FLEX_DIR + acFileName;
                SJdtReportGeneratorManager.copyFile(originalAcFilePath, destAcFilePath);
                String circleSwfFileName = "loading_circle3.swf";
                String originalCircleSwfFilePath = "/sanproject/sn2/rptdt/template/common/flex/swf/" + circleSwfFileName;
                String destCircleSwfFilePath = COMMON_FLEX_SWF_DIR + circleSwfFileName;
                SJdtReportGeneratorManager.copyFile(originalCircleSwfFilePath, destCircleSwfFilePath);
            }
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107017");
            throw e;
        }
    }

    private static void generateContentsFooter(List<ReportInfo> reportInfoList) throws SJdtRPTDTException {
        try {
            if (SJdtCommonReportGenerator.existsUseContentsFooterReport(reportInfoList)) {
                String cssFileName = "contentsFooter.css";
                String originalFilePath = "/sanproject/sn2/rptdt/template/common/css/" + cssFileName;
                String destFilePath = COMMON_CSS_DIR + cssFileName;
                SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
            }
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107018");
            throw e;
        }
    }

    private static boolean existsUseTableSortReport(List<ReportInfo> reportInfoList) {
        boolean result = false;
        for (ReportInfo reportInfo : reportInfoList) {
            if (!reportInfo.getUseTableSort()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean existsUseContentsFooterReport(List<ReportInfo> reportInfoList) {
        boolean result = false;
        for (ReportInfo reportInfo : reportInfoList) {
            if (!reportInfo.getUseContentsFooter()) continue;
            result = true;
            break;
        }
        return result;
    }
}

