/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import sanproject.server.data.DGDsetGuardFile;
import sanproject.server.data.DGDsetLdevGuard;
import sanproject.server.data.DGDsetVtocArea;

public abstract class RJDGDGuardPatternCom
implements RJDGDGuardPattern,
Comparable {
    static final int MAX_CU = 32;
    static final int MAX_LDEV = 256;
    public static final byte GUARD_INHIBIT = 0;
    public static final byte GUARD_RW = -128;
    public static final byte GUARD_RO = -126;
    public static final byte GUARD_PROTECT = -127;
    public static final byte FILE_READ = 0;
    public static final byte FILE_WRITE = 16;
    public static final byte FILE_DELETE = 32;
    public static byte[][] _defaultGuard = new byte[32][256];
    final String _logName = this.getClass().getName();
    boolean _flgCopy = false;
    boolean _flgRename = false;
    boolean _flgDelete = false;
    boolean _flgAttribute = false;
    boolean _flgVtoc = false;
    RJDGDDataControl _dctl = null;
    String _name = null;
    String _oldName = null;
    byte[][] _guard = _defaultGuard;
    boolean[][] _flgGuardModify = new boolean[32][256];

    public RJDGDGuardPatternCom(RJDGDDataControl rJDGDDataControl, String string) throws NullPointerException, RJDGDException {
        if (rJDGDDataControl == null) {
            throw new NullPointerException("dctl is null");
        }
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        this._dctl = rJDGDDataControl;
        this._oldName = this._name = string;
    }

    public void newGuardPattern() {
        this._guard = new byte[32][256];
        this._flgGuardModify = new boolean[32][256];
    }

    public boolean initGuardStatus(int n, int n2, byte by) throws ArrayIndexOutOfBoundsException {
        boolean bl = false;
        if (RJDGDGuardPatternCom.chkGuardStatus(by)) {
            this._guard[n][n2] = by;
            this._flgGuardModify[n][n2] = false;
            bl = true;
        }
        return bl;
    }

    public void copyGuardStatus(byte[][] byArray) {
        this.newGuardPattern();
        this._flgCopy = true;
        this._flgAttribute = true;
        int n = 0;
        while (n < 32) {
            int n2 = 0;
            while (n2 < 256) {
                this._guard[n][n2] = byArray[n][n2];
                this._flgGuardModify[n][n2] = true;
                ++n2;
            }
            ++n;
        }
    }

    public void delete() {
        if (this.canDelete()) {
            this._flgDelete = true;
        }
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public boolean rename(String string) {
        boolean bl = true;
        if (string == null) {
            string = new String();
        }
        String[] stringArray = this._dctl.getGuardNameList();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            this._name = string;
            this._flgRename = true;
        }
        return bl;
    }

    public byte getGuardStatus(int n, int n2) throws ArrayIndexOutOfBoundsException {
        return this._guard[n][n2];
    }

    public boolean setGuardStatus(int n, int n2, byte by) throws ArrayIndexOutOfBoundsException {
        boolean bl = false;
        if (RJDGDGuardPatternCom.chkGuardStatus(by) && by != 0 && this._guard[n][n2] != 0 && this._guard[n][n2] != by) {
            this._guard[n][n2] = by;
            this._flgGuardModify[n][n2] = true;
            this._flgAttribute = true;
            bl = true;
        }
        return bl;
    }

    public static boolean chkGuardStatus(byte by) {
        return by == -128 || by == -126 || by == -127 || by == 0;
    }

    public void setVtocArea(RJDGDVtocArea rJDGDVtocArea) {
        if (rJDGDVtocArea.isModify()) {
            this._flgVtoc = true;
        }
    }

    public DGDsetLdevGuard getDGDsetLdevGuard() {
        DGDsetLdevGuard dGDsetLdevGuard = new DGDsetLdevGuard();
        int n = 0;
        while (n < dGDsetLdevGuard.guard.length) {
            int n2 = 0;
            while (n2 < dGDsetLdevGuard.guard[n].length) {
                dGDsetLdevGuard.guard[n][n2] = this._guard[n][n2];
                dGDsetLdevGuard.error[n][n2] = -1;
                ++n2;
            }
            ++n;
        }
        return dGDsetLdevGuard;
    }

    public DGDsetGuardFile getDGDsetGuardFile(byte by) {
        DGDsetGuardFile dGDsetGuardFile = new DGDsetGuardFile();
        int n = 0;
        while (n < dGDsetGuardFile.guard.length) {
            int n2 = 0;
            while (n2 < dGDsetGuardFile.guard[n].length) {
                dGDsetGuardFile.guard[n][n2] = this._guard[n][n2];
                ++n2;
            }
            ++n;
        }
        dGDsetGuardFile.name = by == 32 ? this._oldName : this._name;
        dGDsetGuardFile.error = -1;
        dGDsetGuardFile.operation = by;
        return dGDsetGuardFile;
    }

    public abstract DGDsetVtocArea[] getDGDsetVtocArea();

    public abstract List getSetupData();

    public boolean canSetup() {
        return (this._dctl.canEnterSetupToDkc() | this.isSetupToDkc()) & !this.isUnload() & !this.isDelete();
    }

    public boolean canCopy() {
        return this._dctl.getGuardPatternSize() < 32 & !this.isUnload();
    }

    public boolean canRename() {
        return !this.isUnload() & !this.isDelete();
    }

    public boolean canDelete() {
        boolean bl = !this.isSetupToDkc();
        bl = bl & !this.isCopy() ? !this.isRename() : bl;
        return bl;
    }

    public boolean canChgAttribute() {
        return !this.isChgVtoc() & !this.isUnload();
    }

    public boolean canChgVtoc() {
        return !this.isChgAttribute() & !this.isUnload();
    }

    public boolean isModify() {
        return this.isSetupToDkc() | this.isCopy() | this.isRename() | this.isDelete() | this.isChgAttribute() | this.isChgVtoc();
    }

    public boolean isSetupToDkc() {
        RJDGDGuardPattern rJDGDGuardPattern = this._dctl.getSetupToDkc();
        return rJDGDGuardPattern != null ? rJDGDGuardPattern.equals(this) : false;
    }

    public boolean isCopy() {
        return this._flgCopy;
    }

    public boolean isRename() {
        return this._flgRename;
    }

    public boolean isDelete() {
        return this._flgDelete;
    }

    public boolean isChgAttribute() {
        return this._flgAttribute;
    }

    public boolean isChgVtoc() {
        return this._flgVtoc;
    }

    public boolean isModifyLdev(int n, int n2) throws ArrayIndexOutOfBoundsException {
        return this._flgGuardModify[n][n2];
    }

    public boolean isUnload() {
        return this._guard.equals(_defaultGuard);
    }

    public int compareTo(Object object) throws NullPointerException, ClassCastException {
        int n = -1;
        String string = ((RJDGDGuardPattern)object).toString();
        return this._name.compareTo(string);
    }

    public abstract boolean isDkc();

    public abstract RJDGDLdev[] getLdevs(int var1) throws ArrayIndexOutOfBoundsException, RJDGDException;

    public abstract RJDGDGuardPattern getCopy();

    static {
        int n = 0;
        while (n < 32) {
            int n2 = 0;
            while (n2 < 256) {
                RJDGDGuardPatternCom._defaultGuard[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
    }
}

