/*
 * Decompiled with CFR 0.152.
 */
package sanproject.server.data;

import java.util.ArrayList;
import sanproject.server.data.BaseTimeoutValue;
import sanproject.server.data.GetRmiException;
import sanproject.server.data.RmiConObjErr;
import sanproject.server.data.RmiConObjInFile;
import sanproject.server.data.RmiConObjOutFile;
import sanproject.server.data.SetTimeoutValue;
import sanproject.server.data.StringControl;

public class RmiConObjEnvInfo {
    final int ENV_IDX_MAX_CONNECT = 0;
    final int ENV_IDX_MAX_USR_ACCOUNT = 1;
    final int ENV_IDX_Reserve_2 = 2;
    final int ENV_IDX_Reserve_3 = 3;
    final int ENV_IDX_Reserve_4 = 4;
    final int ENV_IDX_NUM_LINES_WRAP_ROUND = 5;
    final int ENV_IDX_Reserve_6 = 6;
    final int ENV_IDX_SERVER_VERSION = 7;
    final int ENV_IDX_LOGMAINTE_TIME = 8;
    final int ENV_IDX_LOGLINE_NUMBER = 9;
    final int ENV_IDX_LOGLEVEL = 10;
    final int ENV_IDX_HEALTHCHECK_TIMER = 11;
    final int ENV_IDX_SURVEILLANCE_TIMER = 13;
    final int ENV_IDX_SURVEILLANCE_TIMEOUT = 14;
    final int ENV_IDX_SOCKET_TIMEOUT = 15;
    final int ENV_IDX_FT_TIMEOUT = 16;
    final int CGI_ENV_IDX_Reserve_0 = 0;
    final int CGI_ENV_IDX_Reserve_1 = 1;
    final int CGI_ENV_IDX_AUTO_ELMINATE_TIME = 2;
    final int CGI_ENV_IDX_LOCK_OBSERVE_INTERVAL = 3;
    final int CGI_ENV_IDX_ERR_STS_GET_INTERVAL = 4;
    final int CGI_ENV_IDX_LOCK_TIMER = 9;
    static final int MIN_LOCK_TIMER = 0;
    static final int DEFAULT_LOCK_TIMER = 30;
    static final int MAX_LOCK_TIMER = 1280;
    static final int MIN_LOGOFF_TIME = 0;
    static final int MAX_LOGOFF_TIME = 2880;
    static final int DEFAULT_LOGMAINTE_TIME = 3;
    static final int DEFAULT_TIMER_INTERVAL = 20;
    static final int DEFAULT_LOG_INTERVAL = 60;
    static final int DEFAULT_DEL_LOG_CNT = 30;
    static final int DEFAULT_LIMIT_LOG_CNT = 300;
    static final int DEFAULT_SOCKET_TIMEOUT = 60;
    static final int DEFAULT_FT_TIMEOUT = 10;
    private ArrayList envInfo;
    private ArrayList envInfo_rmi;

    private boolean _checkRange(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    private GetRmiException outRange() {
        return RmiConObjErr.makeException(5522);
    }

    private void readEnvFile(String string, String string2) throws GetRmiException {
        RmiConObjInFile rmiConObjInFile;
        RmiConObjInFile rmiConObjInFile2;
        try {
            rmiConObjInFile2 = new RmiConObjInFile(string, false);
            this.envInfo = rmiConObjInFile2.getArrayList();
            rmiConObjInFile2.clear();
        }
        catch (GetRmiException getRmiException) {
            string = string.substring(0, string.length() - 3).concat("bak");
            rmiConObjInFile = new RmiConObjInFile(string, false);
            this.envInfo = rmiConObjInFile.getArrayList();
            rmiConObjInFile.clear();
        }
        try {
            rmiConObjInFile2 = new RmiConObjInFile(string2, false);
            this.envInfo_rmi = rmiConObjInFile2.getArrayList();
            rmiConObjInFile2.clear();
        }
        catch (GetRmiException getRmiException) {
            string2 = string2.substring(0, string2.length() - 3).concat("bak");
            rmiConObjInFile = new RmiConObjInFile(string2, false);
            this.envInfo_rmi = rmiConObjInFile.getArrayList();
            rmiConObjInFile.clear();
        }
    }

    void _resetEnvInfo(String string, String string2) throws Exception {
        RmiConObjInFile rmiConObjInFile = new RmiConObjInFile(string, false);
        this.envInfo = rmiConObjInFile.getArrayList();
        rmiConObjInFile.clear();
        RmiConObjInFile rmiConObjInFile2 = new RmiConObjInFile(string2, false);
        this.envInfo_rmi = rmiConObjInFile2.getArrayList();
        rmiConObjInFile2.clear();
    }

    synchronized void _makeEnvFile(String string) throws Exception {
        RmiConObjOutFile rmiConObjOutFile = new RmiConObjOutFile(string);
        String string2 = this.envInfo.toString();
        string2 = string2.substring(1, string2.length() - 1);
        string2 = StringControl.replace(string2, " ", "");
        rmiConObjOutFile.putOneLine(string2);
    }

    synchronized void _setEnvData(SetTimeoutValue[] setTimeoutValueArray) throws Exception {
        int n = setTimeoutValueArray.length - 1;
        while (n >= 0) {
            int n2 = setTimeoutValueArray[n].nTimeoutValue;
            if (setTimeoutValueArray[n].strTimeoutName.equals(BaseTimeoutValue.TIMEOUT_LOGOFF)) {
                this.setAutoElmTime(n2);
            } else if (setTimeoutValueArray[n].strTimeoutName.equals(BaseTimeoutValue.TIMEOUT_MODIFY)) {
                this.setLockTimer(n2);
            } else {
                throw RmiConObjErr.makeException(5521);
            }
            --n;
        }
    }

    String _getEnv() {
        return "env.csv " + this.envInfo.toString();
    }

    String _getRmiEnv() {
        return "rmienv.csv " + this.envInfo_rmi.toString();
    }

    public RmiConObjEnvInfo(String string, String string2) throws GetRmiException {
        this.readEnvFile(string, string2);
    }

    public String getMaxConnect() {
        return (String)this.envInfo_rmi.get(0);
    }

    public String getMaxUsrAccnt() {
        return (String)this.envInfo_rmi.get(1);
    }

    int getLimitLogCount() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(2));
        }
        catch (Exception exception) {
            n = 300;
        }
        return n;
    }

    int getDelAtOnceCount() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(4));
        }
        catch (Exception exception) {
            n = 30;
        }
        return n;
    }

    int getLogCheckInterval() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(4));
        }
        catch (Exception exception) {
            n = 60;
        }
        return n;
    }

    public String getNumLinesWrapRound() {
        return (String)this.envInfo_rmi.get(5);
    }

    int getTimerCheckInterval() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(6));
        }
        catch (Exception exception) {
            n = 20;
        }
        return n;
    }

    public String getServerVersion() {
        return (String)this.envInfo_rmi.get(7);
    }

    public int getLogMainteTime() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(8));
        }
        catch (Exception exception) {
            n = 3;
        }
        return n;
    }

    public int getLogLine() {
        return Integer.parseInt((String)this.envInfo_rmi.get(9));
    }

    public int getLogLevel() {
        return Integer.parseInt((String)this.envInfo_rmi.get(10));
    }

    public int getHealthChkTimer() {
        return Integer.parseInt((String)this.envInfo_rmi.get(11));
    }

    public int getSurveillanceTimer() {
        return Integer.parseInt((String)this.envInfo_rmi.get(13));
    }

    public int getSurveillanceTimeOut() {
        return Integer.parseInt((String)this.envInfo_rmi.get(14));
    }

    public int getSocketTimeOut() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(15));
        }
        catch (Exception exception) {
            n = 60;
        }
        return n;
    }

    public int getFTClientTimeOut() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(16));
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    public String getAutoElmTime() {
        return (String)this.envInfo.get(2);
    }

    public String getLockObsInterval() {
        return (String)this.envInfo.get(3);
    }

    public String getErrStsGetInterval() {
        return (String)this.envInfo.get(4);
    }

    int getLockTimer() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo.get(9));
        }
        catch (Exception exception) {
            n = 30;
        }
        return n;
    }

    void setAutoElmTime(int n) throws Exception {
        if (!this._checkRange(n, 0, 2880)) {
            throw this.outRange();
        }
        this.envInfo.set(2, new Integer(n));
    }

    void setLockTimer(int n) throws Exception {
        if (!this._checkRange(n, 0, 1280)) {
            throw this.outRange();
        }
        this.envInfo.set(9, new Integer(n));
    }
}

