/*
 * Decompiled with CFR 0.152.
 */
package sanproject.syslog.communicator;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.syslog.communicator.CommitCertificateException;
import sanproject.syslog.communicator.CreateCertificateCommitterException;
import sanproject.syslog.communicator.SetCertificateException;
import sanproject.syslog.communicator.UploadCACertificateException;
import sanproject.syslog.communicator.UploadClientCertificateException;
import sanproject.syslog.enums.SyslogServerType;
import sanproject.syslog.enums.SyslogType;
import sanproject.syslog.sender.TLSSender;

public class SyslogCommunicator
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String DIR_TMP = "syslog\\tmp\\";
    static final String COPY_SYSLOG_CLIENT = "ClientCertfcate.syslog";
    static final String COPY_SIMSYSLOG_CLIENT = "ClientCertfcate.simsyslog";
    static final String COPY_SYSLOG_CA = "CACertfcate.syslog";
    static final String COPY_SIMSYSLOG_CA = "CACertfcate.simsyslog";
    static final String TMP_SYSLOG_KEY_STORE = "tmp_syslog.keyStore";
    static final String TMP_SYSLOG_TRUST_STORE = "tmp_syslog.trustStore";
    static final String TMP_SIMSYSLOG_KEY_STORE = "tmp_simsyslog.keyStore";
    static final String TMP_SIMSYSLOG_TRUST_STORE = "tmp_simsyslog.trustStore";
    static final String STORE_FILE_DIR = "san\\syslog\\";
    static final String SYSLOG_KEY_STORE = "syslog.keyStore";
    static final String SYSLOG_TRUST_STORE = "syslog.trustStore";
    static final String SIMSYSLOG_KEY_STORE = "simsyslog.keyStore";
    static final String SIMSYSLOG_TRUST_STORE = "simsyslog.trustStore";
    static final String TEST_SYSLOG_KEY_STORE = "test_syslog.keyStore";
    static final String TEST_SYSLOG_TRUST_STORE = "test_syslog.trustStore";
    static final String TEST_SIMSYSLOG_KEY_STORE = "test_simsyslog.keyStore";
    static final String TEST_SIMSYSLOG_TRUST_STORE = "test_simsyslog.trustStore";
    static final String SYSLOG_TEST_DATA_TLS = "<14>1 %s SVP Storage - - - CELFSS,1.1,,ConfigurationAccess,Success,uid=%s,R800:%s,%s,,,,,SVP,%s,,[AuditLog],Send Test Message,,Normal end";
    static final String SYSLOG_TEST_DATA_UDP = "'<14> 'MMM dd HH:mm:ss' SVP Storage: CELFSS,1.1,,,%s,Storage,SVP,ConfigurationAccess,Success,uid=%s,R800:%s,,%s,,,,,,,,,,,,SVP,%s,,[AuditLog],Send Test Message,,Normal end'";
    static final String SIMSYSLOG_TEST_DATA_TLS = "<13>1 %s SVP Storage - - - ,Test,RAID800(Serial:%s),%s,RefCode : 7FFFFF,This is Test Report.";
    static final String SIMSYSLOG_TEST_DATA_UDP = "'<13> 'MMM dd HH:mm:ss' SVP Storage: ,Test,RAID800(Serial:%s),%s,RefCode : 7FFFFF,This is Test Report.'";
    static final String TIME_FORMAT_YMDTHMSMS = "yyyy-MM-dd'T'HH:mm:ss.S";
    static final int TIME_FORMAT_YMDTHMSMS_SIZE = 21;
    static final int TIME_FORMAT_YMDTHMS_SIZE = 19;
    static final int UDP_DAY_CHANGE_DATA_SIZE = 11;
    static final String TIME_ZONE_Z = "Z";
    static final String TIME_ZONE_PLUS = "+%02d:%02d";
    static final String TIME_ZONE_MINUS = "-%02d:%02d";
    static final String FUNCTIONID = "007";
    static final String MODULEID = "26";
    static final String SEND_OK_MSGID = "205000";
    static final String CLIENT_UPLOAD_ERR_MSGID = "207001";
    static final String CA_UPLOAD_ERR_MSGID = "207002";
    static final String SET_KEYSTORE_ERR_MSGID = "205001";
    static final String SET_TRUSTSTORE_ERR_MSGID = "205002";
    static final String COMMIT_STORE_ERR_MSGID = "207003";
    static final String GET_CLIENT_STORE_ERR_MSGID = "207005";
    static final String GET_CA_STORE_ERR_MSGID = "207006";
    static final String TCP_ERR_MSGID = "205003";
    static final String HANDSHAKE_ERR_MSGID = "205004";
    static final String SUBJECT_ALT_NAME_ERR_MSGID = "205005";
    static final String TLS_SEND_ERR_MSGID = "205006";
    static final String MAKE_STORE_ERR_MSGID = "205007";
    static final String IPADD_ERR_MSGID = "205008";
    static final String ETC_ERR_MSGID = "207004";
    static final String KEY_STORE_PASSWORD = "hitachi2syslog1t0l0s2A3u1d0i0t2p";
    static final String TRUST_STORE_PASSWOR = "I2n1b0a0n2d3syslog1t0l0shitachip";
    static final String LOG_FILE = "SyslogCommunicator.log";
    static final String GUIDANCE_SERVER = "COMMON/%s_SERVER";
    static final String SET_COMMON_CERTFCATE_FILE = "set_Common.crt";
    static final String DIR_STORE = "syslog\\store\\";
    static final String DIR_RELATIVE_PATH = "..\\..\\";
    private static SJcLoggerInterface m_Logger = null;
    private SyslogType m_SyslogType;
    private boolean m_IsPriClientCertfile;
    private String m_PriPassword;
    private boolean m_IsSecClientCertfile;
    private String m_SecPassword;
    private boolean m_IsPriCaCertfile;
    private boolean m_IsSecCaCertfile;
    private byte[] m_PriClientCertByteData = null;
    private byte[] m_SecClientCertByteData = null;
    private byte[] m_PriCaCertByteData = null;
    private byte[] m_SecCaCertByteData = null;

    private SyslogCommunicator() {
    }

    public static void uploadClientCertificate(SyslogType syslogType, SyslogServerType syslogServerType, String string) throws UploadClientCertificateException {
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "uploadClientCertificate", "start:" + syslogType.name() + " " + syslogServerType.name());
        }
        String string2 = "";
        switch (syslogType) {
            case Syslog: {
                string2 = COPY_SYSLOG_CLIENT + syslogServerType.ordinal();
                break;
            }
            case SimSyslog: {
                string2 = COPY_SIMSYSLOG_CLIENT + syslogServerType.ordinal();
            }
        }
        try {
            SJcFileUty.getUploadFile(string, DIR_TMP, string2);
        }
        catch (Exception exception) {
            if (null != sJcLoggerInterface) {
                sJcLoggerInterface.error("communicator", "SyslogCommunicator", "uploadClientCertificate", syslogType.name() + " " + syslogServerType.name() + "=" + "Upload Error:" + CLIENT_UPLOAD_ERR_MSGID, exception);
            }
            throw new UploadClientCertificateException(exception, FUNCTIONID, MODULEID, CLIENT_UPLOAD_ERR_MSGID);
        }
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "uploadClientCertificate", "end:" + syslogType.name() + " " + syslogServerType.name());
        }
    }

    public static void uploadCACertificate(SyslogType syslogType, SyslogServerType syslogServerType, String string) throws UploadCACertificateException {
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "uploadCACertificate", "start:" + syslogType.name() + " " + syslogServerType.name());
        }
        String string2 = "";
        switch (syslogType) {
            case Syslog: {
                string2 = COPY_SYSLOG_CA + syslogServerType.ordinal();
                break;
            }
            case SimSyslog: {
                string2 = COPY_SIMSYSLOG_CA + syslogServerType.ordinal();
            }
        }
        try {
            SJcFileUty.getUploadFile(string, DIR_TMP, string2);
        }
        catch (Exception exception) {
            if (null != sJcLoggerInterface) {
                sJcLoggerInterface.error("communicator", "SyslogCommunicator", "uploadCACertificate", syslogType.name() + " " + syslogServerType.name() + "=" + "Upload Error:" + CA_UPLOAD_ERR_MSGID, exception);
            }
            throw new UploadCACertificateException(exception, FUNCTIONID, MODULEID, CA_UPLOAD_ERR_MSGID);
        }
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "uploadCACertificate", "end:" + syslogType.name() + " " + syslogServerType.name());
        }
    }

    public static SyslogCommunicator createCertificateCommitter(SyslogType syslogType, boolean bl, String string, boolean bl2, String string2, boolean bl3, boolean bl4) throws CreateCertificateCommitterException {
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        SyslogCommunicator syslogCommunicator = new SyslogCommunicator();
        syslogCommunicator.m_SyslogType = syslogType;
        syslogCommunicator.m_IsPriClientCertfile = bl;
        syslogCommunicator.m_PriPassword = string;
        syslogCommunicator.m_IsSecClientCertfile = bl2;
        syslogCommunicator.m_SecPassword = string2;
        syslogCommunicator.m_IsPriCaCertfile = bl3;
        syslogCommunicator.m_IsSecCaCertfile = bl4;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        switch (syslogType) {
            case Syslog: {
                string3 = COPY_SYSLOG_CLIENT;
                string4 = COPY_SYSLOG_CA;
                break;
            }
            case SimSyslog: {
                string3 = COPY_SIMSYSLOG_CLIENT;
                string4 = COPY_SIMSYSLOG_CA;
            }
        }
        SyslogServerType syslogServerType = SyslogServerType.Primary;
        try {
            if (bl) {
                string5 = CLIENT_UPLOAD_ERR_MSGID;
                syslogCommunicator.m_PriClientCertByteData = SJcFileUty.loadBinary(DIR_TMP, string3 + syslogServerType.ordinal(), 0, -1);
            }
            if (bl3) {
                string5 = CA_UPLOAD_ERR_MSGID;
                syslogCommunicator.m_PriCaCertByteData = SJcFileUty.loadBinary(DIR_TMP, string4 + syslogServerType.ordinal(), 0, -1);
            }
            syslogServerType = SyslogServerType.Secondary;
            if (bl2) {
                string5 = CLIENT_UPLOAD_ERR_MSGID;
                syslogCommunicator.m_SecClientCertByteData = SJcFileUty.loadBinary(DIR_TMP, string3 + syslogServerType.ordinal(), 0, -1);
            }
            if (bl4) {
                string5 = CA_UPLOAD_ERR_MSGID;
                syslogCommunicator.m_SecCaCertByteData = SJcFileUty.loadBinary(DIR_TMP, string4 + syslogServerType.ordinal(), 0, -1);
            }
        }
        catch (Exception exception) {
            if (null != sJcLoggerInterface) {
                sJcLoggerInterface.error("communicator", "SyslogCommunicator", "createCertificateCommitter", syslogType.name() + " " + syslogServerType.name() + "=" + "Upload Error:" + string5, exception);
            }
            throw new CreateCertificateCommitterException(exception, FUNCTIONID, MODULEID, string5);
        }
        return syslogCommunicator;
    }

    public void setCertificate() throws SetCertificateException {
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "setCertificate", "start:" + this.m_SyslogType.name());
        }
        this.deleteTmpCertificate();
        String string = "";
        String string2 = "";
        switch (this.m_SyslogType) {
            case Syslog: {
                string = TMP_SYSLOG_KEY_STORE;
                string2 = TMP_SYSLOG_TRUST_STORE;
                break;
            }
            case SimSyslog: {
                string = TMP_SIMSYSLOG_KEY_STORE;
                string2 = TMP_SIMSYSLOG_TRUST_STORE;
            }
        }
        String string3 = "";
        SyslogServerType syslogServerType = SyslogServerType.Primary;
        try {
            if (this.m_IsPriClientCertfile) {
                string3 = SET_KEYSTORE_ERR_MSGID;
                SJcFileUty.saveBinary(DIR_TMP, SET_COMMON_CERTFCATE_FILE, this.m_PriClientCertByteData, 0);
                SyslogCommunicator.setKeyStore(SET_COMMON_CERTFCATE_FILE, this.m_PriPassword, string + syslogServerType.ordinal());
            }
            if (this.m_IsPriCaCertfile) {
                string3 = SET_TRUSTSTORE_ERR_MSGID;
                SJcFileUty.saveBinary(DIR_TMP, SET_COMMON_CERTFCATE_FILE, this.m_PriCaCertByteData, 0);
                SyslogCommunicator.setTrustStore(SET_COMMON_CERTFCATE_FILE, string2 + syslogServerType.ordinal());
            }
            syslogServerType = SyslogServerType.Secondary;
            if (this.m_IsSecClientCertfile) {
                string3 = SET_KEYSTORE_ERR_MSGID;
                SJcFileUty.saveBinary(DIR_TMP, SET_COMMON_CERTFCATE_FILE, this.m_SecClientCertByteData, 0);
                SyslogCommunicator.setKeyStore(SET_COMMON_CERTFCATE_FILE, this.m_SecPassword, string + syslogServerType.ordinal());
            }
            if (this.m_IsSecCaCertfile) {
                string3 = SET_TRUSTSTORE_ERR_MSGID;
                SJcFileUty.saveBinary(DIR_TMP, SET_COMMON_CERTFCATE_FILE, this.m_SecCaCertByteData, 0);
                SyslogCommunicator.setTrustStore(SET_COMMON_CERTFCATE_FILE, string2 + syslogServerType.ordinal());
            }
        }
        catch (Exception exception) {
            if (null != sJcLoggerInterface) {
                sJcLoggerInterface.error("communicator", "SyslogCommunicator", "setCertificate", this.m_SyslogType.name() + " " + syslogServerType.name() + "=" + "Set Error:" + string3, exception);
            }
            this.deleteTmpCertificate();
            String[] stringArray = new String[]{String.format(GUIDANCE_SERVER, syslogServerType.name().toUpperCase())};
            throw new SetCertificateException(exception, FUNCTIONID, MODULEID, string3, stringArray);
        }
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "setCertificate", "end:" + this.m_SyslogType.name());
        }
    }

    public void commitCertificate() throws CommitCertificateException {
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "commitCertificate", "start:" + this.m_SyslogType.name());
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        switch (this.m_SyslogType) {
            case Syslog: {
                string = TMP_SYSLOG_KEY_STORE;
                string2 = TMP_SYSLOG_TRUST_STORE;
                string3 = SYSLOG_KEY_STORE;
                string4 = SYSLOG_TRUST_STORE;
                break;
            }
            case SimSyslog: {
                string = TMP_SIMSYSLOG_KEY_STORE;
                string2 = TMP_SIMSYSLOG_TRUST_STORE;
                string3 = SIMSYSLOG_KEY_STORE;
                string4 = SIMSYSLOG_TRUST_STORE;
            }
        }
        try {
            SyslogServerType[] syslogServerTypeArray = SyslogServerType.values();
            boolean[] blArray = new boolean[]{this.m_IsPriClientCertfile, this.m_IsSecClientCertfile};
            boolean[] blArray2 = new boolean[]{this.m_IsPriCaCertfile, this.m_IsSecCaCertfile};
            for (SyslogServerType syslogServerType : syslogServerTypeArray) {
                String[] stringArray = new String[]{string + syslogServerType.ordinal()};
                String[] stringArray2 = new String[]{string2 + syslogServerType.ordinal()};
                String[] stringArray3 = new String[]{string3 + syslogServerType.ordinal()};
                String[] stringArray4 = new String[]{string4 + syslogServerType.ordinal()};
                if (blArray[syslogServerType.ordinal()]) {
                    SJcFileUty.copyInternalToExternal(DIR_STORE, stringArray, SJcEnvUty.getSnBasePath() + STORE_FILE_DIR, stringArray3);
                }
                if (!blArray2[syslogServerType.ordinal()]) continue;
                SJcFileUty.copyInternalToExternal(DIR_STORE, stringArray2, SJcEnvUty.getSnBasePath() + STORE_FILE_DIR, stringArray4);
            }
        }
        catch (Exception exception) {
            if (null != sJcLoggerInterface) {
                sJcLoggerInterface.error("communicator", "SyslogCommunicator", "commitCertificate", this.m_SyslogType.name() + "=" + "Commit Error:" + COMMIT_STORE_ERR_MSGID, exception);
            }
            throw new CommitCertificateException(exception, FUNCTIONID, MODULEID, COMMIT_STORE_ERR_MSGID);
        }
        finally {
            this.deleteTmpCertificate();
        }
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "commitCertificate", "end:" + this.m_SyslogType.name());
        }
    }

    public void deleteTmpCertificate() {
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "deleteTmpCertificate", "start:" + this.m_SyslogType.name());
        }
        String string = "";
        String string2 = "";
        switch (this.m_SyslogType) {
            case Syslog: {
                string = TMP_SYSLOG_KEY_STORE;
                string2 = TMP_SYSLOG_TRUST_STORE;
                break;
            }
            case SimSyslog: {
                string = TMP_SIMSYSLOG_KEY_STORE;
                string2 = TMP_SIMSYSLOG_TRUST_STORE;
            }
        }
        SyslogCommunicator.deleteCertificate(string, string2);
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "deleteTmpCertificate", "end:" + this.m_SyslogType.name());
        }
    }

    public static SJcMessage sendTLS(SyslogType syslogType, SyslogServerType syslogServerType, boolean bl, String string, boolean bl2, String string2, int n, byte by, String string3, String string4, String string5, String string6) {
        String[] stringArray;
        String string7;
        String string8;
        String string9;
        SJcLoggerInterface sJcLoggerInterface;
        block20: {
            sJcLoggerInterface = SyslogCommunicator.getLogger();
            if (null != sJcLoggerInterface) {
                sJcLoggerInterface.info("communicator", "SyslogCommunicator", "sendTLS", "start:" + syslogType.name() + " " + syslogServerType.name());
            }
            int n2 = syslogServerType.ordinal();
            string9 = ETC_ERR_MSGID;
            string8 = "";
            string7 = "";
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "";
            switch (syslogType) {
                case Syslog: {
                    string8 = TEST_SYSLOG_KEY_STORE;
                    string7 = TEST_SYSLOG_TRUST_STORE;
                    string10 = COPY_SYSLOG_CLIENT + n2;
                    string11 = COPY_SYSLOG_CA + n2;
                    string12 = SYSLOG_KEY_STORE + n2;
                    string13 = SYSLOG_TRUST_STORE + n2;
                    break;
                }
                case SimSyslog: {
                    string8 = TEST_SIMSYSLOG_KEY_STORE;
                    string7 = TEST_SIMSYSLOG_TRUST_STORE;
                    string10 = COPY_SIMSYSLOG_CLIENT + n2;
                    string11 = COPY_SIMSYSLOG_CA + n2;
                    string12 = SIMSYSLOG_KEY_STORE + n2;
                    string13 = SIMSYSLOG_TRUST_STORE + n2;
                }
            }
            String string14 = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator + DIR_STORE;
            string14 = string14.toUpperCase().replace(SJcEnvUty.getSnBasePath(), DIR_RELATIVE_PATH);
            try {
                if (bl) {
                    string9 = MAKE_STORE_ERR_MSGID;
                    string12 = string8 + n2;
                    SyslogCommunicator.setKeyStore(string10, string, string12);
                    string12 = string14 + string12;
                }
                if (bl2) {
                    string9 = MAKE_STORE_ERR_MSGID;
                    string13 = string7 + n2;
                    SyslogCommunicator.setTrustStore(string11, string13);
                    string13 = string14 + string13;
                }
                string9 = ETC_ERR_MSGID;
                stringArray = new TLSSender(string12, string13, LOG_FILE);
                String string15 = SyslogCommunicator.getTLSTestData(syslogType, string3, string4, string5, string6);
                string9 = IPADD_ERR_MSGID;
                byte[] byArray = InetAddress.getByName(string2).getAddress();
                string9 = ETC_ERR_MSGID;
                int n3 = stringArray.Send(string15.getBytes("UTF-8"), byArray, n, (byte)0, by);
                switch (n3) {
                    case 0: {
                        string9 = SEND_OK_MSGID;
                        break;
                    }
                    case 1: {
                        string9 = GET_CLIENT_STORE_ERR_MSGID;
                        break;
                    }
                    case 2: {
                        string9 = GET_CA_STORE_ERR_MSGID;
                        break;
                    }
                    case 3: {
                        string9 = TCP_ERR_MSGID;
                        break;
                    }
                    case 4: {
                        string9 = HANDSHAKE_ERR_MSGID;
                        break;
                    }
                    case 5: {
                        string9 = SUBJECT_ALT_NAME_ERR_MSGID;
                        break;
                    }
                    case 6: {
                        string9 = TLS_SEND_ERR_MSGID;
                        break;
                    }
                    case 7: {
                        string9 = ETC_ERR_MSGID;
                    }
                }
                stringArray.Shutdown();
            }
            catch (Exception exception) {
                if (null == sJcLoggerInterface) break block20;
                sJcLoggerInterface.error("communicator", "SyslogCommunicator", "sendTLS", syslogType.name() + " " + syslogServerType.name() + "=" + "Send Error:" + string9, exception);
            }
        }
        SyslogCommunicator.deleteCertificate(string8, string7);
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "sendTLS", "end:" + syslogType.name() + " " + syslogServerType.name());
        }
        stringArray = new String[]{String.format(GUIDANCE_SERVER, syslogServerType.name().toUpperCase())};
        return new SJcMessage(FUNCTIONID, MODULEID, string9, stringArray, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SJcMessage sendUDP(SyslogType syslogType, SyslogServerType syslogServerType, String string, int n, String string2, String string3, String string4, String string5) {
        String[] stringArray;
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "sendUDP", "start:" + syslogType.name() + " " + syslogServerType.name());
        }
        String string6 = ETC_ERR_MSGID;
        DatagramSocket datagramSocket = null;
        try {
            stringArray = SyslogCommunicator.getUDPTestData(syslogType, string2, string3, string4, string5);
            datagramSocket = new DatagramSocket();
            string6 = IPADD_ERR_MSGID;
            InetAddress inetAddress = InetAddress.getByName(string);
            string6 = ETC_ERR_MSGID;
            byte[] byArray = stringArray.getBytes("UTF-8");
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
            datagramSocket.send(datagramPacket);
            string6 = SEND_OK_MSGID;
        }
        catch (Exception exception) {
            if (null != sJcLoggerInterface) {
                sJcLoggerInterface.error("communicator", "SyslogCommunicator", "sendUDP", syslogType.name() + " " + syslogServerType.name() + "=" + "Send Error:" + string6, exception);
            }
        }
        finally {
            if (null != datagramSocket) {
                datagramSocket.close();
            }
        }
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "sendUDP", "end:" + syslogType.name() + " " + syslogServerType.name());
        }
        stringArray = new String[]{String.format(GUIDANCE_SERVER, syslogServerType.name().toUpperCase())};
        return new SJcMessage(FUNCTIONID, MODULEID, string6, stringArray, stringArray);
    }

    private static void setKeyStore(String string, String string2, String string3) throws Exception {
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "setKeyStore", "start:" + string3);
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            String string4 = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            char[] cArray = string2.toCharArray();
            inputStream = SJcFileUty.getInStream(string4 + DIR_TMP + string);
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(inputStream, cArray);
            inputStream.close();
            inputStream = null;
            String string5 = keyStore.aliases().nextElement();
            Key key = keyStore.getKey(string5, cArray);
            Certificate[] certificateArray = keyStore.getCertificateChain(string5);
            char[] cArray2 = KEY_STORE_PASSWORD.toCharArray();
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(null, cArray2);
            keyStore2.setKeyEntry("syscomC", key, cArray2, certificateArray);
            if (!new File(string4 + DIR_STORE).exists()) {
                SJcFileUty.makeDirectory(DIR_STORE);
            }
            outputStream = SJcFileUty.getOutStream(string4 + DIR_STORE + string3);
            keyStore2.store(outputStream, cArray2);
            outputStream.close();
            outputStream = null;
        }
        catch (Exception exception) {
            block13: {
                block12: {
                    if (null != sJcLoggerInterface) {
                        sJcLoggerInterface.error("communicator", "SyslogCommunicator", "setKeyStore", string3 + "=" + "Store Error", exception);
                    }
                    if (null != inputStream) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception2) {
                            if (null == sJcLoggerInterface) break block12;
                            sJcLoggerInterface.error("communicator", "SyslogCommunicator", "setKeyStore", string3 + "=" + "inStream.close Error", exception2);
                        }
                    }
                }
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception3) {
                        if (null == sJcLoggerInterface) break block13;
                        sJcLoggerInterface.error("communicator", "SyslogCommunicator", "setKeyStore", string3 + "=" + "outStream.close Error", exception3);
                    }
                }
            }
            throw exception;
        }
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "setKeyStore", "end:" + string3);
        }
    }

    private static void setTrustStore(String string, String string2) throws Exception {
        SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "setTrustStore", "start:" + string2);
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            String string3 = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            inputStream = SJcFileUty.getInStream(string3 + DIR_TMP + string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            inputStream.close();
            inputStream = null;
            char[] cArray = TRUST_STORE_PASSWOR.toCharArray();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, cArray);
            keyStore.setCertificateEntry("syscomR", certificate);
            if (!new File(string3 + DIR_STORE).exists()) {
                SJcFileUty.makeDirectory(DIR_STORE);
            }
            outputStream = SJcFileUty.getOutStream(string3 + DIR_STORE + string2);
            keyStore.store(outputStream, cArray);
            outputStream.close();
            outputStream = null;
        }
        catch (Exception exception) {
            block13: {
                block12: {
                    if (null != sJcLoggerInterface) {
                        sJcLoggerInterface.error("communicator", "SyslogCommunicator", "setTrustStore", string2 + "=" + "Store Error", exception);
                    }
                    if (null != inputStream) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception2) {
                            if (null == sJcLoggerInterface) break block12;
                            sJcLoggerInterface.error("communicator", "SyslogCommunicator", "setTrustStore", string2 + "=" + "inStream.close Error", exception2);
                        }
                    }
                }
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception3) {
                        if (null == sJcLoggerInterface) break block13;
                        sJcLoggerInterface.error("communicator", "SyslogCommunicator", "setTrustStore", string2 + "=" + "outStream.close Error", exception3);
                    }
                }
            }
            throw exception;
        }
        if (null != sJcLoggerInterface) {
            sJcLoggerInterface.info("communicator", "SyslogCommunicator", "setTrustStore", "end:" + string2);
        }
    }

    private static String getTLSTestData(SyslogType syslogType, String string, String string2, String string3, String string4) throws Exception {
        String string5 = "";
        int n = 0;
        switch (syslogType) {
            case Syslog: {
                string5 = SYSLOG_TEST_DATA_TLS;
                n = 21;
                break;
            }
            case SimSyslog: {
                string5 = SIMSYSLOG_TEST_DATA_TLS;
                n = 19;
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT_YMDTHMSMS, Locale.US);
        Calendar calendar = Calendar.getInstance();
        String string6 = simpleDateFormat.format(calendar.getTime()).substring(0, n);
        int n2 = calendar.getTimeZone().getRawOffset();
        string6 = syslogType == SyslogType.SimSyslog || 0 == n2 ? string6 + TIME_ZONE_Z : (0 < n2 ? string6 + String.format(TIME_ZONE_PLUS, Math.abs(n2) / 1000 / 60 / 60, Math.abs(n2) / 1000 / 60 % 60) : string6 + String.format(TIME_ZONE_MINUS, Math.abs(n2) / 1000 / 60 / 60, Math.abs(n2) / 1000 / 60 % 60));
        String string7 = "";
        switch (syslogType) {
            case Syslog: {
                string7 = String.format(string5, string6, string2, string, string3, string4);
                break;
            }
            case SimSyslog: {
                string7 = String.format(string5, string6, string, string3);
            }
        }
        return String.valueOf(string7.length()) + " " + string7;
    }

    private static String getUDPTestData(SyslogType syslogType, String string, String string2, String string3, String string4) throws Exception {
        Object object;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = null;
        String string5 = "";
        switch (syslogType) {
            case Syslog: {
                simpleDateFormat = new SimpleDateFormat(SYSLOG_TEST_DATA_UDP, Locale.US);
                object = new SimpleDateFormat(TIME_FORMAT_YMDTHMSMS, Locale.US);
                String string6 = ((DateFormat)object).format(calendar.getTime()).substring(0, 21);
                int n = calendar.getTimeZone().getRawOffset();
                string6 = 0 == n ? string6 + TIME_ZONE_Z : (0 < n ? string6 + String.format(TIME_ZONE_PLUS, Math.abs(n) / 1000 / 60 / 60, Math.abs(n) / 1000 / 60 % 60) : string6 + String.format(TIME_ZONE_MINUS, Math.abs(n) / 1000 / 60 / 60, Math.abs(n) / 1000 / 60 % 60));
                string5 = String.format(simpleDateFormat.format(calendar.getTime()), string6, string2, string, string3, string4);
                break;
            }
            case SimSyslog: {
                simpleDateFormat = new SimpleDateFormat(SIMSYSLOG_TEST_DATA_UDP, Locale.US);
                string5 = String.format(simpleDateFormat.format(calendar.getTime()), string, string3);
            }
        }
        object = string5.substring(0, 11);
        string5 = string5.replace((CharSequence)object, ((String)object).replace(" 0", "  "));
        return string5;
    }

    private static void deleteCertificate(String string, String string2) {
        block4: {
            try {
                SyslogServerType[] syslogServerTypeArray = SyslogServerType.values();
                String string3 = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator + DIR_STORE;
                for (SyslogServerType syslogServerType : syslogServerTypeArray) {
                    String string4 = string + syslogServerType.ordinal();
                    String string5 = string2 + syslogServerType.ordinal();
                    if (new File(string3 + string4).exists()) {
                        SJcFileUty.deleteFile(DIR_STORE, string4);
                    }
                    if (!new File(string3 + string5).exists()) continue;
                    SJcFileUty.deleteFile(DIR_STORE, string5);
                }
            }
            catch (Exception exception) {
                SJcLoggerInterface sJcLoggerInterface = SyslogCommunicator.getLogger();
                if (null == sJcLoggerInterface) break block4;
                sJcLoggerInterface.error("communicator", "SyslogCommunicator", "deleteCertificate", string + " " + string2 + "=" + "delete Error", exception);
            }
        }
    }

    private static SJcLoggerInterface getLogger() {
        if (null == m_Logger) {
            System.setProperty("SN_LogPath", "syslog");
            m_Logger = SJcLogUty.getLogger(LOG_FILE);
        }
        return m_Logger;
    }
}

