/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.client;

import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import sanproject.session.client.SJsessionClientConst;
import sanproject.session.client.common.utility.SJsessionClientUty;
import sanproject.session.client.exception.SJsessionAuthenticationException;
import sanproject.session.client.exception.SJsessionClientBusyConnectException;
import sanproject.session.client.exception.SJsessionClientIllegalStateException;
import sanproject.session.client.exception.SJsessionClientParameterException;
import sanproject.session.client.exception.SJsessionClientSecurityException;
import sanproject.session.common.SJsessionDef;
import sanproject.session.common.SJsessionUty;
import sanproject.session.common.application.inf.SJsessionApplicationInterface;
import sanproject.session.common.receive.inf.SJsessionReceiveInterface;
import sanproject.session.common.remote.inf.SJsessionRemoteInterface;
import sanproject.sn2.base.authentication.SJbaseAuthenticationSystem;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;

public class SJsessionClient {
    private static SJsessionClient client = new SJsessionClient();
    private String appID = null;
    private SJsessionApplicationInterface app = null;
    private SJbaseSystemPropertiesManager sysPropMgr = null;
    private static SJcLoggerInterface sessionLogger = null;
    private static final String LOG_FUNCTION = "SessionClient";
    private static final String LOG_TITLE = "SJsessionClient";
    private static final String LOG_START = "Start.";
    private static final String LOG_END = "End.";
    private SJsessionReceiveInterface receive = null;
    private AlivePollingThread alivePollingThread = null;
    private ChangeNotifyThread changeNotifyThread = null;
    private ConnectSessionServerThread connectionThread = null;
    private static boolean isStartedThreads = false;
    private String connectionID = null;
    private int alivePollingInterval = -1;
    private boolean changeNotifyFlag = false;
    private HashMap sessionList = null;
    private Object connectionStateLock = new Object();
    private String connectionState = null;
    private String registry_host = "localhost";
    private int registry_port = 52099;
    private String registry_name = "SessionControl";
    private int wait_count = -1;
    private int wait_interval = 15;
    private boolean connect_async = false;
    private int connect_retry_count = -1;
    private int connect_retry_interval = 10;
    private static boolean isInitialized = false;
    private static boolean isFinished = false;
    private static Object startFinishLockObj = new Object();
    private static Object isFinishedLockObj = new Object();
    private static int executeMethodCount = 0;
    private Object executeMethodCountLockObj = new Object();
    private WaitObject startWaitObj = new WaitObject();
    private WaitObject finishWaitObj = new WaitObject();
    private SJcRoleResourceContainer emergencyGrpContainer = null;
    private static final int ROLE_BITMAP_MAX = 256;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;

    private SJsessionClient() {
        this.sessionList = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SJsessionClient getInstance(HashMap info) throws Exception {
        String LOG_SUBTITLE = "getInstance";
        Object object = startFinishLockObj;
        synchronized (object) {
            Object object2 = isFinishedLockObj;
            synchronized (object2) {
                if (!isInitialized) {
                    try {
                        if (isFinished) {
                            sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getInstance", "SessionClient is restarted.");
                            isFinished = false;
                        }
                        client.initialize(info);
                        isInitialized = true;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getInstance", LOG_END);
                return client;
            }
        }
    }

    private void initialize(HashMap info) {
        this.initProperty();
        sessionLogger = SJsessionClient.getLogger();
        String LOG_SUBTITLE = "initialize";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "initialize", LOG_START);
        if (this.checkInitInfo(info)) {
            this.appID = (String)info.get("APPLICATIONID");
        }
        this.setClientProperties();
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "initialize", LOG_END);
    }

    private void initProperty() {
        try {
            if (System.getProperty("SN_DataPath") == null) {
                System.setProperty("SN_DataPath", SJsessionClientConst.SN_STARTUP_DATA_PATH);
            }
            if (System.getProperty("SN_EnvFile") == null) {
                System.setProperty("SN_EnvFile", SJsessionClientConst.SN_STARTUP_ENV_PATH);
            }
            if (System.getProperty("SN_EnvFileV") == null) {
                System.setProperty("SN_EnvFileV", SJsessionClientConst.SN_STARTUP_ENV_V_PATH);
            }
        }
        catch (SecurityException e) {
            throw new SJsessionClientSecurityException("107002");
        }
        this.sysPropMgr = new SJbaseSystemPropertiesManager();
        this.sysPropMgr.initialize(0);
    }

    private boolean checkInitInfo(HashMap initInfo) {
        boolean result = true;
        String LOG_SUBTITLE = "checkInitInfo";
        if (initInfo == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkInitInfo", "Parameter is null!");
            throw new SJsessionClientParameterException("107001");
        }
        Object obj = initInfo.get("APPLICATIONID");
        if (obj == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkInitInfo", "APPLICATIONID is null!");
            throw new SJsessionClientParameterException("107001");
        }
        if (!(obj instanceof String)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkInitInfo", "APPLICATIONID is not String!");
            throw new SJsessionClientParameterException("107001");
        }
        obj = initInfo.get("APPLICATION");
        if (obj != null && !(obj instanceof SJsessionApplicationInterface)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkInitInfo", "APPLICATION is not SJsessionApplicationInterface!");
            throw new SJsessionClientParameterException("107001");
        }
        return result;
    }

    private void setClientProperties() {
        String LOG_SUBTITLE = "setClientProperties";
        String sessionPath = SJcEnvUty.getProperty("SN_SESSION_PATH", "session");
        String clientPath = SJcEnvUty.getProperty("SN_SESSION_CLIENT_PATH", "client");
        String dirName = SJcFileUty.concatFolderPath(sessionPath, clientPath);
        String fileName = SJcEnvUty.getProperty("SN_SESSION_CLIENT_FILE", "SessionClient.properties");
        try {
            Properties props = SJcFileUty.loadProperties(dirName, fileName);
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (System.getProperty(key) != null) continue;
                String value = props.getProperty(key);
                System.setProperty(key, value);
            }
        }
        catch (SJcException e) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "setClientProperties", "Failed to read properties file.");
            throw e;
        }
    }

    private boolean waitConnect(int count, int interval) {
        String LOG_SUBTITLE = "waitConnect";
        sessionLogger.trace(LOG_FUNCTION, LOG_TITLE, "waitConnect", LOG_START);
        boolean res = false;
        if ("CONNECTING".equals(this.getConnectionStateStr())) {
            int retryCount = 0;
            while (!isFinished) {
                if ("AVAILABLE".equals(this.getConnectionStateStr())) {
                    res = true;
                } else if (!"NOT_AVAILABLE".equals(this.getConnectionStateStr())) {
                    if (count < 0) {
                        this.callSleep(interval);
                        continue;
                    }
                    if (retryCount < count) {
                        ++retryCount;
                        this.callSleep(interval);
                        continue;
                    }
                }
                break;
            }
        } else if ("AVAILABLE".equals(this.getConnectionStateStr())) {
            res = true;
        }
        sessionLogger.trace(LOG_FUNCTION, LOG_TITLE, "waitConnect", LOG_END);
        return res;
    }

    private void startThreads() {
        String LOG_SUBTITLE = "startThreads";
        this.alivePollingThread = new AlivePollingThread();
        this.alivePollingThread.start();
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "startThreads", "Start alive polling thread.");
        this.changeNotifyThread = new ChangeNotifyThread();
        this.changeNotifyThread.start();
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "startThreads", "Start change notify thread.");
    }

    private synchronized void connectSessionServer(HashMap info) {
        String LOG_SUBTITLE = "connectSessionServer";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "connectSessionServer", LOG_START);
        SJsessionRemoteInterface remote = this.lookupRegistry();
        if (remote != null) {
            this.updateReceiver(remote, info);
            this.reLogin();
            HashMap receiveInfo = this.getReceiveInformation();
            if (receiveInfo != null) {
                this.connectionID = (String)receiveInfo.get("CONNECTIONID");
                this.notifyThreads(receiveInfo);
                this.setConnectionState("AVAILABLE");
            } else {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "connectSessionServer", "Receive module information is invalid.");
                try {
                    this.receive.finish();
                }
                catch (Exception e) {
                    sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "connectSessionServer", "Failed to finish receive module.");
                }
                this.setConnectionState("NOT_AVAILABLE");
            }
        } else {
            this.setConnectionState("NOT_AVAILABLE");
        }
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "connectSessionServer", LOG_END);
        this.startWaitObj.notifyObject();
        if (this.connectionThread != null) {
            this.connectionThread.waitThread(0L);
        }
    }

    private SJsessionRemoteInterface lookupRegistry() {
        String LOG_SUBTITLE = "lookupRegistry";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "lookupRegistry", LOG_START);
        int count = 0;
        SJsessionRemoteInterface remote = null;
        String remoteName = "rmi://" + this.registry_host + ":" + this.registry_port + "/" + this.registry_name;
        while (true) {
            try {
                remote = (SJsessionRemoteInterface)Naming.lookup(remoteName);
                if (remote != null) {
                    break;
                }
            }
            catch (AccessException e) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "lookupRegistry", "AccessException -Remote: " + remoteName);
                break;
            }
            catch (MalformedURLException e) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "lookupRegistry", "MalformedURLException -Remote: " + remoteName);
                break;
            }
            catch (NotBoundException e) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "lookupRegistry", "NotBoundException -Remote: " + remoteName);
            }
            catch (RemoteException e) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "lookupRegistry", "RemoteException -Remote: " + remoteName, e);
            }
            if (isFinished) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "lookupRegistry", "Session client has finished.");
                break;
            }
            if (this.connect_retry_count < 0) {
                this.connectionThread.waitThread(this.connect_retry_interval);
                continue;
            }
            if (this.connect_retry_count <= count) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "lookupRegistry", "Failed to get remote class. Remote: " + remoteName);
                break;
            }
            ++count;
            this.connectionThread.waitThread(this.connect_retry_interval);
        }
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "lookupRegistry", LOG_END);
        return remote;
    }

    private void updateReceiver(SJsessionRemoteInterface remote, HashMap info) {
        String LOG_SUBTITLE = "updateReceiver";
        SJsessionReceiveInterface newReceive = null;
        if (this.connectionID != null) {
            info.put("CONNECTIONID", this.connectionID);
            try {
                newReceive = remote.getSessionReceiverByConID(info);
            }
            catch (Exception e) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "updateReceiver", "Failed to get receive module by connection ID. -connectionID:" + this.connectionID, e);
            }
        }
        if (newReceive == null) {
            try {
                newReceive = remote.getSessionReceiver(info);
            }
            catch (Exception exNewRecieve) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "updateReceiver", "Failed to get receive module.", exNewRecieve);
            }
        }
        if (newReceive != null) {
            this.receive = newReceive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reLogin() {
        String LOG_SUBTITLE = "reLogin";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "reLogin", LOG_START);
        if (this.sessionList.size() > 0) {
            HashMap reLoginInfo = new HashMap();
            reLoginInfo.put("RELOGIN_LIST", new ArrayList(this.sessionList.values()));
            HashMap reLoginResult = null;
            try {
                reLoginResult = this.receive.reLogin(reLoginInfo);
            }
            catch (Exception e) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "reLogin", "Failed to Relogin.", e);
                return;
            }
            if (reLoginResult != null) {
                List alivedSessionList = (List)reLoginResult.get("RELOGINED_GSID_LIST");
                HashMap hashMap = this.sessionList;
                synchronized (hashMap) {
                    this.removeClientSession(alivedSessionList);
                }
            }
        }
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "reLogin", LOG_END);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconnect() {
        String LOG_SUBTITLE = "reconnect";
        sessionLogger.trace(LOG_FUNCTION, LOG_TITLE, "reconnect", LOG_START);
        boolean usableReceive = false;
        Object object = this.connectionStateLock;
        synchronized (object) {
            if (!"CONNECTING".equals(this.getConnectionStateStr())) {
                try {
                    usableReceive = this.receive.isAvailable();
                }
                catch (Exception e) {
                    sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "reconnect", "Receive module is not available.");
                }
                if (!usableReceive) {
                    this.setConnectionState("CONNECTING");
                    if (this.connectionThread != null) {
                        this.connectionThread.notifyThread();
                    }
                } else if (!"AVAILABLE".equals(this.getConnectionStateStr())) {
                    this.setConnectionState("AVAILABLE");
                }
            }
        }
        boolean result = this.waitConnect(this.wait_count, this.wait_interval);
        sessionLogger.trace(LOG_FUNCTION, LOG_TITLE, "reconnect", "End. -result:" + result);
        return result;
    }

    private void removeClientSession(List alivedSessionList) {
        String LOG_SUBTITLE = "removeClientSession";
        if (alivedSessionList == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "removeClientSession", "Alive session list is null.");
            return;
        }
        Iterator ite = this.sessionList.keySet().iterator();
        while (ite.hasNext()) {
            String sessionID = (String)ite.next();
            if (alivedSessionList.contains(sessionID)) continue;
            sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "removeClientSession", "Remove session. -global session ID:" + sessionID);
            ite.remove();
        }
    }

    private HashMap getReceiveInformation() {
        String LOG_SUBTITLE = "getReceiveInformation";
        HashMap receiveInfo = null;
        if (this.receive != null) {
            try {
                receiveInfo = this.receive.getReceiveInfo();
            }
            catch (Exception getInfoEx) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "getReceiveInformation", "Failed to get receive information.", getInfoEx);
                this.setConnectionState("NOT_AVAILABLE");
                try {
                    this.receive.finish();
                }
                catch (Exception finishEx) {
                    sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "getReceiveInformation", "Failed to finish receive module.", finishEx);
                }
            }
        }
        return receiveInfo;
    }

    private void notifyThreads(HashMap receiveInfo) {
        if (!isStartedThreads) {
            this.alivePollingInterval = (Integer)receiveInfo.get("ALIVEPOLLINGPERIOD") * 1000;
            this.changeNotifyFlag = (Boolean)receiveInfo.get("NOTIFYFLAG");
            if (this.alivePollingThread != null) {
                this.alivePollingThread.notifyThread();
            }
            if (this.changeNotifyThread != null) {
                this.changeNotifyThread.notifyThread();
            }
            isStartedThreads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        String LOG_SUBTITLE = "finish";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "finish", LOG_START);
        Object object = startFinishLockObj;
        synchronized (object) {
            if (this.isFinished()) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "finish", "Session client has finished.");
                return;
            }
            Object object2 = isFinishedLockObj;
            synchronized (object2) {
                isFinished = true;
            }
            isInitialized = false;
            sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "finish", LOG_END);
        }
    }

    private void finishThreads() {
        this.alivePollingThread.end();
        this.alivePollingThread.notifyThread();
        this.alivePollingThread = null;
        this.changeNotifyThread.end();
        this.changeNotifyThread.notifyThread();
        this.changeNotifyThread = null;
        this.connectionThread.end();
        this.connectionThread.notifyThread();
        this.connectionThread = null;
        this.sysPropMgr.finish();
        this.sysPropMgr = null;
    }

    private void sweepThreads() {
        ArrayList activeInnerThreads = null;
        do {
            activeInnerThreads = this.getActiveInnerThread();
            for (int i = 0; i < activeInnerThreads.size(); ++i) {
                GeneralInnerThread innerThread = (GeneralInnerThread)activeInnerThreads.get(i);
                innerThread.end();
                innerThread.interrupt();
                this.callSleep(100L);
            }
        } while (activeInnerThreads.size() > 0);
    }

    private ArrayList getActiveInnerThread() {
        ArrayList<Thread> activeInnerThreads = new ArrayList<Thread>();
        Thread[] activeThreads = new Thread[Thread.activeCount()];
        Thread.enumerate(activeThreads);
        for (int i = 0; i < activeThreads.length; ++i) {
            if (!(activeThreads[i] instanceof GeneralInnerThread)) continue;
            activeInnerThreads.add(activeThreads[i]);
        }
        return activeInnerThreads;
    }

    public HashMap login(HashMap loginInfo) throws Exception {
        if (this.isFinished()) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "login", "Session client has finished.");
            throw new SJsessionClientIllegalStateException("107006");
        }
        this.checkLoginParam(loginInfo);
        String userId = (String)loginInfo.get("AUTHENTICATION_USERID");
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "login", LOG_START + userId);
        String pass = (String)loginInfo.get("AUTHENTICATION_PASSWORD");
        String type = (String)loginInfo.get("LOGINTYPE");
        String[] authSysList = SJcEnvUty.getProperty(this.appID + "." + type, "").split(",");
        SJbaseAuthenticationSystem authSys = new SJbaseAuthenticationSystem();
        int iRet = authSys.authentication(userId, pass, authSysList, 0);
        if (iRet != 0 || !this.authenticateEmergencyLogin((String)loginInfo.get("LOGINTYPE"), authSys)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "login", "Authentication error occurred. User ID: " + userId);
            if (iRet == 9) {
                SJsessionClientBusyConnectException ex = new SJsessionClientBusyConnectException("107000");
                HashMap failedInfo = this.createLoginFailedInfo(loginInfo);
                ex.setAuthResult(failedInfo);
                throw ex;
            }
            SJsessionAuthenticationException ex = new SJsessionAuthenticationException("107000");
            HashMap failedInfo = this.createLoginFailedInfo(loginInfo);
            ex.setAuthResult(failedInfo);
            throw ex;
        }
        loginInfo = this.createLoginResultInfo(loginInfo, authSys);
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "login", LOG_END + userId);
        return loginInfo;
    }

    private boolean checkLoginParam(HashMap loginInfo) throws Exception {
        String LOG_SUBTITLE = "checkLoginParam";
        boolean result = true;
        if (loginInfo == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "Parameter is null!");
            throw new SJsessionClientParameterException("107001");
        }
        Object param = loginInfo.get("AUTHENTICATION_USERID");
        if (param == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "AUTHENTICATION_USERID is null!");
            throw new SJsessionClientParameterException("107001");
        }
        if (!(param instanceof String)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "AUTHENTICATION_USERID is not String!");
            throw new SJsessionClientParameterException("107001");
        }
        param = loginInfo.get("AUTHENTICATION_PASSWORD");
        if (param == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "AUTHENTICATION_PASSWORD is null!");
            throw new SJsessionClientParameterException("107001");
        }
        if (!(param instanceof String)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "AUTHENTICATION_PASSWORD is not String!");
            throw new SJsessionClientParameterException("107001");
        }
        param = loginInfo.get("LOGINTYPE");
        if (param == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "LOGINTYPE is null!");
            throw new SJsessionClientParameterException("107001");
        }
        if (!(param instanceof String)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "LOGINTYPE is not String!");
            throw new SJsessionClientParameterException("107001");
        }
        param = loginInfo.get("LANG");
        if (param != null && !(param instanceof String)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "LANG is not String!");
            throw new SJsessionClientParameterException("107001");
        }
        if (param == null || ((String)param).length() == 0) {
            loginInfo.put("LANG", "EN");
        }
        if ((param = loginInfo.get("ADDRESS")) != null && !(param instanceof String)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "ADDRESS is not String!");
            throw new SJsessionClientParameterException("107001");
        }
        if (param == null || ((String)param).length() == 0) {
            loginInfo.put("ADDRESS", "");
        }
        if ((param = loginInfo.get("IDENTICAL_USERID")) != null && !(param instanceof Integer)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLoginParam", "IDENTICAL_USERID is not Integer!");
            throw new SJsessionClientParameterException("107001");
        }
        return result;
    }

    private HashMap createLoginResultInfo(HashMap loginInfo, SJbaseAuthenticationSystem authResult) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(loginInfo);
        result.put("APPLICATIONID", this.appID);
        result.put("DISPLAY_USERID", authResult.getUserName());
        result.put("AUTHORIZED_PASSWORD", authResult.getPassword());
        result.put("GLOBALSESSIONID", authResult.getSessionID());
        result.put("LOGINTIME", new Date());
        result.put("AUTHENTICATION_NAME", authResult.getAuthSystemName());
        result.put("USER_IDENTICALNAME", authResult.getUserID());
        result.put("USERGROUPS", authResult.getGroupID());
        result.put("AUTHENTICATION_OBJECT", authResult.getAuthObject());
        SJcRoleResourceContainer roleResource = null;
        roleResource = null != authResult.getGroupID() ? SJcUserGroupInfoUty.getUserGroupObject(authResult.getGroupID()) : this.createRoleResource(authResult);
        result.put("RESOURCE_ROLE", roleResource);
        result.put("IDENTICAL_USERID", new Integer(0));
        return result;
    }

    private SJcRoleResourceContainer createRoleResource(SJbaseAuthenticationSystem authSys) {
        SJcRoleResourceContainer roleResource = new SJcRoleResourceContainer(0);
        String roleString = this.createRoleString(authSys.getRoleMap());
        roleResource.setAllAuthBit(roleString);
        roleResource.setAllRsrcMap(authSys.getResourceGrpMap());
        roleResource.setAllRsrcFlg(authSys.isAllRSG());
        return roleResource;
    }

    private String createRoleString(boolean[] roleMap) {
        if (null == roleMap) {
            return "";
        }
        int CHAR_SIZE = 4;
        StringBuffer buff = new StringBuffer();
        int role = 0;
        for (int i = 0; i < roleMap.length; ++i) {
            if (roleMap[i]) {
                role = (byte)(role | 1 << 3 - i % 4);
            }
            if ((i + 1) % 4 != 0 && i != roleMap.length - 1) continue;
            buff.append(Integer.toHexString(role));
            role = 0;
        }
        return buff.toString().toUpperCase();
    }

    private boolean authenticateEmergencyLogin(String loginType, SJbaseAuthenticationSystem authSys) {
        boolean ret = false;
        if ("StorageNavigator2".equals(this.appID) && "NOR_EM".equals(loginType)) {
            this.updateEmergencyGrpContainer();
            if (null != this.emergencyGrpContainer) {
                SJcRoleResourceContainer authRscContaier = null;
                if (null != authSys.getGroupID()) {
                    authRscContaier = SJcUserGroupInfoUty.getUserGroupObject(authSys.getGroupID());
                }
                boolean checkRole = this.checkEmergencyGrpRole(authSys, authRscContaier);
                boolean checkRSG = this.checkEmergencyGrpRSG(authSys, authRscContaier);
                boolean checkAllRSG = this.checkEmergencyGrpAllRSG(authSys, authRscContaier);
                ret = checkRole && checkRSG && checkAllRSG;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private void updateEmergencyGrpContainer() {
        try {
            if (null == this.emergencyGrpContainer) {
                this.emergencyGrpContainer = SJcUserGroupInfoUty.getUserGroupObject(SJsessionClientConst.EMERGENCY_NEED_GROUP);
            }
        }
        catch (SJcException e) {
            sessionLogger.error(LOG_TITLE, LOG_FUNCTION, "updateEmergencyGrpContainer", "Failed to get role resource object.", e);
        }
    }

    private boolean checkEmergencyGrpRole(SJbaseAuthenticationSystem authSys, SJcRoleResourceContainer authRscContaier) {
        boolean ret = true;
        boolean[] authRoleMap = authSys.getRoleMap();
        int roleSize = 256;
        if (null != authRoleMap) {
            roleSize = authRoleMap.length;
        }
        boolean authRole = false;
        for (int i = 0; i < roleSize; ++i) {
            authRole = null != authRoleMap ? authRoleMap[i] : (null != authRscContaier ? authRscContaier.checkAuthority(i) : false);
            if (!this.emergencyGrpContainer.checkAuthority(i) || authRole) continue;
            ret = false;
            sessionLogger.error(LOG_TITLE, LOG_FUNCTION, "checkEmergencyGrpRole", "No authority: " + i);
            break;
        }
        return ret;
    }

    private boolean checkEmergencyGrpRSG(SJbaseAuthenticationSystem authSys, SJcRoleResourceContainer authRscContaier) {
        boolean ret = true;
        boolean[] authRsgMap = authSys.getResourceGrpMap();
        int rsgSize = 1024;
        if (null != authRsgMap) {
            rsgSize = authRsgMap.length;
        }
        boolean authRsc = false;
        for (int i = 0; i < rsgSize; ++i) {
            authRsc = null != authRsgMap ? authRsgMap[i] : (null != authRscContaier ? authRscContaier.checkResourceGroup(i) : false);
            if (!this.emergencyGrpContainer.checkResourceGroup(i) || authRsc) continue;
            ret = false;
            sessionLogger.error(LOG_TITLE, LOG_FUNCTION, "checkEmergencyGrpRSG", "No RSG authority: " + i);
            break;
        }
        return ret;
    }

    private boolean checkEmergencyGrpAllRSG(SJbaseAuthenticationSystem authSys, SJcRoleResourceContainer authRscContaier) {
        boolean ret;
        boolean authAllRSG = false;
        authAllRSG = null != authRscContaier ? authRscContaier.checkAllResourceGroup() : authSys.isAllRSG();
        boolean bl = ret = !this.emergencyGrpContainer.checkAllResourceGroup() || authAllRSG;
        if (!ret) {
            sessionLogger.error(LOG_TITLE, LOG_FUNCTION, "checkEmergencyGrpAllRSG", "User All RSG: " + authSys.isAllRSG());
        }
        return ret;
    }

    private HashMap createLoginFailedInfo(HashMap loginInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("AUTHENTICATION_USERID", (String)loginInfo.get("AUTHENTICATION_USERID"));
        result.put("AUTHENTICATION_PASSWORD", (String)loginInfo.get("AUTHENTICATION_PASSWORD"));
        result.put("GLOBALSESSIONID", "");
        result.put("IDENTICAL_USERID", new Integer(0));
        return result;
    }

    public HashMap logout(HashMap logoutInfo) throws Exception {
        String LOG_SUBTITLE = "logout";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "logout", LOG_START);
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "logout", LOG_END);
        return null;
    }

    private boolean checkLogoutParam(HashMap logoutInfo) throws Exception {
        String LOG_SUBTITLE = "checkLogoutParam";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "checkLogoutParam", LOG_START);
        if (logoutInfo == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLogoutParam", "Parameter is null!");
            return false;
        }
        Object param = logoutInfo.get("GLOBALSESSIONID");
        if (param == null) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLogoutParam", "GLOBALSESSIONID is null!");
            return false;
        }
        if (!(param instanceof String)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLogoutParam", "GLOBALSESSIONID is not String!");
            return false;
        }
        param = logoutInfo.get("FORCED_FLAG");
        if (param != null && !(param instanceof Boolean)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "checkLogoutParam", "FORCED_FLAG is not Boolean!");
            return false;
        }
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "checkLogoutParam", LOG_END);
        return true;
    }

    public HashMap getUserList() throws Exception {
        String LOG_SUBTITLE = "getUserList";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getUserList", LOG_START);
        HashMap userList = new HashMap(0);
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getUserList", LOG_END);
        return userList;
    }

    public HashMap getConnectionState(HashMap info) throws Exception {
        String LOG_SUBTITLE = "getConnectionState";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getConnectionState", LOG_START);
        HashMap ret = new HashMap();
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getConnectionState", LOG_END);
        return ret;
    }

    private void setConnectionState(String connectionState) {
        String LOG_SUBTITLE = "setConnectionState";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "setConnectionState", "Set status:" + this.connectionState + " -> " + connectionState);
        this.connectionState = connectionState;
    }

    private String getConnectionStateStr() {
        String LOG_SUBTITLE = "getConnectionStateStr";
        sessionLogger.trace(LOG_FUNCTION, LOG_TITLE, "getConnectionStateStr", LOG_START);
        sessionLogger.trace(LOG_FUNCTION, LOG_TITLE, "getConnectionStateStr", LOG_END);
        return this.connectionState;
    }

    public HashMap getVersionInfo(HashMap info) throws Exception {
        String LOG_SUBTITLE = "getVersionInfo";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getVersionInfo", LOG_START);
        if (this.isFinished()) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "getVersionInfo", "Session client has finished.");
            throw new SJsessionClientIllegalStateException("107005");
        }
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getVersionInfo", LOG_END);
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("VERSION", SJsessionDef.VERSION_VAL);
        return ret;
    }

    private static SJcLoggerInterface getLogger() {
        return SJcLogUty.getLogger("SN_Session_Log.log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aliveSession() {
        String LOG_SUBTITLE = "aliveSession";
        sessionLogger.trace(LOG_FUNCTION, LOG_TITLE, "aliveSession", LOG_START);
        if (!this.reconnect()) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "aliveSession", "Connection error has occurred.");
            if (this.alivePollingThread != null) {
                this.alivePollingThread.waitThread(this.alivePollingInterval);
            }
            return;
        }
        if (this.isFinished()) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "aliveSession", "Session client has finished.");
            return;
        }
        HashMap hashMap = this.sessionList;
        synchronized (hashMap) {
            HashMap info = new HashMap();
            info.put("GLOBALSESSIONID_ALIVE_LIST", new ArrayList(this.sessionList.keySet()));
            HashMap result = null;
            try {
                result = this.receive.alive_session(info);
            }
            catch (Exception e) {
                sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "aliveSession", "Failed to inform alive session.");
            }
            if (result != null) {
                sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "aliveSession", "Get alive session list.");
                List alivedSessionList = (List)result.get("GLOBALSESSIONID_ALIVE_LIST");
                this.removeClientSession(alivedSessionList);
            }
        }
        sessionLogger.trace(LOG_FUNCTION, LOG_TITLE, "aliveSession", LOG_END);
        if (this.alivePollingThread != null) {
            this.alivePollingThread.waitThread(this.alivePollingInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getChangeNotifyInfo() {
        String LOG_SUBTITLE = "getChangeNotifyInfo";
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getChangeNotifyInfo", LOG_START);
        if (!this.reconnect()) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "getChangeNotifyInfo", "Connection error has occurred.");
            if (this.changeNotifyThread != null) {
                this.changeNotifyThread.waitThread(this.wait_interval);
            }
            return;
        }
        HashMap notifyInfo = null;
        try {
            notifyInfo = this.receive.changeNotify();
        }
        catch (Exception e) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "getChangeNotifyInfo", "Failed to get event info.", e);
        }
        if (!SJsessionUty.checkParameter(notifyInfo, "EVENT_LIST", class$java$util$List == null ? (class$java$util$List = SJsessionClient.class$("java.util.List")) : class$java$util$List, true)) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "getChangeNotifyInfo", "Event info is invalid.");
            if (this.changeNotifyThread != null) {
                this.changeNotifyThread.waitThread(this.wait_interval);
            }
            return;
        }
        List eventList = (List)notifyInfo.get("EVENT_LIST");
        HashMap hashMap = this.sessionList;
        synchronized (hashMap) {
            for (int i = 0; i < eventList.size(); ++i) {
                String sessionID;
                HashMap sessionInfo = (HashMap)eventList.get(i);
                String sessionInfoStr = SJsessionClientUty.getChangeNotifyInfoStr(sessionInfo);
                sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getChangeNotifyInfo", "Get notify event information. -sessionInfo:" + sessionInfoStr);
                String kind = null;
                if (SJsessionUty.checkParameter(sessionInfo, "EVENT_KIND", class$java$lang$String == null ? SJsessionClient.class$("java.lang.String") : class$java$lang$String, true)) {
                    kind = (String)sessionInfo.get("EVENT_KIND");
                }
                if (!"INFO_DEL".equals(kind) || (sessionID = this.getSessionIDfromMap(sessionInfo)) == null) continue;
                this.sessionList.remove(sessionID);
            }
        }
        if (this.app != null) {
            this.app.getUserChgInfo(notifyInfo);
        }
        sessionLogger.info(LOG_FUNCTION, LOG_TITLE, "getChangeNotifyInfo", LOG_END);
    }

    private String getSessionIDfromMap(HashMap map) {
        String res = null;
        if (SJsessionUty.checkParameter(map, "GLOBALSESSIONID", class$java$lang$String == null ? (class$java$lang$String = SJsessionClient.class$("java.lang.String")) : class$java$lang$String, true)) {
            res = (String)map.get("GLOBALSESSIONID");
        }
        return res;
    }

    private void callSleep(long msec) {
        String LOG_SUBTITLE = "callSleep";
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            sessionLogger.error(LOG_FUNCTION, LOG_TITLE, "callSleep", "InterruptedException has occurred.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFinished() {
        Object object = isFinishedLockObj;
        synchronized (object) {
            return isFinished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishNotify() {
        Object object = this.executeMethodCountLockObj;
        synchronized (object) {
        }
        if (--executeMethodCount <= 0 && this.isFinished()) {
            this.finishWaitObj.notifyObject();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ChangeNotifyThread
    extends GeneralInnerThread {
        private static final String LOG_TITLE = "ChangeNotifyThread";

        ChangeNotifyThread() {
        }

        public void run() {
            String LOG_SUBTITLE = "run";
            if (SJsessionClient.this.changeNotifyThread != null) {
                SJsessionClient.this.changeNotifyThread.waitThread(0L);
            }
            if (!SJsessionClient.this.changeNotifyFlag) {
                sessionLogger.info(SJsessionClient.LOG_FUNCTION, LOG_TITLE, "run", "Change notify flag is false.");
                return;
            }
            if (SJsessionClient.this.app == null) {
                sessionLogger.error(SJsessionClient.LOG_FUNCTION, LOG_TITLE, "run", "Call back instance is null.");
            }
            while (!this.endFlag) {
                SJsessionClient.this.getChangeNotifyInfo();
            }
        }
    }

    class AlivePollingThread
    extends GeneralInnerThread {
        private static final String LOG_TITLE = "AlivePollingThread";

        AlivePollingThread() {
        }

        public void run() {
            String LOG_SUBTITLE = "run";
            if (SJsessionClient.this.alivePollingThread != null) {
                SJsessionClient.this.alivePollingThread.waitThread(0L);
            }
            if (SJsessionClient.this.alivePollingInterval <= 0) {
                sessionLogger.info(SJsessionClient.LOG_FUNCTION, LOG_TITLE, "run", "Alive polling interval is not available. -alivePollingInterval:" + SJsessionClient.this.alivePollingInterval);
                return;
            }
            while (!this.endFlag) {
                SJsessionClient.this.aliveSession();
            }
        }
    }

    class LogoutThread
    extends GeneralInnerThread {
        private static final String LOG_TITLE = "LogoutThread";
        HashMap info = null;

        public LogoutThread(HashMap info) {
            this.info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String LOG_SUBTITLE = "run";
            String sessionID = (String)this.info.get("GLOBALSESSIONID");
            try {
                Object object = SJsessionClient.this.executeMethodCountLockObj;
                synchronized (object) {
                    executeMethodCount++;
                }
                if (!SJsessionClient.this.reconnect()) {
                    sessionLogger.error(SJsessionClient.LOG_FUNCTION, LOG_TITLE, "run", "Connection error has occurred.");
                } else {
                    SJsessionClient.this.receive.logout(this.info);
                    sessionLogger.info(SJsessionClient.LOG_FUNCTION, LOG_TITLE, "run", "Logout session success. -session ID:" + sessionID);
                }
            }
            catch (Exception e) {
                sessionLogger.error(SJsessionClient.LOG_FUNCTION, LOG_TITLE, "run", "Failed to logout. -session ID:" + sessionID);
            }
            finally {
                SJsessionClient.this.finishNotify();
            }
        }
    }

    class ConnectSessionServerThread
    extends GeneralInnerThread {
        private HashMap info = null;

        public ConnectSessionServerThread(HashMap info) {
            this.info = info;
            this.info.put("VERSION", SJsessionDef.VERSION_VAL);
        }

        public void run() {
            while (!this.endFlag) {
                SJsessionClient.this.connectSessionServer(this.info);
            }
        }
    }

    class WaitObject {
        private final String LOG_TITLE = "GeneralInnerThread";

        WaitObject() {
        }

        public synchronized void waitObject(long msec) {
            String LOG_SUBTITLE = "waitThread";
            try {
                this.wait(msec);
            }
            catch (InterruptedException e) {
                sessionLogger.error(SJsessionClient.LOG_FUNCTION, "GeneralInnerThread", "waitThread", "InterruptedException occurred.");
            }
        }

        public synchronized void notifyObject() {
            this.notify();
        }
    }

    class GeneralInnerThread
    extends Thread {
        private final String LOG_TITLE = "GeneralInnerThread";
        protected boolean endFlag = false;

        public synchronized void waitThread(long msec) {
            String LOG_SUBTITLE = "waitThread";
            try {
                this.wait(msec);
            }
            catch (InterruptedException e) {
                sessionLogger.error(SJsessionClient.LOG_FUNCTION, "GeneralInnerThread", "waitThread", "InterruptedException occurred.", e);
            }
        }

        public synchronized void notifyThread() {
            this.notify();
        }

        public synchronized void end() {
            this.endFlag = true;
        }
    }
}

