/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.base;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sanproject.client.base.RJbGuideConst;
import sanproject.client.com.RJcBaseDialog;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcSouthPanel;

public class RJbVenderInfoDialog
extends RJcBaseDialog
implements RJbGuideConst {
    protected JLabel venderName = new JLabel();
    protected URLLabel helpPG = new URLLabel();
    protected URLLabel webPG = new URLLabel();
    RJcListPanel listPanel = new RJcListPanel();
    private static final String errMsg = "Error attempting to launch web browser";
    static /* synthetic */ Class class$java$lang$String;

    public RJbVenderInfoDialog(Frame frame) {
        super(frame);
        this.setResizable(false);
        super.initInstance();
        this.pack();
    }

    public String getDialogName() {
        return "Base/MenuVender";
    }

    protected JPanel createCenterComponent() {
        this.venderName.setPreferredSize(new Dimension(250, this.venderName.getHeight()));
        this.listPanel.addEntry("Base/MenuVenderVenderL", this.venderName);
        this.listPanel.addEntry("Base/MenuVenderWebL", this.webPG);
        this.listPanel.addEntry("Base/MenuVenderHelpPageL", this.helpPG);
        this.listPanel.completed();
        return this.listPanel;
    }

    protected JPanel createSouthComponent() {
        RJcSouthPanel rJcSouthPanel = (RJcSouthPanel)super.createSouthComponent();
        JButton jButton = this.newButton("Base/MenuVersionButton");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJbVenderInfoDialog.this.windowClosing();
            }
        });
        rJcSouthPanel.addComponent(jButton, 0);
        return rJcSouthPanel;
    }

    public boolean showPanel() {
        boolean bl = true;
        this.venderName.setText(RJcGuide.text("Base/MenuVenderVender"));
        this.webPG.setURL(RJcGuide.text("Base/MenuVenderWeb"));
        this.helpPG.setURL(RJcGuide.text("Base/MenuVenderHelpPage"));
        return bl;
    }

    public static void openURL(String string) {
        String string2 = System.getProperty("os.name");
        try {
            if (string2.startsWith("Mac OS")) {
                Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                Method method = clazz.getDeclaredMethod("openURL", class$java$lang$String == null ? (class$java$lang$String = RJbVenderInfoDialog.class$("java.lang.String")) : class$java$lang$String);
                method.invoke(null, string);
            } else if (string2.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
            } else {
                String[] stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String string3 = null;
                for (int i = 0; i < stringArray.length && string3 == null; ++i) {
                    if (Runtime.getRuntime().exec(new String[]{"which", stringArray[i]}).waitFor() != 0) continue;
                    string3 = stringArray[i];
                }
                if (string3 == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{string3, string});
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + exception.getLocalizedMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class URLLabel
    extends JLabel {
        private String url;
        private Point pos = new Point();
        private Color orgColor = this.getForeground();
        private Cursor cc = this.getCursor();
        private Cursor hc = new Cursor(12);
        private boolean flg = false;
        private int width;
        private int height;

        URLLabel() {
        }

        public void setURL(String string) {
            Font font = this.getFont();
            this.url = string;
            this.setText(this.url);
            this.setOpaque(false);
            this.width = SwingUtilities.computeStringWidth(this.getFontMetrics(font), this.url);
            this.height = this.getHeight();
            if (this.width > 200) {
                this.width = 200;
            }
            this.setPreferredSize(new Dimension(this.width, this.height));
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    JComponent jComponent = (JComponent)componentEvent.getSource();
                    URLLabel.this.pos.setLocation(jComponent.getInsets().left, (jComponent.getSize().height + URLLabel.this.height) / 2);
                    jComponent.repaint();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    URLLabel.this.flg = URLLabel.this.isOnURL(mouseEvent.getPoint());
                    if (URLLabel.this.flg) {
                        jComponent.setCursor(URLLabel.this.hc);
                    } else {
                        jComponent.setCursor(URLLabel.this.cc);
                    }
                    jComponent.repaint();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseExited(MouseEvent mouseEvent) {
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    jComponent.setCursor(URLLabel.this.cc);
                    URLLabel.this.flg = false;
                    jComponent.repaint();
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    RJbVenderInfoDialog.openURL(URLLabel.this.url);
                }
            });
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.flg) {
                this.setForeground(Color.BLUE);
            } else {
                this.setForeground(Color.BLACK);
            }
        }

        private boolean isOnURL(Point point) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(this.getInsets().left, this.pos.y - this.height / 2, this.width, this.height);
            return float_.contains(point.x, point.y);
        }
    }
}

