/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import sanproject.client.com.restoreview.ComponentParser;
import sanproject.client.com.restoreview.DefaultTreeComponentParser;
import sanproject.client.com.restoreview.TreeComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.com.restoreview.ViewRestorer;
import sanproject.client.com.restoreview.utility.TreeComponentUtilities;

public class DefaultTreeViewRestorer
implements ViewRestorer {
    public static final int TREE_EXPAND_ONLY_SELECTION_RESTORE = 16;
    public static final int TREE_EXPAND_ALL_RESTORE = 32;
    public static final int TREE_EXPAND_COMPLETENESS_RESTORE = 64;
    public static final int TREE_EXPAND_MAINTENANCE_RESTORE = 128;
    private int miRestoreMode;
    private JTree mclsSaveTree;
    private TreeComponentParser mclsComponentParser;

    public DefaultTreeViewRestorer() {
        this.initInstance();
    }

    public DefaultTreeViewRestorer(JTree jTree) throws UnsupportedComponentException {
        this();
        this.saveViewComponent(jTree);
    }

    private void initInstance() {
        int n = 0;
        n |= 1;
        n |= 0x10;
        n |= 0x80;
        try {
            this.setRestoreMode(n);
        }
        catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
            throw new RuntimeException();
        }
        this.mclsComponentParser = new DefaultTreeComponentParser();
    }

    protected void finalize() throws Throwable {
        this.mclsSaveTree = null;
        this.mclsComponentParser = null;
        super.finalize();
    }

    public void saveViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JTree)) {
            String string = "Any components other than 'javax.swing.JTree' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        try {
            JTree jTree = (JTree)component;
            this.mclsSaveTree = TreeComponentUtilities.createCopyTree(jTree);
            TreeComponentUtilities.collapseAllNodes(this.mclsSaveTree);
            this.mclsSaveTree.clearSelection();
            TreeModel treeModel = jTree.getModel();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
            TreePath treePath = new TreePath(defaultMutableTreeNode);
            this.restoreAllNodesExpanded(jTree, this.mclsSaveTree, treePath);
            TreeComponentParser treeComponentParser = (TreeComponentParser)this.getComponentParser();
            treeComponentParser.setAnalysisComponent(this.mclsSaveTree);
            TreePath[] treePathArray = jTree.getSelectionPaths();
            if (treePathArray != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    TreePath treePath2 = treeComponentParser.searchTreeNode(treePathArray[i]);
                    if (treePath2 == null) continue;
                    this.mclsSaveTree.addSelectionPath(treePath2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("[Defalt Tree]Save View Failure");
            exception.printStackTrace();
            this.releaseSavedViewComponent();
        }
    }

    public void restoreViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JTree)) {
            String string = "Any components other than 'javax.swing.JTree' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        try {
            if (this.hasSavedViewComponent()) {
                JTree jTree = (JTree)component;
                TreeSelectionModel treeSelectionModel = this.mclsSaveTree.getSelectionModel();
                int n = 0;
                n = this.getRestoreMode();
                if ((n & 0x40) > 0) {
                    TreeComponentUtilities.collapseAllNodes(jTree);
                }
                jTree.clearSelection();
                TreeComponentParser treeComponentParser = (TreeComponentParser)this.getComponentParser();
                treeComponentParser.setAnalysisComponent(jTree);
                int n2 = this.mclsSaveTree.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    TreePath treePath = this.mclsSaveTree.getPathForRow(i);
                    TreePath treePath2 = treeComponentParser.searchTreeNode(treePath);
                    if (treePath2 == null) continue;
                    if (treeSelectionModel.isPathSelected(treePath)) {
                        if ((n & 0x10) > 0) {
                            if (TreeComponentUtilities.isLeafNodeForTreePath(treePath) || this.mclsSaveTree.isExpanded(treePath)) {
                                TreeComponentUtilities.expandNode(jTree, treePath2);
                            }
                        } else if ((n & 0x20) > 0 && this.mclsSaveTree.isExpanded(treePath)) {
                            jTree.expandPath(treePath2);
                        }
                        if ((n & 1) <= 0) continue;
                        jTree.addSelectionPath(treePath2);
                        continue;
                    }
                    if ((n & 0x20) <= 0 || !this.mclsSaveTree.isExpanded(treePath)) continue;
                    jTree.expandPath(treePath2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("[Default Tree]Restore View Failure");
            exception.printStackTrace();
        }
    }

    public void setRestoreMode(int n) throws UnsupportedRestoreModeException {
        if (!this.isSupportedRestoreMode(n)) {
            String string = "The parameter which is not supported was specified [" + n + "].";
            throw new UnsupportedRestoreModeException(string);
        }
        this.miRestoreMode = n;
    }

    public int getRestoreMode() {
        return this.miRestoreMode;
    }

    public void setComponentParser(ComponentParser componentParser) throws IllegalArgumentException {
        if (componentParser == null || !(componentParser instanceof TreeComponentParser)) {
            String string = "Any components other than 'restoreview.TreeComponentParser' are not supported.";
            throw new IllegalArgumentException(string);
        }
        this.mclsComponentParser = (TreeComponentParser)componentParser;
    }

    public ComponentParser getComponentParser() {
        return this.mclsComponentParser;
    }

    public boolean isSupportedRestoreMode(int n) {
        int n2 = n;
        n2 &= 0xFFFFFFFE;
        n2 &= 0xFFFFFFDF;
        n2 &= 0xFFFFFFEF;
        n2 &= 0xFFFFFFBF;
        return (n2 &= 0xFFFFFF7F) == 0;
    }

    public boolean hasSavedViewComponent() {
        return this.mclsSaveTree != null;
    }

    public void releaseSavedViewComponent() {
        this.mclsSaveTree = null;
    }

    protected TreeComponentParser createDefaultComponentParser() {
        return new DefaultTreeComponentParser();
    }

    protected JTree getSavedViewComponent() {
        return this.mclsSaveTree;
    }

    protected void restoreAllNodesExpanded(JTree jTree, JTree jTree2, TreePath treePath) throws UnsupportedComponentException {
        Object object;
        Object object2;
        if (jTree.isExpanded(treePath)) {
            object2 = (TreeComponentParser)this.getComponentParser();
            object2.setAnalysisComponent(jTree2);
            object = object2.searchTreeNode(treePath);
            jTree2.expandPath((TreePath)object);
        }
        object2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        object = ((DefaultMutableTreeNode)object2).children();
        while (object.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
            Object[] objectArray = treePath.getPath();
            Object[] objectArray2 = new Object[objectArray.length + 1];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i];
            }
            objectArray2[objectArray.length] = defaultMutableTreeNode;
            TreePath treePath2 = new TreePath(objectArray2);
            this.restoreAllNodesExpanded(jTree, jTree2, treePath2);
        }
    }
}

