/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview.light;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import sanproject.client.com.restoreview.ComponentParser;
import sanproject.client.com.restoreview.TableComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.com.restoreview.ViewRestorer;
import sanproject.client.com.restoreview.light.LightTableComponentParser;
import sanproject.client.com.restoreview.utility.CollectionUtilities;

public class LightTableViewRestorer
implements ViewRestorer {
    static final int COLUMN_WIDTH_RESTORE = 4096;
    public static final int ALL_COLUMN_WIDTH_RESTORE = 12288;
    private int restoreMode = 0;
    private TableComponentParser componentParser = null;
    private Set selectionSet = new HashSet();
    private Map widthsMap = new HashMap();

    public LightTableViewRestorer() {
        this.initInstance();
    }

    public void saveViewComponent(Component component) throws UnsupportedComponentException {
        if (component != null) {
            if (!(component instanceof JTable)) {
                String string = "Any components other than 'javax.swing.JTable' are not supported.";
                throw new UnsupportedComponentException(string);
            }
            try {
                int n;
                Object object;
                int n2;
                int n3;
                JTable jTable = (JTable)component;
                LightTableViewRestorer.debugPrint("<" + this.getClass().getName() + ">execute save...");
                long l = System.currentTimeMillis();
                Object object2 = jTable.getSelectedRows();
                if (object2 != null && ((int[])object2).length > 0) {
                    n3 = CollectionUtilities.getHashModerateSize(((int[])object2).length);
                    this.selectionSet = new HashSet(n3);
                    for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                        Object object3 = object2[n2];
                        object = this.createIdentifier(jTable, (int)object3);
                        n = this.selectionSet.add(object) ? 1 : 0;
                        if (n != 0) continue;
                        System.err.println("found same identifier : " + object);
                    }
                }
                if ((object2 = (Object)jTable.getColumnModel()) != null) {
                    n3 = jTable.getColumnCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        TableColumn tableColumn = object2.getColumn(n2);
                        object = this.createIdentifier(tableColumn);
                        n = tableColumn.getWidth();
                        Integer n4 = new Integer(n);
                        this.widthsMap.put(object, n4);
                    }
                }
                LightTableViewRestorer.debugPrint("<" + this.getClass().getName() + ">save : " + (System.currentTimeMillis() - l) + "ms.");
            }
            catch (Exception exception) {
                System.err.println("[Light Table]Save View Failure");
                exception.printStackTrace();
                this.releaseSavedViewComponent();
            }
        }
    }

    public void restoreViewComponent(Component component) throws UnsupportedComponentException {
        block10: {
            if (component != null) {
                if (!(component instanceof JTable)) {
                    String string = "Any components other than 'javax.swing.JTable' are not supported.";
                    throw new UnsupportedComponentException(string);
                }
                try {
                    Object[] objectArray;
                    Object object;
                    if (!this.hasSavedViewComponent()) break block10;
                    LightTableViewRestorer.debugPrint("<" + this.getClass().getName() + ">execute restore " + " [mode=" + Integer.toHexString(this.restoreMode) + "]...");
                    long l = System.currentTimeMillis();
                    JTable jTable = (JTable)component;
                    TableComponentParser tableComponentParser = (TableComponentParser)this.getComponentParser();
                    tableComponentParser.setAnalysisComponent(jTable);
                    jTable.clearSelection();
                    if (this.isSpecified(1)) {
                        object = this.selectionSet.iterator();
                        while (object.hasNext()) {
                            objectArray = (Object[])object.next();
                            int n = tableComponentParser.searchTableRow(objectArray);
                            if (n == -1) continue;
                            jTable.addRowSelectionInterval(n, n);
                        }
                    }
                    if (this.isSpecified(12288)) {
                        object = this.widthsMap.keySet();
                        objectArray = object.iterator();
                        while (objectArray.hasNext()) {
                            Object e = objectArray.next();
                            TableColumn tableColumn = tableComponentParser.findColumn(e);
                            if (tableColumn == null) continue;
                            Integer n = (Integer)this.widthsMap.get(e);
                            int n2 = n;
                            tableColumn.setPreferredWidth(n2);
                        }
                    }
                    try {
                        tableComponentParser.setAnalysisComponent(null);
                    }
                    catch (UnsupportedComponentException unsupportedComponentException) {
                        // empty catch block
                    }
                    LightTableViewRestorer.debugPrint("<" + this.getClass().getName() + ">restore : " + (System.currentTimeMillis() - l) + "ms.");
                }
                catch (Exception exception) {
                    System.err.println("[Light Table]Restore View Failure");
                    exception.printStackTrace();
                }
            }
        }
    }

    public void setRestoreMode(int n) throws UnsupportedRestoreModeException {
        if (!this.isSupportedRestoreMode(n)) {
            String string = "The parameter which is not supported was specified [" + n + "].";
            throw new UnsupportedRestoreModeException(string);
        }
        this.restoreMode = n;
    }

    public int getRestoreMode() {
        int n = this.restoreMode;
        return n;
    }

    public void setComponentParser(ComponentParser componentParser) throws IllegalArgumentException {
        if (componentParser == null || !(componentParser instanceof TableComponentParser)) {
            String string = "Any components other than 'restoreview.TableComponentParser' are not supported.";
            throw new IllegalArgumentException(string);
        }
        this.componentParser = (TableComponentParser)componentParser;
    }

    public ComponentParser getComponentParser() {
        TableComponentParser tableComponentParser = this.componentParser;
        return tableComponentParser;
    }

    public boolean isSupportedRestoreMode(int n) {
        int n2 = n;
        n2 &= 0xFFFFFFFE;
        return (n2 &= 0xFFFFCFFF) == 0;
    }

    public boolean hasSavedViewComponent() {
        boolean bl = true;
        if (this.selectionSet.isEmpty() && this.widthsMap.isEmpty()) {
            bl = false;
        }
        return bl;
    }

    public void releaseSavedViewComponent() {
        this.selectionSet.clear();
        this.widthsMap.clear();
    }

    protected void initInstance() {
        int n = 0;
        n |= 1;
        try {
            this.setRestoreMode(n);
        }
        catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
            throw new RuntimeException();
        }
        this.componentParser = new LightTableComponentParser();
    }

    protected boolean isSpecified(int n) {
        int n2 = this.getRestoreMode();
        boolean bl = (n2 & n) > 0;
        return bl;
    }

    protected Object createIdentifier(JTable jTable, int n) {
        int n2 = jTable.getColumnCount();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = jTable.convertColumnIndexToModel(i);
            objectArray[n3] = jTable.getValueAt(n, i);
        }
        Object[] objectArray2 = objectArray;
        return objectArray2;
    }

    protected Object createIdentifier(TableColumn tableColumn) {
        Object object = tableColumn.getIdentifier();
        return object;
    }

    protected static void debugPrint(String string) {
        if (LightTableViewRestorer.isDebugMode()) {
            System.err.println(string);
        }
    }

    protected static boolean isDebugMode() {
        String string = System.getProperty("WebConsole.viewrestorer.debug");
        Object object = Boolean.valueOf(string);
        boolean bl = (Boolean)object;
        object = System.getProperty("WebConsole.viewrestorer.table.debug");
        Boolean bl2 = Boolean.valueOf((String)object);
        boolean bl3 = bl2;
        boolean bl4 = bl || bl3;
        return bl4;
    }
}

