/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview.utility;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreeComponentUtilities {
    private static final boolean DEBUG_MODE = false;
    private static JFrame mfrmDebugWindow = null;

    private TreeComponentUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandAllNodes(JTree jTree) {
        if (jTree != null) {
            JTree jTree2 = jTree;
            synchronized (jTree2) {
                TreeModel treeModel = jTree.getModel();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
                TreeComponentUtilities.expandAllChildren(jTree, defaultMutableTreeNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandAllChildren(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            JTree jTree2 = jTree;
            synchronized (jTree2) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = enumeration.nextElement();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode;
                    Object[] objectArray = defaultMutableTreeNode2.getPath();
                    TreePath treePath = new TreePath(objectArray);
                    jTree.expandPath(treePath);
                    TreeComponentUtilities.expandAllChildren(jTree, defaultMutableTreeNode2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandNode(JTree jTree, TreePath treePath) {
        if (treePath != null) {
            Object[] objectArray = treePath.getPath();
            JTree jTree2 = jTree;
            synchronized (jTree2) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object[] objectArray2 = new Object[i + 1];
                    for (int j = 0; j < i + 1; ++j) {
                        objectArray2[j] = objectArray[j];
                    }
                    TreePath treePath2 = new TreePath(objectArray2);
                    jTree.expandPath(treePath2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collapseAllNodes(JTree jTree) {
        if (jTree != null) {
            JTree jTree2 = jTree;
            synchronized (jTree2) {
                TreeComponentUtilities.expandAllNodes(jTree);
                int n = jTree.getRowCount();
                for (int i = n - 1; i >= 0; --i) {
                    if (!jTree.isExpanded(i)) continue;
                    jTree.collapseRow(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JTree createCopyTree(JTree jTree) throws IllegalArgumentException {
        JTree jTree2 = null;
        if (jTree != null) {
            JTree jTree3 = jTree;
            synchronized (jTree3) {
                TreeModel treeModel = jTree.getModel();
                Object object = treeModel.getRoot();
                if (!(object instanceof DefaultMutableTreeNode)) {
                    String string = "The specified component cannot be supported.tree node is not 'javax.swing.tree.DefaultMutableTreeNode'.";
                    throw new IllegalArgumentException(string);
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                jTree2 = new JTree();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
                TreeComponentUtilities.copyTreeNodes(defaultMutableTreeNode, defaultMutableTreeNode2);
                DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode2);
                jTree2.setModel(defaultTreeModel);
            }
        }
        return jTree2;
    }

    public static TreePath createTreePath(TreeNode treeNode) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (treeNode != null) {
            arrayList.add(treeNode);
            for (object = treeNode.getParent(); object != null; object = object.getParent()) {
                arrayList.add(0, object);
            }
        }
        object = arrayList.toArray();
        TreePath treePath = new TreePath((Object[])object);
        return treePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode2 != null) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode;
            synchronized (defaultMutableTreeNode3) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration.nextElement();
                    DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode4.clone();
                    defaultMutableTreeNode2.add(defaultMutableTreeNode5);
                    TreeComponentUtilities.copyTreeNodes(defaultMutableTreeNode4, defaultMutableTreeNode5);
                }
            }
        }
    }

    public static boolean isLeafNodeForTreePath(TreePath treePath) {
        Object object;
        boolean bl = false;
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            bl = defaultMutableTreeNode.isLeaf();
        }
        return bl;
    }

    public static int getAllNodeCount(JTree jTree) {
        TreeNode treeNode;
        TreeModel treeModel;
        int n = 0;
        if (jTree != null && (treeModel = jTree.getModel()) != null && (treeNode = (TreeNode)treeModel.getRoot()) != null) {
            int n2 = TreeComponentUtilities.countChildren(treeNode);
            n = n2 + 1;
        }
        return n;
    }

    public static int countChildren(TreeNode treeNode) {
        int n = 0;
        if (treeNode != null) {
            n = treeNode.getChildCount();
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                n += TreeComponentUtilities.countChildren(treeNode2);
            }
        }
        return n;
    }
}

