/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.data;

import java.util.ArrayList;
import sanproject.client.data.RJDataDSHostGrp;
import sanproject.client.data.RJDataDSHostInf;
import sanproject.client.data.RJDataDSLdevGrp;
import sanproject.client.data.RJDataDSSecurityGrp;
import sanproject.client.ldsec.RJLdSecMacro;

public class RJDataDSSecurityInf
implements RJLdSecMacro {
    public static int STAT_SECGRP_DISABLE = 0;
    public static int STAT_SECGRP_ENABLE = 1;
    public static int STAT_SECGRP_ATRB_POOL = 0;
    public static int STAT_SECGRP_ATRB_ACC = 1;
    public static int STAT_SECGRP_ATRB_RW = 0;
    public static int STAT_SECGRP_ATRB_RO = 1;
    public static int STAT_SECGRP_ATRB_PRTC = 2;
    public static int STAT_SECGRP_RVOL_DIS = 0;
    public static int STAT_SECGRP_RVOL_ENB = 1;
    public static int STAT_VOL_ATRB_NORM = 0;
    public static int STAT_VOL_ATRB_RVOL = 1;
    public int m_RJDataLdkc;
    ArrayList m_RJDataGSecurityGrp;
    public ArrayList m_RJDataSSecurityGrp;
    ArrayList m_RJDataGHostGrp;
    public ArrayList m_RJDataSHostGrp;
    ArrayList m_RJDataGLdevGrp;
    public ArrayList m_RJDataSLdevGrp;
    int m_RJDataGSecRev = 0;
    public int m_RJDataSSecRev = 0;
    public ArrayList m_RJDSEqpPort;
    public static boolean m_VolEqp_Flg = false;
    ArrayList m_RJDataOthSecGrpName = new ArrayList();
    ArrayList m_RJDataOthHstGrpName = new ArrayList();
    ArrayList m_RJDataOthLdvGrpName = new ArrayList();
    boolean m_RJDataOthGrpIsVarid;

    public ArrayList getDSSecurityGrpData() {
        return this.m_RJDataGSecurityGrp;
    }

    public ArrayList getDSHostGrpData() {
        return this.m_RJDataGHostGrp;
    }

    public ArrayList getDSLdevGrpData() {
        return this.m_RJDataGLdevGrp;
    }

    public int getDSSecRevData() {
        return this.m_RJDataGSecRev;
    }

    public void cpSetSecurityInfTbl() {
        RJDataDSLdevGrp rJDataDSLdevGrp;
        RJDataDSHostGrp rJDataDSHostGrp;
        RJDataDSSecurityGrp rJDataDSSecurityGrp;
        int n;
        this.m_RJDataSSecurityGrp = new ArrayList();
        this.m_RJDataSHostGrp = new ArrayList();
        this.m_RJDataSLdevGrp = new ArrayList();
        for (n = 0; n < this.m_RJDataGSecurityGrp.size() && (rJDataDSSecurityGrp = (RJDataDSSecurityGrp)this.m_RJDataGSecurityGrp.get(n)) != null; ++n) {
            this.addDSSecurityGrp(this.m_RJDataSSecurityGrp, rJDataDSSecurityGrp);
        }
        for (n = 0; n < this.m_RJDataGHostGrp.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataGHostGrp.get(n)) != null; ++n) {
            this.addDSHostGrp(this.m_RJDataSHostGrp, rJDataDSHostGrp);
        }
        for (n = 0; n < this.m_RJDataGLdevGrp.size() && (rJDataDSLdevGrp = (RJDataDSLdevGrp)this.m_RJDataGLdevGrp.get(n)) != null; ++n) {
            this.addDSLdevGrp(this.m_RJDataSLdevGrp, rJDataDSLdevGrp);
        }
        this.m_RJDataSSecRev = this.m_RJDataGSecRev;
    }

    public void addDSLdev(int[] nArray, Integer n) {
        this.setLdevBitMapOn(nArray, n);
    }

    public void addDSLdevGrp(ArrayList arrayList, RJDataDSLdevGrp rJDataDSLdevGrp) {
        RJDataDSLdevGrp rJDataDSLdevGrp2;
        boolean bl = false;
        for (int i = 0; i < arrayList.size() && (rJDataDSLdevGrp2 = (RJDataDSLdevGrp)arrayList.get(i)) != null; ++i) {
            if (rJDataDSLdevGrp2.szGrpName == null || rJDataDSLdevGrp.szGrpName == null || !rJDataDSLdevGrp2.szGrpName.equals(rJDataDSLdevGrp.szGrpName)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            RJDataDSLdevGrp rJDataDSLdevGrp3 = new RJDataDSLdevGrp();
            this.cpDSLdevGrp(rJDataDSLdevGrp3, rJDataDSLdevGrp);
            arrayList.add(rJDataDSLdevGrp3);
        }
    }

    public void cpDSLdevGrp(RJDataDSLdevGrp rJDataDSLdevGrp, RJDataDSLdevGrp rJDataDSLdevGrp2) {
        if (rJDataDSLdevGrp == null) {
            rJDataDSLdevGrp = new RJDataDSLdevGrp();
        }
        rJDataDSLdevGrp.szGrpName = rJDataDSLdevGrp2.szGrpName;
        rJDataDSLdevGrp.iLdevBmp = new int[2048];
        for (int i = 0; i < 2048; ++i) {
            rJDataDSLdevGrp.iLdevBmp[i] = rJDataDSLdevGrp2.iLdevBmp[i];
        }
    }

    public boolean checkDSLdevGrpInLdev(String string, int n) {
        RJDataDSLdevGrp rJDataDSLdevGrp;
        boolean bl = false;
        for (int i = 0; i < this.m_RJDataSLdevGrp.size() && (rJDataDSLdevGrp = (RJDataDSLdevGrp)this.m_RJDataSLdevGrp.get(i)) != null; ++i) {
            if (rJDataDSLdevGrp.szGrpName == null || string == null || !rJDataDSLdevGrp.szGrpName.equals(string)) continue;
            int n2 = (n & 0xFFFF0000) >>> 16;
            int n3 = n & 0xFFFF;
            bl = this.isRegistLdev(rJDataDSLdevGrp.iLdevBmp, n2, n3);
            break;
        }
        return bl;
    }

    public void cpDSHostInf(RJDataDSHostInf rJDataDSHostInf, RJDataDSHostInf rJDataDSHostInf2) {
        String string;
        rJDataDSHostInf.szType = rJDataDSHostInf2.szType;
        rJDataDSHostInf.szModel = rJDataDSHostInf2.szModel;
        rJDataDSHostInf.szLPAR = rJDataDSHostInf2.szLPAR;
        rJDataDSHostInf.szSeqNum = rJDataDSHostInf2.szSeqNum;
        rJDataDSHostInf.szTag = rJDataDSHostInf2.szTag;
        rJDataDSHostInf.iExtend = rJDataDSHostInf2.iExtend;
        rJDataDSHostInf.iEnable = rJDataDSHostInf2.iEnable;
        rJDataDSHostInf.szPort = new ArrayList();
        for (int i = 0; i < rJDataDSHostInf2.szPort.size() && (string = (String)rJDataDSHostInf2.szPort.get(i)) != null; ++i) {
            rJDataDSHostInf.szPort.add(string);
        }
    }

    public void addDSHostInf(ArrayList arrayList, RJDataDSHostInf rJDataDSHostInf) {
        RJDataDSHostInf rJDataDSHostInf2;
        boolean bl = false;
        for (int i = 0; i < arrayList.size() && (rJDataDSHostInf2 = (RJDataDSHostInf)arrayList.get(i)) != null; ++i) {
            if (!this.cmpDSHostInf(rJDataDSHostInf2, rJDataDSHostInf, false)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            RJDataDSHostInf rJDataDSHostInf3 = new RJDataDSHostInf();
            this.cpDSHostInf(rJDataDSHostInf3, rJDataDSHostInf);
            arrayList.add(rJDataDSHostInf3);
        }
    }

    public void addDSHostGrp(ArrayList arrayList, RJDataDSHostGrp rJDataDSHostGrp) {
        RJDataDSHostGrp rJDataDSHostGrp2;
        boolean bl = false;
        for (int i = 0; i < arrayList.size() && (rJDataDSHostGrp2 = (RJDataDSHostGrp)arrayList.get(i)) != null; ++i) {
            if (rJDataDSHostGrp2.szGrpName == null || rJDataDSHostGrp.szGrpName == null || !rJDataDSHostGrp2.szGrpName.equals(rJDataDSHostGrp.szGrpName)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            RJDataDSHostGrp rJDataDSHostGrp3 = new RJDataDSHostGrp();
            this.cpDSHostGrp(rJDataDSHostGrp3, rJDataDSHostGrp);
            arrayList.add(rJDataDSHostGrp3);
        }
    }

    public void cpDSHostGrp(RJDataDSHostGrp rJDataDSHostGrp, RJDataDSHostGrp rJDataDSHostGrp2) {
        RJDataDSHostInf rJDataDSHostInf;
        rJDataDSHostGrp.szGrpName = rJDataDSHostGrp2.szGrpName;
        rJDataDSHostGrp.m_RJDataDSHostInf = new ArrayList();
        for (int i = 0; i < rJDataDSHostGrp2.m_RJDataDSHostInf.size() && (rJDataDSHostInf = (RJDataDSHostInf)rJDataDSHostGrp2.m_RJDataDSHostInf.get(i)) != null; ++i) {
            RJDataDSHostInf rJDataDSHostInf2 = new RJDataDSHostInf();
            this.cpDSHostInf(rJDataDSHostInf2, rJDataDSHostInf);
            rJDataDSHostGrp.m_RJDataDSHostInf.add(rJDataDSHostInf2);
        }
    }

    public boolean checkDSDuplicateSecGrp(RJDataDSSecurityGrp rJDataDSSecurityGrp, RJDataDSHostGrp rJDataDSHostGrp, RJDataDSLdevGrp rJDataDSLdevGrp, boolean bl) {
        for (int i = 0; i < this.m_RJDataSSecurityGrp.size(); ++i) {
            RJDataDSSecurityGrp rJDataDSSecurityGrp2 = (RJDataDSSecurityGrp)this.m_RJDataSSecurityGrp.get(i);
            if (rJDataDSSecurityGrp.szGrpName.equals(rJDataDSSecurityGrp2.szGrpName) || rJDataDSSecurityGrp2.szLdevGrp == null) continue;
            int[] nArray = this.getDSLdevGrpToLdevData(rJDataDSSecurityGrp2.szLdevGrp);
            for (int j = 0; j < 2048; ++j) {
                if ((rJDataDSLdevGrp.iLdevBmp[j] & nArray[j]) == 0) continue;
                boolean bl2 = true;
                boolean bl3 = true;
                bl2 = this.chkDisableSecGrp(rJDataDSSecurityGrp, rJDataDSHostGrp.szGrpName, rJDataDSLdevGrp.szGrpName, bl);
                bl3 = this.chkDisableSecGrp(rJDataDSSecurityGrp2, rJDataDSSecurityGrp2.szHostGrp, rJDataDSSecurityGrp2.szLdevGrp, true);
                if (!bl2 || !bl3) continue;
                if (rJDataDSSecurityGrp.iGrpAtrb != rJDataDSSecurityGrp2.iGrpAtrb) {
                    return false;
                }
                if (rJDataDSSecurityGrp.iRVolFlg != rJDataDSSecurityGrp2.iRVolFlg) {
                    return false;
                }
                if (rJDataDSSecurityGrp.iRWAtrb == rJDataDSSecurityGrp2.iRWAtrb) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkDSSecGrpInLdev(RJDataDSSecurityGrp rJDataDSSecurityGrp, RJDataDSLdevGrp rJDataDSLdevGrp) {
        for (int i = 0; i < this.m_RJDataSSecurityGrp.size(); ++i) {
            RJDataDSSecurityGrp rJDataDSSecurityGrp2 = (RJDataDSSecurityGrp)this.m_RJDataSSecurityGrp.get(i);
            if (rJDataDSSecurityGrp.szGrpName.equals(rJDataDSSecurityGrp2.szGrpName) || rJDataDSSecurityGrp2.szLdevGrp == null) continue;
            int[] nArray = this.getDSLdevGrpToLdevData(rJDataDSSecurityGrp2.szLdevGrp);
            for (int j = 0; j < 2048; ++j) {
                if ((rJDataDSLdevGrp.iLdevBmp[j] & nArray[j]) == 0) continue;
                boolean bl = true;
                boolean bl2 = true;
                bl = this.chkDisableSecGrp(rJDataDSSecurityGrp, rJDataDSSecurityGrp.szHostGrp, rJDataDSLdevGrp.szGrpName, true);
                bl2 = this.chkDisableSecGrp(rJDataDSSecurityGrp2, rJDataDSSecurityGrp2.szHostGrp, rJDataDSSecurityGrp2.szLdevGrp, true);
                if (!bl || !bl2) continue;
                if (rJDataDSSecurityGrp.iGrpAtrb != rJDataDSSecurityGrp2.iGrpAtrb) {
                    return false;
                }
                if (rJDataDSSecurityGrp.iRVolFlg != rJDataDSSecurityGrp2.iRVolFlg) {
                    return false;
                }
                if (rJDataDSSecurityGrp.iRWAtrb == rJDataDSSecurityGrp2.iRWAtrb) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkDSHostGrpInHost(String string, RJDataDSHostInf rJDataDSHostInf) {
        RJDataDSHostGrp rJDataDSHostGrp;
        boolean bl = false;
        block0: for (int i = 0; i < this.m_RJDataSHostGrp.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(i)) != null; ++i) {
            RJDataDSHostInf rJDataDSHostInf2;
            if (rJDataDSHostGrp.szGrpName == null || string == null || !rJDataDSHostGrp.szGrpName.equals(string)) continue;
            for (int j = 0; j < rJDataDSHostGrp.m_RJDataDSHostInf.size() && (rJDataDSHostInf2 = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(j)) != null; ++j) {
                if (!this.cmpDSHostInf(rJDataDSHostInf2, rJDataDSHostInf, false)) continue;
                bl = true;
                break block0;
            }
            break;
        }
        return bl;
    }

    public boolean cmpDSHostInf(RJDataDSHostInf rJDataDSHostInf, RJDataDSHostInf rJDataDSHostInf2, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (rJDataDSHostInf.szType.equals(rJDataDSHostInf2.szType) && rJDataDSHostInf.szModel.equals(rJDataDSHostInf2.szModel) && rJDataDSHostInf.szLPAR.equalsIgnoreCase(rJDataDSHostInf2.szLPAR) && rJDataDSHostInf.szSeqNum.equals(rJDataDSHostInf2.szSeqNum) && rJDataDSHostInf.iExtend == rJDataDSHostInf2.iExtend) {
            if (bl) {
                if (this.chkHostPort(rJDataDSHostInf.szPort, rJDataDSHostInf2.szPort)) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean chkDisableSecGrp(RJDataDSSecurityGrp rJDataDSSecurityGrp, String string, String string2, boolean bl) {
        Object object;
        int n;
        ArrayList arrayList;
        if (rJDataDSSecurityGrp == null) {
            return false;
        }
        if (rJDataDSSecurityGrp.iEnable == STAT_SECGRP_DISABLE) {
            return false;
        }
        if (rJDataDSSecurityGrp.szLdevGrp == null) {
            if (string2 == null) {
                return false;
            }
            if (string2.length() == 0) {
                return false;
            }
        } else if (rJDataDSSecurityGrp.szLdevGrp.length() == 0) {
            if (string2 == null) {
                return false;
            }
            if (string2.length() == 0) {
                return false;
            }
        } else {
            arrayList = this.getDSLdevGrpData();
            if (arrayList == null) {
                return false;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                object = (RJDataDSLdevGrp)arrayList.get(n);
                if (object == null) {
                    return false;
                }
                if (!((RJDataDSLdevGrp)object).szGrpName.equals(string2) || this.chkLdvInLdvGrp((RJDataDSLdevGrp)object)) continue;
                return false;
            }
        }
        if (bl) {
            if (rJDataDSSecurityGrp.iGrpAtrb == STAT_SECGRP_ATRB_ACC) {
                if (string == null) {
                    return false;
                }
                if (string.length() == 0) {
                    return false;
                }
                arrayList = this.getDSHostGrpData();
                if (arrayList == null) {
                    return false;
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    object = (RJDataDSHostGrp)arrayList.get(n);
                    if (object == null) {
                        return false;
                    }
                    if (!((RJDataDSHostGrp)object).szGrpName.equals(string)) continue;
                    if (((RJDataDSHostGrp)object).m_RJDataDSHostInf == null) {
                        return false;
                    }
                    if (((RJDataDSHostGrp)object).m_RJDataDSHostInf.size() != 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void addDSSecurityGrp(ArrayList arrayList, RJDataDSSecurityGrp rJDataDSSecurityGrp) {
        RJDataDSSecurityGrp rJDataDSSecurityGrp2;
        boolean bl = false;
        for (int i = 0; i < arrayList.size() && (rJDataDSSecurityGrp2 = (RJDataDSSecurityGrp)arrayList.get(i)) != null; ++i) {
            if (rJDataDSSecurityGrp2.szGrpName == null || rJDataDSSecurityGrp.szGrpName == null || !rJDataDSSecurityGrp2.szGrpName.equals(rJDataDSSecurityGrp.szGrpName)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            RJDataDSSecurityGrp rJDataDSSecurityGrp3 = new RJDataDSSecurityGrp();
            this.cpDSSecurityGrp(rJDataDSSecurityGrp3, rJDataDSSecurityGrp);
            arrayList.add(rJDataDSSecurityGrp3);
        }
    }

    public void cpDSSecurityGrp(RJDataDSSecurityGrp rJDataDSSecurityGrp, RJDataDSSecurityGrp rJDataDSSecurityGrp2) {
        rJDataDSSecurityGrp.iEnable = rJDataDSSecurityGrp2.iEnable;
        rJDataDSSecurityGrp.iGrpAtrb = rJDataDSSecurityGrp2.iGrpAtrb;
        rJDataDSSecurityGrp.iRVolFlg = rJDataDSSecurityGrp2.iRVolFlg;
        rJDataDSSecurityGrp.iRWAtrb = rJDataDSSecurityGrp2.iRWAtrb;
        rJDataDSSecurityGrp.szHostGrp = rJDataDSSecurityGrp2.szHostGrp;
        rJDataDSSecurityGrp.szLdevGrp = rJDataDSSecurityGrp2.szLdevGrp;
        rJDataDSSecurityGrp.szGrpName = rJDataDSSecurityGrp2.szGrpName;
    }

    public int[] getDSLdevGrpToLdevData(String string) {
        RJDataDSLdevGrp rJDataDSLdevGrp;
        int[] nArray = new int[2048];
        for (int i = 0; i < this.m_RJDataSLdevGrp.size() && (rJDataDSLdevGrp = (RJDataDSLdevGrp)this.m_RJDataSLdevGrp.get(i)) != null; ++i) {
            if (rJDataDSLdevGrp.szGrpName == null || string == null || !rJDataDSLdevGrp.szGrpName.equals(string)) continue;
            for (int j = 0; j < 2048; ++j) {
                nArray[j] = rJDataDSLdevGrp.iLdevBmp[j];
            }
            break;
        }
        return nArray;
    }

    public ArrayList getDSLdevToLdevGrpData(int n) {
        RJDataDSLdevGrp rJDataDSLdevGrp;
        ArrayList arrayList = new ArrayList();
        int n2 = (n & 0xFFFF0000) >> 16;
        int n3 = n & 0xFFFF;
        for (int i = 0; i < this.m_RJDataSLdevGrp.size() && (rJDataDSLdevGrp = (RJDataDSLdevGrp)this.m_RJDataSLdevGrp.get(i)) != null; ++i) {
            int[] nArray = rJDataDSLdevGrp.iLdevBmp;
            if (!this.isRegistLdev(nArray, n2, n3)) continue;
            this.addDSLdevGrp(arrayList, rJDataDSLdevGrp);
        }
        return arrayList;
    }

    public ArrayList getDSHostGrpToHostData(String string) {
        RJDataDSHostGrp rJDataDSHostGrp;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.m_RJDataSHostGrp.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(i)) != null; ++i) {
            RJDataDSHostInf rJDataDSHostInf;
            if (rJDataDSHostGrp.szGrpName == null || string == null || !rJDataDSHostGrp.szGrpName.equals(string)) continue;
            for (int j = 0; j < rJDataDSHostGrp.m_RJDataDSHostInf.size() && (rJDataDSHostInf = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(j)) != null; ++j) {
                this.addDSHostInf(arrayList, rJDataDSHostInf);
            }
            break;
        }
        return arrayList;
    }

    public ArrayList getDSHostToHostGrpData(RJDataDSHostInf rJDataDSHostInf) {
        RJDataDSHostGrp rJDataDSHostGrp;
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        block0: for (int i = 0; i < this.m_RJDataSHostGrp.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(i)) != null; ++i) {
            RJDataDSHostInf rJDataDSHostInf2;
            for (int j = 0; j < rJDataDSHostGrp.m_RJDataDSHostInf.size() && (rJDataDSHostInf2 = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(j)) != null; ++j) {
                if (!this.cmpDSHostInf(rJDataDSHostInf2, rJDataDSHostInf, false)) continue;
                this.addDSHostGrp(arrayList, rJDataDSHostGrp);
                continue block0;
            }
        }
        return arrayList;
    }

    public ArrayList getDSHostToLdevGrpData(RJDataDSHostInf rJDataDSHostInf) {
        RJDataDSSecurityGrp rJDataDSSecurityGrp;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.getDSHostToSecGrpData(rJDataDSHostInf);
        block0: for (int i = 0; i < arrayList2.size() && (rJDataDSSecurityGrp = (RJDataDSSecurityGrp)arrayList2.get(i)) != null; ++i) {
            RJDataDSLdevGrp rJDataDSLdevGrp;
            if (rJDataDSSecurityGrp.szHostGrp == null || !this.checkDSHostGrpInHost(rJDataDSSecurityGrp.szHostGrp, rJDataDSHostInf) || rJDataDSSecurityGrp.szLdevGrp == null) continue;
            for (int j = 0; j < this.m_RJDataSLdevGrp.size() && (rJDataDSLdevGrp = (RJDataDSLdevGrp)this.m_RJDataSLdevGrp.get(j)) != null; ++j) {
                if (rJDataDSLdevGrp.szGrpName == null || rJDataDSSecurityGrp.szLdevGrp == null || !rJDataDSLdevGrp.szGrpName.equals(rJDataDSSecurityGrp.szLdevGrp)) continue;
                this.addDSLdevGrp(arrayList, rJDataDSLdevGrp);
                continue block0;
            }
        }
        return arrayList;
    }

    public ArrayList getDSSecGrpToHostGrpData(String string) {
        RJDataDSSecurityGrp rJDataDSSecurityGrp;
        ArrayList arrayList = new ArrayList();
        block0: for (int i = 0; i < this.m_RJDataSSecurityGrp.size() && (rJDataDSSecurityGrp = (RJDataDSSecurityGrp)this.m_RJDataSSecurityGrp.get(i)) != null; ++i) {
            RJDataDSHostGrp rJDataDSHostGrp;
            if (rJDataDSSecurityGrp.szGrpName == null || string == null || !rJDataDSSecurityGrp.szGrpName.equals(string)) continue;
            if (rJDataDSSecurityGrp.szHostGrp == null) break;
            for (int j = 0; j < this.m_RJDataSHostGrp.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(j)) != null; ++j) {
                if (rJDataDSSecurityGrp.szHostGrp == null || rJDataDSHostGrp.szGrpName == null || !rJDataDSSecurityGrp.szHostGrp.equals(rJDataDSHostGrp.szGrpName)) continue;
                this.addDSHostGrp(arrayList, rJDataDSHostGrp);
                break block0;
            }
            break;
        }
        return arrayList;
    }

    public ArrayList getDSSecGrpToLdevGrpData(String string) {
        RJDataDSSecurityGrp rJDataDSSecurityGrp;
        ArrayList arrayList = new ArrayList();
        block0: for (int i = 0; i < this.m_RJDataSSecurityGrp.size() && (rJDataDSSecurityGrp = (RJDataDSSecurityGrp)this.m_RJDataSSecurityGrp.get(i)) != null; ++i) {
            RJDataDSLdevGrp rJDataDSLdevGrp;
            if (rJDataDSSecurityGrp.szGrpName == null || string == null || !rJDataDSSecurityGrp.szGrpName.equals(string)) continue;
            if (rJDataDSSecurityGrp.szLdevGrp == null) break;
            for (int j = 0; j < this.m_RJDataSLdevGrp.size() && (rJDataDSLdevGrp = (RJDataDSLdevGrp)this.m_RJDataSLdevGrp.get(j)) != null; ++j) {
                if (rJDataDSSecurityGrp.szLdevGrp == null || rJDataDSLdevGrp.szGrpName == null || !rJDataDSSecurityGrp.szLdevGrp.equals(rJDataDSLdevGrp.szGrpName)) continue;
                this.addDSLdevGrp(arrayList, rJDataDSLdevGrp);
                break block0;
            }
            break;
        }
        return arrayList;
    }

    public ArrayList getDSHostGrpToNoRegHostData(String string) {
        RJDataDSHostInf rJDataDSHostInf;
        int n;
        RJDataDSHostGrp rJDataDSHostGrp;
        int n2;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (n2 = 0; n2 < this.m_RJDataSHostGrp.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(n2)) != null; ++n2) {
            if (rJDataDSHostGrp.szGrpName == null || string == null || !rJDataDSHostGrp.szGrpName.equals(string)) continue;
            for (n = 0; n < rJDataDSHostGrp.m_RJDataDSHostInf.size() && (rJDataDSHostInf = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(n)) != null; ++n) {
                this.addDSHostInf(arrayList2, rJDataDSHostInf);
            }
            break;
        }
        block2: for (n2 = 0; n2 < this.m_RJDataSHostGrp.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(n2)) != null; ++n2) {
            if (rJDataDSHostGrp.szGrpName == null || string == null || rJDataDSHostGrp.szGrpName.equals(string)) continue;
            for (n = 0; n < rJDataDSHostGrp.m_RJDataDSHostInf.size(); ++n) {
                RJDataDSHostInf rJDataDSHostInf2;
                boolean bl = false;
                rJDataDSHostInf = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(n);
                if (rJDataDSHostInf == null) continue block2;
                for (int i = 0; i < arrayList2.size() && (rJDataDSHostInf2 = (RJDataDSHostInf)arrayList2.get(i)) != null; ++i) {
                    if (!this.cmpDSHostInf(rJDataDSHostInf, rJDataDSHostInf2, false)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.addDSHostInf(arrayList, rJDataDSHostInf);
            }
        }
        return arrayList;
    }

    public int[] getDSSecGrpToLdevData(String string) {
        int[] nArray = new int[2048];
        ArrayList arrayList = this.getDSSecGrpToLdevGrpData(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            RJDataDSLdevGrp rJDataDSLdevGrp = (RJDataDSLdevGrp)arrayList.get(i);
            if (rJDataDSLdevGrp == null) continue;
            for (int j = 0; j < 2048; ++j) {
                nArray[j] = rJDataDSLdevGrp.iLdevBmp[j];
            }
        }
        return nArray;
    }

    public ArrayList getDSSecGrpToHostData(String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.getDSSecGrpToHostGrpData(string);
        for (int i = 0; i < arrayList2.size(); ++i) {
            RJDataDSHostGrp rJDataDSHostGrp = (RJDataDSHostGrp)arrayList2.get(i);
            if (rJDataDSHostGrp == null) continue;
            for (int j = 0; j < rJDataDSHostGrp.m_RJDataDSHostInf.size(); ++j) {
                RJDataDSHostInf rJDataDSHostInf = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(j);
                if (rJDataDSHostInf == null) continue;
                this.addDSHostInf(arrayList, rJDataDSHostInf);
            }
        }
        return arrayList;
    }

    public ArrayList getDSHostToSecGrpData(RJDataDSHostInf rJDataDSHostInf) {
        RJDataDSHostGrp rJDataDSHostGrp;
        ArrayList arrayList = new ArrayList();
        int n = 0;
        ArrayList arrayList2 = this.getDSHostToHostGrpData(rJDataDSHostInf);
        for (int i = 0; i < arrayList2.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)arrayList2.get(i)) != null; ++i) {
            RJDataDSSecurityGrp rJDataDSSecurityGrp;
            for (n = 0; n < this.m_RJDataSSecurityGrp.size() && (rJDataDSSecurityGrp = (RJDataDSSecurityGrp)this.m_RJDataSSecurityGrp.get(n)) != null; ++n) {
                if (rJDataDSSecurityGrp.szHostGrp == null || rJDataDSHostGrp.szGrpName == null || !rJDataDSSecurityGrp.szHostGrp.equals(rJDataDSHostGrp.szGrpName)) continue;
                this.addDSSecurityGrp(arrayList, rJDataDSSecurityGrp);
            }
        }
        return arrayList;
    }

    public ArrayList getDSHostToLdevData(RJDataDSHostInf rJDataDSHostInf) {
        ArrayList arrayList = new ArrayList();
        int[] nArray = new int[2048];
        ArrayList arrayList2 = this.getDSHostToLdevGrpData(rJDataDSHostInf);
        for (int i = 0; i < arrayList2.size(); ++i) {
            RJDataDSLdevGrp rJDataDSLdevGrp = (RJDataDSLdevGrp)arrayList2.get(i);
            if (rJDataDSLdevGrp == null) continue;
            int[] nArray2 = rJDataDSLdevGrp.iLdevBmp;
            for (int j = 0; j < 2048; ++j) {
                nArray[j] = nArray[j] | nArray2[j];
            }
        }
        arrayList = this.getLdevIdFromBitMap(nArray);
        return arrayList;
    }

    public ArrayList getDSLdevToSecGrpData(int n) {
        RJDataDSLdevGrp rJDataDSLdevGrp;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.getDSLdevToLdevGrpData(n);
        for (int i = 0; i < arrayList2.size() && (rJDataDSLdevGrp = (RJDataDSLdevGrp)arrayList2.get(i)) != null; ++i) {
            RJDataDSSecurityGrp rJDataDSSecurityGrp;
            for (int j = 0; j < this.m_RJDataSSecurityGrp.size() && (rJDataDSSecurityGrp = (RJDataDSSecurityGrp)this.m_RJDataSSecurityGrp.get(j)) != null; ++j) {
                if (rJDataDSSecurityGrp.szLdevGrp == null || rJDataDSLdevGrp.szGrpName == null || !rJDataDSSecurityGrp.szLdevGrp.equals(rJDataDSLdevGrp.szGrpName)) continue;
                this.addDSSecurityGrp(arrayList, rJDataDSSecurityGrp);
            }
        }
        return arrayList;
    }

    public ArrayList getDSLdevToHostGrpData(int n) {
        RJDataDSSecurityGrp rJDataDSSecurityGrp;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.getDSLdevToSecGrpData(n);
        block0: for (int i = 0; i < arrayList2.size() && (rJDataDSSecurityGrp = (RJDataDSSecurityGrp)arrayList2.get(i)) != null; ++i) {
            RJDataDSHostGrp rJDataDSHostGrp;
            for (int j = 0; j < this.m_RJDataSHostGrp.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(j)) != null; ++j) {
                if (rJDataDSSecurityGrp.szHostGrp == null || rJDataDSHostGrp.szGrpName == null || !rJDataDSSecurityGrp.szHostGrp.equals(rJDataDSHostGrp.szGrpName)) continue;
                this.addDSHostGrp(arrayList, rJDataDSHostGrp);
                continue block0;
            }
        }
        return arrayList;
    }

    public ArrayList getDSLdevToHostData(int n) {
        RJDataDSHostGrp rJDataDSHostGrp;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.getDSLdevToHostGrpData(n);
        for (int i = 0; i < arrayList2.size() && (rJDataDSHostGrp = (RJDataDSHostGrp)arrayList2.get(i)) != null; ++i) {
            RJDataDSHostInf rJDataDSHostInf;
            for (int j = 0; j < rJDataDSHostGrp.m_RJDataDSHostInf.size() && (rJDataDSHostInf = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(j)) != null; ++j) {
                this.addDSHostInf(arrayList, rJDataDSHostInf);
            }
        }
        return arrayList;
    }

    public ArrayList getDSInputHostData(ArrayList arrayList) {
        RJDataDSHostInf rJDataDSHostInf;
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        if (arrayList == null) {
            return new ArrayList();
        }
        ArrayList arrayList3 = this.getAllRegistGroupHost();
        for (int i = 0; i < arrayList3.size() && (rJDataDSHostInf = (RJDataDSHostInf)arrayList3.get(i)) != null; ++i) {
            bl = false;
            for (int j = 0; j < arrayList.size(); ++j) {
                RJDataDSHostInf rJDataDSHostInf2 = (RJDataDSHostInf)arrayList.get(j);
                if (rJDataDSHostInf2 == null || !this.cmpDSHostInf(rJDataDSHostInf, rJDataDSHostInf2, false)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.addDSHostInf(arrayList2, rJDataDSHostInf);
        }
        return arrayList2;
    }

    public ArrayList getDSInputHostData(ArrayList arrayList, ArrayList arrayList2) {
        RJDataDSHostInf rJDataDSHostInf;
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList == null) {
            return new ArrayList();
        }
        ArrayList arrayList4 = this.getAllRegistGroupHost(arrayList2);
        for (int i = 0; i < arrayList4.size() && (rJDataDSHostInf = (RJDataDSHostInf)arrayList4.get(i)) != null; ++i) {
            bl = false;
            for (int j = 0; j < arrayList.size(); ++j) {
                RJDataDSHostInf rJDataDSHostInf2 = (RJDataDSHostInf)arrayList.get(j);
                if (rJDataDSHostInf2 == null || !this.cmpDSHostInf(rJDataDSHostInf, rJDataDSHostInf2, false)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.addDSHostInf(arrayList3, rJDataDSHostInf);
        }
        return arrayList3;
    }

    public int[] getLdevBitMap(int[] nArray) {
        int[] nArray2 = new int[2048];
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                this.setLdevBitMapOn(nArray2, n);
            }
        }
        return nArray2;
    }

    public boolean isRegistLdev(int[] nArray, int n, int n2) {
        boolean bl = false;
        if (nArray != null) {
            int n3 = n * 8 + n2 / 32;
            if (n3 > nArray.length) {
                return bl;
            }
            int n4 = n2 % 32;
            int n5 = Integer.MIN_VALUE >>> n4;
            if ((nArray[n3] & n5) != 0) {
                bl = true;
            }
        }
        return bl;
    }

    public ArrayList getLdevIdFromBitMap(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = i / 8;
            int n3 = i % 8;
            if (nArray[i] == 0) continue;
            for (int j = 0; j < 32; ++j) {
                if ((nArray[i] & Integer.MIN_VALUE >>> j) == 0) continue;
                n = n3 * 32 + j;
                n = n2 << 16 | n;
                Integer n4 = new Integer(n);
                arrayList.add(n4);
            }
        }
        return arrayList;
    }

    public boolean chkHostPort(ArrayList arrayList, ArrayList arrayList2) {
        boolean bl = true;
        boolean bl2 = false;
        if (arrayList.size() == arrayList2.size()) {
            if (arrayList.size() != 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    if (string != null) {
                        String string2;
                        bl2 = false;
                        for (int j = 0; j < arrayList2.size() && (string2 = (String)arrayList2.get(j)) != null; ++j) {
                            if (!string.equals(string2)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        continue;
                    }
                    break;
                }
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public ArrayList getHostListToPort(ArrayList arrayList, String string) {
        RJDataDSHostInf rJDataDSHostInf;
        ArrayList<RJDataDSHostInf> arrayList2 = new ArrayList<RJDataDSHostInf>();
        block0: for (int i = 0; i < arrayList.size() && (rJDataDSHostInf = (RJDataDSHostInf)arrayList.get(i)) != null; ++i) {
            for (int j = 0; j < rJDataDSHostInf.szPort.size(); ++j) {
                String string2 = (String)rJDataDSHostInf.szPort.get(j);
                if (string2 == null || !string2.equals(string)) continue;
                RJDataDSHostInf rJDataDSHostInf2 = new RJDataDSHostInf();
                this.cpDSHostInf(rJDataDSHostInf2, rJDataDSHostInf);
                arrayList2.add(rJDataDSHostInf2);
                continue block0;
            }
        }
        return arrayList2;
    }

    public boolean setPort(RJDataDSHostInf rJDataDSHostInf, String string) {
        String string2;
        int n;
        boolean bl = false;
        boolean bl2 = true;
        for (n = 0; n < rJDataDSHostInf.szPort.size(); ++n) {
            string2 = (String)rJDataDSHostInf.szPort.get(n);
            if (string2 == null || !string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < rJDataDSHostInf.szPort.size() && ((string2 = (String)rJDataDSHostInf.szPort.get(n)) == null || this.getPortID(string2) <= this.getPortID(string)); ++n) {
            }
            String string3 = new String(string);
            if (n != rJDataDSHostInf.szPort.size()) {
                rJDataDSHostInf.szPort.add(n, string3);
            } else {
                rJDataDSHostInf.szPort.add(string3);
            }
        }
        return bl2;
    }

    public ArrayList getSelectAllPortFromHostGrp(String string) {
        ArrayList arrayList = this.getDSHostGrpToHostData(string);
        ArrayList arrayList2 = arrayList != null ? this.ChkSelectPortCount(arrayList) : new ArrayList();
        return arrayList2;
    }

    public ArrayList getConnectPortFromHostGrp(String string, ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        ArrayList arrayList3 = this.getSelectAllPortFromHostGrp(string);
        if (arrayList3 != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (string2 == null) continue;
                bl = false;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    String string3 = (String)arrayList3.get(j);
                    if (string3 == null || !string3.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                String string4 = new String(string2);
                arrayList2.add(string4);
            }
        }
        return arrayList2;
    }

    public boolean addPortToHostGrp(String string, ArrayList arrayList, ArrayList arrayList2) {
        int n;
        boolean bl = true;
        ArrayList arrayList3 = null;
        boolean bl2 = false;
        for (n = 0; n < this.m_RJDataSHostGrp.size(); ++n) {
            RJDataDSHostGrp rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(n);
            if (rJDataDSHostGrp == null || rJDataDSHostGrp.szGrpName == null || string == null || !rJDataDSHostGrp.szGrpName.equals(string)) continue;
            arrayList3 = rJDataDSHostGrp.m_RJDataDSHostInf;
            bl2 = true;
            break;
        }
        if (bl2) {
            for (n = 0; n < arrayList3.size(); ++n) {
                RJDataDSHostInf rJDataDSHostInf = (RJDataDSHostInf)arrayList3.get(n);
                if (rJDataDSHostInf == null) continue;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    if (string2 == null) continue;
                    this.setPort(rJDataDSHostInf, string2);
                }
            }
        }
        return bl;
    }

    public boolean delPortToHostGrp(String string, ArrayList arrayList) {
        int n;
        boolean bl = true;
        ArrayList arrayList2 = null;
        boolean bl2 = false;
        for (n = 0; n < this.m_RJDataSHostGrp.size(); ++n) {
            RJDataDSHostGrp rJDataDSHostGrp = (RJDataDSHostGrp)this.m_RJDataSHostGrp.get(n);
            if (rJDataDSHostGrp == null || rJDataDSHostGrp.szGrpName == null || string == null || !rJDataDSHostGrp.szGrpName.equals(string)) continue;
            arrayList2 = rJDataDSHostGrp.m_RJDataDSHostInf;
            bl2 = true;
            break;
        }
        if (bl2) {
            for (n = 0; n < arrayList2.size(); ++n) {
                RJDataDSHostInf rJDataDSHostInf = (RJDataDSHostInf)arrayList2.get(n);
                if (rJDataDSHostInf == null) continue;
                block2: for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    if (string2 == null) continue;
                    for (int j = 0; j < rJDataDSHostInf.szPort.size(); ++j) {
                        String string3 = (String)rJDataDSHostInf.szPort.get(j);
                        if (!string3.equals(string2)) continue;
                        rJDataDSHostInf.szPort.remove(j);
                        continue block2;
                    }
                }
            }
        }
        return bl;
    }

    public ArrayList ChkSelectPortCount(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            RJDataDSHostInf rJDataDSHostInf = (RJDataDSHostInf)arrayList.get(i);
            if (rJDataDSHostInf == null) continue;
            for (int j = 0; j < rJDataDSHostInf.szPort.size(); ++j) {
                String string;
                int n;
                String string2 = (String)rJDataDSHostInf.szPort.get(j);
                if (string2 == null) continue;
                bl = false;
                for (n = 0; n < arrayList2.size(); ++n) {
                    string = (String)arrayList2.get(n);
                    if (string == null || !string2.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                for (n = 0; n < arrayList2.size() && ((string = (String)arrayList2.get(n)) == null || this.getPortID(string2) >= this.getPortID(string)); ++n) {
                }
                if (n == arrayList2.size()) {
                    arrayList2.add(string2);
                    continue;
                }
                arrayList2.add(n, string2);
            }
        }
        return arrayList2;
    }

    public ArrayList getAllRegistGroupHost() {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        ArrayList arrayList2 = this.m_RJDataSHostGrp;
        for (int i = 0; i < arrayList2.size(); ++i) {
            RJDataDSHostGrp rJDataDSHostGrp = (RJDataDSHostGrp)arrayList2.get(i);
            if (rJDataDSHostGrp == null) continue;
            for (int j = 0; j < rJDataDSHostGrp.m_RJDataDSHostInf.size(); ++j) {
                RJDataDSHostInf rJDataDSHostInf = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(j);
                if (rJDataDSHostInf == null) continue;
                bl = false;
                for (int k = 0; k < arrayList.size(); ++k) {
                    RJDataDSHostInf rJDataDSHostInf2 = (RJDataDSHostInf)arrayList.get(k);
                    if (!this.cmpDSHostInf(rJDataDSHostInf, rJDataDSHostInf2, false)) continue;
                    bl = true;
                }
                if (bl) continue;
                this.addDSHostInf(arrayList, rJDataDSHostInf);
            }
        }
        return arrayList;
    }

    public ArrayList getAllRegistGroupHost(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        ArrayList arrayList3 = arrayList;
        for (int i = 0; i < arrayList3.size(); ++i) {
            RJDataDSHostGrp rJDataDSHostGrp = (RJDataDSHostGrp)arrayList3.get(i);
            if (rJDataDSHostGrp == null) continue;
            for (int j = 0; j < rJDataDSHostGrp.m_RJDataDSHostInf.size(); ++j) {
                RJDataDSHostInf rJDataDSHostInf = (RJDataDSHostInf)rJDataDSHostGrp.m_RJDataDSHostInf.get(j);
                if (rJDataDSHostInf == null) continue;
                bl = false;
                for (int k = 0; k < arrayList2.size(); ++k) {
                    RJDataDSHostInf rJDataDSHostInf2 = (RJDataDSHostInf)arrayList2.get(k);
                    if (!this.cmpDSHostInf(rJDataDSHostInf, rJDataDSHostInf2, false)) continue;
                    bl = true;
                }
                if (bl) continue;
                this.addDSHostInf(arrayList2, rJDataDSHostInf);
            }
        }
        return arrayList2;
    }

    public ArrayList getHstGrpCngRegHst(String string, ArrayList arrayList) {
        ArrayList<RJDataDSHostInf> arrayList2 = new ArrayList<RJDataDSHostInf>();
        ArrayList arrayList3 = this.getSelectAllPortFromHostGrp(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            RJDataDSHostInf rJDataDSHostInf = (RJDataDSHostInf)arrayList.get(i);
            if (rJDataDSHostInf == null) continue;
            RJDataDSHostInf rJDataDSHostInf2 = new RJDataDSHostInf();
            this.cpDSHostInf(rJDataDSHostInf2, rJDataDSHostInf);
            rJDataDSHostInf2.szPort.clear();
            for (int j = 0; j < arrayList3.size(); ++j) {
                String string2 = (String)arrayList3.get(j);
                if (string2 == null) continue;
                this.setPort(rJDataDSHostInf2, string2);
            }
            arrayList2.add(rJDataDSHostInf2);
        }
        return arrayList2;
    }

    public boolean chkLdvInLdvGrp(RJDataDSLdevGrp rJDataDSLdevGrp) {
        boolean bl = false;
        if (rJDataDSLdevGrp != null) {
            for (int i = 0; i < rJDataDSLdevGrp.iLdevBmp.length; ++i) {
                if (rJDataDSLdevGrp.iLdevBmp[i] == 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public int getLdvCntInLdevGrp(RJDataDSLdevGrp rJDataDSLdevGrp) {
        int n = 0;
        if (rJDataDSLdevGrp != null) {
            for (int i = 0; i < rJDataDSLdevGrp.iLdevBmp.length; ++i) {
                if (rJDataDSLdevGrp.iLdevBmp[i] == 0) continue;
                n += this.getIsIntBitOn(rJDataDSLdevGrp.iLdevBmp[i]);
            }
        }
        return n;
    }

    public int getIsIntBitOn(int n) {
        int n2 = 0;
        if (n != 0) {
            for (int i = 0; i < 32; ++i) {
                if ((n & Integer.MIN_VALUE >>> i) == 0) continue;
                ++n2;
            }
        }
        return n2;
    }

    public boolean setLdevBitMapOn(int[] nArray, int n) {
        boolean bl = true;
        int n2 = (n & 0xFFFF0000) >> 16;
        int n3 = n & 0xFFFF;
        int n4 = n2 * 8 + n3 / 32;
        int n5 = n3 % 32;
        nArray[n4] = nArray[n4] | Integer.MIN_VALUE >>> n5;
        return bl;
    }

    public boolean setLdevBitMapOff(int[] nArray, int n) {
        boolean bl = true;
        int n2 = (n & 0xFFFF0000) >> 16;
        int n3 = n & 0xFFFF;
        int n4 = n2 * 8 + n3 / 32;
        int n5 = n3 % 32;
        nArray[n4] = nArray[n4] & ~(Integer.MIN_VALUE >>> n5);
        return bl;
    }

    public void setEqpPort(ArrayList arrayList) {
        int n = 0;
        String string = null;
        this.m_RJDSEqpPort = new ArrayList();
        if (arrayList != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (string == null) continue;
                this.m_RJDSEqpPort.add(new String(string));
            }
        }
    }

    public int getPortID(String string) {
        int n = -1;
        boolean bl = false;
        if (this.m_RJDSEqpPort != null || string != null) {
            String string2;
            for (n = 0; n < this.m_RJDSEqpPort.size() && (string2 = (String)this.m_RJDSEqpPort.get(n)) != null; ++n) {
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                n = -1;
            }
        }
        return n;
    }

    public boolean getVolumeEquipCheck() {
        return m_VolEqp_Flg;
    }

    public boolean checkLdevGrpInEquipVol(RJDataDSLdevGrp rJDataDSLdevGrp, int[] nArray) {
        boolean bl = false;
        int n = 0;
        for (n = 0; n < 2048; ++n) {
            if ((rJDataDSLdevGrp.iLdevBmp[n] & nArray[n]) == rJDataDSLdevGrp.iLdevBmp[n]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean checkLdkcSecGrpName(String string) {
        boolean bl = false;
        if (this.m_RJDataOthSecGrpName == null) {
            return false;
        }
        for (int i = 0; i < this.m_RJDataOthSecGrpName.size(); ++i) {
            if (!this.m_RJDataOthSecGrpName.get(i).equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean checkLdkcHstGrpName(String string) {
        boolean bl = false;
        if (this.m_RJDataOthHstGrpName == null) {
            return false;
        }
        for (int i = 0; i < this.m_RJDataOthHstGrpName.size(); ++i) {
            if (!this.m_RJDataOthHstGrpName.get(i).equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean checkLdkcLdvGrpName(String string) {
        boolean bl = false;
        if (this.m_RJDataOthLdvGrpName == null) {
            return false;
        }
        for (int i = 0; i < this.m_RJDataOthLdvGrpName.size(); ++i) {
            if (!this.m_RJDataOthLdvGrpName.get(i).equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ArrayList getOtherLdkcSecGrpList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_RJDataOthSecGrpName == null) {
            return arrayList;
        }
        for (int i = 0; i < this.m_RJDataOthSecGrpName.size(); ++i) {
            arrayList.add(new String(this.m_RJDataOthSecGrpName.get(i).toString()));
        }
        return arrayList;
    }

    public ArrayList getOtherLdkcHstGrpList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_RJDataOthHstGrpName == null) {
            return arrayList;
        }
        for (int i = 0; i < this.m_RJDataOthHstGrpName.size(); ++i) {
            arrayList.add(new String(this.m_RJDataOthHstGrpName.get(i).toString()));
        }
        return arrayList;
    }

    public ArrayList getOtherLdkcLdvGrpList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_RJDataOthLdvGrpName == null) {
            return arrayList;
        }
        for (int i = 0; i < this.m_RJDataOthLdvGrpName.size(); ++i) {
            arrayList.add(new String(this.m_RJDataOthLdvGrpName.get(i).toString()));
        }
        return arrayList;
    }
}

