/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.email;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcException;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.com.RJcSouthPanel;
import sanproject.client.com.RJcTabPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.email.RJEmailAddressPanel;
import sanproject.client.email.RJEmailApplyData;
import sanproject.client.email.RJEmailDataSupplier;
import sanproject.client.email.RJEmailGuideDef;
import sanproject.client.email.RJEmailNoticePanel;
import sanproject.client.email.RJEmailServerPanel;

public class RJEmailPanel
extends RJcTabPanel
implements RJEmailGuideDef {
    private RJEmailNoticePanel noticePanel;
    private RJEmailServerPanel serverPanel;
    private RJEmailAddressPanel addressPanel;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton sendButton;
    private JCheckBox completeCheckBox;
    private RJEmailDataSupplier supplier;
    private boolean mode = false;
    private ArrayList errorInfoList = new ArrayList();
    private static final int TABLE_PANEL_HIGHT = 240;
    private static final int NOTICE_PANEL_HIGHT = 28;
    private static final int SERVER_PANEL_HIGHT = 112;
    private static final int MLADDR_PANEL_HIGHT = 324;

    public RJEmailPanel() {
        this.supplier = new RJEmailDataSupplier(RJDataControl.getDataControl());
        this.initInstance();
    }

    public RJEmailPanel(RJEmailDataSupplier rJEmailDataSupplier) {
        this.supplier = rJEmailDataSupplier;
        this.initInstance();
    }

    protected JComponent createNorthComponent() {
        RJcMainTitlePanel rJcMainTitlePanel = (RJcMainTitlePanel)super.createNorthComponent();
        return rJcMainTitlePanel;
    }

    protected JComponent createCenterComponent() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        jPanel.add((Component)this.createCenterPanel(), "North");
        jPanel.add((Component)this.createBottomPanel(), "Center");
        return jPanel;
    }

    private JPanel createCenterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        jPanel.add((Component)this.createTopPanel(), "North");
        jPanel.add((Component)this.createMiddlePanel(), "Center");
        return jPanel;
    }

    private JPanel createTopPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("Email/NoticeTitle");
        this.noticePanel = new RJEmailNoticePanel(this.supplier);
        jPanel.add((Component)rJcHeaderPanel, "North");
        jPanel.add((Component)this.noticePanel, "Center");
        return jPanel;
    }

    private JPanel createMiddlePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("Email/ServerTitle");
        this.serverPanel = new RJEmailServerPanel(this.supplier);
        jPanel.add((Component)rJcHeaderPanel, "North");
        jPanel.add((Component)this.serverPanel, "Center");
        return jPanel;
    }

    private JPanel createBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("Email/AddressTitle");
        this.addressPanel = new RJEmailAddressPanel(this.supplier);
        jPanel.add((Component)rJcHeaderPanel, "North");
        jPanel.add((Component)this.addressPanel, "Center");
        return jPanel;
    }

    protected JComponent createSouthComponent() {
        RJcSouthPanel rJcSouthPanel = (RJcSouthPanel)super.createSouthComponent();
        this.sendButton = this.newButton("Email/TestSendBtn");
        this.sendButton.setEnabled(false);
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJEmailPanel.this.sendButton_actionPerformed(actionEvent);
            }
        });
        this.applyButton = this.newButton("Email/ApplyBtn");
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJEmailPanel.this.applyButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton = this.newButton("Email/CancelBtn");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJEmailPanel.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        rJcSouthPanel.addComponent(this.sendButton, 1);
        rJcSouthPanel.addComponent(this.applyButton, 0);
        rJcSouthPanel.addComponent(this.cancelButton, 0);
        return rJcSouthPanel;
    }

    public boolean showPanel(boolean bl) {
        boolean bl2 = true;
        this.mode = bl;
        this.supplier.setMode(bl);
        try {
            this.supplier.initialize();
            this.noticePanel.showPanel();
            this.serverPanel.showPanel();
            this.addressPanel.showPanel();
            this.sendButton.setEnabled(this.supplier.isModify());
            this.applyButton.setEnabled(this.supplier.isModify());
            this.cancelButton.setEnabled(this.supplier.isModify());
        }
        catch (RJcException rJcException) {
            bl2 = false;
        }
        return bl2;
    }

    public boolean chkSts() {
        RJEmailApplyData rJEmailApplyData = this.supplier.getApplyData();
        boolean bl = super.chkSts() || rJEmailApplyData.chkSts();
        return bl;
    }

    private void sendButton_actionPerformed(ActionEvent actionEvent) {
        int n;
        RJDataMsg rJDataMsg;
        Object[] objectArray;
        this.supplier.putLog("[EMail]", "[Test Send]", "Button ActionPerformed Start");
        if (this.chkSts()) {
            objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            rJDataMsg = this.supplier.getMessage(861065762);
            n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            if (n == 0) {
                this.supplier.putLog("[EMail]", "[Test Send]", "Button ActionPerformed Cancel");
                return;
            }
        }
        objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
        rJDataMsg = this.supplier.getMessage(861069081);
        n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        if (n == 0) {
            try {
                this.supplier.execTestMailSend();
                Object[] objectArray2 = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJDataMsg rJDataMsg2 = this.supplier.getMessage(861069082);
                int n2 = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg2, 0, objectArray2, objectArray2[0]);
            }
            catch (RJcException rJcException) {
                // empty catch block
            }
            this.supplier.putLog("[EMail]", "[Test Send]", "Button ActionPerformed End");
        } else {
            this.supplier.putLog("[EMail]", "[Test Send]", "Button ActionPerformed Cancel");
        }
    }

    private void applyButton_actionPerformed(ActionEvent actionEvent) {
        this.supplier.putLog("[EMail]", "[Apply]", "Button ActionPerformed");
        RJEmailApplyData rJEmailApplyData = this.supplier.getApplyData();
        int n = rJEmailApplyData.setApplyData();
        if (n == 0) {
            int n2 = this.apply(false);
            this.supplier.putLog("[EMail]", "[Apply]", "applyEx [status = " + n2 + "]");
            if (n2 != 0) {
                this.supplier.cancel();
            }
        } else {
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            int n3 = 0;
            switch (n) {
                case 1: {
                    n3 = 861065761;
                    break;
                }
                case 2: {
                    n3 = 861065758;
                    break;
                }
                case 3: {
                    n3 = 861065759;
                    break;
                }
                case 4: {
                    n3 = 861065760;
                    break;
                }
            }
            RJDataMsg rJDataMsg = this.supplier.getMessage(n3);
            this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        }
    }

    public void applyEnd(boolean bl) {
        this.supplier.putLog("[EMail]", "[ApplyEnd]", "rlt = " + bl);
        if (bl) {
            this.applyNormalEnd();
        } else {
            int n = this.getErrLevel();
            this.endRequest(n, 0);
        }
    }

    private void applyNormalEnd() {
        this.showPanel(this.mode);
        this.showApplyEndMsg();
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        if (this.chkSts()) {
            this.supplier.putLog("[EMail]", "[Cancel]", "Button ActionPerformed");
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
            RJDataMsg rJDataMsg = this.supplier.getMessage(11009101);
            int n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            if (n == 0) {
                this.showPanel(this.mode);
            }
        } else {
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJDataMsg rJDataMsg = this.supplier.getMessage(11005030);
            int n = this.supplier.showMessage(this, rJDataMsg, 0, objectArray, objectArray[0]);
        }
    }

    public boolean chgTab() {
        boolean bl = super.chgTab();
        return bl;
    }

    public String getWindowName() {
        return "Email/Window";
    }

    public void setParent(Component component) {
        super.setParent(component);
        this.supplier.pushParentPanel((RJComFuncPanel)component);
    }
}

