/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.Arrays;
import sanproject.client.com.RJComCHA;
import sanproject.client.exdevice.data.CHAUtility;
import sanproject.client.exdevice.data.ChangeAttributeData;
import sanproject.client.exdevice.data.ModifyTaker;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.utility.Debug;
import sanproject.common.Robj_interface_RJiCHAInfoDetail;
import sanproject.common.Robj_interface_RJiPortAttributeInfoDetail;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;

public abstract class PortInfo
extends ModifyTaker
implements Comparable {
    public static final int ATR_UNKNOWN = 0;
    public static final int ATR_LCP = 1;
    public static final int ATR_RCP = 2;
    public static final int ATR_TARGET = 3;
    public static final int ATR_RCUTARGET = 4;
    public static final int ATR_INITIATOR = 5;
    public static final int ATR_EXTERNAL = 6;
    public static final int ATR_IE_MIX = 256;
    public static final int ATR_ALL = -1;
    public static final byte PORT_KIND_UNKNOWN = 0;
    private static final byte[] supprtPortKind = new byte[]{2};
    private Robj_interface_RJiCHAInfoDetail chaInfo = null;
    private Robj_interface_RJiPortAttributeInfoDetail[] attributeInfo = new Robj_interface_RJiPortAttributeInfoDetail[0];
    private Robj_interface_RJiPortInfoDetail[] portInfo = new Robj_interface_RJiPortInfoDetail[0];
    private String portName = "";
    private int portAttribute = 0;
    private int pcbMode = 0;

    private static PortInfo createPortInfo(byte by) {
        PortInfoFibre portInfoFibre = null;
        switch (by) {
            case 2: {
                portInfoFibre = new PortInfoFibre();
            }
        }
        return portInfoFibre;
    }

    public static PortInfo createPortInfo(Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail, Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray, Robj_interface_RJiPortAttributeInfoDetail[] robj_interface_RJiPortAttributeInfoDetailArray) {
        boolean bl;
        PortInfo portInfo;
        PortInfo portInfo2 = null;
        if (robj_interface_RJiCHAInfoDetail != null && robj_interface_RJiPortInfoDetailArray != null && robj_interface_RJiPortInfoDetailArray.length != 0 && robj_interface_RJiPortAttributeInfoDetailArray != null && robj_interface_RJiPortAttributeInfoDetailArray.length != 0 && Arrays.equals(robj_interface_RJiPortInfoDetailArray, robj_interface_RJiPortAttributeInfoDetailArray) && RJComCHA.getPortToCluster(robj_interface_RJiPortInfoDetailArray[0].getSPort()) == robj_interface_RJiCHAInfoDetail.getSCHAClusterNumber() && RJComCHA.getPortToCHANumber(robj_interface_RJiPortInfoDetailArray[0].getSPort()) == robj_interface_RJiCHAInfoDetail.getSCHANumber() && (portInfo = PortInfo.createPortInfo(robj_interface_RJiPortInfoDetailArray[0].getByPortKindNo())) != null && (bl = portInfo.initPortInfo(robj_interface_RJiCHAInfoDetail, robj_interface_RJiPortInfoDetailArray, robj_interface_RJiPortAttributeInfoDetailArray))) {
            portInfo2 = portInfo;
        }
        return portInfo2;
    }

    public static int[] getSupportPortAttributeList(byte by) {
        int[] nArray = new int[]{};
        PortInfo portInfo = PortInfo.createPortInfo(by);
        if (portInfo != null) {
            nArray = portInfo.getSupportAttributeList();
        }
        return nArray;
    }

    public static byte[] getSupportPortKindList() {
        return supprtPortKind;
    }

    private PortInfo() {
    }

    private boolean initPortInfo(Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail, Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray, Robj_interface_RJiPortAttributeInfoDetail[] robj_interface_RJiPortAttributeInfoDetailArray) {
        boolean bl;
        this.chaInfo = robj_interface_RJiCHAInfoDetail;
        this.portInfo = robj_interface_RJiPortInfoDetailArray;
        this.attributeInfo = robj_interface_RJiPortAttributeInfoDetailArray;
        this.portName = CHAUtility.toIntensivePortName(robj_interface_RJiPortInfoDetailArray);
        this.portAttribute = robj_interface_RJiPortAttributeInfoDetailArray[0].getByPortKind();
        this.pcbMode = CHAUtility.getChaMode(robj_interface_RJiPortAttributeInfoDetailArray, robj_interface_RJiCHAInfoDetail);
        if (this.pcbMode == 258) {
            this.portAttribute = 256;
        }
        if ((bl = this.isSupportDisplayValue(this.portAttribute)) && Debug.isDebugMode()) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("\u25c6Port=").append(this.getPortNumber());
            stringBuffer.append(" Kind=").append(RJComCHA.toPortKindString(this.getPortKindID()));
            stringBuffer.append(" Mode=").append(this.getPcbSpeed());
            stringBuffer.append(" Attribute=").append(this.getAttribute());
            stringBuffer.append(" Name=").append(this.getName());
            Debug.println(stringBuffer);
        }
        return bl;
    }

    protected abstract int[] getSupportAttributeList();

    protected abstract int[] getSupportBaseAttribute();

    protected abstract int[] getSupportChangeAttribute();

    protected abstract int[] getSupportDisplay();

    protected boolean isSupportBaseAttributeValue(int n) {
        return Arrays.binarySearch(this.getSupportBaseAttribute(), n) >= 0;
    }

    protected boolean isSupportChangeAttributeValue(int n) {
        boolean bl = false;
        if (this.portAttribute != n && Arrays.binarySearch(this.getSupportChangeAttribute(), n) >= 0) {
            bl = true;
        }
        return bl;
    }

    protected boolean isSupportDisplayValue(int n) {
        return Arrays.binarySearch(this.getSupportDisplay(), n) >= 0;
    }

    void setAttribute(int n) {
        this.portAttribute = n;
    }

    public abstract boolean canChangeAttribute(int var1);

    public void changeAttribute(int n) {
        if (this.isModify()) {
            this.setAttribute(n);
        } else {
            ChangeAttributeData changeAttributeData = new ChangeAttributeData(this);
            changeAttributeData.saveChangeAttribute(this.portAttribute);
            PresetManager presetManager = PresetManager.getInstance();
            if (presetManager.add(changeAttributeData, 1)) {
                this.setAttribute(n);
            }
        }
    }

    public int getAttribute() {
        return this.portAttribute;
    }

    public Robj_interface_RJiPortIndex[] getIntensivePorts() {
        return this.portInfo;
    }

    public String getName() {
        return this.portName;
    }

    public int getPcbSpeed() {
        return this.pcbMode;
    }

    public int getPortCount() {
        return this.portInfo.length;
    }

    public byte getPortKindID() {
        byte by = 0;
        if (this.portInfo.length > 0) {
            by = this.portInfo[0].getByPortKindNo();
        }
        return by;
    }

    public short getPortNumber() {
        short s = -1;
        if (this.portInfo.length > 0) {
            s = this.portInfo[0].getSPort();
        }
        return s;
    }

    public int compareTo(Object object) {
        return this.hashCode() - object.hashCode();
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        return this.getPortNumber();
    }

    public String toString() {
        return Short.toString(this.getPortNumber());
    }

    static {
        Arrays.sort(supprtPortKind);
    }

    private static class PortInfoFibre
    extends PortInfo {
        private static final int[] supportAttribute = new int[]{6, 3, 5, 4, 256};
        private static final int[] supportBaseAttribute = new int[]{3, 4, 5, 6};
        private static final int[] supportChangeAttribute = new int[]{3, 6};
        private static final int[] supportDisplay;

        private PortInfoFibre() {
        }

        protected int[] getSupportAttributeList() {
            return supportAttribute;
        }

        protected int[] getSupportBaseAttribute() {
            return supportBaseAttribute;
        }

        protected int[] getSupportChangeAttribute() {
            return supportChangeAttribute;
        }

        protected int[] getSupportDisplay() {
            return supportDisplay;
        }

        public boolean canChangeAttribute(int n) {
            boolean bl = false;
            if (this.isSupportBaseAttributeValue(this.getAttribute()) && this.isSupportChangeAttributeValue(n) && !(this.getPcbSpeed() == 2 ? n != 3 : this.getPcbSpeed() == 258)) {
                bl = true;
            }
            return bl;
        }

        static {
            Arrays.sort(supportBaseAttribute);
            Arrays.sort(supportChangeAttribute);
            supportDisplay = (int[])supportAttribute.clone();
            Arrays.sort(supportDisplay);
        }
    }
}

