/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.PhysicalPathManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.TargetPortInfo;
import sanproject.client.exdevice.data.TargetPortInfo_Fibre;
import sanproject.client.exdevice.data.Utility;
import sanproject.serverux.dataimpl.EXDTargetPort;
import sanproject.serverux.dataimpl.EXDTargetPort_Fiber;

public class TargetPortManager
implements Singleton {
    private static final String LOG_NAME = "TargetPortManager";
    private ArrayList mTargetPortList;
    private static Comparator mTargetPortIdComparator = new TargetPortIdComparator();
    private static final Comparator COMP_PRODUCT_ID = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n;
            if (object instanceof TargetPortInfo) {
                n = ((TargetPortInfo)object).referSubsystemId();
            } else if (object instanceof ProductInfo) {
                n = ((ProductInfo)object).getId();
            } else {
                throw new ClassCastException();
            }
            return n;
        }
    };
    static final Comparator COMP_TARGETPORT = new Comparator(){

        public int compare(Object object, Object object2) {
            EXDTargetPort eXDTargetPort = this.getObject(object);
            EXDTargetPort eXDTargetPort2 = this.getObject(object2);
            String string = eXDTargetPort.getDispTargetPortAddress();
            String string2 = eXDTargetPort2.getDispTargetPortAddress();
            int n = string.compareTo(string2);
            return n;
        }

        private EXDTargetPort getObject(Object object) {
            EXDTargetPort eXDTargetPort;
            if (object instanceof TargetPortInfo) {
                TargetPortInfo targetPortInfo = (TargetPortInfo)object;
                eXDTargetPort = targetPortInfo.getEXDTargetPort();
            } else {
                eXDTargetPort = (EXDTargetPort)object;
            }
            return eXDTargetPort;
        }
    };
    static final int ID_OFFSET_UNCONFIGURED = Integer.MIN_VALUE;
    ArrayList mDiscoveryTargetPorts = new ArrayList();
    static /* synthetic */ Class class$sanproject$client$exdevice$data$TargetPortManager;

    TargetPortManager() {
    }

    public static synchronized TargetPortManager getInstance() {
        return (TargetPortManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$TargetPortManager == null ? (class$sanproject$client$exdevice$data$TargetPortManager = TargetPortManager.class$("sanproject.client.exdevice.data.TargetPortManager")) : class$sanproject$client$exdevice$data$TargetPortManager);
    }

    public void destroy() {
    }

    void initialize(EXDTargetPort[] eXDTargetPortArray) {
        Utility.putLog(LOG_NAME, "initialize");
        this.clearDiscoveryInfo();
        int n = eXDTargetPortArray.length;
        this.mTargetPortList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            EXDTargetPort eXDTargetPort = eXDTargetPortArray[i];
            if (eXDTargetPort == null || !(eXDTargetPort instanceof EXDTargetPort_Fiber)) continue;
            TargetPortInfo_Fibre targetPortInfo_Fibre = new TargetPortInfo_Fibre((EXDTargetPort_Fiber)eXDTargetPort);
            this.mTargetPortList.add(targetPortInfo_Fibre);
        }
        Collections.sort(this.mTargetPortList, mTargetPortIdComparator);
    }

    void update(EXDTargetPort[] eXDTargetPortArray) throws EXDException {
        Collections.sort(this.mTargetPortList, COMP_TARGETPORT);
        Collections.sort(this.mDiscoveryTargetPorts, COMP_TARGETPORT);
        BitSet bitSet = new BitSet(this.mTargetPortList.size());
        ArrayList<Object> arrayList = new ArrayList<Object>(this.mDiscoveryTargetPorts.size());
        for (int i = 0; i < eXDTargetPortArray.length; ++i) {
            Object object;
            EXDTargetPort eXDTargetPort = eXDTargetPortArray[i];
            if (eXDTargetPort == null) continue;
            int n = Collections.binarySearch(this.mTargetPortList, eXDTargetPort, COMP_TARGETPORT);
            if (n >= 0) {
                bitSet.set(n);
                continue;
            }
            int n2 = Collections.binarySearch(this.mDiscoveryTargetPorts, eXDTargetPort, COMP_TARGETPORT);
            if (n2 >= 0) {
                object = this.mDiscoveryTargetPorts.remove(n2);
                if (!(object instanceof TargetPortInfo_Fibre) || !(eXDTargetPort instanceof EXDTargetPort_Fiber)) {
                    this.mDiscoveryTargetPorts.add(n2, object);
                    continue;
                }
                TargetPortInfo_Fibre targetPortInfo_Fibre = (TargetPortInfo_Fibre)object;
                targetPortInfo_Fibre.setEXDTargetPortInfo((EXDTargetPort_Fiber)eXDTargetPort);
                arrayList.add(object);
                continue;
            }
            object = new StringBuffer("Increase Data ->");
            ((StringBuffer)object).append(" WWN:").append(eXDTargetPort.getDispTargetPortAddress());
            Utility.putLog(LOG_NAME, ((StringBuffer)object).toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        if (bitSet.cardinality() != this.mTargetPortList.size()) {
            StringBuffer stringBuffer = new StringBuffer("Decrease Data -> ");
            stringBuffer.append(this.mTargetPortList.get(bitSet.nextClearBit(0)));
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        this.mTargetPortList.addAll(arrayList);
        Collections.sort(this.mTargetPortList, mTargetPortIdComparator);
        Collections.sort(this.mDiscoveryTargetPorts, mTargetPortIdComparator);
    }

    public Collection getTargetPortList() {
        List list = (List)this.mTargetPortList.clone();
        Collections.sort(list);
        return list;
    }

    public TargetPortInfo getTargetPortInfo(int n) {
        ArrayList arrayList = n >= 0 ? this.mTargetPortList : this.mDiscoveryTargetPorts;
        Integer n2 = new Integer(n);
        int n3 = Collections.binarySearch(arrayList, n2, mTargetPortIdComparator);
        TargetPortInfo targetPortInfo = null;
        if (n3 >= 0) {
            targetPortInfo = (TargetPortInfo)arrayList.get(n3);
        }
        return targetPortInfo;
    }

    public TargetPortInfo[] getTargetPortList(ProductInfo productInfo) {
        TargetPortInfo[] targetPortInfoArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList(this.mTargetPortList);
        Collections.sort(arrayList2, COMP_PRODUCT_ID);
        int n = Collections.binarySearch(arrayList2, productInfo, COMP_PRODUCT_ID);
        if (n >= 0) {
            TargetPortInfo targetPortInfo;
            TargetPortInfo targetPortInfo2;
            int n2;
            targetPortInfoArray = (TargetPortInfo)arrayList2.get(n);
            arrayList.add(targetPortInfoArray);
            for (n2 = n - 1; n2 >= 0 && COMP_PRODUCT_ID.compare(targetPortInfo2 = (TargetPortInfo)arrayList2.get(n2), targetPortInfoArray) == 0; --n2) {
                arrayList.add(targetPortInfo2);
            }
            n2 = arrayList2.size();
            for (int i = n + 1; i < n2 && COMP_PRODUCT_ID.compare(targetPortInfo = (TargetPortInfo)arrayList2.get(i), targetPortInfoArray) == 0; ++i) {
                arrayList.add(targetPortInfo);
            }
            Collections.sort(arrayList);
        }
        targetPortInfoArray = new TargetPortInfo[arrayList.size()];
        targetPortInfoArray = arrayList.toArray(targetPortInfoArray);
        return targetPortInfoArray;
    }

    TargetPortInfo createDiscoveryTargetPortInfo(EXDTargetPort eXDTargetPort) {
        TargetPortInfo targetPortInfo = null;
        if (eXDTargetPort.isConfigured()) {
            int n = eXDTargetPort.getId();
            targetPortInfo = this.getTargetPortInfo(n);
        } else {
            int n;
            String string = eXDTargetPort.getDispTargetPortAddress();
            for (n = 0; n < this.mDiscoveryTargetPorts.size(); ++n) {
                TargetPortInfo targetPortInfo2 = (TargetPortInfo)this.mDiscoveryTargetPorts.get(n);
                String string2 = targetPortInfo2.getDisplayTargetAdr();
                if (!string.equals(string2)) continue;
                targetPortInfo = targetPortInfo2;
                break;
            }
            if (targetPortInfo == null) {
                n = Integer.MIN_VALUE + this.mDiscoveryTargetPorts.size();
                eXDTargetPort.setId(n);
                targetPortInfo = new TargetPortInfo_Fibre((EXDTargetPort_Fiber)eXDTargetPort);
                this.mDiscoveryTargetPorts.add(targetPortInfo);
            }
        }
        return targetPortInfo;
    }

    void clearDiscoveryInfo() {
        this.mDiscoveryTargetPorts.clear();
    }

    void deleteTargetPortInfo(TargetPortInfo targetPortInfo) {
        int n = Collections.binarySearch(this.mTargetPortList, targetPortInfo, mTargetPortIdComparator);
        if (n >= 0) {
            PhysicalPathManager physicalPathManager = PhysicalPathManager.getInstance();
            PhysicalPathInfo[] physicalPathInfoArray = physicalPathManager.getPhysicalPathInfo(targetPortInfo);
            for (int i = 0; i < physicalPathInfoArray.length; ++i) {
                physicalPathManager.deletePhysicalPathInfo(physicalPathInfoArray[i]);
            }
            this.mTargetPortList.remove(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TargetPortIdComparator
    implements Comparator {
        TargetPortIdComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n = object instanceof TargetPortInfo ? ((TargetPortInfo)object).getId() : ((Integer)object).intValue();
            return n;
        }
    }
}

