/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComSpringUtilities;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcDlgMainTitlePanel;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.com.RJcTableModel;
import sanproject.client.exdevice.com.AbstractElement;
import sanproject.client.exdevice.com.Button;
import sanproject.client.exdevice.com.CheckBox;
import sanproject.client.exdevice.com.DefaultTablePanel;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.com.Message;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.LprManager;
import sanproject.client.exdevice.data.SsidManager;
import sanproject.client.exdevice.luoperation.AddVolumeDirectorElement;
import sanproject.client.exdevice.luoperation.LocalGuidance;

public class SSIDListPanel
extends DialogContentsPanel {
    private static final String KEY_NAME = "SSIDList";
    private AddVolumeDirectorElement director;
    private transient ItemListener limitChangeListener;
    private JComboBox slprComboBox;
    private CheckBox limitedCheckBox;
    private DefaultTablePanel detailPanel;
    private Button applyButton;
    private Button cancelButton;

    public SSIDListPanel(AddVolumeDirectorElement addVolumeDirectorElement) {
        this.director = addVolumeDirectorElement;
        this.limitChangeListener = null;
        this.slprComboBox = null;
        this.limitedCheckBox = null;
        this.detailPanel = null;
        this.applyButton = null;
        this.cancelButton = null;
        this.putLog(KEY_NAME, "create [SSIDList].");
        this.initializePanel();
        this.buildPanelLayout();
    }

    public void addNotify() {
        Object object;
        super.addNotify();
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            object = new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    SSIDListPanel.this.putLog(SSIDListPanel.KEY_NAME, "[SSIDList] opened.");
                }

                public void windowClosed(WindowEvent windowEvent) {
                    SSIDListPanel.this.putLog(SSIDListPanel.KEY_NAME, "[SSIDList] closed.");
                    window.removeWindowListener(this);
                }
            };
            window.addWindowListener((WindowListener)object);
        }
        if ((object = this.getWindowRootPane()) != null) {
            ((JRootPane)object).setDefaultButton(this.cancelButton);
        }
    }

    public String getWindowName() {
        String string = "ExDevice_LU";
        return string;
    }

    private void initializePanel() {
        this.detailPanel = new DefaultTablePanel();
        Object object = new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    try {
                        SSIDListPanel.this.putLog(SSIDListPanel.KEY_NAME, "[SSIDList] onChange SLPR.");
                        SSIDListPanel.this.setWaitCursor();
                        SSIDListPanel.this.onChangeSLPR();
                    }
                    finally {
                        SSIDListPanel.this.setDefaultCursor();
                    }
                }
            }
        };
        Object object2 = LprManager.getInstance();
        Collection collection = ((LprManager)object2).getSlprList();
        Object[] objectArray = new Object[]{};
        if (collection != null) {
            objectArray = collection.toArray();
        }
        Serializable serializable = new DefaultComboBoxModel<Object>(objectArray);
        object2 = new DefaultListCellRenderer();
        ((JLabel)object2).setHorizontalAlignment(4);
        this.slprComboBox = new JComboBox<Object>((ComboBoxModel<Object>)((Object)serializable));
        this.slprComboBox.addItemListener((ItemListener)object);
        this.slprComboBox.setRenderer(object2);
        this.limitChangeListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SSIDListPanel.this.putLog(SSIDListPanel.KEY_NAME, "[SSIDList] onChange SSIDLimit.");
                SSIDListPanel.this.onChangeSSIDLimit();
            }
        };
        object = LocalGuidance.TEXT_SLPRLIMITED.getText();
        this.limitedCheckBox = new CheckBox((String)object);
        this.limitedCheckBox.addItemListener(this.limitChangeListener);
        this.limitedCheckBox.setOpaque(false);
        this.limitedCheckBox.setFont(RJComFont.buttonFont);
        this.limitedCheckBox.setSelected(true);
        object = LocalGuidance.BUTTON_OK.getItemID();
        serializable = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                SSIDListPanel.this.putLog(SSIDListPanel.KEY_NAME, "[SSIDList] onClick Apply.");
                SSIDListPanel.this.onClickApply();
            }
        };
        this.applyButton = new Button((String)object);
        this.applyButton.setAction((Action)((Object)serializable));
        object = LocalGuidance.BUTTON_CANCEL.getItemID();
        serializable = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                SSIDListPanel.this.putLog(SSIDListPanel.KEY_NAME, "[SSIDList] onClick Cancel.");
                SSIDListPanel.this.onClickCancel();
            }
        };
        this.cancelButton = new Button((String)object);
        this.cancelButton.setAction((Action)((Object)serializable));
    }

    private void buildPanelLayout() {
        Object object = LocalGuidance.TITLE_SSIDLIST.getItemID();
        JPanel jPanel = new RJcDlgMainTitlePanel();
        ((RJcMainTitlePanel)jPanel).setMainTitle((String)object);
        RJcDlgMainTitlePanel rJcDlgMainTitlePanel = jPanel;
        jPanel = new RJcListPanel();
        Object object2 = LocalGuidance.TEXT_SLPR.getText();
        Serializable serializable = Box.createVerticalStrut(1);
        Component component = Box.createHorizontalStrut(48);
        SpringLayout springLayout = new SpringLayout();
        Object object3 = new JPanel();
        ((Container)object3).setLayout(springLayout);
        ((JComponent)object3).setOpaque(false);
        ((Container)object3).add((Component)serializable);
        ((Container)object3).add(this.slprComboBox);
        ((Container)object3).add(component);
        RJComSpringUtilities.makeCompactGrid((Container)object3, 3, 1, 0, 0, 0, 0);
        serializable = new BorderLayout(4, 4);
        Serializable serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)((Object)serializable));
        serializable2.setOpaque(false);
        serializable2.add((Component)object3, "West");
        serializable2.add(this.limitedCheckBox, "Center");
        ((RJcListPanel)jPanel).addEntry((String)object2, (JComponent)serializable2);
        serializable2 = new Dimension(150, 200);
        object2 = new RJcCushionPanel((JComponent)this.detailPanel, 1);
        ((JComponent)object2).setPreferredSize((Dimension)serializable2);
        serializable2 = new BorderLayout(4, 4);
        object = new JPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jPanel, "North");
        ((Container)object).add((Component)object2, "Center");
        serializable2 = new GridLayout(1, 0, 4, 4);
        object2 = new JPanel();
        ((Container)object2).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object2).setOpaque(false);
        ((Container)object2).add(this.applyButton);
        ((Container)object2).add(this.cancelButton);
        serializable2 = new BorderLayout(4, 4);
        object3 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        jPanel.setOpaque(false);
        jPanel.setBorder((Border)object3);
        jPanel.add((Component)object2, "East");
        object2 = new BorderLayout(4, 4);
        this.setLayout((LayoutManager)object2);
        this.add((Component)rJcDlgMainTitlePanel, "North");
        this.add((Component)object, "Center");
        this.add((Component)jPanel, "South");
    }

    private void checkBoundaries() throws EXDException {
        SsidManager ssidManager = SsidManager.getInstance();
        boolean bl = ssidManager.chkSsidCompRequest();
        if (bl) {
            int n = 610;
            int n2 = 69003;
            throw new EXDException(n, n2);
        }
    }

    private void onChangeSLPR() {
        this.putLog(KEY_NAME, "onChangeSLPR()");
        Object object = this.slprComboBox.getSelectedItem();
        if (object != null) {
            Integer n = new Integer(object.toString());
            boolean bl = this.limitedCheckBox.isSelected();
            this.director.setSSIDSLPR(n);
            this.director.setSSIDSLPRLimit(bl);
            AbstractElement.DetailType detailType = AddVolumeDirectorElement.SSIDLIST_DETAILTYPE;
            RJcTableModel rJcTableModel = this.director.getTableModel(detailType);
            this.detailPanel.createTable(rJcTableModel);
            this.detailPanel.completedTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChangeSSIDLimit() {
        this.putLog(KEY_NAME, "onChangeSSIDLimit()");
        try {
            this.setWaitCursor();
            boolean bl = this.limitedCheckBox.isSelected();
            this.putLog(KEY_NAME, " -> selected:" + bl);
            if (!bl) {
                int n = 610;
                int n2 = 59058;
                Message message = Message.getMessage(n, n2);
                int n3 = message.showOKCancelDialog(this);
                if (n3 != 0) {
                    this.limitedCheckBox.removeItemListener(this.limitChangeListener);
                    this.limitedCheckBox.setSelected(true);
                    this.limitedCheckBox.addItemListener(this.limitChangeListener);
                } else {
                    this.onChangeSLPR();
                }
            } else {
                this.onChangeSLPR();
            }
        }
        finally {
            this.setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClickApply() {
        try {
            this.setWaitCursor();
            try {
                this.checkBoundaries();
                this.setDialogStatus(DialogContentsPanel.APPLY_STATUS);
                this.closeContentDialog();
            }
            catch (EXDException eXDException) {
                this.processEXDException(eXDException);
            }
        }
        finally {
            this.setDefaultCursor();
        }
    }

    private void onClickCancel() {
        this.closeContentDialog();
    }
}

