/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hpav.pav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.data.RJDataMsg;
import sanproject.client.data.RJDataPAVAliasItem;
import sanproject.client.data.RJDataPPKey;
import sanproject.client.hpav.com.RJPavAbstractDataSupplier;
import sanproject.client.hpav.com.RJPavException;
import sanproject.client.hpav.com.RJcCacheSupplierGetInterface;
import sanproject.client.hpav.com.RJcFIFOCache;
import sanproject.client.hpav.pav.RJPavCUDataCache;
import sanproject.client.hpav.pav.RJPavCuComparator;
import sanproject.client.hpav.pav.RJPavDataPAVAliasListEx;
import sanproject.client.hpav.pav.RJPavDataPAVFreeLDEV;
import sanproject.client.hpav.pav.RJPavDef;
import sanproject.client.hpav.pav.RJPavGuideConfig;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJSetGettingParamVol;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiLDKCIndex;
import sanproject.serverux.dataimpl.HPAVgetAliasLDEVInfoEx;
import sanproject.serverux.dataimpl.HPAVgetFreeLDEVInfo;
import sanproject.serverux.dataimpl.HPAVgetHPAVLDEV;
import sanproject.serverux.dataimpl.HPAVgetHPAVLDEVandPP;
import sanproject.serverux.dataimpl.PPKget1PPInfo;
import sanproject.serverux.dataimpl.PPKgetKeyDetail;
import sanproject.serverux.dataimpl.RJSetGettingParamLDEV;
import sanproject.serverux.dataimpl.RJSetGettingParamVol;

public class RJPavDataSupplier
extends RJPavAbstractDataSupplier
implements RJPavDef,
RJcCacheSupplierGetInterface {
    private boolean status = false;
    private RJcFIFOCache cuCache;
    private boolean bCalculating = false;
    private long lUsedCapacity = 0L;
    private long lBuffUsedCapacity = 0L;
    private static final int ERR_UNEXPECTED = 7440;

    public RJPavDataSupplier() {
        this(RJDataControl.getDataControl());
    }

    public RJPavDataSupplier(RJDataControl rJDataControl) {
        super(rJDataControl);
        RJPavGuideConfig rJPavGuideConfig = new RJPavGuideConfig();
        this.getGuidance().addGuidance(rJPavGuideConfig.getConfig());
        this.cuCache = new RJcFIFOCache(this, 64, new RJPavCuComparator());
        this.cuCache.setDisposeFactor(1.0);
    }

    public Icon getIcon(String string) {
        Icon icon = null;
        if (string != null) {
            icon = RJCom.createImgIcon(this.controller, string);
        }
        return icon;
    }

    private void ExceptionHandler(Exception exception, String string) throws RJPavException {
        int n = 9010;
        int n2 = 7440;
        String string2 = "";
        if (exception instanceof RJDataException) {
            n = ((RJDataException)exception).getErrPart();
            n2 = ((RJDataException)exception).getErrCode();
            string2 = "Failed to access ";
        } else {
            exception.printStackTrace();
            string2 = "Unexpected Exception ";
        }
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
        RJPavException rJPavException = new RJPavException(rJDataMsg.getMessage() + string2);
        Object[] objectArray = new Object[]{"OK"};
        RJComDialog.show(this.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        int n3 = rJDataMsg.getErrorLevel();
        RJComFuncPanel rJComFuncPanel = (RJComFuncPanel)this.getParentPanel();
        rJComFuncPanel.endRequest(n3);
        throw rJPavException;
    }

    public Robj_interface_RJiLDKCIndex[] getLDKCIndex() throws RJPavException {
        this.putLog("[HPAV]", "[getLDKCIndex]", "");
        Robj_interface_RJiLDKCIndex[] robj_interface_RJiLDKCIndexArray = null;
        try {
            RJCom.waitCursor(this.getParentPanel());
            RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
            robj_interface_RJiLDKCIndexArray = rJDataLDEVPart.getLDKCIndex();
            RJCom.defCursor(this.getParentPanel());
        }
        catch (Exception exception) {
            RJCom.defCursor(this.getParentPanel());
            this.ExceptionHandler(exception, "getLDKCIndex");
        }
        return robj_interface_RJiLDKCIndexArray;
    }

    public Robj_interface_RJiCUIndex[] getCUIndex(Robj_interface_RJiLDKCIndex robj_interface_RJiLDKCIndex) throws RJPavException {
        this.putLog("[HPAV]", "[getCUIndex]", "LDKC = " + robj_interface_RJiLDKCIndex.getSLDKC());
        Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray = null;
        try {
            RJCom.waitCursor(this.getParentPanel());
            RJSetGettingParamVol rJSetGettingParamVol = new RJSetGettingParamVol();
            rJSetGettingParamVol.setBMFVolume(true);
            RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
            Robj_interface_RJiLDKCIndex[] robj_interface_RJiLDKCIndexArray = new Robj_interface_RJiLDKCIndex[]{robj_interface_RJiLDKCIndex};
            robj_interface_RJiCUIndexArray = rJDataLDEVPart.getCUIndex(robj_interface_RJiLDKCIndexArray, (Robj_interface_RJSetGettingParamVol)rJSetGettingParamVol);
            List<Robj_interface_RJiCUIndex> list = Arrays.asList(robj_interface_RJiCUIndexArray);
            this.cuCache.setReadHint(list);
            RJCom.defCursor(this.getParentPanel());
        }
        catch (Exception exception) {
            RJCom.defCursor(this.getParentPanel());
            this.ExceptionHandler(exception, "getCUIndex");
        }
        return robj_interface_RJiCUIndexArray;
    }

    public ArrayList getPAVAlias(Robj_interface_RJiCUIndex robj_interface_RJiCUIndex) throws RJPavException {
        this.putLog("[HPAV]", "[getPAVAlias]", "CU = " + robj_interface_RJiCUIndex.getSCU());
        ArrayList<RJPavDataPAVAliasListEx> arrayList = null;
        try {
            HPAVgetAliasLDEVInfoEx[] hPAVgetAliasLDEVInfoExArray;
            RJCom.waitCursor(this.getParentPanel());
            RJPavCUDataCache rJPavCUDataCache = (RJPavCUDataCache)((Object)this.cuCache.get(robj_interface_RJiCUIndex));
            arrayList = new ArrayList<RJPavDataPAVAliasListEx>();
            if (rJPavCUDataCache != null && (hPAVgetAliasLDEVInfoExArray = rJPavCUDataCache.getAliasList()) != null) {
                for (int i = 0; i < hPAVgetAliasLDEVInfoExArray.length; ++i) {
                    int n;
                    RJPavDataPAVAliasListEx rJPavDataPAVAliasListEx = new RJPavDataPAVAliasListEx(robj_interface_RJiCUIndex.getSLDKC(), robj_interface_RJiCUIndex.getSCU(), hPAVgetAliasLDEVInfoExArray[i].nBaseLDEV, hPAVgetAliasLDEVInfoExArray[i].isAccount());
                    for (n = 0; n < hPAVgetAliasLDEVInfoExArray[i].nAliasLDEVArrayCurrent.length; ++n) {
                        rJPavDataPAVAliasListEx.addAriasLDEVCurrent(hPAVgetAliasLDEVInfoExArray[i].nAliasLDEVArrayCurrent[n]);
                    }
                    for (n = 0; n < hPAVgetAliasLDEVInfoExArray[i].nAliasLDEVArray.length; ++n) {
                        rJPavDataPAVAliasListEx.addAriasLDEV(hPAVgetAliasLDEVInfoExArray[i].nAliasLDEVArray[n]);
                    }
                    arrayList.add(rJPavDataPAVAliasListEx);
                }
            }
            RJCom.defCursor(this.getParentPanel());
        }
        catch (Exception exception) {
            RJCom.defCursor(this.getParentPanel());
            this.ExceptionHandler(exception, "getPAVAlias");
        }
        return arrayList;
    }

    public RJPavDataPAVFreeLDEV getPAVFreeLdev(Robj_interface_RJiCUIndex robj_interface_RJiCUIndex) throws RJPavException {
        this.putLog("[HPAV]", "[getPAVFreeLdev]", "CU = " + robj_interface_RJiCUIndex.getSCU());
        RJPavDataPAVFreeLDEV rJPavDataPAVFreeLDEV = null;
        try {
            HPAVgetFreeLDEVInfo hPAVgetFreeLDEVInfo;
            RJCom.waitCursor(this.getParentPanel());
            RJPavCUDataCache rJPavCUDataCache = (RJPavCUDataCache)((Object)this.cuCache.get(robj_interface_RJiCUIndex));
            rJPavDataPAVFreeLDEV = new RJPavDataPAVFreeLDEV(robj_interface_RJiCUIndex.getSLDKC(), robj_interface_RJiCUIndex.getSCU());
            if (rJPavCUDataCache != null && (hPAVgetFreeLDEVInfo = rJPavCUDataCache.getFreeLDEV()) != null) {
                for (int i = 0; i < hPAVgetFreeLDEVInfo.nFreeLDEVArray.length; ++i) {
                    rJPavDataPAVFreeLDEV.addFreeLDEV(hPAVgetFreeLDEVInfo.nFreeLDEVArray[i]);
                }
            }
            RJCom.defCursor(this.getParentPanel());
        }
        catch (Exception exception) {
            RJCom.defCursor(this.getParentPanel());
            this.ExceptionHandler(exception, "getPAVFreeLdev");
        }
        return rJPavDataPAVFreeLDEV;
    }

    public void setPAVAlias(ArrayList arrayList) {
        this.putItems("<<", arrayList);
        this.controller.setPAVAlias(arrayList);
    }

    public void setPAVFreeLdev(ArrayList arrayList) {
        this.putItems(">>", arrayList);
        this.controller.setPAVFreeLdev(arrayList);
    }

    public void putItems(String string, ArrayList arrayList) {
        this.putLog("[HPAV]", "[" + string + "]", "-LDKC- --CU-- -LDEV- -Base-");
        for (int i = 0; i < arrayList.size(); ++i) {
            RJDataPAVAliasItem rJDataPAVAliasItem = (RJDataPAVAliasItem)arrayList.get(i);
            String string2 = "  " + RJPavDataSupplier.toHexString(rJDataPAVAliasItem.getLDKC(), 2) + "     " + RJPavDataSupplier.toHexString(rJDataPAVAliasItem.getCU(), 2) + "     " + RJPavDataSupplier.toHexString(rJDataPAVAliasItem.getAliasLDEV(), 2) + "     " + RJPavDataSupplier.toHexString(rJDataPAVAliasItem.getBaseLDEV(), 2);
            this.putLog("[HPAV]", "[" + string + "]", string2);
        }
    }

    public void init() {
        this.cuCache.clear();
    }

    public Robj_interface_RJiLDEVInfoDetail getLDEVDetailInfo(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) throws RJPavException {
        this.putLog("[HPAV]", "[getLDEVDetailInfo]", "LDEV = " + robj_interface_RJiLDEVIndex.getSLDEV());
        Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail = null;
        try {
            RJCom.waitCursor(this.getParentPanel());
            RJPavCUDataCache rJPavCUDataCache = (RJPavCUDataCache)((Object)this.cuCache.get(robj_interface_RJiLDEVIndex));
            robj_interface_RJiLDEVInfoDetail = rJPavCUDataCache.getLDEVDetail(robj_interface_RJiLDEVIndex.getSLDEV());
            RJCom.defCursor(this.getParentPanel());
        }
        catch (Exception exception) {
            RJCom.defCursor(this.getParentPanel());
            this.ExceptionHandler(exception, "getLDEVDetailInfo");
        }
        return robj_interface_RJiLDEVInfoDetail;
    }

    public List getData(List list) throws RJDataException {
        RJSetGettingParamLDEV rJSetGettingParamLDEV;
        Robj_interface_RJiCUIndex robj_interface_RJiCUIndex;
        Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray;
        ArrayList<Robj_interface_RJiLDEVInfoDetail[]> arrayList = null;
        RJPavCuComparator rJPavCuComparator = new RJPavCuComparator();
        Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray = new Robj_interface_RJiCUIndex[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            robj_interface_RJiCUIndexArray[n++] = (Robj_interface_RJiCUIndex)iterator.next();
        }
        this.waitControl();
        this.controller.getHPAVLDEV(robj_interface_RJiCUIndexArray);
        long l = System.currentTimeMillis();
        this.controller.waitDC();
        long l2 = System.currentTimeMillis() - l;
        ArrayList arrayList2 = this.controller.getEndStatus();
        int n2 = (Integer)arrayList2.get(0);
        int n3 = (Integer)arrayList2.get(1);
        if (n2 != 0) {
            throw new RJDataException(n2, n3);
        }
        this.putLog("[Supplier]", "[confirm]", "getHPAVLDEV : wait=" + l2 + "ms");
        HPAVgetHPAVLDEVandPP hPAVgetHPAVLDEVandPP = this.controller.getHPAVLDEVData();
        this.lUsedCapacity = hPAVgetHPAVLDEVandPP.getLUsedCapacity();
        this.bCalculating = hPAVgetHPAVLDEVandPP.isCalculating();
        try {
            RJDataLDEVPart rJDataLDEVPart;
            robj_interface_RJiLDEVInfoDetailArray = new Robj_interface_RJiLDEVInfoDetail[]{};
            if (robj_interface_RJiCUIndexArray.length > 0 && (robj_interface_RJiCUIndex = (rJDataLDEVPart = this.controller.getLDEVPart()).getLDEVIndex(robj_interface_RJiCUIndexArray)) != null && ((Robj_interface_RJiLDEVIndex[])robj_interface_RJiCUIndex).length > 0) {
                rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
                rJSetGettingParamLDEV.setBBasic(true);
                rJSetGettingParamLDEV.setBSize(true);
                robj_interface_RJiLDEVInfoDetailArray = rJDataLDEVPart.getLDEVInfoDetail((Robj_interface_RJiLDEVIndex[])robj_interface_RJiCUIndex, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
            }
        }
        catch (RJDataException rJDataException) {
            throw rJDataException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RJDataException(9010, 7440);
        }
        HPAVgetHPAVLDEV[] hPAVgetHPAVLDEVArray = hPAVgetHPAVLDEVandPP.getPAVCU();
        if (hPAVgetHPAVLDEVArray != null && robj_interface_RJiLDEVInfoDetailArray != null) {
            arrayList = new ArrayList<Robj_interface_RJiLDEVInfoDetail[]>();
            for (int i = 0; i < robj_interface_RJiCUIndexArray.length; ++i) {
                Object object;
                int n4;
                robj_interface_RJiCUIndex = robj_interface_RJiCUIndexArray[i];
                rJSetGettingParamLDEV = null;
                ArrayList<Robj_interface_RJiLDEVInfoDetail> arrayList3 = null;
                for (n4 = 0; n4 < hPAVgetHPAVLDEVArray.length; ++n4) {
                    if (rJPavCuComparator.compare(robj_interface_RJiCUIndex, hPAVgetHPAVLDEVArray[n4]) != 0) continue;
                    rJSetGettingParamLDEV = hPAVgetHPAVLDEVArray[n4];
                    break;
                }
                arrayList3 = new ArrayList<Robj_interface_RJiLDEVInfoDetail>();
                for (n4 = 0; n4 < robj_interface_RJiLDEVInfoDetailArray.length; ++n4) {
                    if (rJPavCuComparator.compare(robj_interface_RJiCUIndex, robj_interface_RJiLDEVInfoDetailArray[n4]) != 0) continue;
                    arrayList3.add(robj_interface_RJiLDEVInfoDetailArray[n4]);
                }
                RJPavCUDataCache rJPavCUDataCache = null;
                if (rJSetGettingParamLDEV != null) {
                    object = new Robj_interface_RJiLDEVInfoDetail[arrayList3.size()];
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        object[j] = (Robj_interface_RJiLDEVInfoDetail)arrayList3.get(j);
                    }
                    rJPavCUDataCache = new RJPavCUDataCache();
                    rJPavCUDataCache.setCUInfo((HPAVgetHPAVLDEV)rJSetGettingParamLDEV, (Robj_interface_RJiLDEVInfoDetail[])object);
                }
                object = RJcFIFOCache.createEntry(robj_interface_RJiCUIndex, rJPavCUDataCache);
                arrayList.add((Robj_interface_RJiLDEVInfoDetail[])object);
            }
        } else {
            throw new RJDataException(9010, 7440);
        }
        return arrayList;
    }

    public PPKget1PPInfo getPAVLicense() throws RJPavException {
        this.putLog("[HPAV]", "[getPAVLicense]", "Start");
        PPKget1PPInfo pPKget1PPInfo = null;
        try {
            RJCom.waitCursor(this.getParentPanel());
            this.waitControl();
            this.controller.getKeyDetail();
            this.controller.waitDC();
            ArrayList arrayList = this.controller.getEndStatus();
            int n = (Integer)arrayList.get(0);
            int n2 = (Integer)arrayList.get(1);
            if (n != 0) {
                RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
                Object[] objectArray = new Object[]{"OK"};
                RJComDialog.show(this.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
                int n3 = rJDataMsg.getErrorLevel();
                RJComFuncPanel rJComFuncPanel = (RJComFuncPanel)this.getParentPanel();
                rJComFuncPanel.endRequest(n3);
                RJPavException rJPavException = new RJPavException(rJDataMsg.getMessage());
                throw rJPavException;
            }
            PPKgetKeyDetail pPKgetKeyDetail = this.controller.getKeyDetailData();
            PPKget1PPInfo[] pPKget1PPInfoArray = pPKgetKeyDetail.getPPKget1PPInfo();
            for (int i = 0; i < pPKget1PPInfoArray.length; ++i) {
                if (!pPKget1PPInfoArray[i].strPPID.equals(RJDataPPKey.FUNC_NAME_HPAV)) continue;
                pPKget1PPInfo = pPKget1PPInfoArray[i];
                break;
            }
            RJCom.defCursor(this.getParentPanel());
        }
        catch (RJPavException rJPavException) {
            RJCom.defCursor(this.getParentPanel());
            throw rJPavException;
        }
        catch (Exception exception) {
            RJCom.defCursor(this.getParentPanel());
            RJDataException rJDataException = new RJDataException(9010, 7440);
            this.ExceptionHandler(rJDataException, "getPAVLicense");
        }
        return pPKget1PPInfo;
    }

    public ArrayList getAssignList() {
        return this.controller.getAssignList();
    }

    public ArrayList getReleaseList() {
        return this.controller.getReleaseList();
    }

    public boolean isCalculating() {
        return this.bCalculating;
    }

    public void setCalculating(boolean bl) {
        this.bCalculating = bl;
    }

    public long getUsedCapacity() {
        return this.lUsedCapacity;
    }

    public long getBuffUsedCapacity() {
        return this.lBuffUsedCapacity;
    }

    public long setBuffUsedCapacity(long l) {
        this.lBuffUsedCapacity = l;
        return this.lBuffUsedCapacity;
    }

    public void addBuffUsedCapacity(long l) {
        this.lBuffUsedCapacity += l;
    }

    public void delBuffUsedCapacity(long l) {
        this.lBuffUsedCapacity -= l;
    }
}

