/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.ldev;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.abs.RJaComboItemListener;
import sanproject.client.monitor.com.RJHihChartData;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDef;
import sanproject.client.monitor.com.RJHihExComboBox;
import sanproject.client.monitor.performance.RJHihPerfChartAxisComboBox;
import sanproject.client.monitor.performance.RJHihPerfChartPanel;
import sanproject.client.monitor.performance.RJHihPerfTablePanel;

public class RJHihLdChartPanel
extends RJHihPerfChartPanel
implements RJHihDef {
    public static final int COMBO_INDEX_CHECK_DISEABLED = 0;
    public static final String[] DetailItemsIO = new String[]{"LDEV/DetailComboItemIORate", "LDEV/DetailComboItemRead", "LDEV/DetailComboItemWrite", "LDEV/DetailComboItemReadHit", "LDEV/DetailComboItemWriteHit", "LDEV/DetailComboItemBackTrans"};
    public static final String[] DetailItemsMB = new String[]{"LDEV/DetailComboItemTransRate", "LDEV/DetailComboItemReadHit", "LDEV/DetailComboItemWriteHit", "LDEV/DetailComboItemBackTrans"};
    private JCheckBox detailCheck = null;
    private RJHihExComboBox detailCombo = null;
    private int perfComboIndex = 0;
    private RJHihPerfTablePanel tablepanel = null;
    private String axisXTitle = null;
    private String axisYTitle = null;

    public RJHihLdChartPanel(RJHihPerfTablePanel rJHihPerfTablePanel) {
        this.tablepanel = rJHihPerfTablePanel;
        this.createExtraPanel();
    }

    public void init(RJHihDataSupplier rJHihDataSupplier) {
        super.init(rJHihDataSupplier);
    }

    private void createExtraPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(0, 4, 4, 4);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(RJcGuide.text("LDEV/XAXISLABEL"));
        jLabel.setFont(RJcConst.boldFont);
        RJHihPerfChartAxisComboBox rJHihPerfChartAxisComboBox = new RJHihPerfChartAxisComboBox();
        rJHihPerfChartAxisComboBox.setName("LDEV/AxisYComboBox");
        rJHihPerfChartAxisComboBox.setItems((Object[])this.defaultYAxisTable, this);
        rJHihPerfChartAxisComboBox.setMaximumRowCount(11);
        rJHihPerfChartAxisComboBox.setEnabled(false);
        super.setAxisYComboBox(rJHihPerfChartAxisComboBox);
        JLabel jLabel2 = new JLabel();
        this.detailCombo = new RJHihExComboBox();
        this.detailCombo.setFont(RJcConst.normalFont);
        this.detailCombo.setEnabled(false);
        this.detailCombo.setName("LDEV/DetailCombo");
        this.detailCombo.setHorizontalAlignment(2);
        this.detailCombo.setItems(DetailItemsIO, new RJaComboItemListener(){

            public void comboItemStateChanged(int n) {
                RJHihLdChartPanel.this.detailComboItemChanged(n);
            }
        });
        this.detailCheck = new JCheckBox(RJcGuide.text("LDEV/DETAILCHECK"));
        this.detailCheck.setOpaque(false);
        this.detailCheck.setEnabled(false);
        this.detailCheck.setPreferredSize(new Dimension(100, 24));
        this.detailCheck.setName("LDEV/DetailCheck");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 4), 0, 0));
        jPanel.add((Component)rJHihPerfChartAxisComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.detailCheck, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, "North");
    }

    public void drawScale(RJHihChartData rJHihChartData) {
        this.axisXTitle = this.createXAxisTitle();
        super.drawScale(rJHihChartData);
    }

    private String createXAxisTitle() {
        MessageFormat messageFormat = new MessageFormat(RJcGuide.text("LDEV/AxisXLabel"));
        String string = messageFormat.format(new String[]{this.detailCombo.getSelectedItem().toString(), String.valueOf(this.supplier.getMonitoringInfo().getIntervalTime())});
        if (this.detailCombo != null && this.detailCheck.isEnabled() && this.detailCheck.isSelected()) {
            string = this.getSelectedName(this.tablepanel.getDataModel()) + "  " + this.detailCombo.getSelectedItem().toString();
        }
        return string;
    }

    protected String getXAxisTitle(RJHihChartData rJHihChartData) {
        return this.axisXTitle;
    }

    public void detailComboItemChanged(int n) {
        if (this.perfComboIndex == 0) {
            if (this.selectedRowCount == 1 && n != -1) {
                this.detailCheck.setEnabled(true);
            }
        } else if (this.perfComboIndex == 1) {
            if (this.selectedRowCount == 1 && n != 0 && n != -1) {
                this.detailCheck.setEnabled(true);
            }
            if (n == 0) {
                this.detailCheck.setEnabled(false);
            }
        }
    }

    public RJHihExComboBox getDetailComboBox() {
        return this.detailCombo;
    }

    public JCheckBox getDetailCheckBox() {
        return this.detailCheck;
    }

    public void setPerfComboIndex(int n) {
        this.perfComboIndex = n;
    }

    public int getPerfComboIndex() {
        return this.perfComboIndex;
    }
}

