/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.ppc.utl;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import sanproject.client.com.RJComTextField;

public class RJPPCTextField
extends RJComTextField {
    static final int IOPS = 1;
    static final int MBPS = 2;
    private int digit = 0;
    private int decimal = 0;
    private RJPPCTextField textField;
    private NumberFormat integerFormatter;
    private int m_mode = 0;

    public RJPPCTextField() {
        this.setHorizontalAlignment(4);
        this.textField = this;
        this.setChkStr((short)2);
        this.setEditChk(true);
        this.setForeground(Color.black);
        this.setUpdFlg(false);
    }

    public RJPPCTextField(int n) {
        this.setMaxLen(n);
        this.digit = n;
        this.setDocument(new IOPSNumberDocument());
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setGroupingUsed(false);
        this.integerFormatter.setParseIntegerOnly(true);
        this.integerFormatter.setMaximumIntegerDigits(n);
        this.setHorizontalAlignment(4);
        this.textField = this;
        this.m_mode = 1;
        this.setChkStr((short)2);
        this.setEditChk(false);
        this.setForeground(Color.black);
        this.setFont(this.getFont().deriveFont(11.0f));
        this.setUpdFlg(false);
    }

    public RJPPCTextField(int n, int n2) {
        this.setMaxLen(n + n2 + 1);
        this.digit = n;
        this.decimal = n2;
        this.setDocument(new MBPSNumberDocument());
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setGroupingUsed(false);
        this.integerFormatter.setParseIntegerOnly(false);
        this.integerFormatter.setMaximumIntegerDigits(n);
        this.integerFormatter.setMaximumFractionDigits(n2);
        this.setHorizontalAlignment(4);
        this.textField = this;
        this.m_mode = 2;
        this.setChkStr((short)130);
        this.setEditChk(false);
        this.setForeground(Color.black);
        this.setFont(this.getFont().deriveFont(11.0f));
        this.setUpdFlg(false);
    }

    public void setField(int n) {
        this.setMaxLen(n);
        this.digit = n;
        this.setDocument(new IOPSNumberDocument());
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setGroupingUsed(false);
        this.integerFormatter.setParseIntegerOnly(true);
        this.integerFormatter.setMaximumIntegerDigits(n);
        this.setHorizontalAlignment(4);
        this.textField = this;
        this.m_mode = 1;
        this.setChkStr((short)2);
        this.setEditChk(true);
        this.setForeground(Color.black);
        this.setUpdFlg(false);
    }

    public void setField(int n, int n2) {
        this.setMaxLen(n + n2 + 1);
        this.digit = n;
        this.decimal = n2;
        this.setDocument(new MBPSNumberDocument());
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setGroupingUsed(false);
        this.integerFormatter.setParseIntegerOnly(false);
        this.integerFormatter.setMaximumIntegerDigits(n);
        this.integerFormatter.setMaximumFractionDigits(n2);
        this.integerFormatter.setMinimumFractionDigits(n2);
        this.textField = this;
        this.m_mode = 2;
        this.setChkStr((short)130);
        this.setEditChk(true);
        this.setForeground(Color.black);
        this.setUpdFlg(false);
    }

    public long getValue() {
        long l = 0L;
        try {
            l = this.m_mode == 1 ? this.integerFormatter.parse(this.getText()).longValue() : Math.round(this.integerFormatter.parse(this.getText()).doubleValue() * 1024.0);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return l;
    }

    public void setValue(long l) {
        if (this.m_mode == 1) {
            this.setText(this.integerFormatter.format(l));
        } else if (l == 0L) {
            this.setText(this.integerFormatter.format(l));
        } else {
            this.setText(this.integerFormatter.format((double)l / 1024.0));
        }
    }

    protected class MBPSNumberDocument
    extends RJComTextField.WholeNumberDocument {
        protected MBPSNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && !string.equals("")) {
                Object object;
                CharSequence charSequence;
                if (attributeSet == null) {
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN && (Character.isDigit(c) || c == '.')) continue;
                        string = string.substring(0, i);
                        break;
                    }
                    charSequence = new StringBuffer(this.getText(0, this.getLength()));
                    ((StringBuffer)charSequence).insert(n, string);
                    object = new ParsePosition(0);
                    RJPPCTextField.this.integerFormatter.parse(((StringBuffer)charSequence).toString(), (ParsePosition)object);
                    int n2 = ((ParsePosition)object).getIndex();
                    System.out.println("####[" + ((StringBuffer)charSequence).toString() + "] pos = " + n2 + " err = " + ((ParsePosition)object).getErrorIndex());
                    int n3 = ((StringBuffer)charSequence).indexOf(".");
                    if (n3 < 0) {
                        n3 = ((StringBuffer)charSequence).length();
                    }
                    if (n2 < ((StringBuffer)charSequence).length() || n3 > RJPPCTextField.this.digit || ((StringBuffer)charSequence).length() - n3 - 1 > RJPPCTextField.this.decimal) {
                        string = "";
                    }
                }
                super.insertString(n, string, attributeSet);
                charSequence = this.getText(0, this.getLength());
                if (!((String)charSequence).isEmpty() && Double.parseDouble((String)charSequence) > 2097152.0) {
                    object = new DecimalFormat("0.00");
                    String string2 = ((NumberFormat)object).format(2097152.0);
                    super.replace(0, ((String)charSequence).length(), string2, attributeSet);
                }
            }
        }
    }

    protected class IOPSNumberDocument
    extends RJComTextField.WholeNumberDocument {
        protected IOPSNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && !string.equals("")) {
                CharSequence charSequence;
                if (attributeSet == null) {
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN && Character.isDigit(c)) continue;
                        string = string.substring(0, i);
                        break;
                    }
                    charSequence = new StringBuffer(this.getText(0, this.getLength()));
                    ((StringBuffer)charSequence).insert(n, string);
                    ParsePosition parsePosition = new ParsePosition(0);
                    RJPPCTextField.this.integerFormatter.parse(((StringBuffer)charSequence).toString(), parsePosition);
                    int n2 = parsePosition.getIndex();
                    System.out.println("####[" + ((StringBuffer)charSequence).toString() + "] pos = " + n2 + " err = " + parsePosition.getErrorIndex());
                    int n3 = ((StringBuffer)charSequence).length();
                    if (n2 < ((StringBuffer)charSequence).length() || n3 > RJPPCTextField.this.digit) {
                        string = "";
                    }
                }
                super.insertString(n, string, attributeSet);
                charSequence = this.getText(0, this.getLength());
                if (!((String)charSequence).isEmpty() && Long.parseLong((String)charSequence) > Integer.MAX_VALUE) {
                    super.replace(0, ((String)charSequence).length(), String.valueOf(Integer.MAX_VALUE), attributeSet);
                }
            }
        }
    }
}

