/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ppkey;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sanproject.client.ppkey.LicenseCounterWrapper;
import sanproject.serverux.dataimpl.PPKLicenseCounter;

public final class LicenseCounterWrapperList {
    private List wrapperList = new ArrayList();

    public LicenseCounterWrapperList(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PPKLicenseCounter pPKLicenseCounter = (PPKLicenseCounter)iterator.next();
                LicenseCounterWrapper licenseCounterWrapper = new LicenseCounterWrapper(pPKLicenseCounter);
                this.wrapperList.add(licenseCounterWrapper);
            }
            Collections.sort(this.wrapperList);
        }
    }

    public boolean isModified() {
        boolean bl = false;
        int n = this.getWrapperCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isModifiedAt(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int getWrapperCount() {
        int n = this.wrapperList.size();
        return n;
    }

    public int getTotalCurrentCapacity() {
        int n = this.getWrapperCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getCurrentCapacityAt(i);
        }
        return n2;
    }

    public int getTotalModifiedCapacity() {
        int n = this.getWrapperCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getModifiedCapacityAt(i);
        }
        return n2;
    }

    public boolean isModifiedAt(int n) {
        LicenseCounterWrapper licenseCounterWrapper = this.getWrapper(n);
        boolean bl = licenseCounterWrapper.isModifed();
        return bl;
    }

    public int getLicenseCapacityAt(int n) {
        LicenseCounterWrapper licenseCounterWrapper = this.getWrapper(n);
        int n2 = licenseCounterWrapper.getLicenseCapacity();
        return n2;
    }

    public int getCurrentLicenseCountAt(int n) {
        LicenseCounterWrapper licenseCounterWrapper = this.getWrapper(n);
        int n2 = licenseCounterWrapper.getCurrentLicenseCount();
        return n2;
    }

    public int getModifiedLicenseCountAt(int n) {
        LicenseCounterWrapper licenseCounterWrapper = this.getWrapper(n);
        int n2 = licenseCounterWrapper.getModifiedLicenseCount();
        return n2;
    }

    public int getCurrentCapacityAt(int n) {
        LicenseCounterWrapper licenseCounterWrapper = this.getWrapper(n);
        int n2 = licenseCounterWrapper.getCurrentTotalCapacity();
        return n2;
    }

    public int getModifiedCapacityAt(int n) {
        LicenseCounterWrapper licenseCounterWrapper = this.getWrapper(n);
        int n2 = licenseCounterWrapper.getModifiedTotalCapacity();
        return n2;
    }

    public void changeLicenseCountAt(int n, int n2) {
        LicenseCounterWrapper licenseCounterWrapper = this.getWrapper(n);
        licenseCounterWrapper.changeLicenseCount(n2);
    }

    public void clearChangedCount() {
        int n = this.getWrapperCount();
        for (int i = 0; i < n; ++i) {
            LicenseCounterWrapper licenseCounterWrapper = this.getWrapper(i);
            int n2 = licenseCounterWrapper.getCurrentLicenseCount();
            this.changeLicenseCountAt(i, n2);
        }
    }

    public void setLicensesTo(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n;
                PPKLicenseCounter pPKLicenseCounter = (PPKLicenseCounter)iterator.next();
                int n2 = pPKLicenseCounter.nCapaKind;
                LicenseCounterWrapper licenseCounterWrapper = this.getWrapperCapacityAt(n2);
                pPKLicenseCounter.nModifyNum = n = licenseCounterWrapper.getModifiedLicenseCount();
            }
        }
    }

    public LicenseCounterWrapper getWrapperCapacityAt(int n) {
        LicenseCounterWrapper licenseCounterWrapper = null;
        Integer n2 = new Integer(n);
        int n3 = Collections.binarySearch(this.wrapperList, n2);
        if (n3 >= 0) {
            licenseCounterWrapper = this.getWrapper(n3);
        }
        return licenseCounterWrapper;
    }

    private LicenseCounterWrapper getWrapper(int n) {
        LicenseCounterWrapper licenseCounterWrapper = (LicenseCounterWrapper)this.wrapperList.get(n);
        return licenseCounterWrapper;
    }

    public static List createCloneCounterList(List list) {
        ArrayList<PPKLicenseCounter> arrayList = new ArrayList<PPKLicenseCounter>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PPKLicenseCounter pPKLicenseCounter = (PPKLicenseCounter)iterator.next();
                PPKLicenseCounter pPKLicenseCounter2 = LicenseCounterWrapper.getCloneCounter(pPKLicenseCounter);
                arrayList.add(pPKLicenseCounter2);
            }
        }
        return arrayList;
    }

    public static void setUninstallAllLicenses(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PPKLicenseCounter pPKLicenseCounter = (PPKLicenseCounter)iterator.next();
                pPKLicenseCounter.nModifyNum = 0;
            }
        }
    }
}

