/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ppkey;

import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import sanproject.client.openldevguard.utility.sort.DataSorter;
import sanproject.client.openldevguard.utility.sort.DataSorterFactory;
import sanproject.client.ppkey.LicenseListTableModel;
import sanproject.client.ppkey.RJPPKeyGuidance;
import sanproject.client.ppkey.UninstallLicenseInformation;

public final class UninstallLicenseListTableModel
extends AbstractTableModel {
    private static final int COLUMN_INDEX = -1;
    public static final int ROW_NUMBER = 0;
    public static final int PRODUCT_NAME = 1;
    public static final int LICENSE_CAPACITY = 2;
    public static final int KEY_CODE = 3;
    public static final int MAX_COLUMN_COUNT = 4;
    private final Class[] columnClasses = new Class[4];
    private final String[] columnNames;
    private final int[] columnWidths;
    private int sortedIndex;
    private LicenseListTableModel.SortType sortType;
    private List licenseList;
    private Object[][] modelData;
    private LicenseListTableModel.ViewRow[] viewIndex;

    public UninstallLicenseListTableModel(RJPPKeyGuidance rJPPKeyGuidance, List list) {
        this.columnClasses[0] = Integer.class;
        this.columnClasses[1] = String.class;
        this.columnClasses[2] = Integer.class;
        this.columnClasses[3] = String.class;
        this.columnNames = new String[4];
        this.columnNames[0] = " ";
        this.columnNames[1] = RJPPKeyGuidance.TBLHEAD[0].getGuidance();
        this.columnNames[2] = rJPPKeyGuidance.licenseCapacityHeader.getGuidance();
        this.columnNames[3] = rJPPKeyGuidance.KEYCODELABEL.getGuidance();
        this.columnWidths = new int[4];
        this.columnWidths[0] = 56;
        this.columnWidths[1] = 326;
        this.columnWidths[2] = 186;
        this.columnWidths[3] = 440;
        this.sortedIndex = -1;
        this.sortType = LicenseListTableModel.EMPTY_SORT;
        this.licenseList = list;
        this.updateLicenses();
    }

    public int getRowCount() {
        int n = this.modelData.length;
        return n;
    }

    public int getColumnCount() {
        int n = this.columnNames.length;
        return n;
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.convertToModelIndex(n);
        Object object = this.modelData[n3][n2];
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        throw new UnsupportedOperationException("can not set.");
    }

    public Class getColumnClass(int n) {
        Class clazz = this.columnClasses[n];
        return clazz;
    }

    public String getColumnName(int n) {
        String string = this.columnNames[n];
        return string;
    }

    public int getPreferredColumnWidth(int n) {
        int n2 = 75;
        try {
            n2 = this.columnWidths[n];
        }
        catch (Exception exception) {
            Class<?> clazz = exception.getClass();
            String string = clazz.getName();
            System.err.println("not found preferred width. [" + n + "]");
        }
        return n2;
    }

    public synchronized void updateLicenses() {
        int n = this.licenseList.size();
        this.modelData = new Object[n][4];
        this.viewIndex = new LicenseListTableModel.ViewRow[n];
        for (int i = 0; i < n; ++i) {
            UninstallLicenseInformation uninstallLicenseInformation = (UninstallLicenseInformation)this.licenseList.get(i);
            String string = uninstallLicenseInformation.getProductName();
            int n2 = uninstallLicenseInformation.getLicenseCapacity();
            String string2 = uninstallLicenseInformation.getKeyCode();
            this.modelData[i][0] = new Integer(i + 1);
            this.modelData[i][1] = string;
            this.modelData[i][2] = new Integer(n2);
            this.modelData[i][3] = string2;
            this.viewIndex[i] = new LicenseListTableModel.ViewRow(i);
        }
        this.clearSortState();
        this.fireTableDataChanged();
    }

    public synchronized void setSortAt(int n) {
        LicenseListTableModel.SortType sortType = LicenseListTableModel.ASCENDING_SORT;
        if (this.sortedIndex == n && this.sortType.equals(LicenseListTableModel.ASCENDING_SORT)) {
            sortType = LicenseListTableModel.DESCENDING_SORT;
        }
        DataSorter dataSorter = this.createSorter(n);
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            Object object = this.getValueAt(i, n);
            LicenseListTableModel.ViewRow viewRow = this.viewIndex[i];
            dataSorter.put(object, viewRow);
        }
        List list = dataSorter.getSortedDataList();
        if (sortType.equals(LicenseListTableModel.DESCENDING_SORT)) {
            Collections.reverse(list);
        }
        this.viewIndex = new LicenseListTableModel.ViewRow[0];
        this.viewIndex = list.toArray(this.viewIndex);
        this.sortedIndex = n;
        this.sortType = sortType;
        this.fireTableDataChanged();
    }

    private int convertToModelIndex(int n) {
        LicenseListTableModel.ViewRow viewRow = this.viewIndex[n];
        int n2 = viewRow.getModelIndex();
        return n2;
    }

    private int convertToViewIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.viewIndex.length; ++i) {
            LicenseListTableModel.ViewRow viewRow = this.viewIndex[i];
            if (viewRow.getModelIndex() != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private DataSorter createSorter(int n) {
        DataSorter dataSorter;
        switch (n) {
            case 1: 
            case 3: {
                dataSorter = DataSorterFactory.createStringDataSorter();
                break;
            }
            default: {
                dataSorter = DataSorterFactory.createMixtureDataSorter();
            }
        }
        return dataSorter;
    }

    private void clearSortState() {
        this.sortedIndex = -1;
        this.sortType = LicenseListTableModel.EMPTY_SORT;
    }
}

