/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.syslog;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.data.RJDataMsg;
import sanproject.client.syslog.RJMediator;
import sanproject.client.syslog.RJRadioButton;
import sanproject.client.syslog.RJslDataControl;
import sanproject.client.syslog.RJslDef;
import sanproject.client.syslog.RJslGuide;
import sanproject.client.syslog.RJslIPField;
import sanproject.client.syslog.RJslIPField_IPv6;
import sanproject.client.syslog.RJslNumberField;
import sanproject.client.syslog.RJslTabPanel;
import sanproject.serverux.data.SysLogServ;

public class RJslMediator
implements RJMediator,
RJslDef,
RJslGuide {
    SysLogServ servData;
    RJslTabPanel parentPanel;
    RJRadioButton enable;
    RJRadioButton disable;
    RJRadioButton ipv6;
    RJRadioButton ipv4;
    RJslIPField ipField;
    RJslIPField_IPv6 ipField_IPv6;
    JPanel ipField_base;
    CardLayout ipField_chg;
    RJslNumberField portField;
    RJslDataControl datacontrol;
    JPanel portPanel;
    int srvNum;

    public RJslMediator() {
        this(null);
    }

    public RJslMediator(SysLogServ sysLogServ) {
        this.servData = sysLogServ;
        this.init();
    }

    public void setMediatorNum(int n) {
        this.srvNum = n;
    }

    public void init() {
        this.enable = new RJRadioButton(RJcGuide.text("syslog/Enable"), false);
        this.disable = new RJRadioButton(RJcGuide.text("syslog/Disable"), true);
        this.enable.setOpaque(false);
        this.disable.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.enable);
        buttonGroup.add(this.disable);
        this.ipv4 = new RJRadioButton(RJcGuide.text("syslog/IPv4"), false);
        this.ipv6 = new RJRadioButton(RJcGuide.text("syslog/IPv6"), true);
        this.ipv4.setOpaque(false);
        this.ipv6.setOpaque(false);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.ipv4);
        buttonGroup2.add(this.ipv6);
        this.ipField = new RJslIPField();
        this.ipField.setPreferredSize(new Dimension(180, 20));
        this.ipField_IPv6 = new RJslIPField_IPv6();
        this.ipField_IPv6.setPreferredSize(new Dimension(390, 20));
        this.ipField_chg = new CardLayout();
        this.ipField_base = new JPanel(this.ipField_chg);
        this.ipField_base.setOpaque(false);
        this.portField = new RJslNumberField(5, 1, 65535);
        this.portField.setBorder(BorderFactory.createEmptyBorder());
        this.portField.setOpaque(false);
        this.portPanel = new JPanel();
        this.portPanel.setLayout(new GridBagLayout());
        this.portPanel.setBackground(Color.white);
        this.portPanel.setBorder(UIManager.getBorder("TextField.border"));
        this.portPanel.setPreferredSize(new Dimension(55, 20));
        this.portPanel.add((Component)this.portField, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setValue(SysLogServ sysLogServ) {
        int[] nArray;
        int[] nArray2;
        this.enable.setMediator(null);
        this.disable.setMediator(null);
        this.ipv4.setMediator(null);
        this.ipv6.setMediator(null);
        this.ipField.setMediator(null);
        this.ipField_IPv6.setMediator(null);
        this.portField.setMediator(null);
        this.servData = sysLogServ;
        this.enable.setSelected(this.servData.B_On);
        this.disable.setSelected(!this.servData.B_On);
        this.ipv4.setSelected(!this.servData.B_IPv6);
        this.ipv6.setSelected(this.servData.B_IPv6);
        if (this.srvNum == 0) {
            nArray2 = RJslDef.def_IPv4;
            nArray = RJslDef.def_IPv6;
        } else {
            nArray2 = RJslDef.def_IPv4_2;
            nArray = RJslDef.def_IPv6_2;
        }
        if (!this.servData.B_IPv6) {
            this.ipField_chg.show(this.ipField_base, "IPv4");
            nArray2 = this.getIPv4Address();
        } else {
            this.ipField_chg.show(this.ipField_base, "IPv6");
            nArray = this.servData.I_IP_Add;
        }
        this.ipField.setValue(nArray2);
        this.ipField_IPv6.setValue(nArray);
        this.portField.setText(Integer.toString(this.servData.I_Port));
    }

    public void setDataControl(RJslDataControl rJslDataControl) {
        this.datacontrol = rJslDataControl;
    }

    public void setModifyMode(boolean bl) {
        if (!bl) {
            this.enable.setEnabled(false);
            this.disable.setEnabled(false);
            this.enable.setstate(false);
            this.disable.setstate(false);
            this.ipv4.setEnabled(false);
            this.ipv6.setEnabled(false);
            this.ipv4.setstate(false);
            this.ipv6.setstate(false);
            this.ipField.setEnabled(false);
            this.ipField.setBlue(false);
            this.ipField.setItalic(false);
            this.ipField_IPv6.setEnabled(false);
            this.ipField_IPv6.setBlue(false);
            this.ipField_IPv6.setItalic(false);
            this.portField.setEnabled(false);
            this.portField.setBlue(false);
            this.portField.setItalic(false);
        } else {
            this.enable.setEnabled(true);
            this.disable.setEnabled(true);
            this.ipv4.setEnabled(true);
            this.ipv6.setEnabled(true);
            this.ipField.setEnabled(true);
            this.ipField.setItalic(false);
            this.ipField.setBlue(false);
            this.ipField_IPv6.setEnabled(true);
            this.ipField_IPv6.setItalic(false);
            this.ipField_IPv6.setBlue(false);
            this.portField.setEnabled(true);
            this.portField.setItalic(false);
            this.enable.setMediator(this);
            this.disable.setMediator(this);
            this.ipField.setMediator(this);
            this.ipField_IPv6.setMediator(this);
            this.portField.setMediator(this);
            this.ipv4.setMediator(this);
            this.ipv6.setMediator(this);
            this.colleagueChanged();
        }
    }

    public void colleagueChanged() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int[] nArray;
        int[] nArray2;
        SysLogServ sysLogServ = new SysLogServ();
        sysLogServ.B_On = this.enable.isSelected();
        if (this.servData.B_On != this.enable.isSelected()) {
            this.enable.setstate(true);
        } else {
            this.enable.setstate(false);
        }
        if (this.enable.isSelected()) {
            this.ipField.setEnabled(true);
            this.ipField_IPv6.setEnabled(true);
            this.portField.setEnabled(true);
            this.ipField.setEditable(true);
            this.ipField_IPv6.setEditable(true);
            this.portField.setEditable(true);
            this.ipv4.setEnabled(true);
            this.ipv6.setEnabled(true);
        } else {
            this.ipField.setEnabled(false);
            this.ipField_IPv6.setEnabled(false);
            this.portField.setEnabled(false);
            this.ipField.setEditable(false);
            this.ipField_IPv6.setEditable(false);
            this.portField.setEditable(false);
            this.ipv4.setEnabled(false);
            this.ipv6.setEnabled(false);
        }
        sysLogServ.B_IPv6 = this.ipv6.isSelected();
        if (this.servData.B_IPv6 != this.ipv6.isSelected()) {
            this.ipv6.setstate(true);
            this.ipv4.setstate(true);
        } else {
            this.ipv6.setstate(false);
            this.ipv4.setstate(false);
        }
        if (this.srvNum == 0) {
            nArray2 = RJslDef.def_IPv4;
            nArray = RJslDef.def_IPv6;
        } else {
            nArray2 = RJslDef.def_IPv4_2;
            nArray = RJslDef.def_IPv6_2;
        }
        if (!this.servData.B_IPv6) {
            nArray2 = this.getIPv4Address();
        } else {
            nArray = this.servData.I_IP_Add;
        }
        boolean bl4 = bl3 = this.ipField.check(nArray2) || this.ipv6.getstate();
        if (bl3) {
            this.ipField.setItalic(true);
            if (this.enable.isSelected()) {
                this.ipField.setBlue(true);
            }
        } else {
            this.ipField.setItalic(false);
            this.ipField.setBlue(false);
        }
        boolean bl5 = bl2 = this.ipField_IPv6.check(nArray) || this.ipv6.getstate();
        if (bl2) {
            this.ipField_IPv6.setItalic(true);
            if (this.enable.isSelected()) {
                this.ipField_IPv6.setBlue(true);
            }
        } else {
            this.ipField_IPv6.setItalic(false);
            this.ipField_IPv6.setBlue(false);
        }
        int n = 0;
        n = this.portField.getText() == null || this.portField.getText().equals("") ? 1 : Integer.parseInt(this.portField.getText());
        sysLogServ.I_Port = n;
        if (n == this.servData.I_Port) {
            this.portField.setItalic(false);
            this.portField.setBlue(false);
        } else {
            this.portField.setItalic(true);
            if (this.enable.isSelected()) {
                this.portField.setBlue(true);
            }
        }
        if (this.ipv4.isSelected()) {
            this.ipField_chg.show(this.ipField_base, "IPv4");
            sysLogServ.I_IP_Add = this.getIPAddress();
        } else {
            this.ipField_chg.show(this.ipField_base, "IPv6");
            sysLogServ.I_IP_Add = this.ipField_IPv6.getAddress_int();
        }
        if (this.datacontrol != null && sysLogServ != null && this.disable.isSelected() && !(bl = this.datacontrol.check_IP(sysLogServ))) {
            this.enable.setSelected(true);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJDataMsg rJDataMsg = this.ipv4.isSelected() ? this.datacontrol.getMessage(71055011) : this.datacontrol.getMessage(71065683);
            int n2 = this.datacontrol.showMessage(this.parentPanel, rJDataMsg, 0, objectArray, objectArray[0]);
            this.ipField.requestFocus();
        }
    }

    public void setParentPanel(RJslTabPanel rJslTabPanel) {
        this.parentPanel = rJslTabPanel;
    }

    public boolean getstate() {
        boolean bl = false;
        boolean bl2 = bl = this.enable.getstate() || this.portField.getstate() || this.ipv6.getstate();
        bl = this.ipv6.isSelected() ? bl || this.ipField_IPv6.getstate() : bl || this.ipField.getstate();
        return bl;
    }

    public int[] getIPv4Address() {
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = this.servData.I_IP_Add[i + 4];
        }
        return nArray;
    }

    public int[] getIPAddress() {
        int[] nArray = new int[8];
        if (this.ipv4.isSelected()) {
            if (this.ipField.getAddress_int().length == 4) {
                int n;
                for (n = 0; n < 4; ++n) {
                    nArray[n] = 0;
                }
                for (n = 0; n < 4; ++n) {
                    nArray[n + 4] = this.ipField.getAddress_int()[n];
                }
            } else {
                for (int i = 0; i < 8; ++i) {
                    nArray[i] = this.ipField.getAddress_int()[i];
                }
            }
        } else {
            nArray = this.ipField_IPv6.getAddress_int();
        }
        return nArray;
    }

    public int getPortNum() {
        int n = this.portField.getText() == null || this.portField.getText().equals("") ? 0 : Integer.parseInt(this.portField.getText());
        return n;
    }

    public boolean getIPMode() {
        return this.ipv6.isSelected();
    }

    public boolean getServEnable() {
        boolean bl = false;
        if (this.enable.isSelected()) {
            bl = true;
        }
        return bl;
    }

    public void setIPFocus() {
        if (this.ipv6.isSelected()) {
            this.ipField_IPv6.requestFocus();
        } else {
            this.ipField.requestFocus();
        }
    }

    public RJcCushionPanel getRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.enable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.disable, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(jPanel);
        return rJcCushionPanel;
    }

    public RJcCushionPanel getIPTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(" ");
        jLabel.setOpaque(false);
        this.ipField_base.add((Component)this.getIPTextPanel_IPv4(), "IPv4");
        this.ipField_base.add((Component)this.getIPTextPanel_IPv6(), "IPv6");
        jPanel.add((Component)this.getIPChgPanel(), new GridBagConstraints(0, 0, 3, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ipField_base, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.getPortTextPanel(), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(jPanel);
        return rJcCushionPanel;
    }

    public JPanel getIPTextPanel_IPv4() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(RJcGuide.text("syslog/IPAdd"));
        JLabel jLabel2 = new JLabel(" ");
        jLabel2.setOpaque(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ipField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel getIPTextPanel_IPv6() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(RJcGuide.text("syslog/IPAdd"));
        JLabel jLabel2 = new JLabel(" ");
        jLabel2.setOpaque(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ipField_IPv6, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel getPortTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(RJcGuide.text("syslog/PortAdd"));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.portPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel getIPChgPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(" ");
        jLabel.setOpaque(false);
        jPanel.add((Component)this.ipv4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ipv6, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }
}

