/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.messages.AcknowledgeMessageExt;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.UUIDUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AcknowledgeMessage
extends AsyncMessage {
    private static final long serialVersionUID = 228072709981643313L;

    public AcknowledgeMessage() {
        this.messageId = UUIDUtils.createUUID((boolean)false);
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readExternal(input);
        short[] flagsArray = this.readFlags(input);
        for (int i = 0; i < flagsArray.length; ++i) {
            short flags = flagsArray[i];
            int reservedPosition = 0;
            if (flags >> reservedPosition == 0) continue;
            for (int j = reservedPosition; j < 6; j = (int)((short)(j + 1))) {
                if ((flags >> j & 1) == 0) continue;
                input.readObject();
            }
        }
    }

    @Override
    public Message getSmallMessage() {
        if (this.getClass() == AcknowledgeMessage.class) {
            return new AcknowledgeMessageExt(this);
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        int flags = 0;
        output.writeByte(flags);
    }
}

