/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.HitachiCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public class CacheLib {
    static final String HITACHI_CACHE = "HitachiCache";
    public static final String COMPOSITE = "composite";
    public static final String AOU = "AOU";
    public static final String QS = "QS";
    public static final String DevNum = "DN:";
    private static final String FB4 = "FB4:%d";
    private static final String PG = "PG:%d";
    private static final String VDEV = "VDEV:%d";
    private static final String CHAINFO = "CHAInfo:";
    private static final String CHALOCATION = "CHALocation:";
    private static final String CLPR = "CLPR:";
    private static final String CLPRNUM = "CLPR:%d";
    private static final String CLPRKEY = "PRM:CLPR:";
    private static final String CLPR_ECC_KEY = "ECCGROUP:%s";
    private static final String CLPR_LDEV_KEY = "LDEV:%s";
    private static final String PDEV = "PDEV:";
    private static final String PDEV_FB4_PG = "PDEV:%d-%d";
    private static final String PDEV_LOC = "PDEV:DriveLocation:%s";
    private static final String PDEV_LOC_CDEV_RDEV = "PDEV:DriveLocation:%s:CDEV:%d:RDEV:%d";
    private static final String ARRAYGROUP = "AG:%d";
    static final String DevNumFB4 = "DN:FB4:%d";
    static final String DevNumPG = "DN:PG:%d";
    static final String DevNumVDEV = "DN:VDEV:%d";
    static final String DevNumCLPR = "DN:AOUCLPR:%d";
    private static final String LDEVIndexCU = "CU:%d";
    private static final String LDEVIndexDKC = "DKC:%d";
    private static final String LDEVIndexFB4 = "FB4:%d";
    static final String LDEVIndexLDEV = "LDEV:%d";
    static final String LDEVIndexPG = "PG:%d";
    static final String LDEVIndexVDEV = "VDEV:%d";
    private static final String DBVALIDATOR = "DBValidator:DKC_%d:CU_%d:LDEV_%d";
    private static final String RSG = "RSG:";
    public static final String BYPVOL = "byPVol";
    public static final String BYSVOL = "bySVol";
    public static final String BYPOOLID = "byPoolID";
    public static final String BYSVOLATRB = "bySVolAtrb";
    public static final String RealVirtualLDEV = "RealVirtualLDEV";
    public static final String VirtualLDEV = "VirtualLDEV";

    public static final <T extends Serializable> void addDataToCache(Map<String, List<T>> map, List<T> list, Class<T[]> clz, String serialNum) {
        try {
            if (null != list) {
                CacheLib.addMapToCache(map, clz, serialNum);
                CacheLib.addItemsToCache(list, clz, serialNum);
            }
        }
        catch (Throwable t) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.SEVERE, "Error performing cache work for  " + serialNum, t);
        }
    }

    public static final <T extends Serializable> void addItemsToCache(List<T> pathList, Class<T[]> clz, String serialNum) throws WBEMException {
        try {
            HitachiCache.getHitachiCache(serialNum).addCacheObject(clz, pathList);
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception adding elements to cache for : " + serialNum, null, t);
        }
    }

    private static final <COMMONTYPE extends Serializable> void addMapToCache(Map<String, List<COMMONTYPE>> map, Class<COMMONTYPE[]> clz, String serialNum) {
        Set<String> keys = map.keySet();
        for (String strKey : keys) {
            List<COMMONTYPE> al = map.get(strKey);
            if (al != null && al.size() > 0) {
                try {
                    HitachiCache.getHitachiCache(serialNum).addCacheObject(strKey, al, clz);
                }
                catch (WBEMException e) {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                    logger.log(Level.SEVERE, "Error adding " + ((Serializable)al.get(0)).getClass().toString() + " to cache for device " + serialNum, e);
                }
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.WARNING, strKey + " arraylist was NULL.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <E extends Serializable> void addToMap(Map<String, List<E>> map, String key, E obj) {
        Object object;
        List<E> theList = map.get(key);
        if (theList == null) {
            object = map;
            synchronized (object) {
                theList = map.get(key);
                if (theList == null) {
                    theList = new ArrayList();
                    map.put(key, theList);
                }
            }
        }
        object = theList;
        synchronized (object) {
            theList.add(obj);
        }
    }

    public static String getAuthUserInfoFCSP(int portID) {
        return "AuthUserInfoFCSP:" + portID;
    }

    public static String getCacheInfoDataString(int clprNum) {
        return String.format("CacheInfoData:%d", clprNum);
    }

    public static final Long getCacheMemoryUsage() {
        return HitachiCache.getMemoryUsage();
    }

    public static final String getCacheStatistics() {
        return HitachiCache.getCacheStatistics();
    }

    public static String getCAGAllString(String cagStr, int fb4, int pg, int vdev, int arrayGroup) {
        return String.format("%sFB4:%dPG:%dVDEV:%dAG:%d", cagStr, fb4, pg, vdev, arrayGroup);
    }

    public static String getCAGFB4PgVdevString(String cagStr, int fb4, int pg, int vdev) {
        return String.format("%sFB4:%dPG:%dVDEV:%d", cagStr, fb4, pg, vdev);
    }

    public static String getCAGFB4String(String cagStr, int fb4) {
        return String.format("%sFB4:%d", cagStr, fb4);
    }

    public static String getCAGString(String cagStr, int fb4, int arrayGroup) {
        return String.format("%sFB4:%dAG:%d", cagStr, fb4, arrayGroup);
    }

    public static String getCHAInfoChaNumClusterNum(short chaNum, short clusterNum) {
        return String.format("CHAInfo:chaNum:%d:clusterNum:%d", chaNum, clusterNum);
    }

    public static String getCHAInfoCtrID(int ctrID) {
        return String.format("CHAInfo:ctrID:%d", ctrID);
    }

    public static String getCHALocationChaNumClusterNum(short chaNum, short clusterNum) {
        return String.format("CHALocation:chaNum:%d:clusterNum:%d", chaNum, clusterNum);
    }

    public static String getCHALocationCtrID(int ctrID) {
        return String.format("CHALocation:ctrID:%d", ctrID);
    }

    public static String getCLPRECCKey(String eccGroup) {
        String format = "PRM:CLPR:ECCGROUP:%s";
        return String.format("PRM:CLPR:ECCGROUP:%s", eccGroup);
    }

    public static String getCLPRLDEVKey(String ldev) {
        String format = "PRM:CLPR:LDEV:%s";
        return String.format("PRM:CLPR:LDEV:%s", ldev);
    }

    public static String getCLPRNUMKey(short clpr) {
        String format = "PRM:CLPR:CLPR:%d";
        return String.format("PRM:CLPR:CLPR:%d", clpr);
    }

    public static String getCLPRPgString(String pgStr, short clpr) {
        return String.format("%sCLPR#%d", pgStr, clpr);
    }

    public static String getCUString(short cu) {
        return String.format(LDEVIndexCU, cu);
    }

    public static String getCVAEInfoString(String pID) {
        return String.format("CVAEID:%s", pID);
    }

    public static String getDBValidatorString(short dkc, short cu, short ldev) {
        return String.format(DBVALIDATOR, dkc, cu, ldev);
    }

    public static String getDCRInfoIndexString(short index) {
        return String.format("DCRIndex:%d", index);
    }

    public static String getDCRInfoString(short cu, short ldev) {
        return String.format("CU:%d:LDEV:%d", cu, ldev);
    }

    public static String getDevNumAOUCLPR(short sclpr) {
        return String.format(DevNumCLPR, sclpr);
    }

    public static String getDevNumAOUQSString() {
        StringBuilder ret = new StringBuilder(DevNum);
        ret.append(AOU);
        ret.append(QS);
        return ret.toString();
    }

    public static String getDevNumAOUQSThinPoolIDString(short thinPoolID) {
        StringBuilder builder = new StringBuilder(CacheLib.getDevNumAOUQSString());
        builder.append(":PoolID:");
        builder.append(thinPoolID);
        return builder.toString();
    }

    public static String getDevNumAOUString(boolean thinVols) {
        return DevNum + (thinVols ? AOU : QS);
    }

    public static String getDevNumFB4String(int fb4) {
        return String.format(DevNumFB4, fb4);
    }

    public static String getDevNumPGString(int pg) {
        return String.format(DevNumPG, pg);
    }

    public static String getDevNumQSString() {
        return "DN:QS";
    }

    public static String getDevNumThinPoolIDCompositeString(short thinPoolID, boolean thinVols) {
        String ret = CacheLib.getDevNumThinPoolIDString(thinPoolID, thinVols);
        ret = ret + COMPOSITE;
        return ret;
    }

    public static String getDevNumThinPoolIDString(short thinPoolID, boolean thinVols) {
        StringBuilder builder = new StringBuilder(CacheLib.getDevNumAOUString(thinVols));
        builder.append(String.format(":PoolID:%d", thinPoolID));
        return builder.toString();
    }

    public static String getDevNumVDEVString(int vdev) {
        return String.format(DevNumVDEV, vdev);
    }

    public static String getDkcCuLdevString(short dkc, short cu, short ldev) {
        StringBuffer ret = new StringBuffer(CacheLib.getDKCString(dkc));
        ret.append(CacheLib.getCUString(cu));
        ret.append(CacheLib.getLDEVIndexLDEVString(ldev));
        return ret.toString();
    }

    public static String getDKCString(short dkc) {
        return String.format(LDEVIndexDKC, dkc);
    }

    public static String getEXDStatus(int id) {
        return "EXDStatus:" + id;
    }

    public static String getExternalVolumeInfoPG(int pg) {
        return "ExternalVolumeInfo:" + pg;
    }

    public static String getFB4PgString(String pgStr, int fb4, int pg) {
        return String.format("%sFB4:%dPG:%d", pgStr, fb4, pg);
    }

    public static String getFb4PgVdevString(int fb4, int pg, int vdev) {
        StringBuffer ret = new StringBuffer(CacheLib.getFB4String(fb4));
        ret.append(CacheLib.getPGString(pg));
        ret.append(CacheLib.getVDEVString(vdev));
        return ret.toString();
    }

    static String getFB4String(int fb4) {
        return String.format("FB4:%d", fb4);
    }

    public static String getFCoECtrlIDandPort(short ctrlID, short port) {
        String ret = CacheLib.getFCoECtrlIDString(ctrlID);
        ret = ret.concat(CacheLib.getFCoEPortString(port));
        return ret;
    }

    public static String getFCoECtrlIDString(short ctrlID) {
        String ret = String.format("FCoE:CtrlID:%d", ctrlID);
        return ret;
    }

    public static String getFCoEMACString(String mac) {
        String ret = new String("FCoE:MAC:");
        ret = ret.concat(mac.replaceAll(":", ""));
        return ret;
    }

    public static String getFCoEPortString(short port) {
        String ret = new String("FCoE:");
        ret = ret.concat(CacheLib.getPortString(port));
        return ret;
    }

    public static String getLDEVIndexFB4String(int fb4) {
        return String.format("FB4:%d", fb4);
    }

    public static String getLDEVIndexLDEVString(short ldev) {
        return String.format(LDEVIndexLDEV, ldev);
    }

    public static String getLDEVIndexPGString(int pg) {
        return String.format("PG:%d", pg);
    }

    public static String getLDEVIndexVDEVString(int fb4, int pg, int vdev) {
        StringBuffer ret = new StringBuffer(CacheLib.getLDEVIndexFB4String(fb4));
        ret.append(CacheLib.getLDEVIndexPGString(pg));
        ret.append(String.format("VDEV:%d", vdev));
        return ret.toString();
    }

    public static String getLDEVNicknameByDN(String dnNumber) {
        return String.format("LDevNicknameDNNumber:%s", dnNumber);
    }

    public static String getLUPathDevNum(long devNum) {
        return String.format("LUPath:DN:%d", devNum);
    }

    public static String getLUPathPort(short sPort) {
        return String.format("LUPath:SPort:%d", sPort);
    }

    public static String getLUPathPortHostgroup(short sPort, short sHostgroup) {
        return String.format("LUPath:SPort:%d:SHostGroup:%d", sPort, sHostgroup);
    }

    public static String getLUSEDevNum(long devNum) {
        return String.format("LUSE:DN:%d", devNum);
    }

    public static String getMPBladeLocByBladeID(short bladeID) {
        return String.format("MPBladeLocByBladeID:%d", bladeID);
    }

    public static String getPairDataByPoolID(short poolID) {
        return String.format("PairData:%s:%d", BYPOOLID, poolID);
    }

    public static String getPairDataByPVol(String dnAsString) {
        return String.format("PairData:%s:%s", BYPVOL, dnAsString);
    }

    public static String getPairDataBySVol(String dnAsString) {
        return String.format("PairData:%s:%s", BYSVOL, dnAsString);
    }

    public static String getPDEVFB4PG(int fb4, int pg) {
        return String.format(PDEV_FB4_PG, fb4, pg);
    }

    public static String getPDEVLocCdevRdevKey(String loc, int cdev, int rdev) {
        return String.format(PDEV_LOC_CDEV_RDEV, loc, cdev, rdev);
    }

    public static String getPDEVLocKey(int loc) {
        return String.format(PDEV_LOC, loc);
    }

    public static String getPDEVLocKey(String loc) {
        return String.format(PDEV_LOC, loc);
    }

    public static String getPGNumberString(int clprNum) {
        return String.format("PGNumber:clprNum:%d", clprNum);
    }

    public static String getPGNumberString(int fb4, int pg) {
        return String.format("PGNumber:%d:%d", fb4, pg);
    }

    static String getPGString(int pg) {
        return String.format("PG:%d", pg);
    }

    public static String getPHGIClientType(String clientType) {
        return String.format("PHGI:ClientType:%s", clientType);
    }

    public static String getPHGIControlID(short ctrlID) {
        return String.format("PHGI:ControlID:%d", ctrlID);
    }

    public static String getPHGIControlID(String key, short ctrlID) {
        return String.format(key + ":ControlID:%d", ctrlID);
    }

    public static String getPHGIDomain(String key, short hostgroupID) {
        return String.format(key + ":DomainID:%d", hostgroupID);
    }

    public static String getPHGIHost() {
        return "PHGI:ISHOSTWWN";
    }

    public static String getPHGIHostWWN(String wwn) {
        return String.format("PHGI:HostWWN:%s", wwn);
    }

    public static String getPHGIPortID(short portID) {
        return String.format("PHGI:PortID:%d", portID);
    }

    public static String getPoolNicknameByPoolID(short poolID) {
        return String.format("PoolNicknamePoolID:%d", poolID);
    }

    public static String getPortCtrlIDString(short ctrlID) {
        return String.format("FCPort:CtrlID:%d", ctrlID);
    }

    public static String getPortString(short port) {
        return String.format("FCPort:Port:%d", port);
    }

    public static String getPortWWNString(String portWWN) {
        return String.format("FCPort:WWN:%s", portWWN);
    }

    public static String getProgramProductStatusString(String id) {
        return String.format("ProgramProductID:%s", id);
    }

    public static String getRSGbyDN(String dn) {
        return "RSG:DN:" + dn;
    }

    public static String getRSGbyHostGrp(String hostGrp) {
        return "RSG:HostGrp:" + hostGrp;
    }

    public static String getRSGbyPort(String port) {
        return "RSG:PortID:" + port;
    }

    public static String getRSGbyVDEV(String vdev) {
        return "RSG:VDEV:" + vdev;
    }

    public static String getThinPoolByContainedLDEVID(String containedDN) {
        return new String("AOU:ByContainedLDEV:" + containedDN);
    }

    public static String getThinPoolIDCompositeString(short poolID) {
        return String.format("%s:PoolID:%d%s", AOU, poolID, COMPOSITE);
    }

    public static String getThinPoolIDString(short poolID) {
        return String.format("%s:PoolID:%d", AOU, poolID);
    }

    public static String getThinPoolKind(boolean mAOUPool) {
        return String.format("%s:Thin:%s", AOU, String.valueOf(mAOUPool));
    }

    public static String getThinPoolTierAllocationOn() {
        return String.format("%s:TierAllocationOn", AOU);
    }

    public static String getThinPoolTierAllocationOn(short poolID) {
        return String.format("%s:TierAllocationOn:%s", AOU, String.valueOf(poolID));
    }

    private static String getVDEVString(int vdev) {
        return String.format("VDEV:%d", vdev);
    }

    public static final void printCacheData() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                HitachiCache.dump();
            }
        };
        Thread thread = new Thread(t);
        thread.start();
    }

    public static <T extends Serializable> void removeDataFromCache(Map<String, List<T>> map, T[] items, Class<T[]> clz, String serialNum) {
        try {
            CacheLib.removeMapFromCache(map, clz, serialNum);
            CacheLib.removeItemsFromCache(items, clz, (String)serialNum);
        }
        catch (Throwable t) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.SEVERE, "Error removing items from cache for " + serialNum, t);
        }
    }

    private static <T extends Serializable> void removeItemsFromCache(T[] paths, Class<T[]> clz, String serialNum) throws WBEMException {
        List<T> al = Arrays.asList(paths);
        HitachiCache.getHitachiCache(serialNum).removeCacheObject(null, al, clz);
    }

    private static <T extends Serializable> void removeMapFromCache(Map<String, List<T>> map, Class<?> clz, String serialNum) {
        Set<String> keys = map.keySet();
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        for (String strKey : keys) {
            List<T> al = map.get(strKey);
            if (al == null || al.size() <= 0) continue;
            try {
                logger.info("Removing " + al.size() + " elements from " + strKey + " from cache");
                HitachiCache.getHitachiCache(serialNum).removeCacheObject(strKey, al, clz);
            }
            catch (WBEMException e) {
                logger.log(Level.SEVERE, "Error removing " + al.get(0).toString() + " from cache: " + (Object)((Object)e), e);
            }
        }
    }
}

