/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.LDEVBranchChecker;
import com.hitachi.smi.cache.ResourceGroupInfoVersionChecker;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ResourceGroupInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_BASICVerAllLUPath;
import sanproject.common.Robj_interface_BASICVerLUPathPerPort;
import sanproject.common.Robj_interface_VerLeaf;

public class LUPathBranchChecker
extends AbstractVersionChecker
implements ResourceGroupInfoVersionChecker.RSGUpdateCallback {
    protected LUPathBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.BASIC, this);
        ResourceGroupInfoVersionChecker.registerForRSGUpdates(ResourceGroupInfo.SearchType.PHGI, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        this.CompareAllLUPathBranch((Robj_interface_BASICVerAllLUPath)currentChildren[3], (Robj_interface_BASICVerAllLUPath)prevChildren[3]);
    }

    private void CompareAllLUPathBranch(Robj_interface_BASICVerAllLUPath current, Robj_interface_BASICVerAllLUPath prior) {
        if (current.getNVer() != prior.getNVer() || current.getNSummaryVer() != prior.getNSummaryVer()) {
            mLogger.info("Detected change in ALLLUPath version");
            Robj_interface_BASICVerLUPathPerPort[] currentPaths = (Robj_interface_BASICVerLUPathPerPort[])current.getObjChildren();
            Robj_interface_BASICVerLUPathPerPort[] priorPaths = (Robj_interface_BASICVerLUPathPerPort[])prior.getObjChildren();
            this.ComparePathPerPort(currentPaths, priorPaths);
        }
    }

    private void ComparePathPerPort(Robj_interface_BASICVerLUPathPerPort[] currentPaths, Robj_interface_BASICVerLUPathPerPort[] priorPaths) {
        ArrayList<Short> addedPorts = new ArrayList<Short>();
        ArrayList<Short> removedPorts = new ArrayList<Short>();
        ArrayList<Short> modifiedPorts = new ArrayList<Short>();
        LinkedList<Short[]> affectedDNs = new LinkedList<Short[]>();
        for (short portID = 0; portID < currentPaths.length; portID = (short)((short)(portID + 1))) {
            if (currentPaths[portID] == null && priorPaths[portID] == null) continue;
            if (currentPaths[portID] == null && priorPaths[portID] != null) {
                removedPorts.add(portID);
                continue;
            }
            if (currentPaths[portID] != null && priorPaths[portID] == null) {
                addedPorts.add(portID);
                continue;
            }
            if (currentPaths[portID].getNVer() == priorPaths[portID].getNVer()) continue;
            modifiedPorts.add(portID);
        }
        if (removedPorts != null && !removedPorts.isEmpty()) {
            this.processRemovedPath(removedPorts, affectedDNs);
            this.processRemovedPGHI(removedPorts);
        }
        if (addedPorts != null && !addedPorts.isEmpty()) {
            this.processAddedPath(addedPorts, affectedDNs);
            this.processAddedPGHI(addedPorts);
        }
        if (modifiedPorts != null && !modifiedPorts.isEmpty()) {
            this.processModifiedPath(modifiedPorts, affectedDNs);
            this.processModifiedPGHI(modifiedPorts);
        }
        if (affectedDNs != null && !affectedDNs.isEmpty()) {
            LDEVBranchChecker.processAffectedDNs(null, affectedDNs, null, this.getSerialNumber());
        }
    }

    private void processAddedPath(List<Short> addedPorts, LinkedList<Short[]> affectedDNs) {
        try {
            Serializable[] paths = LUPathObject.addLUPathToCache(addedPorts, affectedDNs, this.getSerialNumber());
            if (null != paths && paths.length != 0) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LUPATH, (Serializable[])paths);
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying add LUPath(" + addedPorts + ") to " + this.getSerialNumber(), e);
        }
    }

    private void processAddedPGHI(List<Short> addedPorts) {
        try {
            Serializable[] pghis = PortandHostGroupInfo.addPGHIToCache(addedPorts, this.getSerialNumber());
            if (null != pghis && pghis.length != 0) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORTHOSTGROUP, (Serializable[])pghis);
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying add PGHI(" + addedPorts + ") to " + this.getSerialNumber(), e);
        }
    }

    private void processModifiedPath(List<Short> modifiedPorts, LinkedList<Short[]> affectedDNs) {
        try {
            ArrayList<LUPathObject> luPathAdded = new ArrayList<LUPathObject>();
            ArrayList<LUPathObject> luPathRemoved = new ArrayList<LUPathObject>();
            LUPathObject.modifyCachedLUPath(modifiedPorts, luPathAdded, luPathRemoved, affectedDNs, this.getSerialNumber());
            if (null != luPathAdded && !luPathAdded.isEmpty()) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LUPATH, (Serializable[])luPathAdded.toArray(new LUPathObject[luPathAdded.size()]));
            }
            if (null != luPathRemoved && !luPathRemoved.isEmpty()) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LUPATH, (Serializable[])luPathRemoved.toArray(new LUPathObject[luPathRemoved.size()]));
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying remove LUPath from " + this.getSerialNumber(), e);
        }
    }

    private void processModifiedPGHI(List<Short> modifiedPorts) {
        try {
            ArrayList<PortandHostGroupInfo> hostGrpAdded = new ArrayList<PortandHostGroupInfo>();
            ArrayList<PortandHostGroupInfo> hostGrpRemoved = new ArrayList<PortandHostGroupInfo>();
            ArrayList<PortandHostGroupInfo> hostGrpModified = new ArrayList<PortandHostGroupInfo>();
            PortandHostGroupInfo.modifyCachedPHGI(modifiedPorts, hostGrpAdded, hostGrpRemoved, hostGrpModified, this.getSerialNumber());
            if (null != hostGrpModified && !hostGrpModified.isEmpty()) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORTHOSTGROUP, (Serializable[])hostGrpModified.toArray(new PortandHostGroupInfo[hostGrpModified.size()]));
            }
            if (null != hostGrpAdded && !hostGrpAdded.isEmpty()) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORTHOSTGROUP, (Serializable[])hostGrpAdded.toArray(new PortandHostGroupInfo[hostGrpAdded.size()]));
            }
            if (null != hostGrpRemoved && !hostGrpRemoved.isEmpty()) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORTHOSTGROUP, (Serializable[])hostGrpRemoved.toArray(new PortandHostGroupInfo[hostGrpRemoved.size()]));
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying remove LUPath from " + this.getSerialNumber(), e);
        }
    }

    private void processRemovedPath(List<Short> removedPorts, LinkedList<Short[]> affectedDNs) {
        try {
            Serializable[] paths = LUPathObject.removeLUPathFromCache(removedPorts, affectedDNs, this.getSerialNumber());
            if (null != paths && paths.length != 0) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LUPATH, (Serializable[])paths);
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying remove LUPath(" + removedPorts + ") from " + this.getSerialNumber(), e);
        }
    }

    private void processRemovedPGHI(List<Short> removedPorts) {
        try {
            Serializable[] pghis = PortandHostGroupInfo.removePGHIFromCache(removedPorts, this.getSerialNumber());
            if (null != pghis && pghis.length != 0) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORTHOSTGROUP, (Serializable[])pghis);
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying remove PGHI(" + removedPorts + ") from cache.", e);
        }
    }

    @Override
    public void RSGUpdated(ResourceGroupInfo.SearchType type, TreeSet<String> addedElements, TreeSet<String> removedElements) {
        int aSize = addedElements.size();
        int rSize = removedElements.size();
        ArrayList<Short> changed = new ArrayList<Short>((int)((double)(rSize + aSize) * 1.5));
        for (String tStr : addedElements) {
            try {
                int colon = tStr.indexOf(58);
                changed.add(Short.parseShort(tStr.substring(0, colon)));
            }
            catch (NumberFormatException nfe) {
                mLogger.log(Level.SEVERE, nfe + " converting " + tStr, nfe);
            }
        }
        for (String tStr : removedElements) {
            try {
                int colon = tStr.indexOf(58);
                changed.add(Short.parseShort(tStr.substring(0, colon)));
            }
            catch (NumberFormatException nfe) {
                mLogger.log(Level.SEVERE, nfe + " converting " + tStr, nfe);
            }
        }
        this.processModifiedPGHI(changed);
    }
}

