/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.PairInfo;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.SnapshotInfo2;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_SIVerAllPair;
import sanproject.common.Robj_interface_SIVerPairPerCU;
import sanproject.common.Robj_interface_VerLeaf;
import sanproject.serverux.data.SANRmiException;

public class LocalCopyBranchChecker
extends AbstractVersionChecker {
    protected LocalCopyBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.LOCAL_COPY, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        Robj_interface_SIVerAllPair current = (Robj_interface_SIVerAllPair)currentChildren[0];
        Robj_interface_SIVerAllPair prev = (Robj_interface_SIVerAllPair)prevChildren[0];
        if (current.getNVer() != prev.getNVer() || prev.getNSummaryVer() != current.getNSummaryVer()) {
            mLogger.info("Change detected in LOCAL COPY ALL branch");
            this.versionChangeChecker(current.getObjChildren(), prev.getObjChildren());
        }
    }

    private Robj_interface_RJiLDEVIndex[] getLDEVIndexArrayFromChangedCUs(Set<Short> changedCUs) throws WBEMException, RemoteException, SANRmiException {
        RMIObjectCache objCache = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber()).getRMIObject();
        Robj_interface_RJiCUIndex[] cuIdxArray = new Robj_interface_RJiCUIndex[changedCUs.size()];
        int index = 0;
        for (short cuNumber : changedCUs) {
            cuIdxArray[index] = (Robj_interface_RJiCUIndex)objCache.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJICUINDEX);
            cuIdxArray[index].setSLDKC((short)0);
            cuIdxArray[index].setSCU(cuNumber);
            ++index;
        }
        return objCache.getLDEVIndex(cuIdxArray);
    }

    private void versionChangeChecker(Robj_interface_VerLeaf[] current, Robj_interface_VerLeaf[] previous) {
        Robj_interface_SIVerPairPerCU[] currentPerCU = (Robj_interface_SIVerPairPerCU[])current;
        Robj_interface_SIVerPairPerCU[] previousPerCU = (Robj_interface_SIVerPairPerCU[])previous;
        HashSet<Short> changedCUs = new HashSet<Short>();
        for (short cuNumber = 0; cuNumber < currentPerCU.length; cuNumber = (short)((short)(cuNumber + 1))) {
            Robj_interface_SIVerPairPerCU curVal = currentPerCU[cuNumber];
            Robj_interface_SIVerPairPerCU prevVal = previousPerCU[cuNumber];
            if (curVal == null && prevVal == null) continue;
            if (curVal != null && prevVal == null) {
                mLogger.info("CU, " + cuNumber + ", has had ALL Pair Info added");
                changedCUs.add(cuNumber);
                continue;
            }
            if (curVal == null & prevVal != null) {
                mLogger.info("CU, " + cuNumber + ", has had ALL Pair Info removed");
                changedCUs.add(cuNumber);
                continue;
            }
            if (curVal.getNVer() == prevVal.getNVer()) continue;
            mLogger.info("CU " + cuNumber + " has had Pair Info modified");
            changedCUs.add(cuNumber);
        }
        if (!changedCUs.isEmpty()) {
            try {
                Robj_interface_RJiLDEVIndex[] ldevIdxArray = this.getLDEVIndexArrayFromChangedCUs(changedCUs);
                PairInfo.modifyCache(ldevIdxArray, this.getSerialNumber());
                ArrayList<SnapshotInfo2> addedSIs = new ArrayList<SnapshotInfo2>();
                ArrayList<SnapshotInfo2> removedSIs = new ArrayList<SnapshotInfo2>();
                ArrayList<SnapshotInfo2> modifiedSIs = new ArrayList<SnapshotInfo2>();
                SnapshotInfo2.modifyCache(ldevIdxArray, changedCUs, addedSIs, modifiedSIs, removedSIs, this.getSerialNumber());
                if (null != modifiedSIs && !modifiedSIs.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.SNAPSHOT, (Serializable[])modifiedSIs.toArray(new SnapshotInfo2[modifiedSIs.size()]));
                }
                if (null != addedSIs && !addedSIs.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.SNAPSHOT, (Serializable[])addedSIs.toArray(new SnapshotInfo2[addedSIs.size()]));
                }
                if (null != removedSIs && !removedSIs.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.SNAPSHOT, (Serializable[])removedSIs.toArray(new SnapshotInfo2[removedSIs.size()]));
                }
            }
            catch (SANRmiException sre) {
                mLogger.log(Level.SEVERE, "RMI error while updating SnapshotInfo2: " + sre.getErrMsgEn(), sre);
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "Exception while updating SnapshotInfo2", e);
            }
        }
    }
}

