/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.HitachiTraceFormatter;
import com.ws.wbem.jserver.JServerTraceProperties;
import java.io.File;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceManager {
    private static final Integer NUMFILES = 10;
    private static final Integer FILESIZE = 256000;
    private static final String LOGEXT = ".log";

    TraceManager(String loggerName, String logFileNamePrefix) {
        try {
            String pDir = JServerTraceProperties.getLogFileDirectory();
            String pNumFiles = JServerTraceProperties.getNumberOfLogs();
            String pFileSize = JServerTraceProperties.getMaxLogFileSize();
            Level pLevel = JServerTraceProperties.getLogLevel();
            int numFiles = NUMFILES;
            int fileSize = FILESIZE;
            if (null != pNumFiles) {
                try {
                    numFiles = new Integer(pNumFiles);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (null != pFileSize) {
                try {
                    fileSize = new Integer(pFileSize);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            Logger mLog = Logger.getLogger(loggerName);
            mLog.setUseParentHandlers(false);
            String dir = null != pDir ? (pDir.endsWith(File.separator) ? pDir : pDir + File.separator) : "";
            String fileName = dir + logFileNamePrefix + "%g" + LOGEXT;
            FileHandler mLogFileHandle = new FileHandler(fileName, fileSize, numFiles);
            if (null != pLevel) {
                mLog.setLevel(pLevel);
            } else {
                mLog.setLevel(Level.INFO);
            }
            mLogFileHandle.setFormatter(new HitachiTraceFormatter());
            mLog.addHandler(mLogFileHandle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

