/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.client;

import com.hitachi.smi.client.SetProviderStatus;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class TCPPEFileFinder
extends SimpleFileVisitor<Path> {
    private final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:tcppe.properties.*");
    private String tcppeFile = null;

    public String getTcppeFile() {
        return this.tcppeFile;
    }

    void match(Path file) throws IOException {
        block8: {
            Path name = file.getFileName();
            if (null == name) {
                throw new IOException("File name returned null for " + file);
            }
            Path tPath = name.getFileName();
            if (null == tPath) {
                throw new IOException("null returned for file name " + name);
            }
            if (name != null && this.matcher.matches(name)) {
                if (null == this.tcppeFile) {
                    this.tcppeFile = tPath.toString();
                } else {
                    try {
                        String end = this.tcppeFile.substring(this.tcppeFile.lastIndexOf(46) + 1);
                        int currentIdx = Integer.parseInt(end);
                        String thisFile = tPath.toString();
                        end = thisFile.substring(thisFile.lastIndexOf(46) + 1);
                        int newIdx = Integer.parseInt(end);
                        if (newIdx > currentIdx) {
                            this.tcppeFile = thisFile;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Ignoring " + name);
                        if (!SetProviderStatus.DEBUG.booleanValue()) break block8;
                        nfe.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        this.match(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        System.err.println("Ignoring " + file + " due to " + exc);
        if (SetProviderStatus.DEBUG.booleanValue()) {
            exc.printStackTrace();
        }
        return FileVisitResult.CONTINUE;
    }
}

