/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TLSChanger {
    private static final String PROGRAM_FILES_X86 = "ProgramFiles(x86)";
    private static final String SYSWOW64 = "sysWOW64";
    private static final String SYSTEM32 = "system32";
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static String[] fileNames = new String[]{"J_Server_start.bat"};
    private static String searchText = "-Dhttps.protocols=";
    private static String TLSvString = "TLSv1";
    private static boolean TLS1 = false;
    private static boolean TLS11 = false;
    private static boolean TLS12 = false;

    private static String addSystemDirectory(String fileName) {
        String ret;
        if (fileName.charAt(0) == '*') {
            String windir = System.getenv("windir");
            ret = String.format("%s\\%s\\%s", windir, null != System.getenv(PROGRAM_FILES_X86) ? SYSWOW64 : SYSTEM32, fileName.substring(1));
        } else {
            ret = fileName;
        }
        return ret;
    }

    private static String createProtocolLine(int idx, String line2Parse) {
        boolean needComma = false;
        int endIdx = line2Parse.indexOf(SPACE, idx);
        String afterProtocols = -1 != endIdx ? line2Parse.substring(endIdx) : null;
        StringBuilder temp = new StringBuilder(line2Parse.subSequence(0, idx));
        temp = temp.append(searchText);
        if (TLS12) {
            temp = temp.append(TLSvString + ".2");
            needComma = true;
        }
        if (TLS11) {
            if (needComma) {
                temp = temp.append(COMMA);
            } else {
                needComma = true;
            }
            temp = temp.append(TLSvString + ".1");
        }
        if (TLS1) {
            if (needComma) {
                temp = temp.append(COMMA);
            }
            temp = temp.append(TLSvString);
        }
        if (null != afterProtocols) {
            temp = temp.append(afterProtocols);
        }
        return temp.toString();
    }

    private static File getFileHandle(String fileName) {
        File ret = new File(fileName);
        if (!ret.exists() || ret.isDirectory()) {
            System.err.println(ret.toString());
            ret = null;
        } else if (!ret.canWrite()) {
            System.err.println("Can not open " + fileName + " for writing.");
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Please pass TLS version info on command line");
            System.exit(1);
        }
        for (String arg : args) {
            if (arg.equalsIgnoreCase("1.0")) {
                TLS1 = true;
                continue;
            }
            if (arg.equalsIgnoreCase("1.1")) {
                TLS11 = true;
                continue;
            }
            if (!arg.equalsIgnoreCase("1.2")) continue;
            TLS12 = true;
        }
        if (!(TLS1 || TLS11 || TLS12)) {
            System.err.println("Must specify at least 1 TLS version");
            System.exit(2);
        }
        int ret = 0;
        int x = 0;
        try {
            for (x = 0; x < fileNames.length && 0 == ret; ++x) {
                StringBuilder fileText;
                String fileName = TLSChanger.addSystemDirectory(fileNames[x]);
                File file = TLSChanger.getFileHandle(fileName);
                ret = TLSChanger.readFile(file, fileText = new StringBuilder());
                if (0 != ret) continue;
                ret = TLSChanger.writeFile(file, fileText.toString());
            }
            ret = 0 == ret ? 0 : ret + x * 10;
        }
        catch (Throwable t) {
            t.printStackTrace();
            ret = x == 0 ? (0 == ret ? -3 : ret) : 10;
        }
        finally {
            System.exit(ret);
        }
    }

    private static int readFile(File file, StringBuilder contents) {
        int ret = 0;
        if (null != file) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while (null != (line = br.readLine())) {
                    int idx = line.indexOf(searchText);
                    if (-1 != idx) {
                        line = TLSChanger.createProtocolLine(idx, line);
                    }
                    contents.append(line);
                    contents.append(System.lineSeparator());
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e.toString());
                ret = 3;
            }
            catch (IOException e) {
                System.err.println("Error reading from  " + file.getName() + System.lineSeparator() + e);
                ret = 4;
            }
        } else {
            System.err.println("File parameter is null!");
            ret = 2;
        }
        return ret;
    }

    private static int writeFile(File file, String contents) {
        int ret = 0;
        try (FileWriter fw = new FileWriter(file);){
            fw.write(contents);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            ret = 5;
        }
        return ret;
    }
}

