/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ThinPool;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public class DedupInfo {
    private static final String VVO_LREAD_USED_CAPACITY_OF_POOLS = "VVOLreadUsedCapacityOfPools";
    private static final String POOLS = "Pools";
    private final ThinPool thePool;
    private final long vvolUsedTotalCapacity;
    private final long fmcExPreSavingCapacity;
    private final long fmcExPostSavingCapacity;
    private final long dkcPreSavingCapacity;
    private final long dedupSavingCapacity;
    private final long dkcCompSavingCapacity;
    private final long vvolUsedTotalCapacityAfterDKCSaving;

    public DedupInfo(RMIObjectCache rmiObj, ThinPool tp) throws WBEMException {
        try {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.fine("getting SanRemote object");
            SanRemote sanRemote = rmiObj.keyValueAPI_GetSanRemote();
            logger.fine("getting general parameter object");
            SanData generalParam = rmiObj.keyValueAPI_GetStorageInfoParam(sanRemote, "127.0.0.1");
            rmiObj.addAccountInfo(generalParam);
            logger.fine("getting new request object");
            SanRequest sanRequest = sanRemote.newRequest(generalParam, VVO_LREAD_USED_CAPACITY_OF_POOLS);
            logger.fine("adding list");
            SanList list = sanRequest.newList(POOLS);
            logger.log(Level.FINE, "Adding id {0}", tp.getPoolID());
            SanObject id = list.addObj();
            id.putInt("Id", (int)tp.getPoolID());
            SanResponse responseData = rmiObj.keyValueAPI_Invoke(VVO_LREAD_USED_CAPACITY_OF_POOLS, sanRemote, generalParam, sanRequest, true);
            SanList pools = responseData.getList(POOLS);
            SanObject pool = pools.getObj(0);
            this.thePool = tp;
            this.dedupSavingCapacity = pool.getLong("DedupSavingCapacity");
            this.dkcCompSavingCapacity = pool.getLong("DkcCompSavingCapacity");
            this.dkcPreSavingCapacity = pool.getLong("DkcPreSavingCapacity");
            this.fmcExPostSavingCapacity = pool.getLong("FmcExPostSavingCapacity");
            this.fmcExPreSavingCapacity = pool.getLong("FmcExPreSavingCapacity");
            this.vvolUsedTotalCapacity = pool.getLong("VvolUsedTotalCapacity");
            this.vvolUsedTotalCapacityAfterDKCSaving = pool.getLong("VvolUsedTotalCapacityAfterDkcSaving");
        }
        catch (SanDataException | SanRmiException | NotBoundException | RemoteException e) {
            throw new WBEMException(1, "Error calling key/value API", null, e);
        }
    }

    public int getCompressionPercent() {
        int ret;
        if (this.vvolUsedTotalCapacity <= 0L) {
            ret = 0;
        } else {
            long fmcSavingCapacity = this.fmcExPreSavingCapacity - this.fmcExPostSavingCapacity;
            long poolUsedCapacity = this.thePool.getPoolUsedPages() * this.thePool.getPageSize() * 2L;
            long fmcSavingCapacityEx = poolUsedCapacity <= this.vvolUsedTotalCapacityAfterDKCSaving ? fmcSavingCapacity : fmcSavingCapacity * (this.vvolUsedTotalCapacityAfterDKCSaving * 1000L / poolUsedCapacity) / 1000L;
            long compSavingCapacity = this.dkcCompSavingCapacity + fmcSavingCapacityEx;
            double compression = (double)compSavingCapacity * 100.0 / (double)this.vvolUsedTotalCapacity;
            ret = compression < 1.0 && compression > 0.0 ? 1 : (compression < 101.0 && compression > 100.0 ? 101 : (int)compression);
        }
        return ret;
    }

    public int getDedupPercent() {
        double deDup;
        int ret = this.vvolUsedTotalCapacity <= 0L ? 0 : ((deDup = (double)this.dedupSavingCapacity * 100.0 / (double)this.vvolUsedTotalCapacity) < 1.0 && deDup > 0.0 ? 1 : (deDup < 101.0 && deDup > 100.0 ? 101 : (int)deDup));
        return ret;
    }

    public long getDedupSavingCapacity() {
        return this.dedupSavingCapacity;
    }

    public long getDkcCompSavingCapacity() {
        return this.dkcCompSavingCapacity;
    }

    public long getDkcPreSavingCapacity() {
        return this.dkcPreSavingCapacity;
    }

    public long getFmcExPostSavingCapacity() {
        return this.fmcExPostSavingCapacity;
    }

    public long getFmcExPreSavingCapacity() {
        return this.fmcExPreSavingCapacity;
    }

    public ThinPool getThePool() {
        return this.thePool;
    }

    public long getVvolUsedTotalCapacity() {
        return this.vvolUsedTotalCapacity;
    }

    public long getVvolUsedTotalCapacityAfterDKCSaving() {
        return this.vvolUsedTotalCapacityAfterDKCSaving;
    }
}

