/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.ISCSIreadPortNetworkConditions;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.hitachi.smi.paralleltasker.Wait4ProcessTasks;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.common.Robj_interface_RJiPortInfoDetailEx;

public class FCPort
extends AbstractBaseCommonObject {
    private static final long serialVersionUID = 1L;
    private static final UnsignedInteger64 UINT64_10625 = new UnsignedInteger64("1062500000");
    private static final UnsignedInteger64 UINT64_21250 = new UnsignedInteger64("2125000000");
    private static final UnsignedInteger64 UINT64_42500 = new UnsignedInteger64("4250000000");
    private static final UnsignedInteger64 UINT64_85000 = new UnsignedInteger64("8500000000");
    private static final UnsignedInteger64 UINT64_10Gps = new UnsignedInteger64("10518750000");
    private static final UnsignedInteger64 UINT64_16Gps = new UnsignedInteger64("14025000000");
    private static final UnsignedInteger64 UINT64_32Gps = new UnsignedInteger64("28500000000");
    private static final String[][] CRTLID_DISPLAY_NAMES_S_MODEL = new String[][]{{"CL1-A", "CL3-A", "CL5-A", "CL7-A"}, {"CL1-B", "CL3-B", "CL5-B", "CL7-B"}, {"CL2-A", "CL4-A", "CL6-A", "CL8-A"}, {"CL2-B", "CL4-B", "CL6-B", "CL8-B"}};
    private static final String[][] CRTLID_DISPLAY_NAMES_M_MODEL = new String[][]{{"CL1-A", "CL3-A", "CL5-A", "CL7-A"}, {"CL1-B", "CL3-B", "CL5-B", "CL7-B"}, {"CL1-C", "CL3-C", "CL5-C", "CL7-C"}, {"CL1-D", "CL3-D", "CL5-D", "CL7-D"}, {"CL1-E", "CL3-E", "CL5-E", "CL7-E"}, {"CL1-F", "CL3-F", "CL5-F", "CL7-F"}, {"CL1-G", "CL3-G", "CL5-G", "CL7-G"}, {"CL1-H", "CL3-H", "CL5-H", "CL7-H"}, {"CL2-A", "CL4-A", "CL6-A", "CL8-A"}, {"CL2-B", "CL4-B", "CL6-B", "CL8-B"}, {"CL2-C", "CL4-C", "CL6-C", "CL8-C"}, {"CL2-D", "CL4-D", "CL6-D", "CL8-D"}, {"CL2-E", "CL4-E", "CL6-E", "CL8-E"}, {"CL2-F", "CL4-F", "CL6-F", "CL8-F"}, {"CL2-G", "CL4-G", "CL6-G", "CL8-G"}, {"CL2-H", "CL4-H", "CL6-H", "CL8-H"}};
    private static final String[][] CRTLID_DISPLAY_NAMES_H_MODEL = new String[][]{{"CL1-A", "CL3-A", "CL5-A", "CL7-A"}, {"CL1-B", "CL3-B", "CL5-B", "CL7-B"}, {"CL1-C", "CL3-C", "CL5-C", "CL7-C"}, {"CL1-D", "CL3-D", "CL5-D", "CL7-D"}, {"CL1-E", "CL3-E", "CL5-E", "CL7-E"}, {"CL1-F", "CL3-F", "CL5-F", "CL7-F"}, {"CL1-G", "CL3-G", "CL5-G", "CL7-G"}, {"CL1-H", "CL3-H", "CL5-H", "CL7-H"}, {"CL1-J", "CL3-J", "CL5-J", "CL7-J"}, {"CL1-K", "CL3-K", "CL5-K", "CL7-K"}, {"CL1-L", "CL3-L", "CL5-L", "CL7-L"}, {"CL1-M", "CL3-M", "CL5-M", "CL7-M"}, {"CL1-N", "CL3-N", "CL5-N", "CL7-N"}, {"CL1-P", "CL3-P", "CL5-P", "CL7-P"}, {"CL1-Q", "CL3-Q", "CL5-Q", "CL7-Q"}, {"CL1-R", "CL3-R", "CL5-R", "CL7-R"}, {"CL2-A", "CL4-A", "CL6-A", "CL8-A"}, {"CL2-B", "CL4-B", "CL6-B", "CL8-B"}, {"CL2-C", "CL4-C", "CL6-C", "CL8-C"}, {"CL2-D", "CL4-D", "CL6-D", "CL8-D"}, {"CL2-E", "CL4-E", "CL6-E", "CL8-E"}, {"CL2-F", "CL4-F", "CL6-F", "CL8-F"}, {"CL2-G", "CL4-G", "CL6-G", "CL8-G"}, {"CL2-H", "CL4-H", "CL6-H", "CL8-H"}, {"CL2-J", "CL4-J", "CL6-J", "CL8-J"}, {"CL2-K", "CL4-K", "CL6-K", "CL8-K"}, {"CL2-L", "CL4-L", "CL6-L", "CL8-L"}, {"CL2-M", "CL4-M", "CL6-M", "CL8-M"}, {"CL2-N", "CL4-N", "CL6-N", "CL8-N"}, {"CL2-P", "CL4-P", "CL6-P", "CL8-P"}, {"CL2-Q", "CL4-Q", "CL6-Q", "CL8-Q"}, {"CL2-R", "CL4-R", "CL6-R", "CL8-R"}};
    private static volatile Map<String, Short> mCtrlIDDisplayNamesHash = new HashMap<String, Short>();
    private static final Map<String, String> mPortNumHash = new HashMap<String, String>();
    private static Class<FCPort[]> clz = FCPort[].class;
    private byte mByDKCChannelSpeed;
    private byte mByPortFibreTopology;
    private byte mByPortKindNo;
    private byte[] mByPortWWN;
    private byte mByUserChannelSpeed;
    private short mPort;
    private short mPortFibreAddress;
    private short mSslpr;
    private String mStrPortKindName;
    private boolean mPortSecuritySwitch;
    private String mStrPortDisplayName;
    private short mControlID;
    private String mPortWWN;
    Hashtable<Short, Byte> mPortKindHash;
    private UnsignedInteger64 mPortSpeed;
    private UnsignedInteger16 mPortRole;
    private UnsignedInteger16 mPortRestriction;
    private UnsignedInteger16 mPortType;
    private UnsignedInteger16 mElementType;
    private String dkcEmulation;
    private volatile ISCSIreadPortNetworkConditions mIscsiInfo;

    public static FCPort[] addFCPortToCache(List<Short> addedPortIDs, String serialNum) {
        ArrayList<FCPort> ret = new ArrayList<FCPort>(addedPortIDs.size());
        try {
            Collections.sort(addedPortIDs);
            ClosableAddableIteratorCB<FCPort> callback = new ClosableAddableIteratorCB<FCPort>();
            FCPort.getUnCachedFCPorts(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), callback, false, true, null, null, null);
            CloseableAddableIterator<FCPort> backEndPortIter = callback.getWrappedCloseableAddableIter();
            HashMap<String, List<FCPort>> pathMap = new HashMap<String, List<FCPort>>(addedPortIDs.size());
            while (!addedPortIDs.isEmpty() && backEndPortIter.hasNext()) {
                FCPort backEndPort = (FCPort)backEndPortIter.next();
                int index = Collections.binarySearch(addedPortIDs, backEndPort.getPort());
                if (index < 0) continue;
                addedPortIDs.remove(index);
                ret.add(backEndPort);
                FCPort.addPathToMap(pathMap, backEndPort);
            }
            if (!backEndPortIter.isDone()) {
                backEndPortIter.done();
            }
            CacheLib.addDataToCache(pathMap, ret, clz, serialNum);
            if (addedPortIDs.size() > 0) {
                cacheLogger.log(Level.SEVERE, "Port IDs {0} where suppose to be added to {1} but they were not found", new Object[]{addedPortIDs, serialNum});
            }
        }
        catch (WBEMException we) {
            cacheLogger.log(Level.SEVERE, "Exception trying to get added FCPort from " + serialNum, we);
        }
        catch (Throwable t) {
            cacheLogger.log(Level.SEVERE, "Unexpected exception adding ports from " + serialNum, t);
        }
        cacheLogger.log(Level.INFO, "Done adding {0}  FCPorts on {1}", new Object[]{ret.size(), serialNum});
        return ret.toArray(new FCPort[ret.size()]);
    }

    private static void addPathToMap(HashMap<String, List<FCPort>> pathMap, FCPort port) throws WBEMException {
        String key = CacheLib.getPortWWNString(port.getPortWWN());
        CacheLib.addToMap(pathMap, key, port);
        String ctrlKey = CacheLib.getPortCtrlIDString(port.getControlID());
        CacheLib.addToMap(pathMap, key + ctrlKey, port);
        CacheLib.addToMap(pathMap, ctrlKey, port);
        key = CacheLib.getPortString(port.getPort());
        CacheLib.addToMap(pathMap, key, port);
        CacheLib.addToMap(pathMap, ctrlKey + key, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping device) throws WBEMException {
        Class<FCPort[]> clz;
        final RMIObjectCache rmiObj = device.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz = FCPort[].class)) {
            Class<FCPort> clazz = FCPort.class;
            synchronized (FCPort.class) {
                if (!cache.isCached(clz)) {
                    final ClosableAddableIteratorCB callback = new ClosableAddableIteratorCB();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AbstractBaseCommonObject.cacheLogger.info("FCPort processor starting");
                                FCPort.getUnCachedFCPorts(rmiObj, callback, false, true, null, null, null);
                            }
                            catch (WBEMException e) {
                                callback.exceptionOccurred(e);
                            }
                            catch (Throwable e) {
                                WBEMException we = new WBEMException(1, e.toString(), null, e);
                                callback.exceptionOccurred(we);
                            }
                            AbstractBaseCommonObject.cacheLogger.info("FCPort processor exiting");
                        }
                    };
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    t.setName("FCPort Processor");
                    t.start();
                    CloseableAddableIterator portIter = callback.getWrappedCloseableAddableIter();
                    HashMap<String, List<FCPort>> portMap = new HashMap<String, List<FCPort>>();
                    ArrayList<FCPort> ports = new ArrayList<FCPort>(36);
                    while (portIter.hasNext()) {
                        FCPort port = (FCPort)portIter.next();
                        ports.add(port);
                        FCPort.addPathToMap(portMap, port);
                    }
                    CacheLib.addDataToCache(portMap, ports, clz, device.getSerialNumber());
                } else {
                    cacheLogger.log(Level.WARNING, "FCPorts were cached on {0}", device.getSerialNumber());
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else {
            cacheLogger.log(Level.WARNING, "FCPort is already in the cache {0}", device.getSerialNumber());
        }
    }

    public static FCPort find(short expSPort, PortTypeRequested requestedType, RMIObjectCache rmiObj) throws WBEMException {
        FCPort ret = null;
        if (null == rmiObj) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        try {
            FindMethodCallbackHandler<FCPort> callback = new FindMethodCallbackHandler<FCPort>();
            FCPort.getFCPorts(rmiObj, callback, false, true, null, null, new Short(expSPort));
            ret = callback.getReturnValue();
            if (null != ret && !ret.isRequestedType(requestedType)) {
                ret = null;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    public static FCPort find(String fcPortWWN, PortTypeRequested requestedType, RMIObjectCache rmiObj) throws WBEMException {
        FCPort ret = null;
        if (null == rmiObj) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        if (fcPortWWN != null && fcPortWWN.length() > 0) {
            try {
                FindMethodCallbackHandler<FCPort> callback = new FindMethodCallbackHandler<FCPort>();
                FCPort.getFCPorts(rmiObj, callback, false, true, fcPortWWN, null, null);
                ret = callback.getReturnValue();
                if (null == ret || !ret.isRequestedType(requestedType)) {
                    ret = null;
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable e) {
                throw new WBEMException(1, e.toString(), null, e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getCtrlID(short portID, String serialNumber) throws WBEMException {
        Short ctrlID;
        Map<String, String> map = mPortNumHash;
        synchronized (map) {
            if (mPortNumHash.isEmpty()) {
                CommonClassAsList<FCPort> callback = new CommonClassAsList<FCPort>();
                FCPort.getUnCachedFCPorts(RMIObjectMapping.getRMIObjectMapping(serialNumber).getRMIObject(), callback, false, true, null, null, null);
                callback = null;
            }
        }
        String displayName = mPortNumHash.get(serialNumber + "." + portID);
        if (null != displayName && null != (ctrlID = FCPort.getCtrlIdDisplaynamesHash(serialNumber).get(displayName))) {
            return ctrlID;
        }
        throw new WBEMException("Could not find FCPort with CtrlID: " + portID + " on device " + serialNumber);
    }

    protected static short getCtrlID(String portDisplayName, String serialNumber) throws IllegalArgumentException {
        Short ctrVal;
        try {
            ctrVal = FCPort.getCtrlIdDisplaynamesHash(serialNumber).get(portDisplayName);
        }
        catch (WBEMException e) {
            providerLogger.log(Level.SEVERE, "Device, {0}, does not have a control ID for {1}", new Object[]{serialNumber, portDisplayName});
            ctrVal = null;
        }
        if (null != ctrVal) {
            return ctrVal;
        }
        throw new IllegalArgumentException("Could not map port display name \"" + portDisplayName + "\" to a CtrlID value for device: " + serialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, Short> getCtrlIdDisplaynamesHash(String serialNumber) throws WBEMException {
        Map<String, Short> ret = mCtrlIDDisplayNamesHash;
        if (ret.isEmpty()) {
            Map<String, Short> map = mCtrlIDDisplayNamesHash;
            synchronized (map) {
                ret = mCtrlIDDisplayNamesHash;
                if (ret.isEmpty()) {
                    String[][] displayNamesStr;
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
                    if (null == device) {
                        throw new WBEMException("Unable to find RMI device for serial #: " + serialNumber);
                    }
                    device.getRMIObject();
                    String modelName = device.getRMIObject().getSMIHm800ModelName();
                    if (modelName.contains("100") || modelName.contains("200")) {
                        displayNamesStr = CRTLID_DISPLAY_NAMES_S_MODEL;
                    } else if (modelName.contains("400") || modelName.contains("600")) {
                        displayNamesStr = CRTLID_DISPLAY_NAMES_M_MODEL;
                    } else if (modelName.contains("800")) {
                        displayNamesStr = CRTLID_DISPLAY_NAMES_H_MODEL;
                    } else {
                        throw new WBEMException("Invalid model : " + modelName);
                    }
                    for (int i = 0; i < displayNamesStr.length; ++i) {
                        for (int j = 0; j < displayNamesStr[i].length; ++j) {
                            ret.put(displayNamesStr[i][j], new Short((short)i));
                        }
                    }
                }
                mCtrlIDDisplayNamesHash = ret;
            }
        }
        return ret;
    }

    public static void getFCPorts(RMIObjectCache rmiObj, IteratorCallback<FCPort> callback, boolean isObjectPath, boolean hasProperties, String fcPortWWN, String expSysName) throws WBEMException {
        FCPort.getFCPorts(rmiObj, callback, isObjectPath, hasProperties, fcPortWWN, expSysName, null);
    }

    public static void getFCPorts(RMIObjectCache rmiObj, IteratorCallback<FCPort> callback, boolean isObjectPath, boolean hasProperties, String fcPortWWN, String expSysName, Short expSPort) throws WBEMException {
        try {
            RMIObjectMapping rmiMap = rmiObj.getSMISMappingContainer();
            if (expSysName == null || expSysName.startsWith(rmiMap.getStorageSystemName())) {
                HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
                Class<FCPort[]> clz = FCPort[].class;
                String key = null;
                if (cache.isCached(clz)) {
                    AbstractBaseCommonObject[] ports = null;
                    if (fcPortWWN != null && expSysName != null) {
                        String ctrlID = ProviderLibs.getEndString(expSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        key = CacheLib.getPortWWNString(fcPortWWN);
                        key = key + CacheLib.getPortCtrlIDString(Short.parseShort(ctrlID));
                    } else if (fcPortWWN != null) {
                        key = CacheLib.getPortWWNString(fcPortWWN);
                    } else if (expSysName != null && null != expSPort) {
                        String ctrlID = ProviderLibs.getEndString(expSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        key = CacheLib.getPortCtrlIDString(Short.parseShort(ctrlID));
                        key = key + CacheLib.getPortString(expSPort);
                    } else if (expSysName != null) {
                        String ctrlID = ProviderLibs.getEndString(expSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        key = CacheLib.getPortCtrlIDString(Short.parseShort(ctrlID));
                    } else {
                        key = expSPort != null ? CacheLib.getPortString(expSPort) : null;
                    }
                    ports = (FCPort[])cache.getCachedObject(key, clz);
                    if (ports != null) {
                        callback.returnItems(ports);
                    } else {
                        providerLogger.log(Level.WARNING, "Did not find any FCPorts with key {0}, in {1}", new Object[]{key, rmiMap.getSerialNumber()});
                        callback.done();
                    }
                } else {
                    LogRecord record = new LogRecord(Level.WARNING, "FCPort is not cached on {0}, this is a performance issue");
                    record.setParameters(new Object[]{rmiMap.getSerialNumber()});
                    record.setThrown(new Exception(record.getMessage()));
                    cacheLogger.log(record);
                    FCPort.getUnCachedFCPorts(rmiObj, callback, isObjectPath, hasProperties, fcPortWWN, expSysName, expSPort);
                }
            } else {
                callback.done();
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, "Exception getting FCPorts on " + rmiObj.getSMISMappingContainer().getSerialNumber(), null, th);
        }
    }

    private static void getUnCachedFCPorts(RMIObjectCache rmiObj, IteratorCallback<FCPort> callback, boolean isObjectPath, boolean hasProperties, String fcPortWWN, String expSysName, Short expSPort) throws WBEMException {
        try {
            RMIObjectMapping mapping = rmiObj.getSMISMappingContainer();
            if (expSysName == null || expSysName.startsWith(mapping.getStorageSystemName())) {
                Robj_interface_RJiPortInfoDetail[] infoDetails = rmiObj.getPortInfoDetail();
                if (infoDetails.length > 0) {
                    Hashtable<Short, Byte> portKind = ProviderLibs.getPortKindHash(rmiObj);
                    String serial = mapping.getSerialNumber();
                    TaskProcessor task = new TaskProcessor("FCPort - " + serial, infoDetails.length);
                    for (Robj_interface_RJiPortInfoDetail infoDetail : infoDetails) {
                        WorkerThread worker = new WorkerThread(serial, callback, infoDetail, portKind, isObjectPath, hasProperties, task, fcPortWWN, expSysName, expSPort);
                        task.addTask(worker);
                    }
                } else {
                    callback.done();
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Unexpected exception processing FC ports on  " + rmiObj.getSMISMappingContainer().getSerialNumber(), null, e);
        }
    }

    public static FCPort[] modifyFCportInCache(String serialNum, List<Short> modifiedPortIDs, List<Short> removed, List<Short> added) {
        List<FCPort> ret = Collections.synchronizedList(new ArrayList(modifiedPortIDs.size()));
        try {
            FCPort backEndPort;
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            Collections.sort(modifiedPortIDs);
            CommonClassAsList<FCPort> callback = new CommonClassAsList<FCPort>();
            FCPort.getUnCachedFCPorts(rmiObj, callback, false, true, null, null, null);
            LinkedList<FCPort> backEndPorts = callback.getReturnValue();
            callback = null;
            Wait4ProcessTasks task = new Wait4ProcessTasks(backEndPorts.size());
            while ((backEndPort = (FCPort)backEndPorts.poll()) != null) {
                ModifyCacheThread worker = new ModifyCacheThread(modifiedPortIDs, backEndPort, ret, added, task, rmiObj);
                ProcessTask.addTask(worker);
            }
            task.processingDone();
            if (!modifiedPortIDs.isEmpty()) {
                removed.addAll(modifiedPortIDs);
            }
        }
        catch (WBEMException we) {
            cacheLogger.log(Level.SEVERE, "Exception trying to get new FCPort from " + serialNum, we);
        }
        catch (Throwable t) {
            cacheLogger.log(Level.SEVERE, "Unexpected exception modifying ports from " + serialNum, t);
        }
        cacheLogger.log(Level.INFO, "Done processing {0} modified FCPorts on {1}", new Object[]{ret.size(), serialNum});
        return ret.toArray(new FCPort[ret.size()]);
    }

    private static boolean processInfoDetail(String serialNum, IteratorCallback<FCPort> callback, Robj_interface_RJiPortInfoDetail mInfo, Hashtable<Short, Byte> portKindHash, boolean isObjectPath, boolean hasProperties, String fcPortWWN, String expSysName, short expSPort) throws WBEMException {
        boolean ret = true;
        mPortNumHash.put(serialNum + "." + mInfo.getSPort(), mInfo.getStrPortDisplayName());
        String currentPortWWN = ProviderLibs.getHexString(mInfo.getByPortWWN());
        if (fcPortWWN == null || fcPortWWN.compareTo(currentPortWWN) == 0) {
            FCPort item = new FCPort(serialNum, mInfo, portKindHash);
            try {
                if (!ResourceRestriction.isFCPortUsable(item)) {
                    cacheLogger.log(Level.FINE, "Skipping FCPort with WWN {0}", item.getPortWWN());
                    return ret;
                }
            }
            catch (WBEMException we) {
                cacheLogger.log(Level.SEVERE, "Exception finding port, " + item.getPort() + ", resource group, will be allowed", we);
            }
            item.dkcEmulation = ((Robj_interface_RJiPortInfoDetailEx)mInfo).getStrDkcEmulation();
            if (expSysName != null) {
                String end = ProviderLibs.getEndString(expSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                try {
                    if (item.getControlID() == Short.parseShort(end)) {
                        ret = callback.returnItem(item);
                    }
                }
                catch (NumberFormatException nfe) {
                    providerLogger.log(Level.SEVERE, "Invalid expected system name: " + expSysName, nfe);
                }
            } else if (-1 != expSPort) {
                if (expSPort == item.mPort) {
                    ret = callback.returnItem(item);
                }
            } else {
                ret = callback.returnItem(item);
            }
        }
        return ret;
    }

    public static FCPort[] removeFCPortFromCache(List<Short> removedPortIDs, String serialNum) throws WBEMException {
        Serializable[] ret = null;
        try {
            ArrayList<FCPort> removedPorts = new ArrayList<FCPort>(removedPortIDs.size());
            HashMap<String, List<FCPort>> pathMap = new HashMap<String, List<FCPort>>();
            for (Short removedPortID : removedPortIDs) {
                FCPort cached = null;
                try {
                    cached = FCPort.find(removedPortID, PortTypeRequested.ALL, RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject());
                }
                catch (WBEMException we) {
                    cacheLogger.log(Level.SEVERE, "Exception trying to get FCPort (" + removedPortID + ") from " + serialNum, we);
                }
                if (cached == null) continue;
                removedPorts.add(cached);
                FCPort.addPathToMap(pathMap, cached);
            }
            ret = removedPorts.toArray(new FCPort[removedPorts.size()]);
            CacheLib.removeDataFromCache(pathMap, (Serializable[])ret, clz, (String)serialNum);
        }
        catch (Throwable t) {
            cacheLogger.log(Level.SEVERE, "Unexpected exception removing ports from " + serialNum, t);
        }
        cacheLogger.log(Level.INFO, "Done removing {0}  FCPorts on {1}", new Object[]{null == ret ? 0 : ret.length, serialNum});
        return ret;
    }

    public FCPort(FCPort other) throws WBEMException {
        super(other.getSerialNumber());
        this.copyFCPort(other);
    }

    private FCPort(String serialNum, Robj_interface_RJiPortInfoDetail pInfo, Hashtable<Short, Byte> pPortkind) throws WBEMException {
        super(serialNum);
        this.mPort = pInfo.getSPort();
        this.mByDKCChannelSpeed = pInfo.getByDKCChannelSpeed();
        this.mByPortFibreTopology = pInfo.getByPortFibreTopology();
        this.mByPortKindNo = pInfo.getByPortKindNo();
        this.mIscsiInfo = null;
        this.mByPortWWN = pInfo.getByPortWWN();
        this.mPortWWN = ProviderLibs.getHexString(this.mByPortWWN);
        this.mByUserChannelSpeed = pInfo.getByUserChannelSpeed();
        this.mPortFibreAddress = pInfo.getSPortFibreAddress();
        this.mSslpr = pInfo.getSSLPR();
        this.mStrPortKindName = pInfo.getStrPortKindName();
        this.mPortSecuritySwitch = pInfo.isBPortSecuritySwitch();
        this.mStrPortDisplayName = pInfo.getStrPortDisplayName();
        this.mControlID = FCPort.getCtrlID(pInfo.getStrPortDisplayName(), serialNum);
        this.mPortKindHash = pPortkind;
        this.dkcEmulation = ((Robj_interface_RJiPortInfoDetailEx)pInfo).getStrDkcEmulation();
        this.setPortSpeed();
        this.setPortRestrictionRoleType();
        this.setPortType();
    }

    private void copyFCPort(FCPort comp) throws WBEMException {
        this.mByDKCChannelSpeed = comp.getByDKCChannelSpeed();
        this.mByPortFibreTopology = comp.getByPortFibreTopology();
        this.mByPortKindNo = this.getByPortKindNo();
        this.mByUserChannelSpeed = this.getByUserChannelSpeed();
        this.mControlID = comp.mControlID;
        this.mElementType = new UnsignedInteger16(comp.getElementType().intValue());
        this.mPort = comp.getPort();
        this.mPortFibreAddress = comp.getPortFibreAddress();
        this.mPortRestriction = new UnsignedInteger16(comp.getPortRestriction().intValue());
        this.mPortRole = new UnsignedInteger16(comp.getPortRole().intValue());
        this.mPortSecuritySwitch = this.isPortSecuritySwitch();
        this.mPortSpeed = new UnsignedInteger64(BigInteger.valueOf(comp.getPortSpeed().longValue()));
        this.mPortType = new UnsignedInteger16(comp.getPortType().intValue());
        this.mPortWWN = comp.getPortWWN();
        this.mSslpr = comp.getSslpr();
        this.mStrPortDisplayName = comp.getStrPortDisplayName();
        this.mStrPortKindName = comp.getStrPortKindName();
        this.mByPortWWN = comp.getByPortWWN();
        this.dkcEmulation = comp.getDKCEmulation();
        if (this.mPortKindHash == null) {
            this.mPortKindHash = new Hashtable();
        } else {
            this.mPortKindHash.clear();
        }
        Set<Short> keys = comp.mPortKindHash.keySet();
        for (Short key : keys) {
            this.mPortKindHash.put(key, comp.mPortKindHash.get(key));
        }
        this.mIscsiInfo = null != this.mIscsiInfo ? new ISCSIreadPortNetworkConditions(comp.mIscsiInfo) : null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FCPort other = (FCPort)obj;
        if (this.mControlID != other.mControlID) {
            return false;
        }
        if (this.mPort != other.mPort) {
            return false;
        }
        if (this.mIscsiInfo == null ? other.mIscsiInfo != null : !this.mIscsiInfo.equals(other.mIscsiInfo)) {
            return false;
        }
        if (this.dkcEmulation == null ? other.dkcEmulation != null : !this.dkcEmulation.equals(other.dkcEmulation)) {
            return false;
        }
        if (this.mByDKCChannelSpeed != other.mByDKCChannelSpeed) {
            return false;
        }
        if (this.mByPortFibreTopology != other.mByPortFibreTopology) {
            return false;
        }
        if (this.mByPortKindNo != other.mByPortKindNo) {
            return false;
        }
        if (!Arrays.equals(this.mByPortWWN, other.mByPortWWN)) {
            return false;
        }
        if (this.mPortWWN == null ? other.mPortWWN != null : !this.mPortWWN.equals(other.mPortWWN)) {
            return false;
        }
        if (this.mByUserChannelSpeed != other.mByUserChannelSpeed) {
            return false;
        }
        if (this.mElementType == null ? other.mElementType != null : !this.mElementType.equals((Object)other.mElementType)) {
            return false;
        }
        if (this.mPortFibreAddress != other.mPortFibreAddress) {
            return false;
        }
        if (this.mPortRestriction == null ? other.mPortRestriction != null : !this.mPortRestriction.equals((Object)other.mPortRestriction)) {
            return false;
        }
        if (this.mPortRole == null ? other.mPortRole != null : !this.mPortRole.equals((Object)other.mPortRole)) {
            return false;
        }
        if (this.mPortSecuritySwitch != other.mPortSecuritySwitch) {
            return false;
        }
        if (this.mPortSpeed == null ? other.mPortSpeed != null : !this.mPortSpeed.equals((Object)other.mPortSpeed)) {
            return false;
        }
        if (this.mPortType == null ? other.mPortType != null : !this.mPortType.equals((Object)other.mPortType)) {
            return false;
        }
        if (this.mSslpr != other.mSslpr) {
            return false;
        }
        if (this.mStrPortDisplayName == null ? other.mStrPortDisplayName != null : !this.mStrPortDisplayName.equals(other.mStrPortDisplayName)) {
            return false;
        }
        return !(this.mStrPortKindName == null ? other.mStrPortKindName != null : !this.mStrPortKindName.equals(other.mStrPortKindName));
    }

    public byte getByDKCChannelSpeed() {
        return this.mByDKCChannelSpeed;
    }

    public UnsignedInteger64 getByDKCChannelSpeedAsUInt64() {
        return this.getSpeed(this.mByDKCChannelSpeed);
    }

    public byte getByPortFibreTopology() {
        return this.mByPortFibreTopology;
    }

    public byte getByPortKindNo() {
        return this.mByPortKindNo;
    }

    public byte[] getByPortWWN() {
        return this.mByPortWWN;
    }

    public byte getByUserChannelSpeed() {
        return this.mByUserChannelSpeed;
    }

    public short getControlID() {
        return this.mControlID;
    }

    public String getDKCEmulation() {
        return this.dkcEmulation;
    }

    public UnsignedInteger16 getElementType() {
        return this.mElementType;
    }

    public String[] getFabricAndPort() {
        byte fibreTopology = this.getByPortFibreTopology();
        String fabric = "UNKNOWN";
        String connection = "UNKNOWN";
        if (fibreTopology == 1) {
            fabric = "On";
            connection = "FC-AL";
        } else if (fibreTopology == 2) {
            fabric = "Off";
            connection = "FC-AL";
        } else if (fibreTopology == 3) {
            fabric = "On";
            connection = "Point to Point";
        } else if (fibreTopology == 4) {
            fabric = "Off";
            connection = "Point to Point";
        }
        return new String[]{fabric, connection};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISCSIreadPortNetworkConditions getISCSIInfo() throws WBEMException {
        if (null == this.mIscsiInfo && 5 == this.getByPortKindNo()) {
            FCPort fCPort = this;
            synchronized (fCPort) {
                if (null == this.mIscsiInfo) {
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber());
                    RMIObjectCache rmiObj = device.getRMIObject();
                    this.mIscsiInfo = ISCSIreadPortNetworkConditions.find(rmiObj, this.mPort);
                }
            }
        }
        return this.mIscsiInfo;
    }

    public String getOtherPortType() {
        String ret = null;
        if (1 == this.mPortType.intValue()) {
            switch (this.mByPortKindNo) {
                case 1: 
                case 3: 
                case 5: {
                    ret = this.getStrPortKindName();
                    break;
                }
                default: {
                    ret = null;
                }
            }
        }
        return ret;
    }

    public short getPort() {
        return this.mPort;
    }

    public short getPortFibreAddress() {
        return this.mPortFibreAddress;
    }

    public Byte getPortkind() {
        return this.mPortKindHash.get(this.mPort);
    }

    public String getPortKindAsString() {
        String ret;
        Byte kind = this.mPortKindHash.get(this.mPort);
        switch (kind) {
            case 1: {
                ret = "LCP";
                break;
            }
            case 2: {
                ret = "RCP";
                break;
            }
            case 3: {
                ret = "Target";
                break;
            }
            case 4: {
                ret = "RCUTarget";
                break;
            }
            case 5: {
                ret = "Inititiator";
                break;
            }
            case 6: {
                ret = "External";
                break;
            }
            case 7: {
                ret = "HTP";
                break;
            }
            case 8: {
                ret = "FNP";
                break;
            }
            default: {
                ret = "UNKNOWN";
            }
        }
        return ret;
    }

    public UnsignedInteger16 getPortRestriction() {
        return this.mPortRestriction;
    }

    public UnsignedInteger16 getPortRole() {
        return this.mPortRole;
    }

    public UnsignedInteger64 getPortSpeed() {
        return this.mPortSpeed;
    }

    public String getPortSpeedString() {
        String channelSpeed = "UNKNOWN";
        byte speed = this.getByUserChannelSpeed();
        switch (speed) {
            case 1: {
                channelSpeed = "1 Gbps";
                break;
            }
            case 2: {
                channelSpeed = "2 Gbps";
                break;
            }
            case 3: {
                channelSpeed = "Auto";
                break;
            }
            case 4: {
                channelSpeed = "Not Fibre";
                break;
            }
            case 5: {
                channelSpeed = "4 Gbps";
                break;
            }
            case 7: {
                channelSpeed = "8 Gbps";
                break;
            }
            case 10: {
                channelSpeed = "10 Gbps";
                break;
            }
            case 16: {
                channelSpeed = "16Gbps";
                break;
            }
            case 32: {
                channelSpeed = "32Gbps";
                break;
            }
            default: {
                channelSpeed = "UNKNOWN";
            }
        }
        return channelSpeed;
    }

    public UnsignedInteger16 getPortType() {
        return this.mPortType;
    }

    public String getPortWWN() throws WBEMException {
        ISCSIreadPortNetworkConditions tIscsiInfo;
        String ret = this.isRequestedType(PortTypeRequested.OPEN) ? this.mPortWWN : (null != (tIscsiInfo = this.getISCSIInfo()) ? tIscsiInfo.getMacAddressAsString() : "UNKNOWN");
        return ret;
    }

    public String getShortName() {
        int index;
        String ret = null;
        if (null != this.mStrPortDisplayName && (index = this.mStrPortDisplayName.indexOf(45)) > 0 && index < this.mStrPortDisplayName.length() - 1) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.mStrPortDisplayName.charAt(index - 1));
            buf.append(this.mStrPortDisplayName.charAt(index + 1));
            ret = buf.toString();
        }
        return ret;
    }

    private UnsignedInteger64 getSpeed(byte val) {
        UnsignedInteger64 ret = null;
        switch (val) {
            case 1: {
                ret = UINT64_10625;
                break;
            }
            case 2: {
                ret = UINT64_21250;
                break;
            }
            case 3: {
                ret = UINT64_21250;
                break;
            }
            case 4: {
                ret = UINT64_42500;
                break;
            }
            case 5: {
                ret = null;
                break;
            }
            case 7: {
                ret = UINT64_85000;
                break;
            }
            case 10: {
                ret = UINT64_10Gps;
                break;
            }
            case 16: {
                ret = UINT64_16Gps;
                break;
            }
            case 32: {
                ret = UINT64_32Gps;
                break;
            }
            default: {
                providerLogger.log(Level.WARNING, "FCPort ({0}) on {1} has an invalid port speed: {2}", new Object[]{this.getPort(), val, this.getSerialNumber()});
                ret = null;
            }
        }
        return ret;
    }

    public short getSslpr() {
        return this.mSslpr;
    }

    public String getStrPortDisplayName() {
        return this.mStrPortDisplayName;
    }

    public String getStrPortKindName() {
        return this.mStrPortKindName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dkcEmulation == null ? 0 : this.dkcEmulation.hashCode());
        result = 31 * result + this.mByDKCChannelSpeed;
        result = 31 * result + this.mByPortFibreTopology;
        result = 31 * result + this.mByPortKindNo;
        result = 31 * result + Arrays.hashCode(this.mByPortWWN);
        result = 31 * result + this.mByUserChannelSpeed;
        result = 31 * result + this.mControlID;
        result = 31 * result + (this.mElementType == null ? 0 : this.mElementType.hashCode());
        result = 31 * result + (this.mIscsiInfo == null ? 0 : this.mIscsiInfo.hashCode());
        result = 31 * result + this.mPort;
        result = 31 * result + this.mPortFibreAddress;
        result = 31 * result + (this.mPortRestriction == null ? 0 : this.mPortRestriction.hashCode());
        result = 31 * result + (this.mPortRole == null ? 0 : this.mPortRole.hashCode());
        result = 31 * result + (this.mPortSecuritySwitch ? 1231 : 1237);
        result = 31 * result + (this.mPortSpeed == null ? 0 : this.mPortSpeed.hashCode());
        result = 31 * result + (this.mPortType == null ? 0 : this.mPortType.hashCode());
        result = 31 * result + (this.mPortWWN == null ? 0 : this.mPortWWN.hashCode());
        result = 31 * result + this.mSslpr;
        result = 31 * result + (this.mStrPortDisplayName == null ? 0 : this.mStrPortDisplayName.hashCode());
        result = 31 * result + (this.mStrPortKindName == null ? 0 : this.mStrPortKindName.hashCode());
        return result;
    }

    public boolean isPortSecuritySwitch() {
        return this.mPortSecuritySwitch;
    }

    public boolean isRequestedType(PortTypeRequested requestedType) {
        boolean ret;
        byte type = this.getByPortKindNo();
        switch (requestedType) {
            case ALL: {
                ret = true;
                break;
            }
            case OPEN: {
                ret = 2 == type;
                break;
            }
            case iSCSI: {
                ret = 5 == type;
                break;
            }
            default: {
                providerLogger.log(Level.SEVERE, "Unknown requested port type: {0}", type);
                ret = false;
            }
        }
        return ret;
    }

    private boolean isSame(FCPort comp) {
        return this.equals(comp);
    }

    public void setPortFibreAddress(short mPortFibreAddress) {
        this.mPortFibreAddress = mPortFibreAddress;
    }

    private void setPortRestrictionRoleType() {
        if (this.mPortKindHash != null) {
            Byte portKind = this.mPortKindHash.get(this.mPort);
            if (null != portKind) {
                switch (portKind) {
                    case 0: {
                        this.mPortRestriction = this.mPortRole = ProviderConstants.UINT16_ZED;
                        this.mElementType = ProviderConstants.UINT16_32768;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.mPortRestriction = ProviderConstants.UINT16_TWO;
                        this.mPortRole = ProviderConstants.UINT16_THREE;
                        this.mElementType = ProviderConstants.UINT16_SIX;
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.mPortRestriction = ProviderConstants.UINT16_THREE;
                        this.mPortRole = ProviderConstants.UINT16_TWO;
                        this.mElementType = ProviderConstants.UINT16_SEVEN;
                        break;
                    }
                    case 9: {
                        this.mPortRestriction = ProviderConstants.UINT16_FOUR;
                        this.mPortRole = ProviderConstants.UINT16_FOUR;
                        this.mElementType = ProviderConstants.UINT16_32769;
                        break;
                    }
                    default: {
                        providerLogger.log(Level.WARNING, "Unrecoginzed PortKind: {0}", portKind.intValue());
                        this.mPortRestriction = this.mPortRole = ProviderConstants.UINT16_ZED;
                        this.mElementType = ProviderConstants.UINT16_32768;
                    }
                }
            }
        } else {
            providerLogger.log(Level.SEVERE, "PortKindHash is null, defaulting portRestriction & portRole to '0'");
            this.mPortRestriction = ProviderConstants.UINT16_ZED;
        }
    }

    private void setPortSpeed() {
        this.mPortSpeed = this.getSpeed(this.mByUserChannelSpeed);
    }

    private void setPortType() {
        int portType = 0;
        switch (this.mByPortFibreTopology) {
            case 1: 
            case 2: {
                portType = 11;
                break;
            }
            case 3: 
            case 4: {
                portType = 10;
                break;
            }
            case 5: {
                portType = 1;
                break;
            }
            default: {
                cacheLogger.log(Level.SEVERE, "FCPort ({0} has unknown ByPortFibreTopology: {1})", new Object[]{this.getPort(), this.mByPortFibreTopology});
                portType = 0;
            }
        }
        this.mPortType = new UnsignedInteger16(portType);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FCPort [mPort=");
        builder.append(this.mPort);
        builder.append(", mControlID=");
        builder.append(this.mControlID);
        builder.append(", mByPortKindNo=");
        builder.append(this.mByPortKindNo);
        builder.append(", ");
        if (this.mByPortWWN != null) {
            builder.append("mByPortWWN=");
            builder.append(Arrays.toString(this.mByPortWWN));
            builder.append(", ");
        }
        if (this.mPortWWN != null) {
            builder.append("mPortWWN=");
            builder.append(this.mPortWWN);
            builder.append(", ");
        }
        if (this.mPortType != null) {
            builder.append("mPortType=");
            builder.append(this.mPortType);
            builder.append(", ");
        }
        builder.append("mByDKCChannelSpeed=");
        builder.append(this.mByDKCChannelSpeed);
        builder.append(", mByPortFibreTopology=");
        builder.append(this.mByPortFibreTopology);
        builder.append(", mByUserChannelSpeed=");
        builder.append(this.mByUserChannelSpeed);
        builder.append(", mPortFibreAddress=");
        builder.append(this.mPortFibreAddress);
        builder.append(", mSslpr=");
        builder.append(this.mSslpr);
        builder.append(", ");
        if (this.mStrPortKindName != null) {
            builder.append("mStrPortKindName=");
            builder.append(this.mStrPortKindName);
            builder.append(", ");
        }
        builder.append("mPortSecuritySwitch=");
        builder.append(this.mPortSecuritySwitch);
        builder.append(", ");
        if (this.mStrPortDisplayName != null) {
            builder.append("mStrPortDisplayName=");
            builder.append(this.mStrPortDisplayName);
            builder.append(", ");
        }
        if (this.mPortSpeed != null) {
            builder.append("mPortSpeed=");
            builder.append(this.mPortSpeed);
            builder.append(", ");
        }
        if (this.mPortRole != null) {
            builder.append("mPortRole=");
            builder.append(this.mPortRole);
            builder.append(", ");
        }
        if (this.mPortRestriction != null) {
            builder.append("mPortRestriction=");
            builder.append(this.mPortRestriction);
            builder.append(", ");
        }
        if (this.mElementType != null) {
            builder.append("mElementType=");
            builder.append(this.mElementType);
            builder.append(", ");
        }
        if (this.dkcEmulation != null) {
            builder.append("dkcEmulation=");
            builder.append(this.dkcEmulation);
            builder.append(", ");
        }
        if (this.mIscsiInfo != null) {
            builder.append("mIscsiInfo=");
            builder.append(this.mIscsiInfo);
        }
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<FCPort> mCallBack;
        private final Hashtable<Short, Byte> mPortKindHashtable;
        private final Robj_interface_RJiPortInfoDetail mInfo;
        private final boolean hasProperties;
        private final boolean isObjectPath;
        private final TaskProcessor mTheTask;
        private final String fcPortWWN;
        private final String expSysName;
        private final short expSPort;
        private final String mSerialNum;

        public WorkerThread(String serialNum, IteratorCallback<FCPort> callback, Robj_interface_RJiPortInfoDetail pInfo, Hashtable<Short, Byte> portKind, boolean isObjectPath, boolean hasProperties, TaskProcessor theTask, String fcPortWWN, String expSysName, Short expSPort) {
            this.mSerialNum = serialNum;
            this.mCallBack = callback;
            this.mPortKindHashtable = portKind;
            this.mInfo = pInfo;
            this.mTheTask = theTask;
            this.isObjectPath = isObjectPath;
            this.hasProperties = hasProperties;
            this.fcPortWWN = fcPortWWN;
            this.expSysName = expSysName;
            this.expSPort = (short)(expSPort == null ? -1 : (int)expSPort.shortValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = FCPort.processInfoDetail(this.mSerialNum, this.mCallBack, this.mInfo, this.mPortKindHashtable, this.isObjectPath, this.hasProperties, this.fcPortWWN, this.expSysName, this.expSPort))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, "Exception while processing items on " + this.mSerialNum, null, (Throwable)e);
                this.mCallBack.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallBack.done();
                }
            }
        }
    }

    public static enum PortTypeRequested {
        ALL,
        OPEN,
        iSCSI;

    }

    private static class ModifyCacheThread
    implements Task {
        final FCPort backendPort;
        final RMIObjectCache rmiObj;
        final Wait4ProcessTasks theTask;
        final List<FCPort> modifiedPorts;
        final List<Short> potentiallyModifiedPorts;
        private final List<Short> added;

        public ModifyCacheThread(List<Short> potentiallyModifiedPorts, FCPort backendPort, List<FCPort> modifiedPorts, List<Short> added, Wait4ProcessTasks task, RMIObjectCache rmiObj) {
            this.rmiObj = rmiObj;
            this.backendPort = backendPort;
            this.theTask = task;
            this.potentiallyModifiedPorts = potentiallyModifiedPorts;
            this.modifiedPorts = Collections.synchronizedList(modifiedPorts);
            this.added = Collections.synchronizedList(added);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            if (!this.theTask.shouldStop()) {
                try {
                    if (this.findPortInListandRemove()) {
                        FCPort cachedFCPort = FCPort.find(this.backendPort.getPort(), PortTypeRequested.ALL, this.rmiObj);
                        if (cachedFCPort != null) {
                            if (!cachedFCPort.isSame(this.backendPort)) {
                                AbstractBaseCommonObject.cacheLogger.log(Level.INFO, "FCPort ({0}) has been modified, updating {1}.", new Object[]{this.backendPort.getPort(), this.rmiObj.getSMISMappingContainer()});
                                this.modifiedPorts.add(new FCPort(cachedFCPort));
                                cachedFCPort.copyFCPort(this.backendPort);
                            }
                        } else {
                            this.added.add(this.backendPort.getPort());
                        }
                    }
                }
                catch (Throwable t) {
                    AbstractBaseCommonObject.cacheLogger.log(Level.SEVERE, "Exception trying to modify port " + this.backendPort.getPort() + " on " + this.rmiObj.getSMISMappingContainer(), t);
                }
                finally {
                    this.theTask.taskProcessed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findPortInListandRemove() {
            List<Short> list = this.potentiallyModifiedPorts;
            synchronized (list) {
                boolean ret;
                int idx = Collections.binarySearch(this.potentiallyModifiedPorts, this.backendPort.getPort());
                if (idx >= 0) {
                    this.potentiallyModifiedPorts.remove(idx);
                    ret = true;
                } else {
                    ret = false;
                }
                return ret;
            }
        }
    }
}

