/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_RJiPGInfoDetail2;
import sanproject.common.Robj_interface_RJiPGInfoDetail7;
import sanproject.common.Robj_interface_RJiPGInfoDetail_IN;
import sanproject.common.Robj_interface_RJiPGInfoDetail_OUT;
import sanproject.serverux.data.GetRmiException;

public class PGInfo
extends AbstractBaseCommonObject {
    private static Class<PGInfo[]> clzType = PGInfo[].class;
    private static final String PGINFO = "PGINFO:";
    private static final long serialVersionUID = 1L;
    private boolean mAOUVol;
    private boolean mExternalVolume;
    private int mFB4;
    private int mIBaseEmulationType;
    private long mLPDEVSize;
    private long mLPGLBASize;
    private boolean mNormalVolume;
    private int mPG;
    private boolean mQSVvol;
    private int mRaidLevel;
    private short mSCLPR;
    private short mSPDEVCount;
    private short mSSLPR;
    private String mStrHDDType;
    private boolean mVvol;
    private byte mDriveType;
    private byte mProtectionLvl;
    private int mHDDrpm;
    private long lpDevSizeDependOnCE;

    public static PGInfo[] addPGInfoToCache(HashMap<Integer, List<Integer>> added, String serialNum) {
        ArrayList<PGInfo> ret = new ArrayList<PGInfo>();
        try {
            PGInfo pg;
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            CommonClassAsList<PGInfo> callback = new CommonClassAsList<PGInfo>();
            PGInfo.getUnCachedPGInfos(rmiObj, callback, -1, -1);
            LinkedList<PGInfo> pgInfos = callback.getReturnValue();
            callback = null;
            ProviderLibs.sortHashMapList(added);
            while ((pg = (PGInfo)pgInfos.poll()) != null) {
                List<Integer> thePGs = added.get(pg.getFB4());
                if (null == thePGs || Collections.binarySearch(thePGs, pg.getPG()) < 0) continue;
                ret.add(pg);
            }
            HashMap map = PGInfo.addPGInfoToMap(ret);
            CacheLib.addDataToCache(map, ret, clzType, serialNum);
        }
        catch (WBEMException e) {
            cacheLogger.log(Level.SEVERE, "Exception trying to get new PGInfo on " + serialNum, e);
        }
        return ret.toArray(new PGInfo[ret.size()]);
    }

    private static HashMap<String, List<PGInfo>> addPGInfoToMap(List<PGInfo> pgs) {
        HashMap<String, List<PGInfo>> map = new HashMap<String, List<PGInfo>>();
        for (PGInfo pg : pgs) {
            PGInfo.addPGInfoToMap(pg, map);
        }
        return map;
    }

    private static void addPGInfoToMap(PGInfo pg, HashMap<String, List<PGInfo>> map) {
        String key = CacheLib.getFB4PgString(PGINFO, pg.getFB4(), pg.getPG());
        CacheLib.addToMap(map, key, pg);
        key = CacheLib.getCLPRPgString(PGINFO, pg.getSCLPR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clzType)) {
            Class<PGInfo> clazz = PGInfo.class;
            synchronized (PGInfo.class) {
                if (!cache.isCached(clzType)) {
                    ClosableAddableIteratorCB<PGInfo> callback = new ClosableAddableIteratorCB<PGInfo>();
                    PGInfo.getUnCachedPGInfos(rmiObj, callback, -1, -1);
                    CloseableAddableIterator<PGInfo> cbIter = callback.getWrappedCloseableAddableIter();
                    ArrayList<PGInfo> pgs = new ArrayList<PGInfo>();
                    HashMap<String, List<PGInfo>> map = new HashMap<String, List<PGInfo>>();
                    while (cbIter.hasNext()) {
                        PGInfo pg = (PGInfo)cbIter.next();
                        pgs.add(pg);
                        PGInfo.addPGInfoToMap(pg, map);
                    }
                    CacheLib.addDataToCache(map, pgs, clzType, mapping.getSerialNumber());
                } else {
                    cacheLogger.log(Level.WARNING, "PGinfo was cached in ", mapping.getSerialNumber());
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            cacheLogger.log(Level.WARNING, "PGInfo is already cached in ", mapping.getSerialNumber());
        }
    }

    public static PGInfo find(RMIObjectCache rmiObj, int pFB4, int pPG) throws WBEMException {
        if (null == rmiObj) {
            throw new WBEMException(6, "Find operation requires a connection object");
        }
        PGInfo ret = null;
        try {
            FindMethodCallbackHandler<PGInfo> callback = new FindMethodCallbackHandler<PGInfo>();
            PGInfo.getPGInfos(rmiObj, callback, pFB4, pPG, -1);
            ret = callback.getReturnValue();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    public static PGInfo find(String serialNumber, int pFB4, int pPG) throws WBEMException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNumber).getRMIObject();
        return PGInfo.find(rmiObj, pFB4, pPG);
    }

    public static void getPGInfos(RMIObjectCache rmiObj, IteratorCallback<PGInfo> callback) throws WBEMException {
        PGInfo.getPGInfos(rmiObj, callback, -1, -1, -1);
    }

    public static void getPGInfos(RMIObjectCache rmiObj, IteratorCallback<PGInfo> callback, int pFB4, int pPG, int pCLPR) throws WBEMException {
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clzType)) {
            String key = null;
            if (pFB4 != -1 && pPG != -1) {
                key = CacheLib.getFB4PgString(PGINFO, pFB4, pPG);
            } else {
                if (pFB4 != -1 || pPG != -1) {
                    throw new WBEMException(1, "Passed in FB4(" + pFB4 + ") & PG(" + pPG + ") must both have non negative values");
                }
                if (pCLPR != -1) {
                    key = CacheLib.getPGNumberString(pCLPR);
                }
            }
            AbstractBaseCommonObject[] items = (PGInfo[])cache.getCachedObject(key, clzType);
            if (items != null) {
                callback.returnItems(items);
            } else {
                providerLogger.log(Level.WARNING, "Did not find any PGinfo in {0}", rmiObj.getSMISMappingContainer().getSerialNumber());
                callback.done();
            }
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "PGInfo not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            PGInfo.getUnCachedPGInfos(rmiObj, callback, pFB4, pPG);
        }
    }

    private static void getUnCachedPGInfos(RMIObjectCache rmiObj, IteratorCallback<PGInfo> callback, int pFB4, int pPG) throws WBEMException {
        block5: {
            try {
                Robj_interface_RJiPGIndex[] pgIndexes = rmiObj.getPGIndex();
                Robj_interface_RJiPGInfoDetail_IN inObj = (Robj_interface_RJiPGInfoDetail_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.PGINFODETAIL_IN);
                inObj.setRJiPGIndex(pgIndexes);
                Robj_interface_RJiPGInfoDetail_OUT outObj = (Robj_interface_RJiPGInfoDetail_OUT)rmiObj.getCmnData(inObj);
                Robj_interface_RJiPGInfoDetail2[] infoDetails = outObj.getDataObject();
                if (infoDetails.length > 0) {
                    String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
                    TaskProcessor task = new TaskProcessor("PGInfo - " + serialNum, infoDetails.length);
                    for (Robj_interface_RJiPGInfoDetail2 infoDetail : infoDetails) {
                        if (task.shouldStop()) {
                            callback.done();
                            break block5;
                        }
                        WorkerThread worker = new WorkerThread(serialNum, callback, infoDetail, task, pFB4, pPG);
                        task.addTask(worker);
                    }
                    break block5;
                }
                callback.done();
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                callback.exceptionOccurred(we);
                callback.done();
            }
        }
    }

    public static PGInfo[] modifyPGInfoInCache(Map<Integer, List<Integer>> modified, String serialNum) {
        LinkedList<PGInfo> modifiedPGs = new LinkedList<PGInfo>();
        try {
            PGInfo actualPG;
            providerLogger.log(Level.FINER, "Modified map\n{0}", modified);
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            CommonClassAsList<PGInfo> callback = new CommonClassAsList<PGInfo>();
            PGInfo.getUnCachedPGInfos(rmiObj, callback, -1, -1);
            LinkedList<PGInfo> actualPGs = callback.getReturnValue();
            callback = null;
            cacheLogger.log(Level.INFO, "Processing {0} PGinfos that may have been modified on {1}", new Object[]{actualPGs.size(), serialNum});
            while ((actualPG = actualPGs.poll()) != null) {
                List<Integer> list = modified.get(actualPG.getFB4());
                if (list == null || Collections.binarySearch(list, actualPG.getPG()) < 0) continue;
                PGInfo cachedPG = PGInfo.find(serialNum, actualPG.getFB4(), actualPG.getPG());
                if (cachedPG != null && !cachedPG.isSame(actualPG)) {
                    providerLogger.log(Level.FINER, "PG changed\nCache: {0}\nActual: {1}", new Object[]{cachedPG, actualPG});
                    modifiedPGs.add(new PGInfo(cachedPG));
                    cachedPG.copyPGInfo(actualPG);
                    continue;
                }
                cacheLogger.log(Level.FINEST, "PGInfo ({0}, {1}) was marked as possibly modified on {2} but it was not.", new Object[]{actualPG.getFB4(), actualPG.getPG(), serialNum});
            }
            cacheLogger.log(Level.INFO, "Done processing for PGInfos on {0}", serialNum);
        }
        catch (WBEMException we) {
            cacheLogger.log(Level.SEVERE, "Exception trying to get new PGInfo for " + serialNum, we);
        }
        return modifiedPGs.toArray(new PGInfo[modifiedPGs.size()]);
    }

    public static boolean processInfoDetail(String serialNum, IteratorCallback<PGInfo> mCallback, Robj_interface_RJiPGInfoDetail2 mTheVal, int mPFB4, int mPPG) throws WBEMException {
        PGInfo newVal;
        boolean ret = true;
        if ((mPFB4 == -1 && mPPG == -1 || mPFB4 == mTheVal.getIFB4() && mPPG == mTheVal.getIPG()) && ResourceRestriction.isPoolUsable(newVal = new PGInfo(serialNum, mTheVal))) {
            mCallback.returnItem(newVal);
        }
        return true;
    }

    public static PGInfo[] removePGInfoFromCache(HashMap<Integer, List<Integer>> removed, String serialNum) {
        Serializable[] ret = new PGInfo[]{};
        try {
            ArrayList<PGInfo> removedPGs = new ArrayList<PGInfo>();
            HashMap<String, List<PGInfo>> pathMap = new HashMap<String, List<PGInfo>>();
            Set<Integer> keys = removed.keySet();
            for (Integer key : keys) {
                List<Integer> removedList = removed.get(key);
                cacheLogger.log(Level.INFO, "Processing {0} PGInfos with FB4: {1}, to be removed from {0}", new Object[]{removedList.size(), key, serialNum});
                if (removedList != null) {
                    for (Integer pg : removedList) {
                        PGInfo cached = PGInfo.find(serialNum, (int)key, (int)pg);
                        if (null != cached) {
                            PGInfo.addPGInfoToMap(cached, pathMap);
                            removedPGs.add(cached);
                            continue;
                        }
                        cacheLogger.log(Level.INFO, "PGInfo({0}, {1}) was removed but it is not in cache {2}", new Object[]{key, pg, serialNum});
                    }
                }
                cacheLogger.log(Level.INFO, "Done processing updating PGInfo for {0}", serialNum);
            }
            ret = removedPGs.toArray(new PGInfo[removedPGs.size()]);
            CacheLib.removeDataFromCache(pathMap, (Serializable[])ret, clzType, (String)serialNum);
        }
        catch (WBEMException we) {
            cacheLogger.log(Level.SEVERE, "Exception trying to get remove PGInfo from " + serialNum, we);
        }
        return ret;
    }

    public PGInfo(PGInfo other) {
        super(other.getSerialNumber());
        this.copyPGInfo(other);
    }

    private PGInfo(String serialNum, Robj_interface_RJiPGInfoDetail2 mTheVal) {
        super(serialNum);
        this.mFB4 = mTheVal.getIFB4();
        this.mPG = mTheVal.getIPG();
        this.mSCLPR = mTheVal.getSCLPR();
        this.mRaidLevel = mTheVal.getIRaidLevel();
        this.mStrHDDType = mTheVal.getStrHDDType();
        if (this.mStrHDDType != null) {
            this.mStrHDDType = this.mStrHDDType.trim();
        }
        this.mIBaseEmulationType = mTheVal.getIBaseEmulationType();
        this.mLPGLBASize = mTheVal.getLPGLBASize();
        this.mLPDEVSize = mTheVal.getLPDEVSize();
        this.mSPDEVCount = mTheVal.getSPDEVCount();
        this.mAOUVol = mTheVal.isAOUVvol();
        this.mExternalVolume = mTheVal.isExternalVolume();
        this.mNormalVolume = mTheVal.isNormalVolume();
        this.mQSVvol = mTheVal.isQSVvol();
        this.mVvol = mTheVal.isVvol();
        this.mDriveType = mTheVal.getByDriveType();
        this.mProtectionLvl = mTheVal.getByProtectionLevel();
        this.mHDDrpm = mTheVal.getNHDDrpm();
        this.lpDevSizeDependOnCE = ((Robj_interface_RJiPGInfoDetail7)mTheVal).getLPDEVSizeDependOnCE();
    }

    private void copyPGInfo(PGInfo other) {
        if (other != null) {
            this.mAOUVol = other.isAOUVol();
            this.mExternalVolume = other.isExternalVolume();
            this.mFB4 = other.getFB4();
            this.mIBaseEmulationType = other.getBaseEmulationType();
            this.mLPDEVSize = other.getLPDEVSize();
            this.mLPGLBASize = other.getLPGLBASize();
            this.mNormalVolume = other.isNormalVolume();
            this.mPG = other.getPG();
            this.mQSVvol = other.isQSVvol();
            this.mRaidLevel = other.getRaidLevel();
            this.mSCLPR = other.getSCLPR();
            this.mSPDEVCount = other.getSPDEVCount();
            this.mSSLPR = other.getSSLPR();
            this.mStrHDDType = other.getStrHDDType();
            this.mVvol = other.isVvol();
            this.mDriveType = other.getDriveType();
            this.mProtectionLvl = other.getProtectionLvl();
            this.mHDDrpm = other.getHDDrpm();
            this.lpDevSizeDependOnCE = other.getLpDevSizeDependOnCE();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PGInfo other = (PGInfo)obj;
        if (this.mFB4 != other.mFB4) {
            return false;
        }
        if (this.mPG != other.mPG) {
            return false;
        }
        if (this.lpDevSizeDependOnCE != other.lpDevSizeDependOnCE) {
            return false;
        }
        if (this.mAOUVol != other.mAOUVol) {
            return false;
        }
        if (this.mDriveType != other.mDriveType) {
            return false;
        }
        if (this.mExternalVolume != other.mExternalVolume) {
            return false;
        }
        if (this.mHDDrpm != other.mHDDrpm) {
            return false;
        }
        if (this.mIBaseEmulationType != other.mIBaseEmulationType) {
            return false;
        }
        if (this.mLPDEVSize != other.mLPDEVSize) {
            return false;
        }
        if (this.mLPGLBASize != other.mLPGLBASize) {
            return false;
        }
        if (this.mNormalVolume != other.mNormalVolume) {
            return false;
        }
        if (this.mProtectionLvl != other.mProtectionLvl) {
            return false;
        }
        if (this.mQSVvol != other.mQSVvol) {
            return false;
        }
        if (this.mRaidLevel != other.mRaidLevel) {
            return false;
        }
        if (this.mSCLPR != other.mSCLPR) {
            return false;
        }
        if (this.mSPDEVCount != other.mSPDEVCount) {
            return false;
        }
        if (this.mSSLPR != other.mSSLPR) {
            return false;
        }
        if (this.mStrHDDType == null ? other.mStrHDDType != null : !this.mStrHDDType.equals(other.mStrHDDType)) {
            return false;
        }
        return this.mVvol == other.mVvol;
    }

    public int getBaseEmulationType() {
        return this.mIBaseEmulationType;
    }

    public final byte getDriveType() {
        return this.mDriveType;
    }

    public int getFB4() {
        return this.mFB4;
    }

    public final int getHDDrpm() {
        return this.mHDDrpm;
    }

    public long getLPDEVSize() {
        return this.mLPDEVSize;
    }

    public long getLpDevSizeDependOnCE() {
        return this.lpDevSizeDependOnCE;
    }

    public long getLPGLBASize() {
        return this.mLPGLBASize;
    }

    public int getPG() {
        return this.mPG;
    }

    public byte getProtectionLvl() {
        return this.mProtectionLvl;
    }

    public int getRaidLevel() {
        return this.mRaidLevel;
    }

    public short getSCLPR() {
        return this.mSCLPR;
    }

    public short getSPDEVCount() {
        return this.mSPDEVCount;
    }

    public short getSSLPR() {
        return this.mSSLPR;
    }

    public String getStrHDDType() {
        return this.mStrHDDType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.lpDevSizeDependOnCE ^ this.lpDevSizeDependOnCE >>> 32);
        result = 31 * result + (this.mAOUVol ? 1231 : 1237);
        result = 31 * result + this.mDriveType;
        result = 31 * result + (this.mExternalVolume ? 1231 : 1237);
        result = 31 * result + this.mFB4;
        result = 31 * result + this.mHDDrpm;
        result = 31 * result + this.mIBaseEmulationType;
        result = 31 * result + (int)(this.mLPDEVSize ^ this.mLPDEVSize >>> 32);
        result = 31 * result + (int)(this.mLPGLBASize ^ this.mLPGLBASize >>> 32);
        result = 31 * result + (this.mNormalVolume ? 1231 : 1237);
        result = 31 * result + this.mPG;
        result = 31 * result + this.mProtectionLvl;
        result = 31 * result + (this.mQSVvol ? 1231 : 1237);
        result = 31 * result + this.mRaidLevel;
        result = 31 * result + this.mSCLPR;
        result = 31 * result + this.mSPDEVCount;
        result = 31 * result + this.mSSLPR;
        result = 31 * result + (this.mStrHDDType == null ? 0 : this.mStrHDDType.hashCode());
        result = 31 * result + (this.mVvol ? 1231 : 1237);
        return result;
    }

    public boolean isAOUVol() {
        return this.mAOUVol;
    }

    public boolean isExternalVolume() {
        return this.mExternalVolume;
    }

    public boolean isNormalVolume() {
        return this.mNormalVolume;
    }

    public boolean isOpen() throws WBEMException {
        boolean ret;
        block5: {
            ret = false;
            try {
                String emulationtype = ProviderLibs.lookupEmulationType(this.mIBaseEmulationType);
                if (emulationtype != null) {
                    if (emulationtype.startsWith("OPEN")) {
                        ret = true;
                    }
                    break block5;
                }
                throw new WBEMException(this.mIBaseEmulationType + " is not a known emulation type");
            }
            catch (RemoteException e) {
                throw new WBEMException(1, "RemoteException getting emulation type: " + e.getMessage(), null, (Throwable)e);
            }
            catch (GetRmiException e) {
                throw new WBEMException(1, "GetRmiException getting emulation type: " + e.getErrMsgEn(), null, (Throwable)e);
            }
        }
        return ret;
    }

    public boolean isQSVvol() {
        return this.mQSVvol;
    }

    private boolean isSame(PGInfo newVal) {
        return this.equals(newVal);
    }

    public boolean isVvol() {
        return this.mVvol;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PGInfo [mFB4=");
        builder.append(this.mFB4);
        builder.append(", mPG=");
        builder.append(this.mPG);
        builder.append(", lpDevSizeDependOnCE=");
        builder.append(this.lpDevSizeDependOnCE);
        builder.append(", mSPDEVCount=");
        builder.append(this.mSPDEVCount);
        builder.append(", mIBaseEmulationType=");
        builder.append(this.mIBaseEmulationType);
        builder.append(", mLPDEVSize=");
        builder.append(this.mLPDEVSize);
        builder.append(", mLPGLBASize=");
        builder.append(this.mLPGLBASize);
        builder.append(", mAOUVol=");
        builder.append(this.mAOUVol);
        builder.append(", mNormalVolume=");
        builder.append(this.mNormalVolume);
        builder.append(", mVvol=");
        builder.append(this.mVvol);
        builder.append(", mQSVvol=");
        builder.append(this.mQSVvol);
        builder.append(", mExternalVolume=");
        builder.append(this.mExternalVolume);
        builder.append(", mRaidLevel=");
        builder.append(this.mRaidLevel);
        builder.append(", mSCLPR=");
        builder.append(this.mSCLPR);
        builder.append(", mSSLPR=");
        builder.append(this.mSSLPR);
        builder.append(", mStrHDDType=");
        builder.append(this.mStrHDDType);
        builder.append(", mDriveType=");
        builder.append(this.mDriveType);
        builder.append(", mProtectionLvl=");
        builder.append(this.mProtectionLvl);
        builder.append(", mHDDrpm=");
        builder.append(this.mHDDrpm);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<PGInfo> mCallback;
        private final int mPFB4;
        private final int mPPG;
        private final TaskProcessor mTheTask;
        Robj_interface_RJiPGInfoDetail2 mTheVal;
        private final String mSerialNum;

        public WorkerThread(String serialNum, IteratorCallback<PGInfo> callback, Robj_interface_RJiPGInfoDetail2 infoDetail, TaskProcessor pTheTask, int pFB4, int pPG) {
            this.mSerialNum = serialNum;
            this.mCallback = callback;
            this.mTheVal = infoDetail;
            this.mTheTask = pTheTask;
            this.mPFB4 = pFB4;
            this.mPPG = pPG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = PGInfo.processInfoDetail(this.mSerialNum, this.mCallback, this.mTheVal, this.mPFB4, this.mPPG))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Throwable e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)e : new WBEMException(1, "Exception while processing items", null, e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }
    }
}

